PGDMP          
             ~            hub4lca_post_simulation    17.7 (Debian 17.7-3.pgdg12+1)    17.4    v           0    0    ENCODING    ENCODING        SET client_encoding = 'UTF8';
                           false            w           0    0 
   STDSTRINGS 
   STDSTRINGS     (   SET standard_conforming_strings = 'on';
                           false            x           0    0 
   SEARCHPATH 
   SEARCHPATH     8   SELECT pg_catalog.set_config('search_path', '', false);
                           false            y           1262    33765    hub4lca_post_simulation    DATABASE        CREATE DATABASE hub4lca_post_simulation WITH TEMPLATE = template0 ENCODING = 'UTF8' LOCALE_PROVIDER = libc LOCALE = 'en_US.utf8';
 '   DROP DATABASE hub4lca_post_simulation;
                     max_schildt    false                        2615    33766    hub4lca_post_simulation    SCHEMA     '   CREATE SCHEMA hub4lca_post_simulation;
 %   DROP SCHEMA hub4lca_post_simulation;
                     postgres    false            ~           1255    37470    get_boxplot_metrics_building(integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer)    FUNCTION       CREATE FUNCTION hub4lca_post_simulation.get_boxplot_metrics_building(_metric_id integer, _life_cycle_module_id integer, _weather_station_id integer DEFAULT NULL::integer, _building_type_id integer DEFAULT NULL::integer, _region_id integer DEFAULT NULL::integer, _municipality_size_id integer DEFAULT NULL::integer, _municipality_growth_class_id integer DEFAULT NULL::integer, _age_class_id integer DEFAULT NULL::integer, _building_adjacency_id integer DEFAULT NULL::integer, _energy_system_id integer DEFAULT NULL::integer, _value_divisor integer DEFAULT 1) RETURNS TABLE(building_type_name text, building_adjacency_type_name text, age_class_name text, region_name text, municipality_size_class_name text, municipality_growth_class_name text, weather_station_id integer, weather_station_name text, metric_id integer, life_cycle_module_id integer, mean_value numeric, median_value numeric, min_value numeric, max_value numeric, p25_value numeric, p75_value numeric)
    LANGUAGE plpgsql
    AS $$BEGIN
    IF _value_divisor = 0 THEN
        RAISE EXCEPTION 'Parameter _value_divisor must not be 0';
    END IF;

RETURN QUERY
SELECT
    bt.building_type_name::text,
    bat.building_adjacency_type_name::text,
    ac.age_class_name::text,
    r.region_name::text,
    msc.municipality_size_class_name::text,
    mgc.municipality_growth_class_name::text,

    amsb.weather_station_id,
    ws.weather_station_name::text,
    amsb.metric_id,
    amsb.life_cycle_module_id,

    -- mean over archetype means
    ROUND(
        (AVG(amsb.mean_value) / _value_divisor)::numeric,
        2
    ) AS mean_value,

    ROUND(
        (
            PERCENTILE_CONT(0.5)
                WITHIN GROUP (ORDER BY amsb.mean_value)
            / _value_divisor
        )::numeric,
        2
    ) AS median_value,

    ROUND(
        (MIN(amsb.mean_value) / _value_divisor)::numeric,
        2
    ) AS min_value,

    ROUND(
        (MAX(amsb.mean_value) / _value_divisor)::numeric,
        2
    ) AS max_value,

    ROUND(
        (
            PERCENTILE_CONT(0.25)
                WITHIN GROUP (ORDER BY amsb.mean_value)
            / _value_divisor
        )::numeric,
        2
    ) AS p25_value,

    ROUND(
        (
            PERCENTILE_CONT(0.75)
                WITHIN GROUP (ORDER BY amsb.mean_value)
            / _value_divisor
        )::numeric,
        2
    ) AS p75_value

FROM hub4lca_post_simulation.archetype_metric_stats_building AS amsb
JOIN hub4lca_post_simulation.building_archetypes AS ba
     ON amsb.building_archetype_id = ba.building_archetype_id
JOIN hub4lca_post_simulation.weather_stations AS ws
     ON amsb.weather_station_id = ws.weather_station_id
JOIN hub4lca_post_simulation.building_types AS bt
     ON ba.building_type_id = bt.building_type_id

LEFT JOIN hub4lca_post_simulation.regions AS r
     ON ba.region_id = r.region_id
LEFT JOIN hub4lca_post_simulation.municipality_size_classes AS msc
     ON ba.municipality_size_id = msc.municipality_size_class_id
LEFT JOIN hub4lca_post_simulation.municipality_growth_classes AS mgc
     ON ba.municipality_growth_id = mgc.municipality_growth_class_id
LEFT JOIN hub4lca_post_simulation.age_classes AS ac
     ON ba.age_class_id = ac.age_class_id
LEFT JOIN hub4lca_post_simulation.building_adjacency_types AS bat
     ON ba.building_adjacency_id = bat.building_adjacency_type_id

WHERE
    amsb.metric_id = _metric_id
    AND amsb.life_cycle_module_id = _life_cycle_module_id

    AND (_weather_station_id IS NULL           OR amsb.weather_station_id   = _weather_station_id)
    AND (_building_type_id IS NULL             OR ba.building_type_id       = _building_type_id)
    AND (_region_id IS NULL                    OR ba.region_id              = _region_id)
    AND (_municipality_size_id IS NULL         OR ba.municipality_size_id   = _municipality_size_id)
    AND (_municipality_growth_class_id IS NULL OR ba.municipality_growth_id = _municipality_growth_class_id)
    AND (_age_class_id IS NULL                 OR ba.age_class_id           = _age_class_id)
    AND (_building_adjacency_id IS NULL        OR ba.building_adjacency_id  = _building_adjacency_id)
    AND (_energy_system_id IS NULL             OR ba.energy_system_id       = _energy_system_id)

GROUP BY
    bt.building_type_name,
    bat.building_adjacency_type_name,
    ac.age_class_name,
    r.region_name,
    msc.municipality_size_class_name,
    mgc.municipality_growth_class_name,
    amsb.weather_station_id,
    ws.weather_station_name,
    amsb.metric_id,
    amsb.life_cycle_module_id;

END;
$$;
 s  DROP FUNCTION hub4lca_post_simulation.get_boxplot_metrics_building(_metric_id integer, _life_cycle_module_id integer, _weather_station_id integer, _building_type_id integer, _region_id integer, _municipality_size_id integer, _municipality_growth_class_id integer, _age_class_id integer, _building_adjacency_id integer, _energy_system_id integer, _value_divisor integer);
       hub4lca_post_simulation               max_schildt    false    6            r           1255    37406 :   get_histogram_by_btype(integer, integer, integer, numeric)    FUNCTION       CREATE FUNCTION hub4lca_post_simulation.get_histogram_by_btype(p_metric_id integer, p_life_cycle_module_id integer, p_building_element_type_id integer DEFAULT 8, p_scale_factor numeric DEFAULT 1000) RETURNS TABLE(building_type_id integer, building_type_name text, metric_id integer, life_cycle_module_id integer, bin_index integer, bin_lower double precision, bin_upper double precision, bin_count bigint)
    LANGUAGE sql
    AS $$
WITH filtered AS (
    SELECT
        ba.building_type_id,
        h.metric_id,
        h.life_cycle_module_id,
        h.bin_index,
        h.count_in_bin
    FROM hub4lca_post_simulation.archetype_metric_histograms_building AS h
    JOIN hub4lca_post_simulation.building_archetypes AS ba
      ON ba.building_archetype_id = h.building_archetype_id
    WHERE h.metric_id = p_metric_id
      AND h.life_cycle_module_id = p_life_cycle_module_id
),
aggregated AS (
    SELECT
        building_type_id,
        metric_id,
        life_cycle_module_id,
        bin_index,
        SUM(count_in_bin) AS bin_count
    FROM filtered
    GROUP BY
        building_type_id,
        metric_id,
        life_cycle_module_id,
        bin_index
)
SELECT
    a.building_type_id,
    bt.building_type_name,
    a.metric_id,
    a.life_cycle_module_id,
    a.bin_index,
    ROUND((b.bin_lower::numeric / p_scale_factor), 2)::double precision AS bin_lower,
    ROUND((b.bin_upper::numeric / p_scale_factor), 2)::double precision AS bin_upper,
    a.bin_count
FROM aggregated AS a
JOIN hub4lca_post_simulation.metric_histogram_bins AS b
  ON  b.building_type_id         = a.building_type_id
  AND b.metric_id                = a.metric_id
  AND b.life_cycle_module_id     = a.life_cycle_module_id
  AND b.building_element_type_id = p_building_element_type_id
  AND b.bin_index                = a.bin_index
JOIN hub4lca_post_simulation.building_types AS bt
  ON bt.building_type_id = a.building_type_id
ORDER BY
    a.building_type_id,
    a.bin_index;
$$;
    DROP FUNCTION hub4lca_post_simulation.get_histogram_by_btype(p_metric_id integer, p_life_cycle_module_id integer, p_building_element_type_id integer, p_scale_factor numeric);
       hub4lca_post_simulation               max_schildt    false    6                       1255    37393 3   get_histogram_by_btype_1(integer, integer, integer)    FUNCTION     D  CREATE FUNCTION hub4lca_post_simulation.get_histogram_by_btype_1(p_metric_id integer, p_life_cycle_module_id integer, p_building_element_type_id integer DEFAULT 8) RETURNS TABLE(building_type_id integer, building_type_name text, metric_id integer, life_cycle_module_id integer, bin_index integer, bin_lower double precision, bin_upper double precision, bin_count bigint)
    LANGUAGE sql
    AS $$
WITH filtered AS (
    SELECT
        ba.building_type_id,
        h.metric_id,
        h.life_cycle_module_id,
        h.bin_index,
        h.count_in_bin
    FROM hub4lca_post_simulation.archetype_metric_histograms_building AS h
    JOIN hub4lca_post_simulation.building_archetypes AS ba
      ON ba.building_archetype_id = h.building_archetype_id
    WHERE h.metric_id = p_metric_id
      AND h.life_cycle_module_id = p_life_cycle_module_id
),
aggregated AS (
    SELECT
        building_type_id,
        metric_id,
        life_cycle_module_id,
        bin_index,
        SUM(count_in_bin) AS bin_count
    FROM filtered
    GROUP BY
        building_type_id,
        metric_id,
        life_cycle_module_id,
        bin_index
)
SELECT
    a.building_type_id,
    bt.building_type_name,
    a.metric_id,
    a.life_cycle_module_id,
    a.bin_index,
    ROUND(b.bin_lower::numeric, 2) AS bin_lower,
    ROUND(b.bin_upper::numeric, 2) AS bin_upper,
    a.bin_count
FROM aggregated AS a
JOIN hub4lca_post_simulation.metric_histogram_bins AS b
  ON  b.building_type_id         = a.building_type_id
  AND b.metric_id                = a.metric_id
  AND b.life_cycle_module_id     = a.life_cycle_module_id
  AND b.building_element_type_id = p_building_element_type_id
  AND b.bin_index                = a.bin_index
JOIN hub4lca_post_simulation.building_types AS bt
  ON bt.building_type_id = a.building_type_id
ORDER BY
    a.building_type_id,
    a.bin_index;
$$;
    DROP FUNCTION hub4lca_post_simulation.get_histogram_by_btype_1(p_metric_id integer, p_life_cycle_module_id integer, p_building_element_type_id integer);
       hub4lca_post_simulation               max_schildt    false    6                        1259    33767    age_classes    TABLE        CREATE TABLE hub4lca_post_simulation.age_classes (
    age_class_name character varying(100) NOT NULL,
    description text,
    age_class_id integer NOT NULL
);
 0   DROP TABLE hub4lca_post_simulation.age_classes;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33772    age_classes_age_class_id_seq    SEQUENCE        CREATE SEQUENCE hub4lca_post_simulation.age_classes_age_class_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
 D   DROP SEQUENCE hub4lca_post_simulation.age_classes_age_class_id_seq;
       hub4lca_post_simulation               postgres    false    224    6            z           0    0    age_classes_age_class_id_seq    SEQUENCE OWNED BY        ALTER SEQUENCE hub4lca_post_simulation.age_classes_age_class_id_seq OWNED BY hub4lca_post_simulation.age_classes.age_class_id;
          hub4lca_post_simulation               postgres    false    225                        1259    33773    age_classes_age_class_id_seq1    SEQUENCE       ALTER TABLE hub4lca_post_simulation.age_classes ALTER COLUMN age_class_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.age_classes_age_class_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    224    6            F           1259    37265 $   archetype_metric_histograms_building    TABLE     1  CREATE TABLE hub4lca_post_simulation.archetype_metric_histograms_building (
    building_archetype_id integer NOT NULL,
    weather_station_id integer NOT NULL,
    metric_id integer NOT NULL,
    life_cycle_module_id integer NOT NULL,
    bin_index integer NOT NULL,
    count_in_bin integer NOT NULL
);
 I   DROP TABLE hub4lca_post_simulation.archetype_metric_histograms_building;
       hub4lca_post_simulation         heap r       max_schildt    false    6            G           1259    37295 #   archetype_metric_histograms_element    TABLE     _  CREATE TABLE hub4lca_post_simulation.archetype_metric_histograms_element (
    building_archetype_id integer NOT NULL,
    weather_station_id integer NOT NULL,
    building_element_type_id integer NOT NULL,
    metric_id integer NOT NULL,
    life_cycle_module_id integer NOT NULL,
    bin_index integer NOT NULL,
    count_in_bin integer NOT NULL
);
 H   DROP TABLE hub4lca_post_simulation.archetype_metric_histograms_element;
       hub4lca_post_simulation         heap r       max_schildt    false    6            C           1259    37191    archetype_metric_stats_building    TABLE       CREATE TABLE hub4lca_post_simulation.archetype_metric_stats_building (
    building_archetype_id integer NOT NULL,
    weather_station_id integer NOT NULL,
    metric_id integer NOT NULL,
    life_cycle_module_id integer NOT NULL,
    n_total_runs integer,
    n_valid_runs integer,
    n_excluded_runs integer,
    n integer,
    mean_value double precision,
    median_value double precision,
    std_dev double precision,
    min_value double precision,
    max_value double precision,
    p05_value double precision,
    p25_value double precision,
    p50_value double precision,
    p75_value double precision,
    p95_value double precision,
    se_mean double precision,
    ci95_lower double precision,
    ci95_upper double precision,
    cv double precision
);
 D   DROP TABLE hub4lca_post_simulation.archetype_metric_stats_building;
       hub4lca_post_simulation         heap r       max_schildt    false    6            D           1259    37216    archetype_metric_stats_element    TABLE     2  CREATE TABLE hub4lca_post_simulation.archetype_metric_stats_element (
    building_archetype_id integer NOT NULL,
    weather_station_id integer NOT NULL,
    building_element_type_id integer NOT NULL,
    metric_id integer NOT NULL,
    life_cycle_module_id integer NOT NULL,
    n_total_runs integer,
    n_valid_runs integer,
    n_excluded_runs integer,
    n integer,
    mean_value double precision,
    median_value double precision,
    std_dev double precision,
    min_value double precision,
    max_value double precision,
    p05_value double precision,
    p25_value double precision,
    p50_value double precision,
    p75_value double precision,
    p95_value double precision,
    se_mean double precision,
    ci95_lower double precision,
    ci95_upper double precision,
    cv double precision
);
 C   DROP TABLE hub4lca_post_simulation.archetype_metric_stats_element;
       hub4lca_post_simulation         heap r       max_schildt    false    6                        1259    33774    building_adjacency_types    TABLE        CREATE TABLE hub4lca_post_simulation.building_adjacency_types (
    building_adjacency_type_id integer NOT NULL,
    building_adjacency_type_name character varying(100) NOT NULL,
    description text
);
 =   DROP TABLE hub4lca_post_simulation.building_adjacency_types;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33780    building_archetypes    TABLE       CREATE TABLE hub4lca_post_simulation.building_archetypes (
    building_archetype_id integer NOT NULL,
    building_archetype_name character varying(100) NOT NULL,
    building_type_id integer NOT NULL,
    region_id integer,
    municipality_size_id integer,
    municipality_growth_id integer,
    age_class_id integer,
    exterior_wall_building_element_id integer NOT NULL,
    interior_wall_building_element_id integer,
    roof_building_element_id integer NOT NULL,
    foundation_building_element_id integer NOT NULL,
    floor_building_element_id integer NOT NULL,
    energy_system_id integer NOT NULL,
    building_adjacency_id integer,
    window_building_element_id integer NOT NULL,
    share_of_building_type real,
    share_of_building_type_in_region real,
    share_of_building_type_in_region_mun real,
    building_geometry_property_id bigint NOT NULL,
    building_type_cluster bigint
);
 8   DROP TABLE hub4lca_post_simulation.building_archetypes;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33794    building_elements    TABLE     r  CREATE TABLE hub4lca_post_simulation.building_elements (
    building_element_id integer NOT NULL,
    building_element_name character varying(100) NOT NULL,
    construction_type_id integer,
    description text,
    building_element_type_id integer NOT NULL,
    u_value_typical_min real,
    u_value_typical_max real,
    u_value_unit_id integer,
    u_value real,
    inner_radiation real,
    inner_radiation_unit_id integer,
    outer_radiation real,
    outer_radiation_unit_id integer,
    inner_convection real,
    inner_convection_unit_id integer,
    outer_convection real,
    outer_convection_unit_id integer
);
 6   DROP TABLE hub4lca_post_simulation.building_elements;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33800    building_geometry_properties    TABLE       CREATE TABLE hub4lca_post_simulation.building_geometry_properties (
    building_geometry_property_id bigint NOT NULL,
    building_archetype_id bigint NOT NULL,
    facade_to_net_leased_area_ratio_mean real,
    facade_to_net_leased_area_ratio_se_min real,
    facade_to_net_leased_area_ratio_se_max real,
    roof_to_net_leased_area_ratio_mean real,
    roof_to_net_leased_area_ratio_se_min real,
    roof_to_net_leased_area_ratio_se_max real,
    foundation_to_net_leased_area_ratio_mean real,
    foundation_to_net_leased_area_ratio_se_min real,
    foundation_to_net_leased_area_ratio_se_max real,
    window_to_net_leased_area_ratio_mean real,
    window_to_net_leased_area_ratio_se_min real,
    window_to_net_leased_area_ratio_se_max real,
    building_height_mean real,
    building_height_se real,
    aspect_ratio_mean real,
    aspect_ratio_se_min real,
    aspect_ratio_se_max real,
    storeys_below_ground_mean real,
    storeys_below_ground_se real,
    storeys_above_ground_mean real,
    storeys_above_ground_se real,
    window_share real,
    net_leased_area_mean real,
    net_leased_area_se real,
    net_leased_area_unit_id integer,
    height_unit_id integer,
    facade_area_north_mean real,
    facade_area_north_se real,
    facade_area_east_mean real,
    facade_area_east_se real,
    facade_area_south_mean real,
    facade_area_south_se real,
    facade_area_west_mean real,
    facade_area_west_se real,
    facade_area_unit_id integer,
    facade_length_north_mean real,
    facade_length_north_se real,
    facade_length_east_mean real,
    facade_length_east_se real,
    facade_length_south_mean real,
    facade_length_south_se real,
    facade_length_west_mean real,
    facade_length_west_se real,
    facade_length_unit_id integer,
    storey_height_mean real,
    storey_height_se_min real,
    storey_height_se_max real,
    storeys_above_ground_se_min real,
    storeys_above_ground_se_max real,
    net_leased_area_se_min real,
    net_leased_area_se_max real
);
 A   DROP TABLE hub4lca_post_simulation.building_geometry_properties;
       hub4lca_post_simulation         heap r       max_schildt    false    6            {           0    0 "   TABLE building_geometry_properties    COMMENT        COMMENT ON TABLE hub4lca_post_simulation.building_geometry_properties IS 'Derived/statistical geometry metrics (means, SEs, ratios) split out of building_archetypes.';
          hub4lca_post_simulation               max_schildt    false    235                        1259    33804    building_materials    TABLE       CREATE TABLE hub4lca_post_simulation.building_materials (
    building_material_id integer NOT NULL,
    building_material_name character varying(100) NOT NULL,
    solar_absorption_rate real,
    thermal_capacity real,
    thermal_capacity_unit_id integer,
    thermal_conductivity real,
    thermal_conductivity_unit_id integer,
    density real,
    density_unit_id integer,
    service_life_id integer,
    description text,
    environmental_product_declaration_id_1 integer,
    environmental_product_declaration_id_2 integer
);
 7   DROP TABLE hub4lca_post_simulation.building_materials;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33810    building_types    TABLE        CREATE TABLE hub4lca_post_simulation.building_types (
    building_type_id integer NOT NULL,
    building_type_name character varying(100) NOT NULL,
    description text
);
 3   DROP TABLE hub4lca_post_simulation.building_types;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33849    construction_types    TABLE        CREATE TABLE hub4lca_post_simulation.construction_types (
    construction_type_id integer NOT NULL,
    construction_type_name character varying(100) NOT NULL,
    description text
);
 7   DROP TABLE hub4lca_post_simulation.construction_types;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33860    energy_converters    TABLE       CREATE TABLE hub4lca_post_simulation.energy_converters (
    energy_converter_id integer NOT NULL,
    energy_converter_name character varying(100) NOT NULL,
    energy_supply_function_id integer,
    energy_source_id integer,
    nominal_power_min real,
    nominal_power_unit_id integer,
    description text,
    environmental_product_declaration_id_1 integer,
    service_life_id integer,
    nominal_power_max real,
    environmental_product_declaration_id_2 integer,
    area real,
    area_unit_id integer
);
 6   DROP TABLE hub4lca_post_simulation.energy_converters;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33866    energy_sources    TABLE        CREATE TABLE hub4lca_post_simulation.energy_sources (
    energy_source_id integer NOT NULL,
    energy_source_name text NOT NULL,
    description text,
    environmental_product_declaration_id integer
);
 3   DROP TABLE hub4lca_post_simulation.energy_sources;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33871    energy_supply_functions    TABLE        CREATE TABLE hub4lca_post_simulation.energy_supply_functions (
    energy_supply_function_id integer NOT NULL,
    energy_supply_function_name character varying(100) NOT NULL,
    description text
);
 <   DROP TABLE hub4lca_post_simulation.energy_supply_functions;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33877    energy_systems    TABLE        CREATE TABLE hub4lca_post_simulation.energy_systems (
    energy_system_id integer NOT NULL,
    energy_system_name character varying(100) NOT NULL,
    description text
);
 3   DROP TABLE hub4lca_post_simulation.energy_systems;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33882     energy_systems_energy_converters    TABLE        CREATE TABLE hub4lca_post_simulation.energy_systems_energy_converters (
    energy_system_id integer NOT NULL,
    energy_converter_id integer NOT NULL
);
 E   DROP TABLE hub4lca_post_simulation.energy_systems_energy_converters;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33886 "   environmental_product_declarations    TABLE     Z  CREATE TABLE hub4lca_post_simulation.environmental_product_declarations (
    environmental_product_declaration_id integer NOT NULL,
    environmental_product_declaration_name text,
    product_category_rule_id integer,
    reference_flow_id integer,
    lca_database_id integer,
    database_uuid character varying(100),
    description text
);
 G   DROP TABLE hub4lca_post_simulation.environmental_product_declarations;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33926    layers    TABLE       CREATE TABLE hub4lca_post_simulation.layers (
    layer_id integer NOT NULL,
    building_element_id integer NOT NULL,
    "position" integer NOT NULL,
    building_material_id integer NOT NULL,
    thickness real,
    thickness_unit_id integer,
    description text
);
 +   DROP TABLE hub4lca_post_simulation.layers;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33976    municipality_growth_classes    TABLE        CREATE TABLE hub4lca_post_simulation.municipality_growth_classes (
    municipality_growth_class_id integer NOT NULL,
    municipality_growth_class_name character varying(100) NOT NULL,
    description text
);
 @   DROP TABLE hub4lca_post_simulation.municipality_growth_classes;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33982    municipality_size_classes    TABLE        CREATE TABLE hub4lca_post_simulation.municipality_size_classes (
    municipality_size_class_id integer NOT NULL,
    municipality_size_class_name character varying(100) NOT NULL,
    description text
);
 >   DROP TABLE hub4lca_post_simulation.municipality_size_classes;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33988    pitch_types    TABLE        CREATE TABLE hub4lca_post_simulation.pitch_types (
    pitch_type_id integer NOT NULL,
    pitch_type_name character varying(100) NOT NULL,
    description text
);
 0   DROP TABLE hub4lca_post_simulation.pitch_types;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    34002    regions    TABLE        CREATE TABLE hub4lca_post_simulation.regions (
    region_id integer NOT NULL,
    region_name character varying(100) NOT NULL,
    description text
);
 ,   DROP TABLE hub4lca_post_simulation.regions;
       hub4lca_post_simulation         heap r       postgres    false    6            "           1259    34008    roofs    TABLE     }   CREATE TABLE hub4lca_post_simulation.roofs (
    pitch_type_id integer NOT NULL,
    building_element_id integer NOT NULL
);
 *   DROP TABLE hub4lca_post_simulation.roofs;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33843 
   service_lives    TABLE       CREATE TABLE hub4lca_post_simulation.service_lives (
    service_life_id integer NOT NULL,
    service_life integer NOT NULL,
    unit_id integer NOT NULL,
    description text,
    standard_id integer,
    component_name character varying(100) NOT NULL
);
 2   DROP TABLE hub4lca_post_simulation.service_lives;
       hub4lca_post_simulation         heap r       postgres    false    6            #           1259    34011 
   shading_types    TABLE        CREATE TABLE hub4lca_post_simulation.shading_types (
    shading_type_id integer NOT NULL,
    shading_type_name character varying(100) NOT NULL,
    description text
);
 2   DROP TABLE hub4lca_post_simulation.shading_types;
       hub4lca_post_simulation         heap r       postgres    false    6            j           1259    37967 &   tmp_simulation_heat_energy_final_merge    TABLE        CREATE TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    annual_heat_energy double precision
);
 K   DROP TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6            |           0    0 ,   TABLE tmp_simulation_heat_energy_final_merge    ACL     j   GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    362            b           1259    37848     tmp_simulation_input_final_merge    TABLE     s  CREATE TABLE hub4lca_post_simulation.tmp_simulation_input_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    building_archetype_id bigint,
    storeys_above_ground real,
    storey_height real,
    net_leased_area real,
    rotation bigint,
    weather_station text,
    statistic_selector text,
    project_name text,
    run_key text
);
 E   DROP TABLE hub4lca_post_simulation.tmp_simulation_input_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6            }           0    0 &   TABLE tmp_simulation_input_final_merge    ACL     "  REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_input_final_merge FROM max_schildt;
GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_input_final_merge TO max_schildt;
GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_input_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    354                       1259    33896    units    TABLE        CREATE TABLE hub4lca_post_simulation.units (
    unit_id integer NOT NULL,
    unit_name character varying(100) NOT NULL,
    description text
);
 *   DROP TABLE hub4lca_post_simulation.units;
       hub4lca_post_simulation         heap r       postgres    false    6            *           1259    34037    window_frame_types    TABLE        CREATE TABLE hub4lca_post_simulation.window_frame_types (
    window_frame_type_id integer NOT NULL,
    window_frame_type_name character varying(100) NOT NULL,
    description text
);
 7   DROP TABLE hub4lca_post_simulation.window_frame_types;
       hub4lca_post_simulation         heap r       postgres    false    6            ,           1259    34043    windows    TABLE     G  CREATE TABLE hub4lca_post_simulation.windows (
    building_element_id integer NOT NULL,
    shading_type_id integer,
    window_frame_type_id integer NOT NULL,
    glazing integer NOT NULL,
    frame_per_window real,
    frame_per_window_unit_id integer,
    window_frame_area_share real,
    g_value real,
    a_conv real
);
 ,   DROP TABLE hub4lca_post_simulation.windows;
       hub4lca_post_simulation         heap r       postgres    false    6            V           1259    37607    vw_pre_simulation    VIEW      CREATE VIEW hub4lca_post_simulation.vw_pre_simulation AS
 WITH step_001 AS (
         SELECT bat.building_archetype_id,
            bat.building_archetype_name,
            bat.share_of_building_type,
            bat.share_of_building_type_in_region,
            bat.share_of_building_type_in_region_mun,
            bat.exterior_wall_building_element_id,
            bat.interior_wall_building_element_id,
            bat.roof_building_element_id,
            bat.foundation_building_element_id,
            bat.floor_building_element_id,
            bat.window_building_element_id,
            bat.energy_system_id,
            bt.building_type_name,
            r.region_name,
            msc.municipality_size_class_name AS municipality_size_name,
            mgc.municipality_growth_class_name AS municipality_growth_name,
            ac.age_class_name,
            baty.building_adjacency_type_name AS building_adjacency_name
           FROM ((((((hub4lca_post_simulation.building_archetypes bat
             LEFT JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = bat.building_type_id)))
             LEFT JOIN hub4lca_post_simulation.regions r ON ((r.region_id = bat.region_id)))
             LEFT JOIN hub4lca_post_simulation.municipality_size_classes msc ON ((msc.municipality_size_class_id = bat.municipality_size_id)))
             LEFT JOIN hub4lca_post_simulation.municipality_growth_classes mgc ON ((mgc.municipality_growth_class_id = bat.municipality_growth_id)))
             LEFT JOIN hub4lca_post_simulation.age_classes ac ON ((ac.age_class_id = bat.age_class_id)))
             LEFT JOIN hub4lca_post_simulation.building_adjacency_types baty ON ((baty.building_adjacency_type_id = bat.building_adjacency_id)))
        ), step_002 AS (
         SELECT g.building_archetype_id,
            g.building_archetype_name,
            g.share_of_building_type,
            g.share_of_building_type_in_region,
            g.share_of_building_type_in_region_mun,
            g.exterior_wall_building_element_id,
            g.interior_wall_building_element_id,
            g.roof_building_element_id,
            g.foundation_building_element_id,
            g.floor_building_element_id,
            g.window_building_element_id,
            g.energy_system_id,
            g.building_type_name,
            g.region_name,
            g.municipality_size_name,
            g.municipality_growth_name,
            g.age_class_name,
            g.building_adjacency_name,
            gem.facade_to_net_leased_area_ratio_mean,
            gem.facade_to_net_leased_area_ratio_se_min,
            gem.facade_to_net_leased_area_ratio_se_max,
            gem.roof_to_net_leased_area_ratio_mean,
            gem.roof_to_net_leased_area_ratio_se_min,
            gem.roof_to_net_leased_area_ratio_se_max,
            gem.foundation_to_net_leased_area_ratio_mean,
            gem.foundation_to_net_leased_area_ratio_se_min,
            gem.foundation_to_net_leased_area_ratio_se_max,
            gem.window_to_net_leased_area_ratio_mean,
            gem.window_to_net_leased_area_ratio_se_min,
            gem.window_to_net_leased_area_ratio_se_max,
            gem.building_height_mean,
            gem.building_height_se,
            u1.unit_name AS height_unit,
            gem.aspect_ratio_mean,
            gem.aspect_ratio_se_min,
            gem.aspect_ratio_se_max,
            gem.storeys_below_ground_mean,
            gem.storeys_below_ground_se,
            gem.storeys_above_ground_mean,
            gem.storeys_above_ground_se,
            gem.storeys_above_ground_se_min,
            gem.storeys_above_ground_se_max,
            gem.storey_height_mean,
            gem.storey_height_se_min,
            gem.storey_height_se_max,
            gem.window_share,
            gem.net_leased_area_mean,
            gem.net_leased_area_se,
            gem.net_leased_area_se_min,
            gem.net_leased_area_se_max,
            u2.unit_name AS net_leased_area_unit,
            gem.facade_area_north_mean,
            gem.facade_area_north_se,
            gem.facade_area_east_mean,
            gem.facade_area_east_se,
            gem.facade_area_south_mean,
            gem.facade_area_south_se,
            gem.facade_area_west_mean,
            gem.facade_area_west_se,
            u3.unit_name AS facade_area_unit,
            gem.facade_length_north_mean,
            gem.facade_length_north_se,
            gem.facade_length_east_mean,
            gem.facade_length_east_se,
            gem.facade_length_south_mean,
            gem.facade_length_south_se,
            gem.facade_length_west_mean,
            gem.facade_length_west_se,
            u4.unit_name AS facade_length_unit
           FROM (((((step_001 g
             LEFT JOIN hub4lca_post_simulation.building_geometry_properties gem ON ((gem.building_archetype_id = g.building_archetype_id)))
             LEFT JOIN hub4lca_post_simulation.units u1 ON ((u1.unit_id = gem.height_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2 ON ((u2.unit_id = gem.net_leased_area_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3 ON ((u3.unit_id = gem.facade_area_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4 ON ((u4.unit_id = gem.facade_length_unit_id)))
        ), step_003 AS (
         SELECT g.building_archetype_id,
            g.building_archetype_name,
            g.share_of_building_type,
            g.share_of_building_type_in_region,
            g.share_of_building_type_in_region_mun,
            g.exterior_wall_building_element_id,
            g.interior_wall_building_element_id,
            g.roof_building_element_id,
            g.foundation_building_element_id,
            g.floor_building_element_id,
            g.window_building_element_id,
            g.energy_system_id,
            g.building_type_name,
            g.region_name,
            g.municipality_size_name,
            g.municipality_growth_name,
            g.age_class_name,
            g.building_adjacency_name,
            g.facade_to_net_leased_area_ratio_mean,
            g.facade_to_net_leased_area_ratio_se_min,
            g.facade_to_net_leased_area_ratio_se_max,
            g.roof_to_net_leased_area_ratio_mean,
            g.roof_to_net_leased_area_ratio_se_min,
            g.roof_to_net_leased_area_ratio_se_max,
            g.foundation_to_net_leased_area_ratio_mean,
            g.foundation_to_net_leased_area_ratio_se_min,
            g.foundation_to_net_leased_area_ratio_se_max,
            g.window_to_net_leased_area_ratio_mean,
            g.window_to_net_leased_area_ratio_se_min,
            g.window_to_net_leased_area_ratio_se_max,
            g.building_height_mean,
            g.building_height_se,
            g.height_unit,
            g.aspect_ratio_mean,
            g.aspect_ratio_se_min,
            g.aspect_ratio_se_max,
            g.storeys_below_ground_mean,
            g.storeys_below_ground_se,
            g.storeys_above_ground_mean,
            g.storeys_above_ground_se,
            g.storeys_above_ground_se_min,
            g.storeys_above_ground_se_max,
            g.storey_height_mean,
            g.storey_height_se_min,
            g.storey_height_se_max,
            g.window_share,
            g.net_leased_area_mean,
            g.net_leased_area_se,
            g.net_leased_area_se_min,
            g.net_leased_area_se_max,
            g.net_leased_area_unit,
            g.facade_area_north_mean,
            g.facade_area_north_se,
            g.facade_area_east_mean,
            g.facade_area_east_se,
            g.facade_area_south_mean,
            g.facade_area_south_se,
            g.facade_area_west_mean,
            g.facade_area_west_se,
            g.facade_area_unit,
            g.facade_length_north_mean,
            g.facade_length_north_se,
            g.facade_length_east_mean,
            g.facade_length_east_se,
            g.facade_length_south_mean,
            g.facade_length_south_se,
            g.facade_length_west_mean,
            g.facade_length_west_se,
            g.facade_length_unit,
            be.building_element_name AS exterior_wall_name,
            ct.construction_type_name AS exterior_wall_construction_type,
            be.u_value_typical_min AS exterior_wall_u_value_typical_min,
            be.u_value_typical_max AS exterior_wall_u_value_typical_max,
            be.u_value AS exterior_wall_u_value,
            u.unit_name AS exterior_wall_u_value_unit,
            be.inner_radiation AS exterior_wall_inner_radiation,
            u1.unit_name AS exterior_wall_inner_radiation_unit,
            be.outer_radiation AS exterior_wall_outer_radiation,
            u2.unit_name AS exterior_wall_outer_radiation_unit,
            be.inner_convection AS exterior_wall_inner_convection,
            u3.unit_name AS exterior_wall_inner_convection_unit,
            be.outer_convection AS exterior_wall_outer_convection,
            u4.unit_name AS exterior_wall_outer_convection_unit
           FROM (((((((step_002 g
             LEFT JOIN hub4lca_post_simulation.building_elements be ON ((be.building_element_id = g.exterior_wall_building_element_id)))
             LEFT JOIN hub4lca_post_simulation.construction_types ct ON ((ct.construction_type_id = be.construction_type_id)))
             LEFT JOIN hub4lca_post_simulation.units u ON ((u.unit_id = be.u_value_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1 ON ((u1.unit_id = be.inner_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2 ON ((u2.unit_id = be.outer_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3 ON ((u3.unit_id = be.inner_convection_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4 ON ((u4.unit_id = be.outer_convection_unit_id)))
        ), step_004 AS (
         SELECT b.building_archetype_id,
            b.building_archetype_name,
            b.share_of_building_type,
            b.share_of_building_type_in_region,
            b.share_of_building_type_in_region_mun,
            b.exterior_wall_building_element_id,
            b.interior_wall_building_element_id,
            b.roof_building_element_id,
            b.foundation_building_element_id,
            b.floor_building_element_id,
            b.window_building_element_id,
            b.energy_system_id,
            b.building_type_name,
            b.region_name,
            b.municipality_size_name,
            b.municipality_growth_name,
            b.age_class_name,
            b.building_adjacency_name,
            b.facade_to_net_leased_area_ratio_mean,
            b.facade_to_net_leased_area_ratio_se_min,
            b.facade_to_net_leased_area_ratio_se_max,
            b.roof_to_net_leased_area_ratio_mean,
            b.roof_to_net_leased_area_ratio_se_min,
            b.roof_to_net_leased_area_ratio_se_max,
            b.foundation_to_net_leased_area_ratio_mean,
            b.foundation_to_net_leased_area_ratio_se_min,
            b.foundation_to_net_leased_area_ratio_se_max,
            b.window_to_net_leased_area_ratio_mean,
            b.window_to_net_leased_area_ratio_se_min,
            b.window_to_net_leased_area_ratio_se_max,
            b.building_height_mean,
            b.building_height_se,
            b.height_unit,
            b.aspect_ratio_mean,
            b.aspect_ratio_se_min,
            b.aspect_ratio_se_max,
            b.storeys_below_ground_mean,
            b.storeys_below_ground_se,
            b.storeys_above_ground_mean,
            b.storeys_above_ground_se,
            b.storeys_above_ground_se_min,
            b.storeys_above_ground_se_max,
            b.storey_height_mean,
            b.storey_height_se_min,
            b.storey_height_se_max,
            b.window_share,
            b.net_leased_area_mean,
            b.net_leased_area_se,
            b.net_leased_area_se_min,
            b.net_leased_area_se_max,
            b.net_leased_area_unit,
            b.facade_area_north_mean,
            b.facade_area_north_se,
            b.facade_area_east_mean,
            b.facade_area_east_se,
            b.facade_area_south_mean,
            b.facade_area_south_se,
            b.facade_area_west_mean,
            b.facade_area_west_se,
            b.facade_area_unit,
            b.facade_length_north_mean,
            b.facade_length_north_se,
            b.facade_length_east_mean,
            b.facade_length_east_se,
            b.facade_length_south_mean,
            b.facade_length_south_se,
            b.facade_length_west_mean,
            b.facade_length_west_se,
            b.facade_length_unit,
            b.exterior_wall_name,
            b.exterior_wall_construction_type,
            b.exterior_wall_u_value_typical_min,
            b.exterior_wall_u_value_typical_max,
            b.exterior_wall_u_value,
            b.exterior_wall_u_value_unit,
            b.exterior_wall_inner_radiation,
            b.exterior_wall_inner_radiation_unit,
            b.exterior_wall_outer_radiation,
            b.exterior_wall_outer_radiation_unit,
            b.exterior_wall_inner_convection,
            b.exterior_wall_inner_convection_unit,
            b.exterior_wall_outer_convection,
            b.exterior_wall_outer_convection_unit,
            l0."position" AS exterior_wall_layer0_position,
            l0.building_material_id AS exterior_wall_layer0_material_id,
            bm0.building_material_name AS exterior_wall_layer0_material_name,
            l0.thickness AS exterior_wall_layer0_thickness,
            u0_th.unit_name AS exterior_wall_layer0_thickness_unit,
            bm0.solar_absorption_rate AS exterior_wall_layer0_solar_absorption_rate,
            bm0.thermal_capacity AS exterior_wall_layer0_thermal_capacity,
            u0_tc.unit_name AS exterior_wall_layer0_thermal_capacity_unit,
            bm0.thermal_conductivity AS exterior_wall_layer0_thermal_conductivity,
            u0_tco.unit_name AS exterior_wall_layer0_thermal_conductivity_unit,
            sl0.service_life AS exterior_wall_layer0_service_life,
            u0_sl.unit_name AS exterior_wall_layer0_service_life_unit,
            bm0.density AS exterior_wall_layer0_density,
            u0_d.unit_name AS exterior_wall_layer0_density_unit,
            l1."position" AS exterior_wall_layer1_position,
            l1.building_material_id AS exterior_wall_layer1_material_id,
            bm1.building_material_name AS exterior_wall_layer1_material_name,
            l1.thickness AS exterior_wall_layer1_thickness,
            u1_th.unit_name AS exterior_wall_layer1_thickness_unit,
            bm1.solar_absorption_rate AS exterior_wall_layer1_solar_absorption_rate,
            bm1.thermal_capacity AS exterior_wall_layer1_thermal_capacity,
            u1_tc.unit_name AS exterior_wall_layer1_thermal_capacity_unit,
            bm1.thermal_conductivity AS exterior_wall_layer1_thermal_conductivity,
            u1_tco.unit_name AS exterior_wall_layer1_thermal_conductivity_unit,
            sl1.service_life AS exterior_wall_layer1_service_life,
            u1_sl.unit_name AS exterior_wall_layer1_service_life_unit,
            bm1.density AS exterior_wall_layer1_density,
            u1_d.unit_name AS exterior_wall_layer1_density_unit,
            l2."position" AS exterior_wall_layer2_position,
            l2.building_material_id AS exterior_wall_layer2_material_id,
            bm2.building_material_name AS exterior_wall_layer2_material_name,
            l2.thickness AS exterior_wall_layer2_thickness,
            u2_th.unit_name AS exterior_wall_layer2_thickness_unit,
            bm2.solar_absorption_rate AS exterior_wall_layer2_solar_absorption_rate,
            bm2.thermal_capacity AS exterior_wall_layer2_thermal_capacity,
            u2_tc.unit_name AS exterior_wall_layer2_thermal_capacity_unit,
            bm2.thermal_conductivity AS exterior_wall_layer2_thermal_conductivity,
            u2_tco.unit_name AS exterior_wall_layer2_thermal_conductivity_unit,
            sl2.service_life AS exterior_wall_layer2_service_life,
            u2_sl.unit_name AS exterior_wall_layer2_service_life_unit,
            bm2.density AS exterior_wall_layer2_density,
            u2_d.unit_name AS exterior_wall_layer2_density_unit,
            l3."position" AS exterior_wall_layer3_position,
            l3.building_material_id AS exterior_wall_layer3_material_id,
            bm3.building_material_name AS exterior_wall_layer3_material_name,
            l3.thickness AS exterior_wall_layer3_thickness,
            u3_th.unit_name AS exterior_wall_layer3_thickness_unit,
            bm3.solar_absorption_rate AS exterior_wall_layer3_solar_absorption_rate,
            bm3.thermal_capacity AS exterior_wall_layer3_thermal_capacity,
            u3_tc.unit_name AS exterior_wall_layer3_thermal_capacity_unit,
            bm3.thermal_conductivity AS exterior_wall_layer3_thermal_conductivity,
            u3_tco.unit_name AS exterior_wall_layer3_thermal_conductivity_unit,
            sl3.service_life AS exterior_wall_layer3_service_life,
            u3_sl.unit_name AS exterior_wall_layer3_service_life_unit,
            bm3.density AS exterior_wall_layer3_density,
            u3_d.unit_name AS exterior_wall_layer3_density_unit,
            l4."position" AS exterior_wall_layer4_position,
            l4.building_material_id AS exterior_wall_layer4_material_id,
            bm4.building_material_name AS exterior_wall_layer4_material_name,
            l4.thickness AS exterior_wall_layer4_thickness,
            u4_th.unit_name AS exterior_wall_layer4_thickness_unit,
            bm4.solar_absorption_rate AS exterior_wall_layer4_solar_absorption_rate,
            bm4.thermal_capacity AS exterior_wall_layer4_thermal_capacity,
            u4_tc.unit_name AS exterior_wall_layer4_thermal_capacity_unit,
            bm4.thermal_conductivity AS exterior_wall_layer4_thermal_conductivity,
            u4_tco.unit_name AS exterior_wall_layer4_thermal_conductivity_unit,
            sl4.service_life AS exterior_wall_layer4_service_life,
            u4_sl.unit_name AS exterior_wall_layer4_service_life_unit,
            bm4.density AS exterior_wall_layer4_density,
            u4_d.unit_name AS exterior_wall_layer4_density_unit,
            l5."position" AS exterior_wall_layer5_position,
            l5.building_material_id AS exterior_wall_layer5_material_id,
            bm5.building_material_name AS exterior_wall_layer5_material_name,
            l5.thickness AS exterior_wall_layer5_thickness,
            u5_th.unit_name AS exterior_wall_layer5_thickness_unit,
            bm5.solar_absorption_rate AS exterior_wall_layer5_solar_absorption_rate,
            bm5.thermal_capacity AS exterior_wall_layer5_thermal_capacity,
            u5_tc.unit_name AS exterior_wall_layer5_thermal_capacity_unit,
            bm5.thermal_conductivity AS exterior_wall_layer5_thermal_conductivity,
            u5_tco.unit_name AS exterior_wall_layer5_thermal_conductivity_unit,
            sl5.service_life AS exterior_wall_layer5_service_life,
            u5_sl.unit_name AS exterior_wall_layer5_service_life_unit,
            bm5.density AS exterior_wall_layer5_density,
            u5_d.unit_name AS exterior_wall_layer5_density_unit
           FROM ((((((((((((((((((((((((((((((((((((((((((((((((step_003 b
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = b.exterior_wall_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_th ON ((u0_th.unit_id = l0.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tc ON ((u0_tc.unit_id = bm0.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tco ON ((u0_tco.unit_id = bm0.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl0 ON ((sl0.service_life_id = bm0.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_sl ON ((u0_sl.unit_id = sl0.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_d ON ((u0_d.unit_id = bm0.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = b.exterior_wall_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_th ON ((u1_th.unit_id = l1.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tc ON ((u1_tc.unit_id = bm1.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tco ON ((u1_tco.unit_id = bm1.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl1 ON ((sl1.service_life_id = bm1.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_sl ON ((u1_sl.unit_id = sl1.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_d ON ((u1_d.unit_id = bm1.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = b.exterior_wall_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_th ON ((u2_th.unit_id = l2.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tc ON ((u2_tc.unit_id = bm2.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tco ON ((u2_tco.unit_id = bm2.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl2 ON ((sl2.service_life_id = bm2.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_sl ON ((u2_sl.unit_id = sl2.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_d ON ((u2_d.unit_id = bm2.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l3 ON (((l3.building_element_id = b.exterior_wall_building_element_id) AND (l3."position" = 3))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm3 ON ((bm3.building_material_id = l3.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_th ON ((u3_th.unit_id = l3.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_tc ON ((u3_tc.unit_id = bm3.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_tco ON ((u3_tco.unit_id = bm3.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl3 ON ((sl3.service_life_id = bm3.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_sl ON ((u3_sl.unit_id = sl3.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_d ON ((u3_d.unit_id = bm3.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l4 ON (((l4.building_element_id = b.exterior_wall_building_element_id) AND (l4."position" = 4))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm4 ON ((bm4.building_material_id = l4.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_th ON ((u4_th.unit_id = l4.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_tc ON ((u4_tc.unit_id = bm4.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_tco ON ((u4_tco.unit_id = bm4.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl4 ON ((sl4.service_life_id = bm4.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_sl ON ((u4_sl.unit_id = sl4.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_d ON ((u4_d.unit_id = bm4.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l5 ON (((l5.building_element_id = b.exterior_wall_building_element_id) AND (l5."position" = 5))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm5 ON ((bm5.building_material_id = l5.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_th ON ((u5_th.unit_id = l5.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_tc ON ((u5_tc.unit_id = bm5.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_tco ON ((u5_tco.unit_id = bm5.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl5 ON ((sl5.service_life_id = bm5.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_sl ON ((u5_sl.unit_id = sl5.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_d ON ((u5_d.unit_id = bm5.density_unit_id)))
        ), step_005 AS (
         SELECT f.building_archetype_id,
            f.building_archetype_name,
            f.share_of_building_type,
            f.share_of_building_type_in_region,
            f.share_of_building_type_in_region_mun,
            f.exterior_wall_building_element_id,
            f.interior_wall_building_element_id,
            f.roof_building_element_id,
            f.foundation_building_element_id,
            f.floor_building_element_id,
            f.window_building_element_id,
            f.energy_system_id,
            f.building_type_name,
            f.region_name,
            f.municipality_size_name,
            f.municipality_growth_name,
            f.age_class_name,
            f.building_adjacency_name,
            f.facade_to_net_leased_area_ratio_mean,
            f.facade_to_net_leased_area_ratio_se_min,
            f.facade_to_net_leased_area_ratio_se_max,
            f.roof_to_net_leased_area_ratio_mean,
            f.roof_to_net_leased_area_ratio_se_min,
            f.roof_to_net_leased_area_ratio_se_max,
            f.foundation_to_net_leased_area_ratio_mean,
            f.foundation_to_net_leased_area_ratio_se_min,
            f.foundation_to_net_leased_area_ratio_se_max,
            f.window_to_net_leased_area_ratio_mean,
            f.window_to_net_leased_area_ratio_se_min,
            f.window_to_net_leased_area_ratio_se_max,
            f.building_height_mean,
            f.building_height_se,
            f.height_unit,
            f.aspect_ratio_mean,
            f.aspect_ratio_se_min,
            f.aspect_ratio_se_max,
            f.storeys_below_ground_mean,
            f.storeys_below_ground_se,
            f.storeys_above_ground_mean,
            f.storeys_above_ground_se,
            f.storeys_above_ground_se_min,
            f.storeys_above_ground_se_max,
            f.storey_height_mean,
            f.storey_height_se_min,
            f.storey_height_se_max,
            f.window_share,
            f.net_leased_area_mean,
            f.net_leased_area_se,
            f.net_leased_area_se_min,
            f.net_leased_area_se_max,
            f.net_leased_area_unit,
            f.facade_area_north_mean,
            f.facade_area_north_se,
            f.facade_area_east_mean,
            f.facade_area_east_se,
            f.facade_area_south_mean,
            f.facade_area_south_se,
            f.facade_area_west_mean,
            f.facade_area_west_se,
            f.facade_area_unit,
            f.facade_length_north_mean,
            f.facade_length_north_se,
            f.facade_length_east_mean,
            f.facade_length_east_se,
            f.facade_length_south_mean,
            f.facade_length_south_se,
            f.facade_length_west_mean,
            f.facade_length_west_se,
            f.facade_length_unit,
            f.exterior_wall_name,
            f.exterior_wall_construction_type,
            f.exterior_wall_u_value_typical_min,
            f.exterior_wall_u_value_typical_max,
            f.exterior_wall_u_value,
            f.exterior_wall_u_value_unit,
            f.exterior_wall_inner_radiation,
            f.exterior_wall_inner_radiation_unit,
            f.exterior_wall_outer_radiation,
            f.exterior_wall_outer_radiation_unit,
            f.exterior_wall_inner_convection,
            f.exterior_wall_inner_convection_unit,
            f.exterior_wall_outer_convection,
            f.exterior_wall_outer_convection_unit,
            f.exterior_wall_layer0_position,
            f.exterior_wall_layer0_material_id,
            f.exterior_wall_layer0_material_name,
            f.exterior_wall_layer0_thickness,
            f.exterior_wall_layer0_thickness_unit,
            f.exterior_wall_layer0_solar_absorption_rate,
            f.exterior_wall_layer0_thermal_capacity,
            f.exterior_wall_layer0_thermal_capacity_unit,
            f.exterior_wall_layer0_thermal_conductivity,
            f.exterior_wall_layer0_thermal_conductivity_unit,
            f.exterior_wall_layer0_service_life,
            f.exterior_wall_layer0_service_life_unit,
            f.exterior_wall_layer0_density,
            f.exterior_wall_layer0_density_unit,
            f.exterior_wall_layer1_position,
            f.exterior_wall_layer1_material_id,
            f.exterior_wall_layer1_material_name,
            f.exterior_wall_layer1_thickness,
            f.exterior_wall_layer1_thickness_unit,
            f.exterior_wall_layer1_solar_absorption_rate,
            f.exterior_wall_layer1_thermal_capacity,
            f.exterior_wall_layer1_thermal_capacity_unit,
            f.exterior_wall_layer1_thermal_conductivity,
            f.exterior_wall_layer1_thermal_conductivity_unit,
            f.exterior_wall_layer1_service_life,
            f.exterior_wall_layer1_service_life_unit,
            f.exterior_wall_layer1_density,
            f.exterior_wall_layer1_density_unit,
            f.exterior_wall_layer2_position,
            f.exterior_wall_layer2_material_id,
            f.exterior_wall_layer2_material_name,
            f.exterior_wall_layer2_thickness,
            f.exterior_wall_layer2_thickness_unit,
            f.exterior_wall_layer2_solar_absorption_rate,
            f.exterior_wall_layer2_thermal_capacity,
            f.exterior_wall_layer2_thermal_capacity_unit,
            f.exterior_wall_layer2_thermal_conductivity,
            f.exterior_wall_layer2_thermal_conductivity_unit,
            f.exterior_wall_layer2_service_life,
            f.exterior_wall_layer2_service_life_unit,
            f.exterior_wall_layer2_density,
            f.exterior_wall_layer2_density_unit,
            f.exterior_wall_layer3_position,
            f.exterior_wall_layer3_material_id,
            f.exterior_wall_layer3_material_name,
            f.exterior_wall_layer3_thickness,
            f.exterior_wall_layer3_thickness_unit,
            f.exterior_wall_layer3_solar_absorption_rate,
            f.exterior_wall_layer3_thermal_capacity,
            f.exterior_wall_layer3_thermal_capacity_unit,
            f.exterior_wall_layer3_thermal_conductivity,
            f.exterior_wall_layer3_thermal_conductivity_unit,
            f.exterior_wall_layer3_service_life,
            f.exterior_wall_layer3_service_life_unit,
            f.exterior_wall_layer3_density,
            f.exterior_wall_layer3_density_unit,
            f.exterior_wall_layer4_position,
            f.exterior_wall_layer4_material_id,
            f.exterior_wall_layer4_material_name,
            f.exterior_wall_layer4_thickness,
            f.exterior_wall_layer4_thickness_unit,
            f.exterior_wall_layer4_solar_absorption_rate,
            f.exterior_wall_layer4_thermal_capacity,
            f.exterior_wall_layer4_thermal_capacity_unit,
            f.exterior_wall_layer4_thermal_conductivity,
            f.exterior_wall_layer4_thermal_conductivity_unit,
            f.exterior_wall_layer4_service_life,
            f.exterior_wall_layer4_service_life_unit,
            f.exterior_wall_layer4_density,
            f.exterior_wall_layer4_density_unit,
            f.exterior_wall_layer5_position,
            f.exterior_wall_layer5_material_id,
            f.exterior_wall_layer5_material_name,
            f.exterior_wall_layer5_thickness,
            f.exterior_wall_layer5_thickness_unit,
            f.exterior_wall_layer5_solar_absorption_rate,
            f.exterior_wall_layer5_thermal_capacity,
            f.exterior_wall_layer5_thermal_capacity_unit,
            f.exterior_wall_layer5_thermal_conductivity,
            f.exterior_wall_layer5_thermal_conductivity_unit,
            f.exterior_wall_layer5_service_life,
            f.exterior_wall_layer5_service_life_unit,
            f.exterior_wall_layer5_density,
            f.exterior_wall_layer5_density_unit,
            epd0_1.environmental_product_declaration_name AS exterior_wall_layer0_epd1_oekobaudat_name,
            epd0_1.database_uuid AS exterior_wall_layer0_epd1_oekobaudat_uuid,
            epd0_2.environmental_product_declaration_name AS exterior_wall_layer0_epd2_oekobaudat_name,
            epd0_2.database_uuid AS exterior_wall_layer0_epd2_oekobaudat_uuid,
            epd1_1.environmental_product_declaration_name AS exterior_wall_layer1_epd1_oekobaudat_name,
            epd1_1.database_uuid AS exterior_wall_layer1_epd1_oekobaudat_uuid,
            epd1_2.environmental_product_declaration_name AS exterior_wall_layer1_epd2_oekobaudat_name,
            epd1_2.database_uuid AS exterior_wall_layer1_epd2_oekobaudat_uuid,
            epd2_1.environmental_product_declaration_name AS exterior_wall_layer2_epd1_oekobaudat_name,
            epd2_1.database_uuid AS exterior_wall_layer2_epd1_oekobaudat_uuid,
            epd2_2.environmental_product_declaration_name AS exterior_wall_layer2_epd2_oekobaudat_name,
            epd2_2.database_uuid AS exterior_wall_layer2_epd2_oekobaudat_uuid,
            epd3_1.environmental_product_declaration_name AS exterior_wall_layer3_epd1_oekobaudat_name,
            epd3_1.database_uuid AS exterior_wall_layer3_epd1_oekobaudat_uuid,
            epd3_2.environmental_product_declaration_name AS exterior_wall_layer3_epd2_oekobaudat_name,
            epd3_2.database_uuid AS exterior_wall_layer3_epd2_oekobaudat_uuid,
            epd4_1.environmental_product_declaration_name AS exterior_wall_layer4_epd1_oekobaudat_name,
            epd4_1.database_uuid AS exterior_wall_layer4_epd1_oekobaudat_uuid,
            epd4_2.environmental_product_declaration_name AS exterior_wall_layer4_epd2_oekobaudat_name,
            epd4_2.database_uuid AS exterior_wall_layer4_epd2_oekobaudat_uuid,
            epd5_1.environmental_product_declaration_name AS exterior_wall_layer5_epd1_oekobaudat_name,
            epd5_1.database_uuid AS exterior_wall_layer5_epd1_oekobaudat_uuid,
            epd5_2.environmental_product_declaration_name AS exterior_wall_layer5_epd2_oekobaudat_name,
            epd5_2.database_uuid AS exterior_wall_layer5_epd2_oekobaudat_uuid
           FROM ((((((((((((((((((((((((step_004 f
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = f.exterior_wall_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_1 ON ((epd0_1.environmental_product_declaration_id = bm0.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_2 ON ((epd0_2.environmental_product_declaration_id = bm0.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = f.exterior_wall_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_1 ON ((epd1_1.environmental_product_declaration_id = bm1.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_2 ON ((epd1_2.environmental_product_declaration_id = bm1.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = f.exterior_wall_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_1 ON ((epd2_1.environmental_product_declaration_id = bm2.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_2 ON ((epd2_2.environmental_product_declaration_id = bm2.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l3 ON (((l3.building_element_id = f.exterior_wall_building_element_id) AND (l3."position" = 3))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm3 ON ((bm3.building_material_id = l3.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd3_1 ON ((epd3_1.environmental_product_declaration_id = bm3.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd3_2 ON ((epd3_2.environmental_product_declaration_id = bm3.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l4 ON (((l4.building_element_id = f.exterior_wall_building_element_id) AND (l4."position" = 4))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm4 ON ((bm4.building_material_id = l4.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd4_1 ON ((epd4_1.environmental_product_declaration_id = bm4.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd4_2 ON ((epd4_2.environmental_product_declaration_id = bm4.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l5 ON (((l5.building_element_id = f.exterior_wall_building_element_id) AND (l5."position" = 5))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm5 ON ((bm5.building_material_id = l5.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd5_1 ON ((epd5_1.environmental_product_declaration_id = bm5.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd5_2 ON ((epd5_2.environmental_product_declaration_id = bm5.environmental_product_declaration_id_2)))
        ), step_006 AS (
         SELECT v.building_archetype_id,
            v.building_archetype_name,
            v.share_of_building_type,
            v.share_of_building_type_in_region,
            v.share_of_building_type_in_region_mun,
            v.exterior_wall_building_element_id,
            v.interior_wall_building_element_id,
            v.roof_building_element_id,
            v.foundation_building_element_id,
            v.floor_building_element_id,
            v.window_building_element_id,
            v.energy_system_id,
            v.building_type_name,
            v.region_name,
            v.municipality_size_name,
            v.municipality_growth_name,
            v.age_class_name,
            v.building_adjacency_name,
            v.facade_to_net_leased_area_ratio_mean,
            v.facade_to_net_leased_area_ratio_se_min,
            v.facade_to_net_leased_area_ratio_se_max,
            v.roof_to_net_leased_area_ratio_mean,
            v.roof_to_net_leased_area_ratio_se_min,
            v.roof_to_net_leased_area_ratio_se_max,
            v.foundation_to_net_leased_area_ratio_mean,
            v.foundation_to_net_leased_area_ratio_se_min,
            v.foundation_to_net_leased_area_ratio_se_max,
            v.window_to_net_leased_area_ratio_mean,
            v.window_to_net_leased_area_ratio_se_min,
            v.window_to_net_leased_area_ratio_se_max,
            v.building_height_mean,
            v.building_height_se,
            v.height_unit,
            v.aspect_ratio_mean,
            v.aspect_ratio_se_min,
            v.aspect_ratio_se_max,
            v.storeys_below_ground_mean,
            v.storeys_below_ground_se,
            v.storeys_above_ground_mean,
            v.storeys_above_ground_se,
            v.storeys_above_ground_se_min,
            v.storeys_above_ground_se_max,
            v.storey_height_mean,
            v.storey_height_se_min,
            v.storey_height_se_max,
            v.window_share,
            v.net_leased_area_mean,
            v.net_leased_area_se,
            v.net_leased_area_se_min,
            v.net_leased_area_se_max,
            v.net_leased_area_unit,
            v.facade_area_north_mean,
            v.facade_area_north_se,
            v.facade_area_east_mean,
            v.facade_area_east_se,
            v.facade_area_south_mean,
            v.facade_area_south_se,
            v.facade_area_west_mean,
            v.facade_area_west_se,
            v.facade_area_unit,
            v.facade_length_north_mean,
            v.facade_length_north_se,
            v.facade_length_east_mean,
            v.facade_length_east_se,
            v.facade_length_south_mean,
            v.facade_length_south_se,
            v.facade_length_west_mean,
            v.facade_length_west_se,
            v.facade_length_unit,
            v.exterior_wall_name,
            v.exterior_wall_construction_type,
            v.exterior_wall_u_value_typical_min,
            v.exterior_wall_u_value_typical_max,
            v.exterior_wall_u_value,
            v.exterior_wall_u_value_unit,
            v.exterior_wall_inner_radiation,
            v.exterior_wall_inner_radiation_unit,
            v.exterior_wall_outer_radiation,
            v.exterior_wall_outer_radiation_unit,
            v.exterior_wall_inner_convection,
            v.exterior_wall_inner_convection_unit,
            v.exterior_wall_outer_convection,
            v.exterior_wall_outer_convection_unit,
            v.exterior_wall_layer0_position,
            v.exterior_wall_layer0_material_id,
            v.exterior_wall_layer0_material_name,
            v.exterior_wall_layer0_thickness,
            v.exterior_wall_layer0_thickness_unit,
            v.exterior_wall_layer0_solar_absorption_rate,
            v.exterior_wall_layer0_thermal_capacity,
            v.exterior_wall_layer0_thermal_capacity_unit,
            v.exterior_wall_layer0_thermal_conductivity,
            v.exterior_wall_layer0_thermal_conductivity_unit,
            v.exterior_wall_layer0_service_life,
            v.exterior_wall_layer0_service_life_unit,
            v.exterior_wall_layer0_density,
            v.exterior_wall_layer0_density_unit,
            v.exterior_wall_layer1_position,
            v.exterior_wall_layer1_material_id,
            v.exterior_wall_layer1_material_name,
            v.exterior_wall_layer1_thickness,
            v.exterior_wall_layer1_thickness_unit,
            v.exterior_wall_layer1_solar_absorption_rate,
            v.exterior_wall_layer1_thermal_capacity,
            v.exterior_wall_layer1_thermal_capacity_unit,
            v.exterior_wall_layer1_thermal_conductivity,
            v.exterior_wall_layer1_thermal_conductivity_unit,
            v.exterior_wall_layer1_service_life,
            v.exterior_wall_layer1_service_life_unit,
            v.exterior_wall_layer1_density,
            v.exterior_wall_layer1_density_unit,
            v.exterior_wall_layer2_position,
            v.exterior_wall_layer2_material_id,
            v.exterior_wall_layer2_material_name,
            v.exterior_wall_layer2_thickness,
            v.exterior_wall_layer2_thickness_unit,
            v.exterior_wall_layer2_solar_absorption_rate,
            v.exterior_wall_layer2_thermal_capacity,
            v.exterior_wall_layer2_thermal_capacity_unit,
            v.exterior_wall_layer2_thermal_conductivity,
            v.exterior_wall_layer2_thermal_conductivity_unit,
            v.exterior_wall_layer2_service_life,
            v.exterior_wall_layer2_service_life_unit,
            v.exterior_wall_layer2_density,
            v.exterior_wall_layer2_density_unit,
            v.exterior_wall_layer3_position,
            v.exterior_wall_layer3_material_id,
            v.exterior_wall_layer3_material_name,
            v.exterior_wall_layer3_thickness,
            v.exterior_wall_layer3_thickness_unit,
            v.exterior_wall_layer3_solar_absorption_rate,
            v.exterior_wall_layer3_thermal_capacity,
            v.exterior_wall_layer3_thermal_capacity_unit,
            v.exterior_wall_layer3_thermal_conductivity,
            v.exterior_wall_layer3_thermal_conductivity_unit,
            v.exterior_wall_layer3_service_life,
            v.exterior_wall_layer3_service_life_unit,
            v.exterior_wall_layer3_density,
            v.exterior_wall_layer3_density_unit,
            v.exterior_wall_layer4_position,
            v.exterior_wall_layer4_material_id,
            v.exterior_wall_layer4_material_name,
            v.exterior_wall_layer4_thickness,
            v.exterior_wall_layer4_thickness_unit,
            v.exterior_wall_layer4_solar_absorption_rate,
            v.exterior_wall_layer4_thermal_capacity,
            v.exterior_wall_layer4_thermal_capacity_unit,
            v.exterior_wall_layer4_thermal_conductivity,
            v.exterior_wall_layer4_thermal_conductivity_unit,
            v.exterior_wall_layer4_service_life,
            v.exterior_wall_layer4_service_life_unit,
            v.exterior_wall_layer4_density,
            v.exterior_wall_layer4_density_unit,
            v.exterior_wall_layer5_position,
            v.exterior_wall_layer5_material_id,
            v.exterior_wall_layer5_material_name,
            v.exterior_wall_layer5_thickness,
            v.exterior_wall_layer5_thickness_unit,
            v.exterior_wall_layer5_solar_absorption_rate,
            v.exterior_wall_layer5_thermal_capacity,
            v.exterior_wall_layer5_thermal_capacity_unit,
            v.exterior_wall_layer5_thermal_conductivity,
            v.exterior_wall_layer5_thermal_conductivity_unit,
            v.exterior_wall_layer5_service_life,
            v.exterior_wall_layer5_service_life_unit,
            v.exterior_wall_layer5_density,
            v.exterior_wall_layer5_density_unit,
            v.exterior_wall_layer0_epd1_oekobaudat_name,
            v.exterior_wall_layer0_epd1_oekobaudat_uuid,
            v.exterior_wall_layer0_epd2_oekobaudat_name,
            v.exterior_wall_layer0_epd2_oekobaudat_uuid,
            v.exterior_wall_layer1_epd1_oekobaudat_name,
            v.exterior_wall_layer1_epd1_oekobaudat_uuid,
            v.exterior_wall_layer1_epd2_oekobaudat_name,
            v.exterior_wall_layer1_epd2_oekobaudat_uuid,
            v.exterior_wall_layer2_epd1_oekobaudat_name,
            v.exterior_wall_layer2_epd1_oekobaudat_uuid,
            v.exterior_wall_layer2_epd2_oekobaudat_name,
            v.exterior_wall_layer2_epd2_oekobaudat_uuid,
            v.exterior_wall_layer3_epd1_oekobaudat_name,
            v.exterior_wall_layer3_epd1_oekobaudat_uuid,
            v.exterior_wall_layer3_epd2_oekobaudat_name,
            v.exterior_wall_layer3_epd2_oekobaudat_uuid,
            v.exterior_wall_layer4_epd1_oekobaudat_name,
            v.exterior_wall_layer4_epd1_oekobaudat_uuid,
            v.exterior_wall_layer4_epd2_oekobaudat_name,
            v.exterior_wall_layer4_epd2_oekobaudat_uuid,
            v.exterior_wall_layer5_epd1_oekobaudat_name,
            v.exterior_wall_layer5_epd1_oekobaudat_uuid,
            v.exterior_wall_layer5_epd2_oekobaudat_name,
            v.exterior_wall_layer5_epd2_oekobaudat_uuid,
            be.building_element_name AS interior_wall_name,
            be.u_value_typical_min AS interior_wall_u_value_typical_min,
            be.u_value_typical_max AS interior_wall_u_value_typical_max,
            be.u_value AS interior_wall_u_value,
            u.unit_name AS interior_wall_u_value_unit,
            be.inner_radiation AS interior_wall_inner_radiation,
            u1.unit_name AS interior_wall_inner_radiation_unit,
            be.inner_convection AS interior_wall_inner_convection,
            u3.unit_name AS interior_wall_inner_convection_unit
           FROM ((((step_005 v
             LEFT JOIN hub4lca_post_simulation.building_elements be ON ((be.building_element_id = v.interior_wall_building_element_id)))
             LEFT JOIN hub4lca_post_simulation.units u ON ((u.unit_id = be.u_value_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1 ON ((u1.unit_id = be.inner_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3 ON ((u3.unit_id = be.inner_convection_unit_id)))
        ), step_007 AS (
         SELECT b.building_archetype_id,
            b.building_archetype_name,
            b.share_of_building_type,
            b.share_of_building_type_in_region,
            b.share_of_building_type_in_region_mun,
            b.exterior_wall_building_element_id,
            b.interior_wall_building_element_id,
            b.roof_building_element_id,
            b.foundation_building_element_id,
            b.floor_building_element_id,
            b.window_building_element_id,
            b.energy_system_id,
            b.building_type_name,
            b.region_name,
            b.municipality_size_name,
            b.municipality_growth_name,
            b.age_class_name,
            b.building_adjacency_name,
            b.facade_to_net_leased_area_ratio_mean,
            b.facade_to_net_leased_area_ratio_se_min,
            b.facade_to_net_leased_area_ratio_se_max,
            b.roof_to_net_leased_area_ratio_mean,
            b.roof_to_net_leased_area_ratio_se_min,
            b.roof_to_net_leased_area_ratio_se_max,
            b.foundation_to_net_leased_area_ratio_mean,
            b.foundation_to_net_leased_area_ratio_se_min,
            b.foundation_to_net_leased_area_ratio_se_max,
            b.window_to_net_leased_area_ratio_mean,
            b.window_to_net_leased_area_ratio_se_min,
            b.window_to_net_leased_area_ratio_se_max,
            b.building_height_mean,
            b.building_height_se,
            b.height_unit,
            b.aspect_ratio_mean,
            b.aspect_ratio_se_min,
            b.aspect_ratio_se_max,
            b.storeys_below_ground_mean,
            b.storeys_below_ground_se,
            b.storeys_above_ground_mean,
            b.storeys_above_ground_se,
            b.storeys_above_ground_se_min,
            b.storeys_above_ground_se_max,
            b.storey_height_mean,
            b.storey_height_se_min,
            b.storey_height_se_max,
            b.window_share,
            b.net_leased_area_mean,
            b.net_leased_area_se,
            b.net_leased_area_se_min,
            b.net_leased_area_se_max,
            b.net_leased_area_unit,
            b.facade_area_north_mean,
            b.facade_area_north_se,
            b.facade_area_east_mean,
            b.facade_area_east_se,
            b.facade_area_south_mean,
            b.facade_area_south_se,
            b.facade_area_west_mean,
            b.facade_area_west_se,
            b.facade_area_unit,
            b.facade_length_north_mean,
            b.facade_length_north_se,
            b.facade_length_east_mean,
            b.facade_length_east_se,
            b.facade_length_south_mean,
            b.facade_length_south_se,
            b.facade_length_west_mean,
            b.facade_length_west_se,
            b.facade_length_unit,
            b.exterior_wall_name,
            b.exterior_wall_construction_type,
            b.exterior_wall_u_value_typical_min,
            b.exterior_wall_u_value_typical_max,
            b.exterior_wall_u_value,
            b.exterior_wall_u_value_unit,
            b.exterior_wall_inner_radiation,
            b.exterior_wall_inner_radiation_unit,
            b.exterior_wall_outer_radiation,
            b.exterior_wall_outer_radiation_unit,
            b.exterior_wall_inner_convection,
            b.exterior_wall_inner_convection_unit,
            b.exterior_wall_outer_convection,
            b.exterior_wall_outer_convection_unit,
            b.exterior_wall_layer0_position,
            b.exterior_wall_layer0_material_id,
            b.exterior_wall_layer0_material_name,
            b.exterior_wall_layer0_thickness,
            b.exterior_wall_layer0_thickness_unit,
            b.exterior_wall_layer0_solar_absorption_rate,
            b.exterior_wall_layer0_thermal_capacity,
            b.exterior_wall_layer0_thermal_capacity_unit,
            b.exterior_wall_layer0_thermal_conductivity,
            b.exterior_wall_layer0_thermal_conductivity_unit,
            b.exterior_wall_layer0_service_life,
            b.exterior_wall_layer0_service_life_unit,
            b.exterior_wall_layer0_density,
            b.exterior_wall_layer0_density_unit,
            b.exterior_wall_layer1_position,
            b.exterior_wall_layer1_material_id,
            b.exterior_wall_layer1_material_name,
            b.exterior_wall_layer1_thickness,
            b.exterior_wall_layer1_thickness_unit,
            b.exterior_wall_layer1_solar_absorption_rate,
            b.exterior_wall_layer1_thermal_capacity,
            b.exterior_wall_layer1_thermal_capacity_unit,
            b.exterior_wall_layer1_thermal_conductivity,
            b.exterior_wall_layer1_thermal_conductivity_unit,
            b.exterior_wall_layer1_service_life,
            b.exterior_wall_layer1_service_life_unit,
            b.exterior_wall_layer1_density,
            b.exterior_wall_layer1_density_unit,
            b.exterior_wall_layer2_position,
            b.exterior_wall_layer2_material_id,
            b.exterior_wall_layer2_material_name,
            b.exterior_wall_layer2_thickness,
            b.exterior_wall_layer2_thickness_unit,
            b.exterior_wall_layer2_solar_absorption_rate,
            b.exterior_wall_layer2_thermal_capacity,
            b.exterior_wall_layer2_thermal_capacity_unit,
            b.exterior_wall_layer2_thermal_conductivity,
            b.exterior_wall_layer2_thermal_conductivity_unit,
            b.exterior_wall_layer2_service_life,
            b.exterior_wall_layer2_service_life_unit,
            b.exterior_wall_layer2_density,
            b.exterior_wall_layer2_density_unit,
            b.exterior_wall_layer3_position,
            b.exterior_wall_layer3_material_id,
            b.exterior_wall_layer3_material_name,
            b.exterior_wall_layer3_thickness,
            b.exterior_wall_layer3_thickness_unit,
            b.exterior_wall_layer3_solar_absorption_rate,
            b.exterior_wall_layer3_thermal_capacity,
            b.exterior_wall_layer3_thermal_capacity_unit,
            b.exterior_wall_layer3_thermal_conductivity,
            b.exterior_wall_layer3_thermal_conductivity_unit,
            b.exterior_wall_layer3_service_life,
            b.exterior_wall_layer3_service_life_unit,
            b.exterior_wall_layer3_density,
            b.exterior_wall_layer3_density_unit,
            b.exterior_wall_layer4_position,
            b.exterior_wall_layer4_material_id,
            b.exterior_wall_layer4_material_name,
            b.exterior_wall_layer4_thickness,
            b.exterior_wall_layer4_thickness_unit,
            b.exterior_wall_layer4_solar_absorption_rate,
            b.exterior_wall_layer4_thermal_capacity,
            b.exterior_wall_layer4_thermal_capacity_unit,
            b.exterior_wall_layer4_thermal_conductivity,
            b.exterior_wall_layer4_thermal_conductivity_unit,
            b.exterior_wall_layer4_service_life,
            b.exterior_wall_layer4_service_life_unit,
            b.exterior_wall_layer4_density,
            b.exterior_wall_layer4_density_unit,
            b.exterior_wall_layer5_position,
            b.exterior_wall_layer5_material_id,
            b.exterior_wall_layer5_material_name,
            b.exterior_wall_layer5_thickness,
            b.exterior_wall_layer5_thickness_unit,
            b.exterior_wall_layer5_solar_absorption_rate,
            b.exterior_wall_layer5_thermal_capacity,
            b.exterior_wall_layer5_thermal_capacity_unit,
            b.exterior_wall_layer5_thermal_conductivity,
            b.exterior_wall_layer5_thermal_conductivity_unit,
            b.exterior_wall_layer5_service_life,
            b.exterior_wall_layer5_service_life_unit,
            b.exterior_wall_layer5_density,
            b.exterior_wall_layer5_density_unit,
            b.exterior_wall_layer0_epd1_oekobaudat_name,
            b.exterior_wall_layer0_epd1_oekobaudat_uuid,
            b.exterior_wall_layer0_epd2_oekobaudat_name,
            b.exterior_wall_layer0_epd2_oekobaudat_uuid,
            b.exterior_wall_layer1_epd1_oekobaudat_name,
            b.exterior_wall_layer1_epd1_oekobaudat_uuid,
            b.exterior_wall_layer1_epd2_oekobaudat_name,
            b.exterior_wall_layer1_epd2_oekobaudat_uuid,
            b.exterior_wall_layer2_epd1_oekobaudat_name,
            b.exterior_wall_layer2_epd1_oekobaudat_uuid,
            b.exterior_wall_layer2_epd2_oekobaudat_name,
            b.exterior_wall_layer2_epd2_oekobaudat_uuid,
            b.exterior_wall_layer3_epd1_oekobaudat_name,
            b.exterior_wall_layer3_epd1_oekobaudat_uuid,
            b.exterior_wall_layer3_epd2_oekobaudat_name,
            b.exterior_wall_layer3_epd2_oekobaudat_uuid,
            b.exterior_wall_layer4_epd1_oekobaudat_name,
            b.exterior_wall_layer4_epd1_oekobaudat_uuid,
            b.exterior_wall_layer4_epd2_oekobaudat_name,
            b.exterior_wall_layer4_epd2_oekobaudat_uuid,
            b.exterior_wall_layer5_epd1_oekobaudat_name,
            b.exterior_wall_layer5_epd1_oekobaudat_uuid,
            b.exterior_wall_layer5_epd2_oekobaudat_name,
            b.exterior_wall_layer5_epd2_oekobaudat_uuid,
            b.interior_wall_name,
            b.interior_wall_u_value_typical_min,
            b.interior_wall_u_value_typical_max,
            b.interior_wall_u_value,
            b.interior_wall_u_value_unit,
            b.interior_wall_inner_radiation,
            b.interior_wall_inner_radiation_unit,
            b.interior_wall_inner_convection,
            b.interior_wall_inner_convection_unit,
            l0."position" AS interior_wall_layer0_position,
            l0.building_material_id AS interior_wall_layer0_material_id,
            bm0.building_material_name AS interior_wall_layer0_material_name,
            l0.thickness AS interior_wall_layer0_thickness,
            u0_th.unit_name AS interior_wall_layer0_thickness_unit,
            bm0.solar_absorption_rate AS interior_wall_layer0_solar_absorption_rate,
            bm0.thermal_capacity AS interior_wall_layer0_thermal_capacity,
            u0_tc.unit_name AS interior_wall_layer0_thermal_capacity_unit,
            bm0.thermal_conductivity AS interior_wall_layer0_thermal_conductivity,
            u0_tco.unit_name AS interior_wall_layer0_thermal_conductivity_unit,
            sl0.service_life AS interior_wall_layer0_service_life,
            u0_sl.unit_name AS interior_wall_layer0_service_life_unit,
            bm0.density AS interior_wall_layer0_density,
            u0_d.unit_name AS interior_wall_layer0_density_unit,
            l1."position" AS interior_wall_layer1_position,
            l1.building_material_id AS interior_wall_layer1_material_id,
            bm1.building_material_name AS interior_wall_layer1_material_name,
            l1.thickness AS interior_wall_layer1_thickness,
            u1_th.unit_name AS interior_wall_layer1_thickness_unit,
            bm1.solar_absorption_rate AS interior_wall_layer1_solar_absorption_rate,
            bm1.thermal_capacity AS interior_wall_layer1_thermal_capacity,
            u1_tc.unit_name AS interior_wall_layer1_thermal_capacity_unit,
            bm1.thermal_conductivity AS interior_wall_layer1_thermal_conductivity,
            u1_tco.unit_name AS interior_wall_layer1_thermal_conductivity_unit,
            sl1.service_life AS interior_wall_layer1_service_life,
            u1_sl.unit_name AS interior_wall_layer1_service_life_unit,
            bm1.density AS interior_wall_layer1_density,
            u1_d.unit_name AS interior_wall_layer1_density_unit,
            l2."position" AS interior_wall_layer2_position,
            l2.building_material_id AS interior_wall_layer2_material_id,
            bm2.building_material_name AS interior_wall_layer2_material_name,
            l2.thickness AS interior_wall_layer2_thickness,
            u2_th.unit_name AS interior_wall_layer2_thickness_unit,
            bm2.solar_absorption_rate AS interior_wall_layer2_solar_absorption_rate,
            bm2.thermal_capacity AS interior_wall_layer2_thermal_capacity,
            u2_tc.unit_name AS interior_wall_layer2_thermal_capacity_unit,
            bm2.thermal_conductivity AS interior_wall_layer2_thermal_conductivity,
            u2_tco.unit_name AS interior_wall_layer2_thermal_conductivity_unit,
            sl2.service_life AS interior_wall_layer2_service_life,
            u2_sl.unit_name AS interior_wall_layer2_service_life_unit,
            bm2.density AS interior_wall_layer2_density,
            u2_d.unit_name AS interior_wall_layer2_density_unit
           FROM ((((((((((((((((((((((((step_006 b
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = b.interior_wall_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_th ON ((u0_th.unit_id = l0.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tc ON ((u0_tc.unit_id = bm0.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tco ON ((u0_tco.unit_id = bm0.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl0 ON ((sl0.service_life_id = bm0.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_sl ON ((u0_sl.unit_id = sl0.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_d ON ((u0_d.unit_id = bm0.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = b.interior_wall_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_th ON ((u1_th.unit_id = l1.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tc ON ((u1_tc.unit_id = bm1.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tco ON ((u1_tco.unit_id = bm1.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl1 ON ((sl1.service_life_id = bm1.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_sl ON ((u1_sl.unit_id = sl1.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_d ON ((u1_d.unit_id = bm1.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = b.interior_wall_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_th ON ((u2_th.unit_id = l2.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tc ON ((u2_tc.unit_id = bm2.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tco ON ((u2_tco.unit_id = bm2.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl2 ON ((sl2.service_life_id = bm2.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_sl ON ((u2_sl.unit_id = sl2.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_d ON ((u2_d.unit_id = bm2.density_unit_id)))
        ), step_008 AS (
         SELECT f.building_archetype_id,
            f.building_archetype_name,
            f.share_of_building_type,
            f.share_of_building_type_in_region,
            f.share_of_building_type_in_region_mun,
            f.exterior_wall_building_element_id,
            f.interior_wall_building_element_id,
            f.roof_building_element_id,
            f.foundation_building_element_id,
            f.floor_building_element_id,
            f.window_building_element_id,
            f.energy_system_id,
            f.building_type_name,
            f.region_name,
            f.municipality_size_name,
            f.municipality_growth_name,
            f.age_class_name,
            f.building_adjacency_name,
            f.facade_to_net_leased_area_ratio_mean,
            f.facade_to_net_leased_area_ratio_se_min,
            f.facade_to_net_leased_area_ratio_se_max,
            f.roof_to_net_leased_area_ratio_mean,
            f.roof_to_net_leased_area_ratio_se_min,
            f.roof_to_net_leased_area_ratio_se_max,
            f.foundation_to_net_leased_area_ratio_mean,
            f.foundation_to_net_leased_area_ratio_se_min,
            f.foundation_to_net_leased_area_ratio_se_max,
            f.window_to_net_leased_area_ratio_mean,
            f.window_to_net_leased_area_ratio_se_min,
            f.window_to_net_leased_area_ratio_se_max,
            f.building_height_mean,
            f.building_height_se,
            f.height_unit,
            f.aspect_ratio_mean,
            f.aspect_ratio_se_min,
            f.aspect_ratio_se_max,
            f.storeys_below_ground_mean,
            f.storeys_below_ground_se,
            f.storeys_above_ground_mean,
            f.storeys_above_ground_se,
            f.storeys_above_ground_se_min,
            f.storeys_above_ground_se_max,
            f.storey_height_mean,
            f.storey_height_se_min,
            f.storey_height_se_max,
            f.window_share,
            f.net_leased_area_mean,
            f.net_leased_area_se,
            f.net_leased_area_se_min,
            f.net_leased_area_se_max,
            f.net_leased_area_unit,
            f.facade_area_north_mean,
            f.facade_area_north_se,
            f.facade_area_east_mean,
            f.facade_area_east_se,
            f.facade_area_south_mean,
            f.facade_area_south_se,
            f.facade_area_west_mean,
            f.facade_area_west_se,
            f.facade_area_unit,
            f.facade_length_north_mean,
            f.facade_length_north_se,
            f.facade_length_east_mean,
            f.facade_length_east_se,
            f.facade_length_south_mean,
            f.facade_length_south_se,
            f.facade_length_west_mean,
            f.facade_length_west_se,
            f.facade_length_unit,
            f.exterior_wall_name,
            f.exterior_wall_construction_type,
            f.exterior_wall_u_value_typical_min,
            f.exterior_wall_u_value_typical_max,
            f.exterior_wall_u_value,
            f.exterior_wall_u_value_unit,
            f.exterior_wall_inner_radiation,
            f.exterior_wall_inner_radiation_unit,
            f.exterior_wall_outer_radiation,
            f.exterior_wall_outer_radiation_unit,
            f.exterior_wall_inner_convection,
            f.exterior_wall_inner_convection_unit,
            f.exterior_wall_outer_convection,
            f.exterior_wall_outer_convection_unit,
            f.exterior_wall_layer0_position,
            f.exterior_wall_layer0_material_id,
            f.exterior_wall_layer0_material_name,
            f.exterior_wall_layer0_thickness,
            f.exterior_wall_layer0_thickness_unit,
            f.exterior_wall_layer0_solar_absorption_rate,
            f.exterior_wall_layer0_thermal_capacity,
            f.exterior_wall_layer0_thermal_capacity_unit,
            f.exterior_wall_layer0_thermal_conductivity,
            f.exterior_wall_layer0_thermal_conductivity_unit,
            f.exterior_wall_layer0_service_life,
            f.exterior_wall_layer0_service_life_unit,
            f.exterior_wall_layer0_density,
            f.exterior_wall_layer0_density_unit,
            f.exterior_wall_layer1_position,
            f.exterior_wall_layer1_material_id,
            f.exterior_wall_layer1_material_name,
            f.exterior_wall_layer1_thickness,
            f.exterior_wall_layer1_thickness_unit,
            f.exterior_wall_layer1_solar_absorption_rate,
            f.exterior_wall_layer1_thermal_capacity,
            f.exterior_wall_layer1_thermal_capacity_unit,
            f.exterior_wall_layer1_thermal_conductivity,
            f.exterior_wall_layer1_thermal_conductivity_unit,
            f.exterior_wall_layer1_service_life,
            f.exterior_wall_layer1_service_life_unit,
            f.exterior_wall_layer1_density,
            f.exterior_wall_layer1_density_unit,
            f.exterior_wall_layer2_position,
            f.exterior_wall_layer2_material_id,
            f.exterior_wall_layer2_material_name,
            f.exterior_wall_layer2_thickness,
            f.exterior_wall_layer2_thickness_unit,
            f.exterior_wall_layer2_solar_absorption_rate,
            f.exterior_wall_layer2_thermal_capacity,
            f.exterior_wall_layer2_thermal_capacity_unit,
            f.exterior_wall_layer2_thermal_conductivity,
            f.exterior_wall_layer2_thermal_conductivity_unit,
            f.exterior_wall_layer2_service_life,
            f.exterior_wall_layer2_service_life_unit,
            f.exterior_wall_layer2_density,
            f.exterior_wall_layer2_density_unit,
            f.exterior_wall_layer3_position,
            f.exterior_wall_layer3_material_id,
            f.exterior_wall_layer3_material_name,
            f.exterior_wall_layer3_thickness,
            f.exterior_wall_layer3_thickness_unit,
            f.exterior_wall_layer3_solar_absorption_rate,
            f.exterior_wall_layer3_thermal_capacity,
            f.exterior_wall_layer3_thermal_capacity_unit,
            f.exterior_wall_layer3_thermal_conductivity,
            f.exterior_wall_layer3_thermal_conductivity_unit,
            f.exterior_wall_layer3_service_life,
            f.exterior_wall_layer3_service_life_unit,
            f.exterior_wall_layer3_density,
            f.exterior_wall_layer3_density_unit,
            f.exterior_wall_layer4_position,
            f.exterior_wall_layer4_material_id,
            f.exterior_wall_layer4_material_name,
            f.exterior_wall_layer4_thickness,
            f.exterior_wall_layer4_thickness_unit,
            f.exterior_wall_layer4_solar_absorption_rate,
            f.exterior_wall_layer4_thermal_capacity,
            f.exterior_wall_layer4_thermal_capacity_unit,
            f.exterior_wall_layer4_thermal_conductivity,
            f.exterior_wall_layer4_thermal_conductivity_unit,
            f.exterior_wall_layer4_service_life,
            f.exterior_wall_layer4_service_life_unit,
            f.exterior_wall_layer4_density,
            f.exterior_wall_layer4_density_unit,
            f.exterior_wall_layer5_position,
            f.exterior_wall_layer5_material_id,
            f.exterior_wall_layer5_material_name,
            f.exterior_wall_layer5_thickness,
            f.exterior_wall_layer5_thickness_unit,
            f.exterior_wall_layer5_solar_absorption_rate,
            f.exterior_wall_layer5_thermal_capacity,
            f.exterior_wall_layer5_thermal_capacity_unit,
            f.exterior_wall_layer5_thermal_conductivity,
            f.exterior_wall_layer5_thermal_conductivity_unit,
            f.exterior_wall_layer5_service_life,
            f.exterior_wall_layer5_service_life_unit,
            f.exterior_wall_layer5_density,
            f.exterior_wall_layer5_density_unit,
            f.exterior_wall_layer0_epd1_oekobaudat_name,
            f.exterior_wall_layer0_epd1_oekobaudat_uuid,
            f.exterior_wall_layer0_epd2_oekobaudat_name,
            f.exterior_wall_layer0_epd2_oekobaudat_uuid,
            f.exterior_wall_layer1_epd1_oekobaudat_name,
            f.exterior_wall_layer1_epd1_oekobaudat_uuid,
            f.exterior_wall_layer1_epd2_oekobaudat_name,
            f.exterior_wall_layer1_epd2_oekobaudat_uuid,
            f.exterior_wall_layer2_epd1_oekobaudat_name,
            f.exterior_wall_layer2_epd1_oekobaudat_uuid,
            f.exterior_wall_layer2_epd2_oekobaudat_name,
            f.exterior_wall_layer2_epd2_oekobaudat_uuid,
            f.exterior_wall_layer3_epd1_oekobaudat_name,
            f.exterior_wall_layer3_epd1_oekobaudat_uuid,
            f.exterior_wall_layer3_epd2_oekobaudat_name,
            f.exterior_wall_layer3_epd2_oekobaudat_uuid,
            f.exterior_wall_layer4_epd1_oekobaudat_name,
            f.exterior_wall_layer4_epd1_oekobaudat_uuid,
            f.exterior_wall_layer4_epd2_oekobaudat_name,
            f.exterior_wall_layer4_epd2_oekobaudat_uuid,
            f.exterior_wall_layer5_epd1_oekobaudat_name,
            f.exterior_wall_layer5_epd1_oekobaudat_uuid,
            f.exterior_wall_layer5_epd2_oekobaudat_name,
            f.exterior_wall_layer5_epd2_oekobaudat_uuid,
            f.interior_wall_name,
            f.interior_wall_u_value_typical_min,
            f.interior_wall_u_value_typical_max,
            f.interior_wall_u_value,
            f.interior_wall_u_value_unit,
            f.interior_wall_inner_radiation,
            f.interior_wall_inner_radiation_unit,
            f.interior_wall_inner_convection,
            f.interior_wall_inner_convection_unit,
            f.interior_wall_layer0_position,
            f.interior_wall_layer0_material_id,
            f.interior_wall_layer0_material_name,
            f.interior_wall_layer0_thickness,
            f.interior_wall_layer0_thickness_unit,
            f.interior_wall_layer0_solar_absorption_rate,
            f.interior_wall_layer0_thermal_capacity,
            f.interior_wall_layer0_thermal_capacity_unit,
            f.interior_wall_layer0_thermal_conductivity,
            f.interior_wall_layer0_thermal_conductivity_unit,
            f.interior_wall_layer0_service_life,
            f.interior_wall_layer0_service_life_unit,
            f.interior_wall_layer0_density,
            f.interior_wall_layer0_density_unit,
            f.interior_wall_layer1_position,
            f.interior_wall_layer1_material_id,
            f.interior_wall_layer1_material_name,
            f.interior_wall_layer1_thickness,
            f.interior_wall_layer1_thickness_unit,
            f.interior_wall_layer1_solar_absorption_rate,
            f.interior_wall_layer1_thermal_capacity,
            f.interior_wall_layer1_thermal_capacity_unit,
            f.interior_wall_layer1_thermal_conductivity,
            f.interior_wall_layer1_thermal_conductivity_unit,
            f.interior_wall_layer1_service_life,
            f.interior_wall_layer1_service_life_unit,
            f.interior_wall_layer1_density,
            f.interior_wall_layer1_density_unit,
            f.interior_wall_layer2_position,
            f.interior_wall_layer2_material_id,
            f.interior_wall_layer2_material_name,
            f.interior_wall_layer2_thickness,
            f.interior_wall_layer2_thickness_unit,
            f.interior_wall_layer2_solar_absorption_rate,
            f.interior_wall_layer2_thermal_capacity,
            f.interior_wall_layer2_thermal_capacity_unit,
            f.interior_wall_layer2_thermal_conductivity,
            f.interior_wall_layer2_thermal_conductivity_unit,
            f.interior_wall_layer2_service_life,
            f.interior_wall_layer2_service_life_unit,
            f.interior_wall_layer2_density,
            f.interior_wall_layer2_density_unit,
            epd0_1.environmental_product_declaration_name AS interior_wall_layer0_epd1_oekobaudat_name,
            epd0_1.database_uuid AS interior_wall_layer0_epd1_oekobaudat_uuid,
            epd0_2.environmental_product_declaration_name AS interior_wall_layer0_epd2_oekobaudat_name,
            epd0_2.database_uuid AS interior_wall_layer0_epd2_oekobaudat_uuid,
            epd1_1.environmental_product_declaration_name AS interior_wall_layer1_epd1_oekobaudat_name,
            epd1_1.database_uuid AS interior_wall_layer1_epd1_oekobaudat_uuid,
            epd1_2.environmental_product_declaration_name AS interior_wall_layer1_epd2_oekobaudat_name,
            epd1_2.database_uuid AS interior_wall_layer1_epd2_oekobaudat_uuid,
            epd2_1.environmental_product_declaration_name AS interior_wall_layer2_epd1_oekobaudat_name,
            epd2_1.database_uuid AS interior_wall_layer2_epd1_oekobaudat_uuid,
            epd2_2.environmental_product_declaration_name AS interior_wall_layer2_epd2_oekobaudat_name,
            epd2_2.database_uuid AS interior_wall_layer2_epd2_oekobaudat_uuid
           FROM ((((((((((((step_007 f
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = f.exterior_wall_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_1 ON ((epd0_1.environmental_product_declaration_id = bm0.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_2 ON ((epd0_2.environmental_product_declaration_id = bm0.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = f.exterior_wall_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_1 ON ((epd1_1.environmental_product_declaration_id = bm1.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_2 ON ((epd1_2.environmental_product_declaration_id = bm1.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = f.exterior_wall_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_1 ON ((epd2_1.environmental_product_declaration_id = bm2.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_2 ON ((epd2_2.environmental_product_declaration_id = bm2.environmental_product_declaration_id_2)))
        ), step_009 AS (
         SELECT v.building_archetype_id,
            v.building_archetype_name,
            v.share_of_building_type,
            v.share_of_building_type_in_region,
            v.share_of_building_type_in_region_mun,
            v.exterior_wall_building_element_id,
            v.interior_wall_building_element_id,
            v.roof_building_element_id,
            v.foundation_building_element_id,
            v.floor_building_element_id,
            v.window_building_element_id,
            v.energy_system_id,
            v.building_type_name,
            v.region_name,
            v.municipality_size_name,
            v.municipality_growth_name,
            v.age_class_name,
            v.building_adjacency_name,
            v.facade_to_net_leased_area_ratio_mean,
            v.facade_to_net_leased_area_ratio_se_min,
            v.facade_to_net_leased_area_ratio_se_max,
            v.roof_to_net_leased_area_ratio_mean,
            v.roof_to_net_leased_area_ratio_se_min,
            v.roof_to_net_leased_area_ratio_se_max,
            v.foundation_to_net_leased_area_ratio_mean,
            v.foundation_to_net_leased_area_ratio_se_min,
            v.foundation_to_net_leased_area_ratio_se_max,
            v.window_to_net_leased_area_ratio_mean,
            v.window_to_net_leased_area_ratio_se_min,
            v.window_to_net_leased_area_ratio_se_max,
            v.building_height_mean,
            v.building_height_se,
            v.height_unit,
            v.aspect_ratio_mean,
            v.aspect_ratio_se_min,
            v.aspect_ratio_se_max,
            v.storeys_below_ground_mean,
            v.storeys_below_ground_se,
            v.storeys_above_ground_mean,
            v.storeys_above_ground_se,
            v.storeys_above_ground_se_min,
            v.storeys_above_ground_se_max,
            v.storey_height_mean,
            v.storey_height_se_min,
            v.storey_height_se_max,
            v.window_share,
            v.net_leased_area_mean,
            v.net_leased_area_se,
            v.net_leased_area_se_min,
            v.net_leased_area_se_max,
            v.net_leased_area_unit,
            v.facade_area_north_mean,
            v.facade_area_north_se,
            v.facade_area_east_mean,
            v.facade_area_east_se,
            v.facade_area_south_mean,
            v.facade_area_south_se,
            v.facade_area_west_mean,
            v.facade_area_west_se,
            v.facade_area_unit,
            v.facade_length_north_mean,
            v.facade_length_north_se,
            v.facade_length_east_mean,
            v.facade_length_east_se,
            v.facade_length_south_mean,
            v.facade_length_south_se,
            v.facade_length_west_mean,
            v.facade_length_west_se,
            v.facade_length_unit,
            v.exterior_wall_name,
            v.exterior_wall_construction_type,
            v.exterior_wall_u_value_typical_min,
            v.exterior_wall_u_value_typical_max,
            v.exterior_wall_u_value,
            v.exterior_wall_u_value_unit,
            v.exterior_wall_inner_radiation,
            v.exterior_wall_inner_radiation_unit,
            v.exterior_wall_outer_radiation,
            v.exterior_wall_outer_radiation_unit,
            v.exterior_wall_inner_convection,
            v.exterior_wall_inner_convection_unit,
            v.exterior_wall_outer_convection,
            v.exterior_wall_outer_convection_unit,
            v.exterior_wall_layer0_position,
            v.exterior_wall_layer0_material_id,
            v.exterior_wall_layer0_material_name,
            v.exterior_wall_layer0_thickness,
            v.exterior_wall_layer0_thickness_unit,
            v.exterior_wall_layer0_solar_absorption_rate,
            v.exterior_wall_layer0_thermal_capacity,
            v.exterior_wall_layer0_thermal_capacity_unit,
            v.exterior_wall_layer0_thermal_conductivity,
            v.exterior_wall_layer0_thermal_conductivity_unit,
            v.exterior_wall_layer0_service_life,
            v.exterior_wall_layer0_service_life_unit,
            v.exterior_wall_layer0_density,
            v.exterior_wall_layer0_density_unit,
            v.exterior_wall_layer1_position,
            v.exterior_wall_layer1_material_id,
            v.exterior_wall_layer1_material_name,
            v.exterior_wall_layer1_thickness,
            v.exterior_wall_layer1_thickness_unit,
            v.exterior_wall_layer1_solar_absorption_rate,
            v.exterior_wall_layer1_thermal_capacity,
            v.exterior_wall_layer1_thermal_capacity_unit,
            v.exterior_wall_layer1_thermal_conductivity,
            v.exterior_wall_layer1_thermal_conductivity_unit,
            v.exterior_wall_layer1_service_life,
            v.exterior_wall_layer1_service_life_unit,
            v.exterior_wall_layer1_density,
            v.exterior_wall_layer1_density_unit,
            v.exterior_wall_layer2_position,
            v.exterior_wall_layer2_material_id,
            v.exterior_wall_layer2_material_name,
            v.exterior_wall_layer2_thickness,
            v.exterior_wall_layer2_thickness_unit,
            v.exterior_wall_layer2_solar_absorption_rate,
            v.exterior_wall_layer2_thermal_capacity,
            v.exterior_wall_layer2_thermal_capacity_unit,
            v.exterior_wall_layer2_thermal_conductivity,
            v.exterior_wall_layer2_thermal_conductivity_unit,
            v.exterior_wall_layer2_service_life,
            v.exterior_wall_layer2_service_life_unit,
            v.exterior_wall_layer2_density,
            v.exterior_wall_layer2_density_unit,
            v.exterior_wall_layer3_position,
            v.exterior_wall_layer3_material_id,
            v.exterior_wall_layer3_material_name,
            v.exterior_wall_layer3_thickness,
            v.exterior_wall_layer3_thickness_unit,
            v.exterior_wall_layer3_solar_absorption_rate,
            v.exterior_wall_layer3_thermal_capacity,
            v.exterior_wall_layer3_thermal_capacity_unit,
            v.exterior_wall_layer3_thermal_conductivity,
            v.exterior_wall_layer3_thermal_conductivity_unit,
            v.exterior_wall_layer3_service_life,
            v.exterior_wall_layer3_service_life_unit,
            v.exterior_wall_layer3_density,
            v.exterior_wall_layer3_density_unit,
            v.exterior_wall_layer4_position,
            v.exterior_wall_layer4_material_id,
            v.exterior_wall_layer4_material_name,
            v.exterior_wall_layer4_thickness,
            v.exterior_wall_layer4_thickness_unit,
            v.exterior_wall_layer4_solar_absorption_rate,
            v.exterior_wall_layer4_thermal_capacity,
            v.exterior_wall_layer4_thermal_capacity_unit,
            v.exterior_wall_layer4_thermal_conductivity,
            v.exterior_wall_layer4_thermal_conductivity_unit,
            v.exterior_wall_layer4_service_life,
            v.exterior_wall_layer4_service_life_unit,
            v.exterior_wall_layer4_density,
            v.exterior_wall_layer4_density_unit,
            v.exterior_wall_layer5_position,
            v.exterior_wall_layer5_material_id,
            v.exterior_wall_layer5_material_name,
            v.exterior_wall_layer5_thickness,
            v.exterior_wall_layer5_thickness_unit,
            v.exterior_wall_layer5_solar_absorption_rate,
            v.exterior_wall_layer5_thermal_capacity,
            v.exterior_wall_layer5_thermal_capacity_unit,
            v.exterior_wall_layer5_thermal_conductivity,
            v.exterior_wall_layer5_thermal_conductivity_unit,
            v.exterior_wall_layer5_service_life,
            v.exterior_wall_layer5_service_life_unit,
            v.exterior_wall_layer5_density,
            v.exterior_wall_layer5_density_unit,
            v.exterior_wall_layer0_epd1_oekobaudat_name,
            v.exterior_wall_layer0_epd1_oekobaudat_uuid,
            v.exterior_wall_layer0_epd2_oekobaudat_name,
            v.exterior_wall_layer0_epd2_oekobaudat_uuid,
            v.exterior_wall_layer1_epd1_oekobaudat_name,
            v.exterior_wall_layer1_epd1_oekobaudat_uuid,
            v.exterior_wall_layer1_epd2_oekobaudat_name,
            v.exterior_wall_layer1_epd2_oekobaudat_uuid,
            v.exterior_wall_layer2_epd1_oekobaudat_name,
            v.exterior_wall_layer2_epd1_oekobaudat_uuid,
            v.exterior_wall_layer2_epd2_oekobaudat_name,
            v.exterior_wall_layer2_epd2_oekobaudat_uuid,
            v.exterior_wall_layer3_epd1_oekobaudat_name,
            v.exterior_wall_layer3_epd1_oekobaudat_uuid,
            v.exterior_wall_layer3_epd2_oekobaudat_name,
            v.exterior_wall_layer3_epd2_oekobaudat_uuid,
            v.exterior_wall_layer4_epd1_oekobaudat_name,
            v.exterior_wall_layer4_epd1_oekobaudat_uuid,
            v.exterior_wall_layer4_epd2_oekobaudat_name,
            v.exterior_wall_layer4_epd2_oekobaudat_uuid,
            v.exterior_wall_layer5_epd1_oekobaudat_name,
            v.exterior_wall_layer5_epd1_oekobaudat_uuid,
            v.exterior_wall_layer5_epd2_oekobaudat_name,
            v.exterior_wall_layer5_epd2_oekobaudat_uuid,
            v.interior_wall_name,
            v.interior_wall_u_value_typical_min,
            v.interior_wall_u_value_typical_max,
            v.interior_wall_u_value,
            v.interior_wall_u_value_unit,
            v.interior_wall_inner_radiation,
            v.interior_wall_inner_radiation_unit,
            v.interior_wall_inner_convection,
            v.interior_wall_inner_convection_unit,
            v.interior_wall_layer0_position,
            v.interior_wall_layer0_material_id,
            v.interior_wall_layer0_material_name,
            v.interior_wall_layer0_thickness,
            v.interior_wall_layer0_thickness_unit,
            v.interior_wall_layer0_solar_absorption_rate,
            v.interior_wall_layer0_thermal_capacity,
            v.interior_wall_layer0_thermal_capacity_unit,
            v.interior_wall_layer0_thermal_conductivity,
            v.interior_wall_layer0_thermal_conductivity_unit,
            v.interior_wall_layer0_service_life,
            v.interior_wall_layer0_service_life_unit,
            v.interior_wall_layer0_density,
            v.interior_wall_layer0_density_unit,
            v.interior_wall_layer1_position,
            v.interior_wall_layer1_material_id,
            v.interior_wall_layer1_material_name,
            v.interior_wall_layer1_thickness,
            v.interior_wall_layer1_thickness_unit,
            v.interior_wall_layer1_solar_absorption_rate,
            v.interior_wall_layer1_thermal_capacity,
            v.interior_wall_layer1_thermal_capacity_unit,
            v.interior_wall_layer1_thermal_conductivity,
            v.interior_wall_layer1_thermal_conductivity_unit,
            v.interior_wall_layer1_service_life,
            v.interior_wall_layer1_service_life_unit,
            v.interior_wall_layer1_density,
            v.interior_wall_layer1_density_unit,
            v.interior_wall_layer2_position,
            v.interior_wall_layer2_material_id,
            v.interior_wall_layer2_material_name,
            v.interior_wall_layer2_thickness,
            v.interior_wall_layer2_thickness_unit,
            v.interior_wall_layer2_solar_absorption_rate,
            v.interior_wall_layer2_thermal_capacity,
            v.interior_wall_layer2_thermal_capacity_unit,
            v.interior_wall_layer2_thermal_conductivity,
            v.interior_wall_layer2_thermal_conductivity_unit,
            v.interior_wall_layer2_service_life,
            v.interior_wall_layer2_service_life_unit,
            v.interior_wall_layer2_density,
            v.interior_wall_layer2_density_unit,
            v.interior_wall_layer0_epd1_oekobaudat_name,
            v.interior_wall_layer0_epd1_oekobaudat_uuid,
            v.interior_wall_layer0_epd2_oekobaudat_name,
            v.interior_wall_layer0_epd2_oekobaudat_uuid,
            v.interior_wall_layer1_epd1_oekobaudat_name,
            v.interior_wall_layer1_epd1_oekobaudat_uuid,
            v.interior_wall_layer1_epd2_oekobaudat_name,
            v.interior_wall_layer1_epd2_oekobaudat_uuid,
            v.interior_wall_layer2_epd1_oekobaudat_name,
            v.interior_wall_layer2_epd1_oekobaudat_uuid,
            v.interior_wall_layer2_epd2_oekobaudat_name,
            v.interior_wall_layer2_epd2_oekobaudat_uuid,
            be.building_element_name AS roof_name,
            ct.construction_type_name AS roof_construction_type,
            pt.pitch_type_name AS roof_pitch_type,
            be.u_value_typical_min AS roof_u_value_typical_min,
            be.u_value_typical_max AS roof_u_value_typical_max,
            be.u_value AS roof_u_value,
            u.unit_name AS roof_u_value_unit,
            be.inner_radiation AS roof_inner_radiation,
            u1.unit_name AS roof_inner_radiation_unit,
            be.outer_radiation AS roof_outer_radiation,
            u2.unit_name AS roof_outer_radiation_unit,
            be.inner_convection AS roof_inner_convection,
            u3.unit_name AS roof_inner_convection_unit,
            be.outer_convection AS roof_outer_convection,
            u4.unit_name AS roof_outer_convection_unit
           FROM (((((((((step_008 v
             LEFT JOIN hub4lca_post_simulation.building_elements be ON ((be.building_element_id = v.roof_building_element_id)))
             LEFT JOIN hub4lca_post_simulation.construction_types ct ON ((ct.construction_type_id = be.construction_type_id)))
             LEFT JOIN hub4lca_post_simulation.roofs r ON ((r.building_element_id = be.building_element_id)))
             LEFT JOIN hub4lca_post_simulation.pitch_types pt ON ((pt.pitch_type_id = r.pitch_type_id)))
             LEFT JOIN hub4lca_post_simulation.units u ON ((u.unit_id = be.u_value_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1 ON ((u1.unit_id = be.inner_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2 ON ((u2.unit_id = be.outer_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3 ON ((u3.unit_id = be.inner_convection_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4 ON ((u4.unit_id = be.outer_convection_unit_id)))
        ), step_010 AS (
         SELECT b.building_archetype_id,
            b.building_archetype_name,
            b.share_of_building_type,
            b.share_of_building_type_in_region,
            b.share_of_building_type_in_region_mun,
            b.exterior_wall_building_element_id,
            b.interior_wall_building_element_id,
            b.roof_building_element_id,
            b.foundation_building_element_id,
            b.floor_building_element_id,
            b.window_building_element_id,
            b.energy_system_id,
            b.building_type_name,
            b.region_name,
            b.municipality_size_name,
            b.municipality_growth_name,
            b.age_class_name,
            b.building_adjacency_name,
            b.facade_to_net_leased_area_ratio_mean,
            b.facade_to_net_leased_area_ratio_se_min,
            b.facade_to_net_leased_area_ratio_se_max,
            b.roof_to_net_leased_area_ratio_mean,
            b.roof_to_net_leased_area_ratio_se_min,
            b.roof_to_net_leased_area_ratio_se_max,
            b.foundation_to_net_leased_area_ratio_mean,
            b.foundation_to_net_leased_area_ratio_se_min,
            b.foundation_to_net_leased_area_ratio_se_max,
            b.window_to_net_leased_area_ratio_mean,
            b.window_to_net_leased_area_ratio_se_min,
            b.window_to_net_leased_area_ratio_se_max,
            b.building_height_mean,
            b.building_height_se,
            b.height_unit,
            b.aspect_ratio_mean,
            b.aspect_ratio_se_min,
            b.aspect_ratio_se_max,
            b.storeys_below_ground_mean,
            b.storeys_below_ground_se,
            b.storeys_above_ground_mean,
            b.storeys_above_ground_se,
            b.storeys_above_ground_se_min,
            b.storeys_above_ground_se_max,
            b.storey_height_mean,
            b.storey_height_se_min,
            b.storey_height_se_max,
            b.window_share,
            b.net_leased_area_mean,
            b.net_leased_area_se,
            b.net_leased_area_se_min,
            b.net_leased_area_se_max,
            b.net_leased_area_unit,
            b.facade_area_north_mean,
            b.facade_area_north_se,
            b.facade_area_east_mean,
            b.facade_area_east_se,
            b.facade_area_south_mean,
            b.facade_area_south_se,
            b.facade_area_west_mean,
            b.facade_area_west_se,
            b.facade_area_unit,
            b.facade_length_north_mean,
            b.facade_length_north_se,
            b.facade_length_east_mean,
            b.facade_length_east_se,
            b.facade_length_south_mean,
            b.facade_length_south_se,
            b.facade_length_west_mean,
            b.facade_length_west_se,
            b.facade_length_unit,
            b.exterior_wall_name,
            b.exterior_wall_construction_type,
            b.exterior_wall_u_value_typical_min,
            b.exterior_wall_u_value_typical_max,
            b.exterior_wall_u_value,
            b.exterior_wall_u_value_unit,
            b.exterior_wall_inner_radiation,
            b.exterior_wall_inner_radiation_unit,
            b.exterior_wall_outer_radiation,
            b.exterior_wall_outer_radiation_unit,
            b.exterior_wall_inner_convection,
            b.exterior_wall_inner_convection_unit,
            b.exterior_wall_outer_convection,
            b.exterior_wall_outer_convection_unit,
            b.exterior_wall_layer0_position,
            b.exterior_wall_layer0_material_id,
            b.exterior_wall_layer0_material_name,
            b.exterior_wall_layer0_thickness,
            b.exterior_wall_layer0_thickness_unit,
            b.exterior_wall_layer0_solar_absorption_rate,
            b.exterior_wall_layer0_thermal_capacity,
            b.exterior_wall_layer0_thermal_capacity_unit,
            b.exterior_wall_layer0_thermal_conductivity,
            b.exterior_wall_layer0_thermal_conductivity_unit,
            b.exterior_wall_layer0_service_life,
            b.exterior_wall_layer0_service_life_unit,
            b.exterior_wall_layer0_density,
            b.exterior_wall_layer0_density_unit,
            b.exterior_wall_layer1_position,
            b.exterior_wall_layer1_material_id,
            b.exterior_wall_layer1_material_name,
            b.exterior_wall_layer1_thickness,
            b.exterior_wall_layer1_thickness_unit,
            b.exterior_wall_layer1_solar_absorption_rate,
            b.exterior_wall_layer1_thermal_capacity,
            b.exterior_wall_layer1_thermal_capacity_unit,
            b.exterior_wall_layer1_thermal_conductivity,
            b.exterior_wall_layer1_thermal_conductivity_unit,
            b.exterior_wall_layer1_service_life,
            b.exterior_wall_layer1_service_life_unit,
            b.exterior_wall_layer1_density,
            b.exterior_wall_layer1_density_unit,
            b.exterior_wall_layer2_position,
            b.exterior_wall_layer2_material_id,
            b.exterior_wall_layer2_material_name,
            b.exterior_wall_layer2_thickness,
            b.exterior_wall_layer2_thickness_unit,
            b.exterior_wall_layer2_solar_absorption_rate,
            b.exterior_wall_layer2_thermal_capacity,
            b.exterior_wall_layer2_thermal_capacity_unit,
            b.exterior_wall_layer2_thermal_conductivity,
            b.exterior_wall_layer2_thermal_conductivity_unit,
            b.exterior_wall_layer2_service_life,
            b.exterior_wall_layer2_service_life_unit,
            b.exterior_wall_layer2_density,
            b.exterior_wall_layer2_density_unit,
            b.exterior_wall_layer3_position,
            b.exterior_wall_layer3_material_id,
            b.exterior_wall_layer3_material_name,
            b.exterior_wall_layer3_thickness,
            b.exterior_wall_layer3_thickness_unit,
            b.exterior_wall_layer3_solar_absorption_rate,
            b.exterior_wall_layer3_thermal_capacity,
            b.exterior_wall_layer3_thermal_capacity_unit,
            b.exterior_wall_layer3_thermal_conductivity,
            b.exterior_wall_layer3_thermal_conductivity_unit,
            b.exterior_wall_layer3_service_life,
            b.exterior_wall_layer3_service_life_unit,
            b.exterior_wall_layer3_density,
            b.exterior_wall_layer3_density_unit,
            b.exterior_wall_layer4_position,
            b.exterior_wall_layer4_material_id,
            b.exterior_wall_layer4_material_name,
            b.exterior_wall_layer4_thickness,
            b.exterior_wall_layer4_thickness_unit,
            b.exterior_wall_layer4_solar_absorption_rate,
            b.exterior_wall_layer4_thermal_capacity,
            b.exterior_wall_layer4_thermal_capacity_unit,
            b.exterior_wall_layer4_thermal_conductivity,
            b.exterior_wall_layer4_thermal_conductivity_unit,
            b.exterior_wall_layer4_service_life,
            b.exterior_wall_layer4_service_life_unit,
            b.exterior_wall_layer4_density,
            b.exterior_wall_layer4_density_unit,
            b.exterior_wall_layer5_position,
            b.exterior_wall_layer5_material_id,
            b.exterior_wall_layer5_material_name,
            b.exterior_wall_layer5_thickness,
            b.exterior_wall_layer5_thickness_unit,
            b.exterior_wall_layer5_solar_absorption_rate,
            b.exterior_wall_layer5_thermal_capacity,
            b.exterior_wall_layer5_thermal_capacity_unit,
            b.exterior_wall_layer5_thermal_conductivity,
            b.exterior_wall_layer5_thermal_conductivity_unit,
            b.exterior_wall_layer5_service_life,
            b.exterior_wall_layer5_service_life_unit,
            b.exterior_wall_layer5_density,
            b.exterior_wall_layer5_density_unit,
            b.exterior_wall_layer0_epd1_oekobaudat_name,
            b.exterior_wall_layer0_epd1_oekobaudat_uuid,
            b.exterior_wall_layer0_epd2_oekobaudat_name,
            b.exterior_wall_layer0_epd2_oekobaudat_uuid,
            b.exterior_wall_layer1_epd1_oekobaudat_name,
            b.exterior_wall_layer1_epd1_oekobaudat_uuid,
            b.exterior_wall_layer1_epd2_oekobaudat_name,
            b.exterior_wall_layer1_epd2_oekobaudat_uuid,
            b.exterior_wall_layer2_epd1_oekobaudat_name,
            b.exterior_wall_layer2_epd1_oekobaudat_uuid,
            b.exterior_wall_layer2_epd2_oekobaudat_name,
            b.exterior_wall_layer2_epd2_oekobaudat_uuid,
            b.exterior_wall_layer3_epd1_oekobaudat_name,
            b.exterior_wall_layer3_epd1_oekobaudat_uuid,
            b.exterior_wall_layer3_epd2_oekobaudat_name,
            b.exterior_wall_layer3_epd2_oekobaudat_uuid,
            b.exterior_wall_layer4_epd1_oekobaudat_name,
            b.exterior_wall_layer4_epd1_oekobaudat_uuid,
            b.exterior_wall_layer4_epd2_oekobaudat_name,
            b.exterior_wall_layer4_epd2_oekobaudat_uuid,
            b.exterior_wall_layer5_epd1_oekobaudat_name,
            b.exterior_wall_layer5_epd1_oekobaudat_uuid,
            b.exterior_wall_layer5_epd2_oekobaudat_name,
            b.exterior_wall_layer5_epd2_oekobaudat_uuid,
            b.interior_wall_name,
            b.interior_wall_u_value_typical_min,
            b.interior_wall_u_value_typical_max,
            b.interior_wall_u_value,
            b.interior_wall_u_value_unit,
            b.interior_wall_inner_radiation,
            b.interior_wall_inner_radiation_unit,
            b.interior_wall_inner_convection,
            b.interior_wall_inner_convection_unit,
            b.interior_wall_layer0_position,
            b.interior_wall_layer0_material_id,
            b.interior_wall_layer0_material_name,
            b.interior_wall_layer0_thickness,
            b.interior_wall_layer0_thickness_unit,
            b.interior_wall_layer0_solar_absorption_rate,
            b.interior_wall_layer0_thermal_capacity,
            b.interior_wall_layer0_thermal_capacity_unit,
            b.interior_wall_layer0_thermal_conductivity,
            b.interior_wall_layer0_thermal_conductivity_unit,
            b.interior_wall_layer0_service_life,
            b.interior_wall_layer0_service_life_unit,
            b.interior_wall_layer0_density,
            b.interior_wall_layer0_density_unit,
            b.interior_wall_layer1_position,
            b.interior_wall_layer1_material_id,
            b.interior_wall_layer1_material_name,
            b.interior_wall_layer1_thickness,
            b.interior_wall_layer1_thickness_unit,
            b.interior_wall_layer1_solar_absorption_rate,
            b.interior_wall_layer1_thermal_capacity,
            b.interior_wall_layer1_thermal_capacity_unit,
            b.interior_wall_layer1_thermal_conductivity,
            b.interior_wall_layer1_thermal_conductivity_unit,
            b.interior_wall_layer1_service_life,
            b.interior_wall_layer1_service_life_unit,
            b.interior_wall_layer1_density,
            b.interior_wall_layer1_density_unit,
            b.interior_wall_layer2_position,
            b.interior_wall_layer2_material_id,
            b.interior_wall_layer2_material_name,
            b.interior_wall_layer2_thickness,
            b.interior_wall_layer2_thickness_unit,
            b.interior_wall_layer2_solar_absorption_rate,
            b.interior_wall_layer2_thermal_capacity,
            b.interior_wall_layer2_thermal_capacity_unit,
            b.interior_wall_layer2_thermal_conductivity,
            b.interior_wall_layer2_thermal_conductivity_unit,
            b.interior_wall_layer2_service_life,
            b.interior_wall_layer2_service_life_unit,
            b.interior_wall_layer2_density,
            b.interior_wall_layer2_density_unit,
            b.interior_wall_layer0_epd1_oekobaudat_name,
            b.interior_wall_layer0_epd1_oekobaudat_uuid,
            b.interior_wall_layer0_epd2_oekobaudat_name,
            b.interior_wall_layer0_epd2_oekobaudat_uuid,
            b.interior_wall_layer1_epd1_oekobaudat_name,
            b.interior_wall_layer1_epd1_oekobaudat_uuid,
            b.interior_wall_layer1_epd2_oekobaudat_name,
            b.interior_wall_layer1_epd2_oekobaudat_uuid,
            b.interior_wall_layer2_epd1_oekobaudat_name,
            b.interior_wall_layer2_epd1_oekobaudat_uuid,
            b.interior_wall_layer2_epd2_oekobaudat_name,
            b.interior_wall_layer2_epd2_oekobaudat_uuid,
            b.roof_name,
            b.roof_construction_type,
            b.roof_pitch_type,
            b.roof_u_value_typical_min,
            b.roof_u_value_typical_max,
            b.roof_u_value,
            b.roof_u_value_unit,
            b.roof_inner_radiation,
            b.roof_inner_radiation_unit,
            b.roof_outer_radiation,
            b.roof_outer_radiation_unit,
            b.roof_inner_convection,
            b.roof_inner_convection_unit,
            b.roof_outer_convection,
            b.roof_outer_convection_unit,
            l0."position" AS roof_layer0_position,
            l0.building_material_id AS roof_layer0_material_id,
            bm0.building_material_name AS roof_layer0_material_name,
            l0.thickness AS roof_layer0_thickness,
            u0_th.unit_name AS roof_layer0_thickness_unit,
            bm0.solar_absorption_rate AS roof_layer0_solar_absorption_rate,
            bm0.thermal_capacity AS roof_layer0_thermal_capacity,
            u0_tc.unit_name AS roof_layer0_thermal_capacity_unit,
            bm0.thermal_conductivity AS roof_layer0_thermal_conductivity,
            u0_tco.unit_name AS roof_layer0_thermal_conductivity_unit,
            sl0.service_life AS roof_layer0_service_life,
            u0_sl.unit_name AS roof_layer0_service_life_unit,
            bm0.density AS roof_layer0_density,
            u0_d.unit_name AS roof_layer0_density_unit,
            l1."position" AS roof_layer1_position,
            l1.building_material_id AS roof_layer1_material_id,
            bm1.building_material_name AS roof_layer1_material_name,
            l1.thickness AS roof_layer1_thickness,
            u1_th.unit_name AS roof_layer1_thickness_unit,
            bm1.solar_absorption_rate AS roof_layer1_solar_absorption_rate,
            bm1.thermal_capacity AS roof_layer1_thermal_capacity,
            u1_tc.unit_name AS roof_layer1_thermal_capacity_unit,
            bm1.thermal_conductivity AS roof_layer1_thermal_conductivity,
            u1_tco.unit_name AS roof_layer1_thermal_conductivity_unit,
            sl1.service_life AS roof_layer1_service_life,
            u1_sl.unit_name AS roof_layer1_service_life_unit,
            bm1.density AS roof_layer1_density,
            u1_d.unit_name AS roof_layer1_density_unit,
            l2."position" AS roof_layer2_position,
            l2.building_material_id AS roof_layer2_material_id,
            bm2.building_material_name AS roof_layer2_material_name,
            l2.thickness AS roof_layer2_thickness,
            u2_th.unit_name AS roof_layer2_thickness_unit,
            bm2.solar_absorption_rate AS roof_layer2_solar_absorption_rate,
            bm2.thermal_capacity AS roof_layer2_thermal_capacity,
            u2_tc.unit_name AS roof_layer2_thermal_capacity_unit,
            bm2.thermal_conductivity AS roof_layer2_thermal_conductivity,
            u2_tco.unit_name AS roof_layer2_thermal_conductivity_unit,
            sl2.service_life AS roof_layer2_service_life,
            u2_sl.unit_name AS roof_layer2_service_life_unit,
            bm2.density AS roof_layer2_density,
            u2_d.unit_name AS roof_layer2_density_unit,
            l3."position" AS roof_layer3_position,
            l3.building_material_id AS roof_layer3_material_id,
            bm3.building_material_name AS roof_layer3_material_name,
            l3.thickness AS roof_layer3_thickness,
            u3_th.unit_name AS roof_layer3_thickness_unit,
            bm3.solar_absorption_rate AS roof_layer3_solar_absorption_rate,
            bm3.thermal_capacity AS roof_layer3_thermal_capacity,
            u3_tc.unit_name AS roof_layer3_thermal_capacity_unit,
            bm3.thermal_conductivity AS roof_layer3_thermal_conductivity,
            u3_tco.unit_name AS roof_layer3_thermal_conductivity_unit,
            sl3.service_life AS roof_layer3_service_life,
            u3_sl.unit_name AS roof_layer3_service_life_unit,
            bm3.density AS roof_layer3_density,
            u3_d.unit_name AS roof_layer3_density_unit,
            l4."position" AS roof_layer4_position,
            l4.building_material_id AS roof_layer4_material_id,
            bm4.building_material_name AS roof_layer4_material_name,
            l4.thickness AS roof_layer4_thickness,
            u4_th.unit_name AS roof_layer4_thickness_unit,
            bm4.solar_absorption_rate AS roof_layer4_solar_absorption_rate,
            bm4.thermal_capacity AS roof_layer4_thermal_capacity,
            u4_tc.unit_name AS roof_layer4_thermal_capacity_unit,
            bm4.thermal_conductivity AS roof_layer4_thermal_conductivity,
            u4_tco.unit_name AS roof_layer4_thermal_conductivity_unit,
            sl4.service_life AS roof_layer4_service_life,
            u4_sl.unit_name AS roof_layer4_service_life_unit,
            bm4.density AS roof_layer4_density,
            u4_d.unit_name AS roof_layer4_density_unit,
            l5."position" AS roof_layer5_position,
            l5.building_material_id AS roof_layer5_material_id,
            bm5.building_material_name AS roof_layer5_material_name,
            l5.thickness AS roof_layer5_thickness,
            u5_th.unit_name AS roof_layer5_thickness_unit,
            bm5.solar_absorption_rate AS roof_layer5_solar_absorption_rate,
            bm5.thermal_capacity AS roof_layer5_thermal_capacity,
            u5_tc.unit_name AS roof_layer5_thermal_capacity_unit,
            bm5.thermal_conductivity AS roof_layer5_thermal_conductivity,
            u5_tco.unit_name AS roof_layer5_thermal_conductivity_unit,
            sl5.service_life AS roof_layer5_service_life,
            u5_sl.unit_name AS roof_layer5_service_life_unit,
            bm5.density AS roof_layer5_density,
            u5_d.unit_name AS roof_layer5_density_unit
           FROM ((((((((((((((((((((((((((((((((((((((((((((((((step_009 b
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = b.roof_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_th ON ((u0_th.unit_id = l0.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tc ON ((u0_tc.unit_id = bm0.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tco ON ((u0_tco.unit_id = bm0.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl0 ON ((sl0.service_life_id = bm0.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_sl ON ((u0_sl.unit_id = sl0.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_d ON ((u0_d.unit_id = bm0.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = b.roof_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_th ON ((u1_th.unit_id = l1.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tc ON ((u1_tc.unit_id = bm1.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tco ON ((u1_tco.unit_id = bm1.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl1 ON ((sl1.service_life_id = bm1.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_sl ON ((u1_sl.unit_id = sl1.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_d ON ((u1_d.unit_id = bm1.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = b.roof_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_th ON ((u2_th.unit_id = l2.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tc ON ((u2_tc.unit_id = bm2.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tco ON ((u2_tco.unit_id = bm2.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl2 ON ((sl2.service_life_id = bm2.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_sl ON ((u2_sl.unit_id = sl2.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_d ON ((u2_d.unit_id = bm2.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l3 ON (((l3.building_element_id = b.roof_building_element_id) AND (l3."position" = 3))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm3 ON ((bm3.building_material_id = l3.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_th ON ((u3_th.unit_id = l3.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_tc ON ((u3_tc.unit_id = bm3.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_tco ON ((u3_tco.unit_id = bm3.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl3 ON ((sl3.service_life_id = bm3.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_sl ON ((u3_sl.unit_id = sl3.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_d ON ((u3_d.unit_id = bm3.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l4 ON (((l4.building_element_id = b.roof_building_element_id) AND (l4."position" = 4))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm4 ON ((bm4.building_material_id = l4.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_th ON ((u4_th.unit_id = l4.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_tc ON ((u4_tc.unit_id = bm4.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_tco ON ((u4_tco.unit_id = bm4.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl4 ON ((sl4.service_life_id = bm4.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_sl ON ((u4_sl.unit_id = sl4.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_d ON ((u4_d.unit_id = bm4.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l5 ON (((l5.building_element_id = b.roof_building_element_id) AND (l5."position" = 5))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm5 ON ((bm5.building_material_id = l5.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_th ON ((u5_th.unit_id = l5.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_tc ON ((u5_tc.unit_id = bm5.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_tco ON ((u5_tco.unit_id = bm5.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl5 ON ((sl5.service_life_id = bm5.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_sl ON ((u5_sl.unit_id = sl5.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_d ON ((u5_d.unit_id = bm5.density_unit_id)))
        ), step_011 AS (
         SELECT f.building_archetype_id,
            f.building_archetype_name,
            f.share_of_building_type,
            f.share_of_building_type_in_region,
            f.share_of_building_type_in_region_mun,
            f.exterior_wall_building_element_id,
            f.interior_wall_building_element_id,
            f.roof_building_element_id,
            f.foundation_building_element_id,
            f.floor_building_element_id,
            f.window_building_element_id,
            f.energy_system_id,
            f.building_type_name,
            f.region_name,
            f.municipality_size_name,
            f.municipality_growth_name,
            f.age_class_name,
            f.building_adjacency_name,
            f.facade_to_net_leased_area_ratio_mean,
            f.facade_to_net_leased_area_ratio_se_min,
            f.facade_to_net_leased_area_ratio_se_max,
            f.roof_to_net_leased_area_ratio_mean,
            f.roof_to_net_leased_area_ratio_se_min,
            f.roof_to_net_leased_area_ratio_se_max,
            f.foundation_to_net_leased_area_ratio_mean,
            f.foundation_to_net_leased_area_ratio_se_min,
            f.foundation_to_net_leased_area_ratio_se_max,
            f.window_to_net_leased_area_ratio_mean,
            f.window_to_net_leased_area_ratio_se_min,
            f.window_to_net_leased_area_ratio_se_max,
            f.building_height_mean,
            f.building_height_se,
            f.height_unit,
            f.aspect_ratio_mean,
            f.aspect_ratio_se_min,
            f.aspect_ratio_se_max,
            f.storeys_below_ground_mean,
            f.storeys_below_ground_se,
            f.storeys_above_ground_mean,
            f.storeys_above_ground_se,
            f.storeys_above_ground_se_min,
            f.storeys_above_ground_se_max,
            f.storey_height_mean,
            f.storey_height_se_min,
            f.storey_height_se_max,
            f.window_share,
            f.net_leased_area_mean,
            f.net_leased_area_se,
            f.net_leased_area_se_min,
            f.net_leased_area_se_max,
            f.net_leased_area_unit,
            f.facade_area_north_mean,
            f.facade_area_north_se,
            f.facade_area_east_mean,
            f.facade_area_east_se,
            f.facade_area_south_mean,
            f.facade_area_south_se,
            f.facade_area_west_mean,
            f.facade_area_west_se,
            f.facade_area_unit,
            f.facade_length_north_mean,
            f.facade_length_north_se,
            f.facade_length_east_mean,
            f.facade_length_east_se,
            f.facade_length_south_mean,
            f.facade_length_south_se,
            f.facade_length_west_mean,
            f.facade_length_west_se,
            f.facade_length_unit,
            f.exterior_wall_name,
            f.exterior_wall_construction_type,
            f.exterior_wall_u_value_typical_min,
            f.exterior_wall_u_value_typical_max,
            f.exterior_wall_u_value,
            f.exterior_wall_u_value_unit,
            f.exterior_wall_inner_radiation,
            f.exterior_wall_inner_radiation_unit,
            f.exterior_wall_outer_radiation,
            f.exterior_wall_outer_radiation_unit,
            f.exterior_wall_inner_convection,
            f.exterior_wall_inner_convection_unit,
            f.exterior_wall_outer_convection,
            f.exterior_wall_outer_convection_unit,
            f.exterior_wall_layer0_position,
            f.exterior_wall_layer0_material_id,
            f.exterior_wall_layer0_material_name,
            f.exterior_wall_layer0_thickness,
            f.exterior_wall_layer0_thickness_unit,
            f.exterior_wall_layer0_solar_absorption_rate,
            f.exterior_wall_layer0_thermal_capacity,
            f.exterior_wall_layer0_thermal_capacity_unit,
            f.exterior_wall_layer0_thermal_conductivity,
            f.exterior_wall_layer0_thermal_conductivity_unit,
            f.exterior_wall_layer0_service_life,
            f.exterior_wall_layer0_service_life_unit,
            f.exterior_wall_layer0_density,
            f.exterior_wall_layer0_density_unit,
            f.exterior_wall_layer1_position,
            f.exterior_wall_layer1_material_id,
            f.exterior_wall_layer1_material_name,
            f.exterior_wall_layer1_thickness,
            f.exterior_wall_layer1_thickness_unit,
            f.exterior_wall_layer1_solar_absorption_rate,
            f.exterior_wall_layer1_thermal_capacity,
            f.exterior_wall_layer1_thermal_capacity_unit,
            f.exterior_wall_layer1_thermal_conductivity,
            f.exterior_wall_layer1_thermal_conductivity_unit,
            f.exterior_wall_layer1_service_life,
            f.exterior_wall_layer1_service_life_unit,
            f.exterior_wall_layer1_density,
            f.exterior_wall_layer1_density_unit,
            f.exterior_wall_layer2_position,
            f.exterior_wall_layer2_material_id,
            f.exterior_wall_layer2_material_name,
            f.exterior_wall_layer2_thickness,
            f.exterior_wall_layer2_thickness_unit,
            f.exterior_wall_layer2_solar_absorption_rate,
            f.exterior_wall_layer2_thermal_capacity,
            f.exterior_wall_layer2_thermal_capacity_unit,
            f.exterior_wall_layer2_thermal_conductivity,
            f.exterior_wall_layer2_thermal_conductivity_unit,
            f.exterior_wall_layer2_service_life,
            f.exterior_wall_layer2_service_life_unit,
            f.exterior_wall_layer2_density,
            f.exterior_wall_layer2_density_unit,
            f.exterior_wall_layer3_position,
            f.exterior_wall_layer3_material_id,
            f.exterior_wall_layer3_material_name,
            f.exterior_wall_layer3_thickness,
            f.exterior_wall_layer3_thickness_unit,
            f.exterior_wall_layer3_solar_absorption_rate,
            f.exterior_wall_layer3_thermal_capacity,
            f.exterior_wall_layer3_thermal_capacity_unit,
            f.exterior_wall_layer3_thermal_conductivity,
            f.exterior_wall_layer3_thermal_conductivity_unit,
            f.exterior_wall_layer3_service_life,
            f.exterior_wall_layer3_service_life_unit,
            f.exterior_wall_layer3_density,
            f.exterior_wall_layer3_density_unit,
            f.exterior_wall_layer4_position,
            f.exterior_wall_layer4_material_id,
            f.exterior_wall_layer4_material_name,
            f.exterior_wall_layer4_thickness,
            f.exterior_wall_layer4_thickness_unit,
            f.exterior_wall_layer4_solar_absorption_rate,
            f.exterior_wall_layer4_thermal_capacity,
            f.exterior_wall_layer4_thermal_capacity_unit,
            f.exterior_wall_layer4_thermal_conductivity,
            f.exterior_wall_layer4_thermal_conductivity_unit,
            f.exterior_wall_layer4_service_life,
            f.exterior_wall_layer4_service_life_unit,
            f.exterior_wall_layer4_density,
            f.exterior_wall_layer4_density_unit,
            f.exterior_wall_layer5_position,
            f.exterior_wall_layer5_material_id,
            f.exterior_wall_layer5_material_name,
            f.exterior_wall_layer5_thickness,
            f.exterior_wall_layer5_thickness_unit,
            f.exterior_wall_layer5_solar_absorption_rate,
            f.exterior_wall_layer5_thermal_capacity,
            f.exterior_wall_layer5_thermal_capacity_unit,
            f.exterior_wall_layer5_thermal_conductivity,
            f.exterior_wall_layer5_thermal_conductivity_unit,
            f.exterior_wall_layer5_service_life,
            f.exterior_wall_layer5_service_life_unit,
            f.exterior_wall_layer5_density,
            f.exterior_wall_layer5_density_unit,
            f.exterior_wall_layer0_epd1_oekobaudat_name,
            f.exterior_wall_layer0_epd1_oekobaudat_uuid,
            f.exterior_wall_layer0_epd2_oekobaudat_name,
            f.exterior_wall_layer0_epd2_oekobaudat_uuid,
            f.exterior_wall_layer1_epd1_oekobaudat_name,
            f.exterior_wall_layer1_epd1_oekobaudat_uuid,
            f.exterior_wall_layer1_epd2_oekobaudat_name,
            f.exterior_wall_layer1_epd2_oekobaudat_uuid,
            f.exterior_wall_layer2_epd1_oekobaudat_name,
            f.exterior_wall_layer2_epd1_oekobaudat_uuid,
            f.exterior_wall_layer2_epd2_oekobaudat_name,
            f.exterior_wall_layer2_epd2_oekobaudat_uuid,
            f.exterior_wall_layer3_epd1_oekobaudat_name,
            f.exterior_wall_layer3_epd1_oekobaudat_uuid,
            f.exterior_wall_layer3_epd2_oekobaudat_name,
            f.exterior_wall_layer3_epd2_oekobaudat_uuid,
            f.exterior_wall_layer4_epd1_oekobaudat_name,
            f.exterior_wall_layer4_epd1_oekobaudat_uuid,
            f.exterior_wall_layer4_epd2_oekobaudat_name,
            f.exterior_wall_layer4_epd2_oekobaudat_uuid,
            f.exterior_wall_layer5_epd1_oekobaudat_name,
            f.exterior_wall_layer5_epd1_oekobaudat_uuid,
            f.exterior_wall_layer5_epd2_oekobaudat_name,
            f.exterior_wall_layer5_epd2_oekobaudat_uuid,
            f.interior_wall_name,
            f.interior_wall_u_value_typical_min,
            f.interior_wall_u_value_typical_max,
            f.interior_wall_u_value,
            f.interior_wall_u_value_unit,
            f.interior_wall_inner_radiation,
            f.interior_wall_inner_radiation_unit,
            f.interior_wall_inner_convection,
            f.interior_wall_inner_convection_unit,
            f.interior_wall_layer0_position,
            f.interior_wall_layer0_material_id,
            f.interior_wall_layer0_material_name,
            f.interior_wall_layer0_thickness,
            f.interior_wall_layer0_thickness_unit,
            f.interior_wall_layer0_solar_absorption_rate,
            f.interior_wall_layer0_thermal_capacity,
            f.interior_wall_layer0_thermal_capacity_unit,
            f.interior_wall_layer0_thermal_conductivity,
            f.interior_wall_layer0_thermal_conductivity_unit,
            f.interior_wall_layer0_service_life,
            f.interior_wall_layer0_service_life_unit,
            f.interior_wall_layer0_density,
            f.interior_wall_layer0_density_unit,
            f.interior_wall_layer1_position,
            f.interior_wall_layer1_material_id,
            f.interior_wall_layer1_material_name,
            f.interior_wall_layer1_thickness,
            f.interior_wall_layer1_thickness_unit,
            f.interior_wall_layer1_solar_absorption_rate,
            f.interior_wall_layer1_thermal_capacity,
            f.interior_wall_layer1_thermal_capacity_unit,
            f.interior_wall_layer1_thermal_conductivity,
            f.interior_wall_layer1_thermal_conductivity_unit,
            f.interior_wall_layer1_service_life,
            f.interior_wall_layer1_service_life_unit,
            f.interior_wall_layer1_density,
            f.interior_wall_layer1_density_unit,
            f.interior_wall_layer2_position,
            f.interior_wall_layer2_material_id,
            f.interior_wall_layer2_material_name,
            f.interior_wall_layer2_thickness,
            f.interior_wall_layer2_thickness_unit,
            f.interior_wall_layer2_solar_absorption_rate,
            f.interior_wall_layer2_thermal_capacity,
            f.interior_wall_layer2_thermal_capacity_unit,
            f.interior_wall_layer2_thermal_conductivity,
            f.interior_wall_layer2_thermal_conductivity_unit,
            f.interior_wall_layer2_service_life,
            f.interior_wall_layer2_service_life_unit,
            f.interior_wall_layer2_density,
            f.interior_wall_layer2_density_unit,
            f.interior_wall_layer0_epd1_oekobaudat_name,
            f.interior_wall_layer0_epd1_oekobaudat_uuid,
            f.interior_wall_layer0_epd2_oekobaudat_name,
            f.interior_wall_layer0_epd2_oekobaudat_uuid,
            f.interior_wall_layer1_epd1_oekobaudat_name,
            f.interior_wall_layer1_epd1_oekobaudat_uuid,
            f.interior_wall_layer1_epd2_oekobaudat_name,
            f.interior_wall_layer1_epd2_oekobaudat_uuid,
            f.interior_wall_layer2_epd1_oekobaudat_name,
            f.interior_wall_layer2_epd1_oekobaudat_uuid,
            f.interior_wall_layer2_epd2_oekobaudat_name,
            f.interior_wall_layer2_epd2_oekobaudat_uuid,
            f.roof_name,
            f.roof_construction_type,
            f.roof_pitch_type,
            f.roof_u_value_typical_min,
            f.roof_u_value_typical_max,
            f.roof_u_value,
            f.roof_u_value_unit,
            f.roof_inner_radiation,
            f.roof_inner_radiation_unit,
            f.roof_outer_radiation,
            f.roof_outer_radiation_unit,
            f.roof_inner_convection,
            f.roof_inner_convection_unit,
            f.roof_outer_convection,
            f.roof_outer_convection_unit,
            f.roof_layer0_position,
            f.roof_layer0_material_id,
            f.roof_layer0_material_name,
            f.roof_layer0_thickness,
            f.roof_layer0_thickness_unit,
            f.roof_layer0_solar_absorption_rate,
            f.roof_layer0_thermal_capacity,
            f.roof_layer0_thermal_capacity_unit,
            f.roof_layer0_thermal_conductivity,
            f.roof_layer0_thermal_conductivity_unit,
            f.roof_layer0_service_life,
            f.roof_layer0_service_life_unit,
            f.roof_layer0_density,
            f.roof_layer0_density_unit,
            f.roof_layer1_position,
            f.roof_layer1_material_id,
            f.roof_layer1_material_name,
            f.roof_layer1_thickness,
            f.roof_layer1_thickness_unit,
            f.roof_layer1_solar_absorption_rate,
            f.roof_layer1_thermal_capacity,
            f.roof_layer1_thermal_capacity_unit,
            f.roof_layer1_thermal_conductivity,
            f.roof_layer1_thermal_conductivity_unit,
            f.roof_layer1_service_life,
            f.roof_layer1_service_life_unit,
            f.roof_layer1_density,
            f.roof_layer1_density_unit,
            f.roof_layer2_position,
            f.roof_layer2_material_id,
            f.roof_layer2_material_name,
            f.roof_layer2_thickness,
            f.roof_layer2_thickness_unit,
            f.roof_layer2_solar_absorption_rate,
            f.roof_layer2_thermal_capacity,
            f.roof_layer2_thermal_capacity_unit,
            f.roof_layer2_thermal_conductivity,
            f.roof_layer2_thermal_conductivity_unit,
            f.roof_layer2_service_life,
            f.roof_layer2_service_life_unit,
            f.roof_layer2_density,
            f.roof_layer2_density_unit,
            f.roof_layer3_position,
            f.roof_layer3_material_id,
            f.roof_layer3_material_name,
            f.roof_layer3_thickness,
            f.roof_layer3_thickness_unit,
            f.roof_layer3_solar_absorption_rate,
            f.roof_layer3_thermal_capacity,
            f.roof_layer3_thermal_capacity_unit,
            f.roof_layer3_thermal_conductivity,
            f.roof_layer3_thermal_conductivity_unit,
            f.roof_layer3_service_life,
            f.roof_layer3_service_life_unit,
            f.roof_layer3_density,
            f.roof_layer3_density_unit,
            f.roof_layer4_position,
            f.roof_layer4_material_id,
            f.roof_layer4_material_name,
            f.roof_layer4_thickness,
            f.roof_layer4_thickness_unit,
            f.roof_layer4_solar_absorption_rate,
            f.roof_layer4_thermal_capacity,
            f.roof_layer4_thermal_capacity_unit,
            f.roof_layer4_thermal_conductivity,
            f.roof_layer4_thermal_conductivity_unit,
            f.roof_layer4_service_life,
            f.roof_layer4_service_life_unit,
            f.roof_layer4_density,
            f.roof_layer4_density_unit,
            f.roof_layer5_position,
            f.roof_layer5_material_id,
            f.roof_layer5_material_name,
            f.roof_layer5_thickness,
            f.roof_layer5_thickness_unit,
            f.roof_layer5_solar_absorption_rate,
            f.roof_layer5_thermal_capacity,
            f.roof_layer5_thermal_capacity_unit,
            f.roof_layer5_thermal_conductivity,
            f.roof_layer5_thermal_conductivity_unit,
            f.roof_layer5_service_life,
            f.roof_layer5_service_life_unit,
            f.roof_layer5_density,
            f.roof_layer5_density_unit,
            epd0_1.environmental_product_declaration_name AS roof_layer0_epd1_oekobaudat_name,
            epd0_1.database_uuid AS roof_layer0_epd1_oekobaudat_uuid,
            epd0_2.environmental_product_declaration_name AS roof_layer0_epd2_oekobaudat_name,
            epd0_2.database_uuid AS roof_layer0_epd2_oekobaudat_uuid,
            epd1_1.environmental_product_declaration_name AS roof_layer1_epd1_oekobaudat_name,
            epd1_1.database_uuid AS roof_layer1_epd1_oekobaudat_uuid,
            epd1_2.environmental_product_declaration_name AS roof_layer1_epd2_oekobaudat_name,
            epd1_2.database_uuid AS roof_layer1_epd2_oekobaudat_uuid,
            epd2_1.environmental_product_declaration_name AS roof_layer2_epd1_oekobaudat_name,
            epd2_1.database_uuid AS roof_layer2_epd1_oekobaudat_uuid,
            epd2_2.environmental_product_declaration_name AS roof_layer2_epd2_oekobaudat_name,
            epd2_2.database_uuid AS roof_layer2_epd2_oekobaudat_uuid,
            epd3_1.environmental_product_declaration_name AS roof_layer3_epd1_oekobaudat_name,
            epd3_1.database_uuid AS roof_layer3_epd1_oekobaudat_uuid,
            epd3_2.environmental_product_declaration_name AS roof_layer3_epd2_oekobaudat_name,
            epd3_2.database_uuid AS roof_layer3_epd2_oekobaudat_uuid,
            epd4_1.environmental_product_declaration_name AS roof_layer4_epd1_oekobaudat_name,
            epd4_1.database_uuid AS roof_layer4_epd1_oekobaudat_uuid,
            epd4_2.environmental_product_declaration_name AS roof_layer4_epd2_oekobaudat_name,
            epd4_2.database_uuid AS roof_layer4_epd2_oekobaudat_uuid,
            epd5_1.environmental_product_declaration_name AS roof_layer5_epd1_oekobaudat_name,
            epd5_1.database_uuid AS roof_layer5_epd1_oekobaudat_uuid,
            epd5_2.environmental_product_declaration_name AS roof_layer5_epd2_oekobaudat_name,
            epd5_2.database_uuid AS roof_layer5_epd2_oekobaudat_uuid
           FROM ((((((((((((((((((((((((step_010 f
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = f.roof_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_1 ON ((epd0_1.environmental_product_declaration_id = bm0.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_2 ON ((epd0_2.environmental_product_declaration_id = bm0.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = f.roof_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_1 ON ((epd1_1.environmental_product_declaration_id = bm1.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_2 ON ((epd1_2.environmental_product_declaration_id = bm1.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = f.roof_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_1 ON ((epd2_1.environmental_product_declaration_id = bm2.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_2 ON ((epd2_2.environmental_product_declaration_id = bm2.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l3 ON (((l3.building_element_id = f.roof_building_element_id) AND (l3."position" = 3))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm3 ON ((bm3.building_material_id = l3.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd3_1 ON ((epd3_1.environmental_product_declaration_id = bm3.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd3_2 ON ((epd3_2.environmental_product_declaration_id = bm3.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l4 ON (((l4.building_element_id = f.roof_building_element_id) AND (l4."position" = 4))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm4 ON ((bm4.building_material_id = l4.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd4_1 ON ((epd4_1.environmental_product_declaration_id = bm4.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd4_2 ON ((epd4_2.environmental_product_declaration_id = bm4.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l5 ON (((l5.building_element_id = f.roof_building_element_id) AND (l5."position" = 5))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm5 ON ((bm5.building_material_id = l5.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd5_1 ON ((epd5_1.environmental_product_declaration_id = bm5.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd5_2 ON ((epd5_2.environmental_product_declaration_id = bm5.environmental_product_declaration_id_2)))
        ), step_012 AS (
         SELECT g.building_archetype_id,
            g.building_archetype_name,
            g.share_of_building_type,
            g.share_of_building_type_in_region,
            g.share_of_building_type_in_region_mun,
            g.exterior_wall_building_element_id,
            g.interior_wall_building_element_id,
            g.roof_building_element_id,
            g.foundation_building_element_id,
            g.floor_building_element_id,
            g.window_building_element_id,
            g.energy_system_id,
            g.building_type_name,
            g.region_name,
            g.municipality_size_name,
            g.municipality_growth_name,
            g.age_class_name,
            g.building_adjacency_name,
            g.facade_to_net_leased_area_ratio_mean,
            g.facade_to_net_leased_area_ratio_se_min,
            g.facade_to_net_leased_area_ratio_se_max,
            g.roof_to_net_leased_area_ratio_mean,
            g.roof_to_net_leased_area_ratio_se_min,
            g.roof_to_net_leased_area_ratio_se_max,
            g.foundation_to_net_leased_area_ratio_mean,
            g.foundation_to_net_leased_area_ratio_se_min,
            g.foundation_to_net_leased_area_ratio_se_max,
            g.window_to_net_leased_area_ratio_mean,
            g.window_to_net_leased_area_ratio_se_min,
            g.window_to_net_leased_area_ratio_se_max,
            g.building_height_mean,
            g.building_height_se,
            g.height_unit,
            g.aspect_ratio_mean,
            g.aspect_ratio_se_min,
            g.aspect_ratio_se_max,
            g.storeys_below_ground_mean,
            g.storeys_below_ground_se,
            g.storeys_above_ground_mean,
            g.storeys_above_ground_se,
            g.storeys_above_ground_se_min,
            g.storeys_above_ground_se_max,
            g.storey_height_mean,
            g.storey_height_se_min,
            g.storey_height_se_max,
            g.window_share,
            g.net_leased_area_mean,
            g.net_leased_area_se,
            g.net_leased_area_se_min,
            g.net_leased_area_se_max,
            g.net_leased_area_unit,
            g.facade_area_north_mean,
            g.facade_area_north_se,
            g.facade_area_east_mean,
            g.facade_area_east_se,
            g.facade_area_south_mean,
            g.facade_area_south_se,
            g.facade_area_west_mean,
            g.facade_area_west_se,
            g.facade_area_unit,
            g.facade_length_north_mean,
            g.facade_length_north_se,
            g.facade_length_east_mean,
            g.facade_length_east_se,
            g.facade_length_south_mean,
            g.facade_length_south_se,
            g.facade_length_west_mean,
            g.facade_length_west_se,
            g.facade_length_unit,
            g.exterior_wall_name,
            g.exterior_wall_construction_type,
            g.exterior_wall_u_value_typical_min,
            g.exterior_wall_u_value_typical_max,
            g.exterior_wall_u_value,
            g.exterior_wall_u_value_unit,
            g.exterior_wall_inner_radiation,
            g.exterior_wall_inner_radiation_unit,
            g.exterior_wall_outer_radiation,
            g.exterior_wall_outer_radiation_unit,
            g.exterior_wall_inner_convection,
            g.exterior_wall_inner_convection_unit,
            g.exterior_wall_outer_convection,
            g.exterior_wall_outer_convection_unit,
            g.exterior_wall_layer0_position,
            g.exterior_wall_layer0_material_id,
            g.exterior_wall_layer0_material_name,
            g.exterior_wall_layer0_thickness,
            g.exterior_wall_layer0_thickness_unit,
            g.exterior_wall_layer0_solar_absorption_rate,
            g.exterior_wall_layer0_thermal_capacity,
            g.exterior_wall_layer0_thermal_capacity_unit,
            g.exterior_wall_layer0_thermal_conductivity,
            g.exterior_wall_layer0_thermal_conductivity_unit,
            g.exterior_wall_layer0_service_life,
            g.exterior_wall_layer0_service_life_unit,
            g.exterior_wall_layer0_density,
            g.exterior_wall_layer0_density_unit,
            g.exterior_wall_layer1_position,
            g.exterior_wall_layer1_material_id,
            g.exterior_wall_layer1_material_name,
            g.exterior_wall_layer1_thickness,
            g.exterior_wall_layer1_thickness_unit,
            g.exterior_wall_layer1_solar_absorption_rate,
            g.exterior_wall_layer1_thermal_capacity,
            g.exterior_wall_layer1_thermal_capacity_unit,
            g.exterior_wall_layer1_thermal_conductivity,
            g.exterior_wall_layer1_thermal_conductivity_unit,
            g.exterior_wall_layer1_service_life,
            g.exterior_wall_layer1_service_life_unit,
            g.exterior_wall_layer1_density,
            g.exterior_wall_layer1_density_unit,
            g.exterior_wall_layer2_position,
            g.exterior_wall_layer2_material_id,
            g.exterior_wall_layer2_material_name,
            g.exterior_wall_layer2_thickness,
            g.exterior_wall_layer2_thickness_unit,
            g.exterior_wall_layer2_solar_absorption_rate,
            g.exterior_wall_layer2_thermal_capacity,
            g.exterior_wall_layer2_thermal_capacity_unit,
            g.exterior_wall_layer2_thermal_conductivity,
            g.exterior_wall_layer2_thermal_conductivity_unit,
            g.exterior_wall_layer2_service_life,
            g.exterior_wall_layer2_service_life_unit,
            g.exterior_wall_layer2_density,
            g.exterior_wall_layer2_density_unit,
            g.exterior_wall_layer3_position,
            g.exterior_wall_layer3_material_id,
            g.exterior_wall_layer3_material_name,
            g.exterior_wall_layer3_thickness,
            g.exterior_wall_layer3_thickness_unit,
            g.exterior_wall_layer3_solar_absorption_rate,
            g.exterior_wall_layer3_thermal_capacity,
            g.exterior_wall_layer3_thermal_capacity_unit,
            g.exterior_wall_layer3_thermal_conductivity,
            g.exterior_wall_layer3_thermal_conductivity_unit,
            g.exterior_wall_layer3_service_life,
            g.exterior_wall_layer3_service_life_unit,
            g.exterior_wall_layer3_density,
            g.exterior_wall_layer3_density_unit,
            g.exterior_wall_layer4_position,
            g.exterior_wall_layer4_material_id,
            g.exterior_wall_layer4_material_name,
            g.exterior_wall_layer4_thickness,
            g.exterior_wall_layer4_thickness_unit,
            g.exterior_wall_layer4_solar_absorption_rate,
            g.exterior_wall_layer4_thermal_capacity,
            g.exterior_wall_layer4_thermal_capacity_unit,
            g.exterior_wall_layer4_thermal_conductivity,
            g.exterior_wall_layer4_thermal_conductivity_unit,
            g.exterior_wall_layer4_service_life,
            g.exterior_wall_layer4_service_life_unit,
            g.exterior_wall_layer4_density,
            g.exterior_wall_layer4_density_unit,
            g.exterior_wall_layer5_position,
            g.exterior_wall_layer5_material_id,
            g.exterior_wall_layer5_material_name,
            g.exterior_wall_layer5_thickness,
            g.exterior_wall_layer5_thickness_unit,
            g.exterior_wall_layer5_solar_absorption_rate,
            g.exterior_wall_layer5_thermal_capacity,
            g.exterior_wall_layer5_thermal_capacity_unit,
            g.exterior_wall_layer5_thermal_conductivity,
            g.exterior_wall_layer5_thermal_conductivity_unit,
            g.exterior_wall_layer5_service_life,
            g.exterior_wall_layer5_service_life_unit,
            g.exterior_wall_layer5_density,
            g.exterior_wall_layer5_density_unit,
            g.exterior_wall_layer0_epd1_oekobaudat_name,
            g.exterior_wall_layer0_epd1_oekobaudat_uuid,
            g.exterior_wall_layer0_epd2_oekobaudat_name,
            g.exterior_wall_layer0_epd2_oekobaudat_uuid,
            g.exterior_wall_layer1_epd1_oekobaudat_name,
            g.exterior_wall_layer1_epd1_oekobaudat_uuid,
            g.exterior_wall_layer1_epd2_oekobaudat_name,
            g.exterior_wall_layer1_epd2_oekobaudat_uuid,
            g.exterior_wall_layer2_epd1_oekobaudat_name,
            g.exterior_wall_layer2_epd1_oekobaudat_uuid,
            g.exterior_wall_layer2_epd2_oekobaudat_name,
            g.exterior_wall_layer2_epd2_oekobaudat_uuid,
            g.exterior_wall_layer3_epd1_oekobaudat_name,
            g.exterior_wall_layer3_epd1_oekobaudat_uuid,
            g.exterior_wall_layer3_epd2_oekobaudat_name,
            g.exterior_wall_layer3_epd2_oekobaudat_uuid,
            g.exterior_wall_layer4_epd1_oekobaudat_name,
            g.exterior_wall_layer4_epd1_oekobaudat_uuid,
            g.exterior_wall_layer4_epd2_oekobaudat_name,
            g.exterior_wall_layer4_epd2_oekobaudat_uuid,
            g.exterior_wall_layer5_epd1_oekobaudat_name,
            g.exterior_wall_layer5_epd1_oekobaudat_uuid,
            g.exterior_wall_layer5_epd2_oekobaudat_name,
            g.exterior_wall_layer5_epd2_oekobaudat_uuid,
            g.interior_wall_name,
            g.interior_wall_u_value_typical_min,
            g.interior_wall_u_value_typical_max,
            g.interior_wall_u_value,
            g.interior_wall_u_value_unit,
            g.interior_wall_inner_radiation,
            g.interior_wall_inner_radiation_unit,
            g.interior_wall_inner_convection,
            g.interior_wall_inner_convection_unit,
            g.interior_wall_layer0_position,
            g.interior_wall_layer0_material_id,
            g.interior_wall_layer0_material_name,
            g.interior_wall_layer0_thickness,
            g.interior_wall_layer0_thickness_unit,
            g.interior_wall_layer0_solar_absorption_rate,
            g.interior_wall_layer0_thermal_capacity,
            g.interior_wall_layer0_thermal_capacity_unit,
            g.interior_wall_layer0_thermal_conductivity,
            g.interior_wall_layer0_thermal_conductivity_unit,
            g.interior_wall_layer0_service_life,
            g.interior_wall_layer0_service_life_unit,
            g.interior_wall_layer0_density,
            g.interior_wall_layer0_density_unit,
            g.interior_wall_layer1_position,
            g.interior_wall_layer1_material_id,
            g.interior_wall_layer1_material_name,
            g.interior_wall_layer1_thickness,
            g.interior_wall_layer1_thickness_unit,
            g.interior_wall_layer1_solar_absorption_rate,
            g.interior_wall_layer1_thermal_capacity,
            g.interior_wall_layer1_thermal_capacity_unit,
            g.interior_wall_layer1_thermal_conductivity,
            g.interior_wall_layer1_thermal_conductivity_unit,
            g.interior_wall_layer1_service_life,
            g.interior_wall_layer1_service_life_unit,
            g.interior_wall_layer1_density,
            g.interior_wall_layer1_density_unit,
            g.interior_wall_layer2_position,
            g.interior_wall_layer2_material_id,
            g.interior_wall_layer2_material_name,
            g.interior_wall_layer2_thickness,
            g.interior_wall_layer2_thickness_unit,
            g.interior_wall_layer2_solar_absorption_rate,
            g.interior_wall_layer2_thermal_capacity,
            g.interior_wall_layer2_thermal_capacity_unit,
            g.interior_wall_layer2_thermal_conductivity,
            g.interior_wall_layer2_thermal_conductivity_unit,
            g.interior_wall_layer2_service_life,
            g.interior_wall_layer2_service_life_unit,
            g.interior_wall_layer2_density,
            g.interior_wall_layer2_density_unit,
            g.interior_wall_layer0_epd1_oekobaudat_name,
            g.interior_wall_layer0_epd1_oekobaudat_uuid,
            g.interior_wall_layer0_epd2_oekobaudat_name,
            g.interior_wall_layer0_epd2_oekobaudat_uuid,
            g.interior_wall_layer1_epd1_oekobaudat_name,
            g.interior_wall_layer1_epd1_oekobaudat_uuid,
            g.interior_wall_layer1_epd2_oekobaudat_name,
            g.interior_wall_layer1_epd2_oekobaudat_uuid,
            g.interior_wall_layer2_epd1_oekobaudat_name,
            g.interior_wall_layer2_epd1_oekobaudat_uuid,
            g.interior_wall_layer2_epd2_oekobaudat_name,
            g.interior_wall_layer2_epd2_oekobaudat_uuid,
            g.roof_name,
            g.roof_construction_type,
            g.roof_pitch_type,
            g.roof_u_value_typical_min,
            g.roof_u_value_typical_max,
            g.roof_u_value,
            g.roof_u_value_unit,
            g.roof_inner_radiation,
            g.roof_inner_radiation_unit,
            g.roof_outer_radiation,
            g.roof_outer_radiation_unit,
            g.roof_inner_convection,
            g.roof_inner_convection_unit,
            g.roof_outer_convection,
            g.roof_outer_convection_unit,
            g.roof_layer0_position,
            g.roof_layer0_material_id,
            g.roof_layer0_material_name,
            g.roof_layer0_thickness,
            g.roof_layer0_thickness_unit,
            g.roof_layer0_solar_absorption_rate,
            g.roof_layer0_thermal_capacity,
            g.roof_layer0_thermal_capacity_unit,
            g.roof_layer0_thermal_conductivity,
            g.roof_layer0_thermal_conductivity_unit,
            g.roof_layer0_service_life,
            g.roof_layer0_service_life_unit,
            g.roof_layer0_density,
            g.roof_layer0_density_unit,
            g.roof_layer1_position,
            g.roof_layer1_material_id,
            g.roof_layer1_material_name,
            g.roof_layer1_thickness,
            g.roof_layer1_thickness_unit,
            g.roof_layer1_solar_absorption_rate,
            g.roof_layer1_thermal_capacity,
            g.roof_layer1_thermal_capacity_unit,
            g.roof_layer1_thermal_conductivity,
            g.roof_layer1_thermal_conductivity_unit,
            g.roof_layer1_service_life,
            g.roof_layer1_service_life_unit,
            g.roof_layer1_density,
            g.roof_layer1_density_unit,
            g.roof_layer2_position,
            g.roof_layer2_material_id,
            g.roof_layer2_material_name,
            g.roof_layer2_thickness,
            g.roof_layer2_thickness_unit,
            g.roof_layer2_solar_absorption_rate,
            g.roof_layer2_thermal_capacity,
            g.roof_layer2_thermal_capacity_unit,
            g.roof_layer2_thermal_conductivity,
            g.roof_layer2_thermal_conductivity_unit,
            g.roof_layer2_service_life,
            g.roof_layer2_service_life_unit,
            g.roof_layer2_density,
            g.roof_layer2_density_unit,
            g.roof_layer3_position,
            g.roof_layer3_material_id,
            g.roof_layer3_material_name,
            g.roof_layer3_thickness,
            g.roof_layer3_thickness_unit,
            g.roof_layer3_solar_absorption_rate,
            g.roof_layer3_thermal_capacity,
            g.roof_layer3_thermal_capacity_unit,
            g.roof_layer3_thermal_conductivity,
            g.roof_layer3_thermal_conductivity_unit,
            g.roof_layer3_service_life,
            g.roof_layer3_service_life_unit,
            g.roof_layer3_density,
            g.roof_layer3_density_unit,
            g.roof_layer4_position,
            g.roof_layer4_material_id,
            g.roof_layer4_material_name,
            g.roof_layer4_thickness,
            g.roof_layer4_thickness_unit,
            g.roof_layer4_solar_absorption_rate,
            g.roof_layer4_thermal_capacity,
            g.roof_layer4_thermal_capacity_unit,
            g.roof_layer4_thermal_conductivity,
            g.roof_layer4_thermal_conductivity_unit,
            g.roof_layer4_service_life,
            g.roof_layer4_service_life_unit,
            g.roof_layer4_density,
            g.roof_layer4_density_unit,
            g.roof_layer5_position,
            g.roof_layer5_material_id,
            g.roof_layer5_material_name,
            g.roof_layer5_thickness,
            g.roof_layer5_thickness_unit,
            g.roof_layer5_solar_absorption_rate,
            g.roof_layer5_thermal_capacity,
            g.roof_layer5_thermal_capacity_unit,
            g.roof_layer5_thermal_conductivity,
            g.roof_layer5_thermal_conductivity_unit,
            g.roof_layer5_service_life,
            g.roof_layer5_service_life_unit,
            g.roof_layer5_density,
            g.roof_layer5_density_unit,
            g.roof_layer0_epd1_oekobaudat_name,
            g.roof_layer0_epd1_oekobaudat_uuid,
            g.roof_layer0_epd2_oekobaudat_name,
            g.roof_layer0_epd2_oekobaudat_uuid,
            g.roof_layer1_epd1_oekobaudat_name,
            g.roof_layer1_epd1_oekobaudat_uuid,
            g.roof_layer1_epd2_oekobaudat_name,
            g.roof_layer1_epd2_oekobaudat_uuid,
            g.roof_layer2_epd1_oekobaudat_name,
            g.roof_layer2_epd1_oekobaudat_uuid,
            g.roof_layer2_epd2_oekobaudat_name,
            g.roof_layer2_epd2_oekobaudat_uuid,
            g.roof_layer3_epd1_oekobaudat_name,
            g.roof_layer3_epd1_oekobaudat_uuid,
            g.roof_layer3_epd2_oekobaudat_name,
            g.roof_layer3_epd2_oekobaudat_uuid,
            g.roof_layer4_epd1_oekobaudat_name,
            g.roof_layer4_epd1_oekobaudat_uuid,
            g.roof_layer4_epd2_oekobaudat_name,
            g.roof_layer4_epd2_oekobaudat_uuid,
            g.roof_layer5_epd1_oekobaudat_name,
            g.roof_layer5_epd1_oekobaudat_uuid,
            g.roof_layer5_epd2_oekobaudat_name,
            g.roof_layer5_epd2_oekobaudat_uuid,
            be.building_element_name AS foundation_name,
            ct.construction_type_name AS foundation_construction_type,
            be.u_value_typical_min AS foundation_u_value_typical_min,
            be.u_value_typical_max AS foundation_u_value_typical_max,
            be.u_value AS foundation_u_value,
            u.unit_name AS foundation_u_value_unit,
            be.inner_radiation AS foundation_inner_radiation,
            u1.unit_name AS foundation_inner_radiation_unit,
            be.inner_convection AS foundation_inner_convection,
            u3.unit_name AS foundation_inner_convection_unit
           FROM (((((step_011 g
             LEFT JOIN hub4lca_post_simulation.building_elements be ON ((be.building_element_id = g.foundation_building_element_id)))
             LEFT JOIN hub4lca_post_simulation.construction_types ct ON ((ct.construction_type_id = be.construction_type_id)))
             LEFT JOIN hub4lca_post_simulation.units u ON ((u.unit_id = be.u_value_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1 ON ((u1.unit_id = be.inner_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3 ON ((u3.unit_id = be.inner_convection_unit_id)))
        ), step_013 AS (
         SELECT b.building_archetype_id,
            b.building_archetype_name,
            b.share_of_building_type,
            b.share_of_building_type_in_region,
            b.share_of_building_type_in_region_mun,
            b.exterior_wall_building_element_id,
            b.interior_wall_building_element_id,
            b.roof_building_element_id,
            b.foundation_building_element_id,
            b.floor_building_element_id,
            b.window_building_element_id,
            b.energy_system_id,
            b.building_type_name,
            b.region_name,
            b.municipality_size_name,
            b.municipality_growth_name,
            b.age_class_name,
            b.building_adjacency_name,
            b.facade_to_net_leased_area_ratio_mean,
            b.facade_to_net_leased_area_ratio_se_min,
            b.facade_to_net_leased_area_ratio_se_max,
            b.roof_to_net_leased_area_ratio_mean,
            b.roof_to_net_leased_area_ratio_se_min,
            b.roof_to_net_leased_area_ratio_se_max,
            b.foundation_to_net_leased_area_ratio_mean,
            b.foundation_to_net_leased_area_ratio_se_min,
            b.foundation_to_net_leased_area_ratio_se_max,
            b.window_to_net_leased_area_ratio_mean,
            b.window_to_net_leased_area_ratio_se_min,
            b.window_to_net_leased_area_ratio_se_max,
            b.building_height_mean,
            b.building_height_se,
            b.height_unit,
            b.aspect_ratio_mean,
            b.aspect_ratio_se_min,
            b.aspect_ratio_se_max,
            b.storeys_below_ground_mean,
            b.storeys_below_ground_se,
            b.storeys_above_ground_mean,
            b.storeys_above_ground_se,
            b.storeys_above_ground_se_min,
            b.storeys_above_ground_se_max,
            b.storey_height_mean,
            b.storey_height_se_min,
            b.storey_height_se_max,
            b.window_share,
            b.net_leased_area_mean,
            b.net_leased_area_se,
            b.net_leased_area_se_min,
            b.net_leased_area_se_max,
            b.net_leased_area_unit,
            b.facade_area_north_mean,
            b.facade_area_north_se,
            b.facade_area_east_mean,
            b.facade_area_east_se,
            b.facade_area_south_mean,
            b.facade_area_south_se,
            b.facade_area_west_mean,
            b.facade_area_west_se,
            b.facade_area_unit,
            b.facade_length_north_mean,
            b.facade_length_north_se,
            b.facade_length_east_mean,
            b.facade_length_east_se,
            b.facade_length_south_mean,
            b.facade_length_south_se,
            b.facade_length_west_mean,
            b.facade_length_west_se,
            b.facade_length_unit,
            b.exterior_wall_name,
            b.exterior_wall_construction_type,
            b.exterior_wall_u_value_typical_min,
            b.exterior_wall_u_value_typical_max,
            b.exterior_wall_u_value,
            b.exterior_wall_u_value_unit,
            b.exterior_wall_inner_radiation,
            b.exterior_wall_inner_radiation_unit,
            b.exterior_wall_outer_radiation,
            b.exterior_wall_outer_radiation_unit,
            b.exterior_wall_inner_convection,
            b.exterior_wall_inner_convection_unit,
            b.exterior_wall_outer_convection,
            b.exterior_wall_outer_convection_unit,
            b.exterior_wall_layer0_position,
            b.exterior_wall_layer0_material_id,
            b.exterior_wall_layer0_material_name,
            b.exterior_wall_layer0_thickness,
            b.exterior_wall_layer0_thickness_unit,
            b.exterior_wall_layer0_solar_absorption_rate,
            b.exterior_wall_layer0_thermal_capacity,
            b.exterior_wall_layer0_thermal_capacity_unit,
            b.exterior_wall_layer0_thermal_conductivity,
            b.exterior_wall_layer0_thermal_conductivity_unit,
            b.exterior_wall_layer0_service_life,
            b.exterior_wall_layer0_service_life_unit,
            b.exterior_wall_layer0_density,
            b.exterior_wall_layer0_density_unit,
            b.exterior_wall_layer1_position,
            b.exterior_wall_layer1_material_id,
            b.exterior_wall_layer1_material_name,
            b.exterior_wall_layer1_thickness,
            b.exterior_wall_layer1_thickness_unit,
            b.exterior_wall_layer1_solar_absorption_rate,
            b.exterior_wall_layer1_thermal_capacity,
            b.exterior_wall_layer1_thermal_capacity_unit,
            b.exterior_wall_layer1_thermal_conductivity,
            b.exterior_wall_layer1_thermal_conductivity_unit,
            b.exterior_wall_layer1_service_life,
            b.exterior_wall_layer1_service_life_unit,
            b.exterior_wall_layer1_density,
            b.exterior_wall_layer1_density_unit,
            b.exterior_wall_layer2_position,
            b.exterior_wall_layer2_material_id,
            b.exterior_wall_layer2_material_name,
            b.exterior_wall_layer2_thickness,
            b.exterior_wall_layer2_thickness_unit,
            b.exterior_wall_layer2_solar_absorption_rate,
            b.exterior_wall_layer2_thermal_capacity,
            b.exterior_wall_layer2_thermal_capacity_unit,
            b.exterior_wall_layer2_thermal_conductivity,
            b.exterior_wall_layer2_thermal_conductivity_unit,
            b.exterior_wall_layer2_service_life,
            b.exterior_wall_layer2_service_life_unit,
            b.exterior_wall_layer2_density,
            b.exterior_wall_layer2_density_unit,
            b.exterior_wall_layer3_position,
            b.exterior_wall_layer3_material_id,
            b.exterior_wall_layer3_material_name,
            b.exterior_wall_layer3_thickness,
            b.exterior_wall_layer3_thickness_unit,
            b.exterior_wall_layer3_solar_absorption_rate,
            b.exterior_wall_layer3_thermal_capacity,
            b.exterior_wall_layer3_thermal_capacity_unit,
            b.exterior_wall_layer3_thermal_conductivity,
            b.exterior_wall_layer3_thermal_conductivity_unit,
            b.exterior_wall_layer3_service_life,
            b.exterior_wall_layer3_service_life_unit,
            b.exterior_wall_layer3_density,
            b.exterior_wall_layer3_density_unit,
            b.exterior_wall_layer4_position,
            b.exterior_wall_layer4_material_id,
            b.exterior_wall_layer4_material_name,
            b.exterior_wall_layer4_thickness,
            b.exterior_wall_layer4_thickness_unit,
            b.exterior_wall_layer4_solar_absorption_rate,
            b.exterior_wall_layer4_thermal_capacity,
            b.exterior_wall_layer4_thermal_capacity_unit,
            b.exterior_wall_layer4_thermal_conductivity,
            b.exterior_wall_layer4_thermal_conductivity_unit,
            b.exterior_wall_layer4_service_life,
            b.exterior_wall_layer4_service_life_unit,
            b.exterior_wall_layer4_density,
            b.exterior_wall_layer4_density_unit,
            b.exterior_wall_layer5_position,
            b.exterior_wall_layer5_material_id,
            b.exterior_wall_layer5_material_name,
            b.exterior_wall_layer5_thickness,
            b.exterior_wall_layer5_thickness_unit,
            b.exterior_wall_layer5_solar_absorption_rate,
            b.exterior_wall_layer5_thermal_capacity,
            b.exterior_wall_layer5_thermal_capacity_unit,
            b.exterior_wall_layer5_thermal_conductivity,
            b.exterior_wall_layer5_thermal_conductivity_unit,
            b.exterior_wall_layer5_service_life,
            b.exterior_wall_layer5_service_life_unit,
            b.exterior_wall_layer5_density,
            b.exterior_wall_layer5_density_unit,
            b.exterior_wall_layer0_epd1_oekobaudat_name,
            b.exterior_wall_layer0_epd1_oekobaudat_uuid,
            b.exterior_wall_layer0_epd2_oekobaudat_name,
            b.exterior_wall_layer0_epd2_oekobaudat_uuid,
            b.exterior_wall_layer1_epd1_oekobaudat_name,
            b.exterior_wall_layer1_epd1_oekobaudat_uuid,
            b.exterior_wall_layer1_epd2_oekobaudat_name,
            b.exterior_wall_layer1_epd2_oekobaudat_uuid,
            b.exterior_wall_layer2_epd1_oekobaudat_name,
            b.exterior_wall_layer2_epd1_oekobaudat_uuid,
            b.exterior_wall_layer2_epd2_oekobaudat_name,
            b.exterior_wall_layer2_epd2_oekobaudat_uuid,
            b.exterior_wall_layer3_epd1_oekobaudat_name,
            b.exterior_wall_layer3_epd1_oekobaudat_uuid,
            b.exterior_wall_layer3_epd2_oekobaudat_name,
            b.exterior_wall_layer3_epd2_oekobaudat_uuid,
            b.exterior_wall_layer4_epd1_oekobaudat_name,
            b.exterior_wall_layer4_epd1_oekobaudat_uuid,
            b.exterior_wall_layer4_epd2_oekobaudat_name,
            b.exterior_wall_layer4_epd2_oekobaudat_uuid,
            b.exterior_wall_layer5_epd1_oekobaudat_name,
            b.exterior_wall_layer5_epd1_oekobaudat_uuid,
            b.exterior_wall_layer5_epd2_oekobaudat_name,
            b.exterior_wall_layer5_epd2_oekobaudat_uuid,
            b.interior_wall_name,
            b.interior_wall_u_value_typical_min,
            b.interior_wall_u_value_typical_max,
            b.interior_wall_u_value,
            b.interior_wall_u_value_unit,
            b.interior_wall_inner_radiation,
            b.interior_wall_inner_radiation_unit,
            b.interior_wall_inner_convection,
            b.interior_wall_inner_convection_unit,
            b.interior_wall_layer0_position,
            b.interior_wall_layer0_material_id,
            b.interior_wall_layer0_material_name,
            b.interior_wall_layer0_thickness,
            b.interior_wall_layer0_thickness_unit,
            b.interior_wall_layer0_solar_absorption_rate,
            b.interior_wall_layer0_thermal_capacity,
            b.interior_wall_layer0_thermal_capacity_unit,
            b.interior_wall_layer0_thermal_conductivity,
            b.interior_wall_layer0_thermal_conductivity_unit,
            b.interior_wall_layer0_service_life,
            b.interior_wall_layer0_service_life_unit,
            b.interior_wall_layer0_density,
            b.interior_wall_layer0_density_unit,
            b.interior_wall_layer1_position,
            b.interior_wall_layer1_material_id,
            b.interior_wall_layer1_material_name,
            b.interior_wall_layer1_thickness,
            b.interior_wall_layer1_thickness_unit,
            b.interior_wall_layer1_solar_absorption_rate,
            b.interior_wall_layer1_thermal_capacity,
            b.interior_wall_layer1_thermal_capacity_unit,
            b.interior_wall_layer1_thermal_conductivity,
            b.interior_wall_layer1_thermal_conductivity_unit,
            b.interior_wall_layer1_service_life,
            b.interior_wall_layer1_service_life_unit,
            b.interior_wall_layer1_density,
            b.interior_wall_layer1_density_unit,
            b.interior_wall_layer2_position,
            b.interior_wall_layer2_material_id,
            b.interior_wall_layer2_material_name,
            b.interior_wall_layer2_thickness,
            b.interior_wall_layer2_thickness_unit,
            b.interior_wall_layer2_solar_absorption_rate,
            b.interior_wall_layer2_thermal_capacity,
            b.interior_wall_layer2_thermal_capacity_unit,
            b.interior_wall_layer2_thermal_conductivity,
            b.interior_wall_layer2_thermal_conductivity_unit,
            b.interior_wall_layer2_service_life,
            b.interior_wall_layer2_service_life_unit,
            b.interior_wall_layer2_density,
            b.interior_wall_layer2_density_unit,
            b.interior_wall_layer0_epd1_oekobaudat_name,
            b.interior_wall_layer0_epd1_oekobaudat_uuid,
            b.interior_wall_layer0_epd2_oekobaudat_name,
            b.interior_wall_layer0_epd2_oekobaudat_uuid,
            b.interior_wall_layer1_epd1_oekobaudat_name,
            b.interior_wall_layer1_epd1_oekobaudat_uuid,
            b.interior_wall_layer1_epd2_oekobaudat_name,
            b.interior_wall_layer1_epd2_oekobaudat_uuid,
            b.interior_wall_layer2_epd1_oekobaudat_name,
            b.interior_wall_layer2_epd1_oekobaudat_uuid,
            b.interior_wall_layer2_epd2_oekobaudat_name,
            b.interior_wall_layer2_epd2_oekobaudat_uuid,
            b.roof_name,
            b.roof_construction_type,
            b.roof_pitch_type,
            b.roof_u_value_typical_min,
            b.roof_u_value_typical_max,
            b.roof_u_value,
            b.roof_u_value_unit,
            b.roof_inner_radiation,
            b.roof_inner_radiation_unit,
            b.roof_outer_radiation,
            b.roof_outer_radiation_unit,
            b.roof_inner_convection,
            b.roof_inner_convection_unit,
            b.roof_outer_convection,
            b.roof_outer_convection_unit,
            b.roof_layer0_position,
            b.roof_layer0_material_id,
            b.roof_layer0_material_name,
            b.roof_layer0_thickness,
            b.roof_layer0_thickness_unit,
            b.roof_layer0_solar_absorption_rate,
            b.roof_layer0_thermal_capacity,
            b.roof_layer0_thermal_capacity_unit,
            b.roof_layer0_thermal_conductivity,
            b.roof_layer0_thermal_conductivity_unit,
            b.roof_layer0_service_life,
            b.roof_layer0_service_life_unit,
            b.roof_layer0_density,
            b.roof_layer0_density_unit,
            b.roof_layer1_position,
            b.roof_layer1_material_id,
            b.roof_layer1_material_name,
            b.roof_layer1_thickness,
            b.roof_layer1_thickness_unit,
            b.roof_layer1_solar_absorption_rate,
            b.roof_layer1_thermal_capacity,
            b.roof_layer1_thermal_capacity_unit,
            b.roof_layer1_thermal_conductivity,
            b.roof_layer1_thermal_conductivity_unit,
            b.roof_layer1_service_life,
            b.roof_layer1_service_life_unit,
            b.roof_layer1_density,
            b.roof_layer1_density_unit,
            b.roof_layer2_position,
            b.roof_layer2_material_id,
            b.roof_layer2_material_name,
            b.roof_layer2_thickness,
            b.roof_layer2_thickness_unit,
            b.roof_layer2_solar_absorption_rate,
            b.roof_layer2_thermal_capacity,
            b.roof_layer2_thermal_capacity_unit,
            b.roof_layer2_thermal_conductivity,
            b.roof_layer2_thermal_conductivity_unit,
            b.roof_layer2_service_life,
            b.roof_layer2_service_life_unit,
            b.roof_layer2_density,
            b.roof_layer2_density_unit,
            b.roof_layer3_position,
            b.roof_layer3_material_id,
            b.roof_layer3_material_name,
            b.roof_layer3_thickness,
            b.roof_layer3_thickness_unit,
            b.roof_layer3_solar_absorption_rate,
            b.roof_layer3_thermal_capacity,
            b.roof_layer3_thermal_capacity_unit,
            b.roof_layer3_thermal_conductivity,
            b.roof_layer3_thermal_conductivity_unit,
            b.roof_layer3_service_life,
            b.roof_layer3_service_life_unit,
            b.roof_layer3_density,
            b.roof_layer3_density_unit,
            b.roof_layer4_position,
            b.roof_layer4_material_id,
            b.roof_layer4_material_name,
            b.roof_layer4_thickness,
            b.roof_layer4_thickness_unit,
            b.roof_layer4_solar_absorption_rate,
            b.roof_layer4_thermal_capacity,
            b.roof_layer4_thermal_capacity_unit,
            b.roof_layer4_thermal_conductivity,
            b.roof_layer4_thermal_conductivity_unit,
            b.roof_layer4_service_life,
            b.roof_layer4_service_life_unit,
            b.roof_layer4_density,
            b.roof_layer4_density_unit,
            b.roof_layer5_position,
            b.roof_layer5_material_id,
            b.roof_layer5_material_name,
            b.roof_layer5_thickness,
            b.roof_layer5_thickness_unit,
            b.roof_layer5_solar_absorption_rate,
            b.roof_layer5_thermal_capacity,
            b.roof_layer5_thermal_capacity_unit,
            b.roof_layer5_thermal_conductivity,
            b.roof_layer5_thermal_conductivity_unit,
            b.roof_layer5_service_life,
            b.roof_layer5_service_life_unit,
            b.roof_layer5_density,
            b.roof_layer5_density_unit,
            b.roof_layer0_epd1_oekobaudat_name,
            b.roof_layer0_epd1_oekobaudat_uuid,
            b.roof_layer0_epd2_oekobaudat_name,
            b.roof_layer0_epd2_oekobaudat_uuid,
            b.roof_layer1_epd1_oekobaudat_name,
            b.roof_layer1_epd1_oekobaudat_uuid,
            b.roof_layer1_epd2_oekobaudat_name,
            b.roof_layer1_epd2_oekobaudat_uuid,
            b.roof_layer2_epd1_oekobaudat_name,
            b.roof_layer2_epd1_oekobaudat_uuid,
            b.roof_layer2_epd2_oekobaudat_name,
            b.roof_layer2_epd2_oekobaudat_uuid,
            b.roof_layer3_epd1_oekobaudat_name,
            b.roof_layer3_epd1_oekobaudat_uuid,
            b.roof_layer3_epd2_oekobaudat_name,
            b.roof_layer3_epd2_oekobaudat_uuid,
            b.roof_layer4_epd1_oekobaudat_name,
            b.roof_layer4_epd1_oekobaudat_uuid,
            b.roof_layer4_epd2_oekobaudat_name,
            b.roof_layer4_epd2_oekobaudat_uuid,
            b.roof_layer5_epd1_oekobaudat_name,
            b.roof_layer5_epd1_oekobaudat_uuid,
            b.roof_layer5_epd2_oekobaudat_name,
            b.roof_layer5_epd2_oekobaudat_uuid,
            b.foundation_name,
            b.foundation_construction_type,
            b.foundation_u_value_typical_min,
            b.foundation_u_value_typical_max,
            b.foundation_u_value,
            b.foundation_u_value_unit,
            b.foundation_inner_radiation,
            b.foundation_inner_radiation_unit,
            b.foundation_inner_convection,
            b.foundation_inner_convection_unit,
            l0."position" AS foundation_layer0_position,
            l0.building_material_id AS foundation_layer0_material_id,
            bm0.building_material_name AS foundation_layer0_material_name,
            l0.thickness AS foundation_layer0_thickness,
            u0_th.unit_name AS foundation_layer0_thickness_unit,
            bm0.solar_absorption_rate AS foundation_layer0_solar_absorption_rate,
            bm0.thermal_capacity AS foundation_layer0_thermal_capacity,
            u0_tc.unit_name AS foundation_layer0_thermal_capacity_unit,
            bm0.thermal_conductivity AS foundation_layer0_thermal_conductivity,
            u0_tco.unit_name AS foundation_layer0_thermal_conductivity_unit,
            sl0.service_life AS foundation_layer0_service_life,
            u0_sl.unit_name AS foundation_layer0_service_life_unit,
            bm0.density AS foundation_layer0_density,
            u0_d.unit_name AS foundation_layer0_density_unit,
            l1."position" AS foundation_layer1_position,
            l1.building_material_id AS foundation_layer1_material_id,
            bm1.building_material_name AS foundation_layer1_material_name,
            l1.thickness AS foundation_layer1_thickness,
            u1_th.unit_name AS foundation_layer1_thickness_unit,
            bm1.solar_absorption_rate AS foundation_layer1_solar_absorption_rate,
            bm1.thermal_capacity AS foundation_layer1_thermal_capacity,
            u1_tc.unit_name AS foundation_layer1_thermal_capacity_unit,
            bm1.thermal_conductivity AS foundation_layer1_thermal_conductivity,
            u1_tco.unit_name AS foundation_layer1_thermal_conductivity_unit,
            sl1.service_life AS foundation_layer1_service_life,
            u1_sl.unit_name AS foundation_layer1_service_life_unit,
            bm1.density AS foundation_layer1_density,
            u1_d.unit_name AS foundation_layer1_density_unit,
            l2."position" AS foundation_layer2_position,
            l2.building_material_id AS foundation_layer2_material_id,
            bm2.building_material_name AS foundation_layer2_material_name,
            l2.thickness AS foundation_layer2_thickness,
            u2_th.unit_name AS foundation_layer2_thickness_unit,
            bm2.solar_absorption_rate AS foundation_layer2_solar_absorption_rate,
            bm2.thermal_capacity AS foundation_layer2_thermal_capacity,
            u2_tc.unit_name AS foundation_layer2_thermal_capacity_unit,
            bm2.thermal_conductivity AS foundation_layer2_thermal_conductivity,
            u2_tco.unit_name AS foundation_layer2_thermal_conductivity_unit,
            sl2.service_life AS foundation_layer2_service_life,
            u2_sl.unit_name AS foundation_layer2_service_life_unit,
            bm2.density AS foundation_layer2_density,
            u2_d.unit_name AS foundation_layer2_density_unit,
            l3."position" AS foundation_layer3_position,
            l3.building_material_id AS foundation_layer3_material_id,
            bm3.building_material_name AS foundation_layer3_material_name,
            l3.thickness AS foundation_layer3_thickness,
            u3_th.unit_name AS foundation_layer3_thickness_unit,
            bm3.solar_absorption_rate AS foundation_layer3_solar_absorption_rate,
            bm3.thermal_capacity AS foundation_layer3_thermal_capacity,
            u3_tc.unit_name AS foundation_layer3_thermal_capacity_unit,
            bm3.thermal_conductivity AS foundation_layer3_thermal_conductivity,
            u3_tco.unit_name AS foundation_layer3_thermal_conductivity_unit,
            sl3.service_life AS foundation_layer3_service_life,
            u3_sl.unit_name AS foundation_layer3_service_life_unit,
            bm3.density AS foundation_layer3_density,
            u3_d.unit_name AS foundation_layer3_density_unit,
            l4."position" AS foundation_layer4_position,
            l4.building_material_id AS foundation_layer4_material_id,
            bm4.building_material_name AS foundation_layer4_material_name,
            l4.thickness AS foundation_layer4_thickness,
            u4_th.unit_name AS foundation_layer4_thickness_unit,
            bm4.solar_absorption_rate AS foundation_layer4_solar_absorption_rate,
            bm4.thermal_capacity AS foundation_layer4_thermal_capacity,
            u4_tc.unit_name AS foundation_layer4_thermal_capacity_unit,
            bm4.thermal_conductivity AS foundation_layer4_thermal_conductivity,
            u4_tco.unit_name AS foundation_layer4_thermal_conductivity_unit,
            sl4.service_life AS foundation_layer4_service_life,
            u4_sl.unit_name AS foundation_layer4_service_life_unit,
            bm4.density AS foundation_layer4_density,
            u4_d.unit_name AS foundation_layer4_density_unit,
            l5."position" AS foundation_layer5_position,
            l5.building_material_id AS foundation_layer5_material_id,
            bm5.building_material_name AS foundation_layer5_material_name,
            l5.thickness AS foundation_layer5_thickness,
            u5_th.unit_name AS foundation_layer5_thickness_unit,
            bm5.solar_absorption_rate AS foundation_layer5_solar_absorption_rate,
            bm5.thermal_capacity AS foundation_layer5_thermal_capacity,
            u5_tc.unit_name AS foundation_layer5_thermal_capacity_unit,
            bm5.thermal_conductivity AS foundation_layer5_thermal_conductivity,
            u5_tco.unit_name AS foundation_layer5_thermal_conductivity_unit,
            sl5.service_life AS foundation_layer5_service_life,
            u5_sl.unit_name AS foundation_layer5_service_life_unit,
            bm5.density AS foundation_layer5_density,
            u5_d.unit_name AS foundation_layer5_density_unit
           FROM ((((((((((((((((((((((((((((((((((((((((((((((((step_012 b
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = b.foundation_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_th ON ((u0_th.unit_id = l0.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tc ON ((u0_tc.unit_id = bm0.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tco ON ((u0_tco.unit_id = bm0.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl0 ON ((sl0.service_life_id = bm0.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_sl ON ((u0_sl.unit_id = sl0.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_d ON ((u0_d.unit_id = bm0.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = b.foundation_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_th ON ((u1_th.unit_id = l1.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tc ON ((u1_tc.unit_id = bm1.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tco ON ((u1_tco.unit_id = bm1.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl1 ON ((sl1.service_life_id = bm1.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_sl ON ((u1_sl.unit_id = sl1.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_d ON ((u1_d.unit_id = bm1.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = b.foundation_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_th ON ((u2_th.unit_id = l2.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tc ON ((u2_tc.unit_id = bm2.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tco ON ((u2_tco.unit_id = bm2.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl2 ON ((sl2.service_life_id = bm2.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_sl ON ((u2_sl.unit_id = sl2.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_d ON ((u2_d.unit_id = bm2.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l3 ON (((l3.building_element_id = b.foundation_building_element_id) AND (l3."position" = 3))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm3 ON ((bm3.building_material_id = l3.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_th ON ((u3_th.unit_id = l3.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_tc ON ((u3_tc.unit_id = bm3.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_tco ON ((u3_tco.unit_id = bm3.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl3 ON ((sl3.service_life_id = bm3.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_sl ON ((u3_sl.unit_id = sl3.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3_d ON ((u3_d.unit_id = bm3.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l4 ON (((l4.building_element_id = b.foundation_building_element_id) AND (l4."position" = 4))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm4 ON ((bm4.building_material_id = l4.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_th ON ((u4_th.unit_id = l4.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_tc ON ((u4_tc.unit_id = bm4.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_tco ON ((u4_tco.unit_id = bm4.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl4 ON ((sl4.service_life_id = bm4.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_sl ON ((u4_sl.unit_id = sl4.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4_d ON ((u4_d.unit_id = bm4.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l5 ON (((l5.building_element_id = b.foundation_building_element_id) AND (l5."position" = 5))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm5 ON ((bm5.building_material_id = l5.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_th ON ((u5_th.unit_id = l5.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_tc ON ((u5_tc.unit_id = bm5.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_tco ON ((u5_tco.unit_id = bm5.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl5 ON ((sl5.service_life_id = bm5.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_sl ON ((u5_sl.unit_id = sl5.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u5_d ON ((u5_d.unit_id = bm5.density_unit_id)))
        ), step_014 AS (
         SELECT f.building_archetype_id,
            f.building_archetype_name,
            f.share_of_building_type,
            f.share_of_building_type_in_region,
            f.share_of_building_type_in_region_mun,
            f.exterior_wall_building_element_id,
            f.interior_wall_building_element_id,
            f.roof_building_element_id,
            f.foundation_building_element_id,
            f.floor_building_element_id,
            f.window_building_element_id,
            f.energy_system_id,
            f.building_type_name,
            f.region_name,
            f.municipality_size_name,
            f.municipality_growth_name,
            f.age_class_name,
            f.building_adjacency_name,
            f.facade_to_net_leased_area_ratio_mean,
            f.facade_to_net_leased_area_ratio_se_min,
            f.facade_to_net_leased_area_ratio_se_max,
            f.roof_to_net_leased_area_ratio_mean,
            f.roof_to_net_leased_area_ratio_se_min,
            f.roof_to_net_leased_area_ratio_se_max,
            f.foundation_to_net_leased_area_ratio_mean,
            f.foundation_to_net_leased_area_ratio_se_min,
            f.foundation_to_net_leased_area_ratio_se_max,
            f.window_to_net_leased_area_ratio_mean,
            f.window_to_net_leased_area_ratio_se_min,
            f.window_to_net_leased_area_ratio_se_max,
            f.building_height_mean,
            f.building_height_se,
            f.height_unit,
            f.aspect_ratio_mean,
            f.aspect_ratio_se_min,
            f.aspect_ratio_se_max,
            f.storeys_below_ground_mean,
            f.storeys_below_ground_se,
            f.storeys_above_ground_mean,
            f.storeys_above_ground_se,
            f.storeys_above_ground_se_min,
            f.storeys_above_ground_se_max,
            f.storey_height_mean,
            f.storey_height_se_min,
            f.storey_height_se_max,
            f.window_share,
            f.net_leased_area_mean,
            f.net_leased_area_se,
            f.net_leased_area_se_min,
            f.net_leased_area_se_max,
            f.net_leased_area_unit,
            f.facade_area_north_mean,
            f.facade_area_north_se,
            f.facade_area_east_mean,
            f.facade_area_east_se,
            f.facade_area_south_mean,
            f.facade_area_south_se,
            f.facade_area_west_mean,
            f.facade_area_west_se,
            f.facade_area_unit,
            f.facade_length_north_mean,
            f.facade_length_north_se,
            f.facade_length_east_mean,
            f.facade_length_east_se,
            f.facade_length_south_mean,
            f.facade_length_south_se,
            f.facade_length_west_mean,
            f.facade_length_west_se,
            f.facade_length_unit,
            f.exterior_wall_name,
            f.exterior_wall_construction_type,
            f.exterior_wall_u_value_typical_min,
            f.exterior_wall_u_value_typical_max,
            f.exterior_wall_u_value,
            f.exterior_wall_u_value_unit,
            f.exterior_wall_inner_radiation,
            f.exterior_wall_inner_radiation_unit,
            f.exterior_wall_outer_radiation,
            f.exterior_wall_outer_radiation_unit,
            f.exterior_wall_inner_convection,
            f.exterior_wall_inner_convection_unit,
            f.exterior_wall_outer_convection,
            f.exterior_wall_outer_convection_unit,
            f.exterior_wall_layer0_position,
            f.exterior_wall_layer0_material_id,
            f.exterior_wall_layer0_material_name,
            f.exterior_wall_layer0_thickness,
            f.exterior_wall_layer0_thickness_unit,
            f.exterior_wall_layer0_solar_absorption_rate,
            f.exterior_wall_layer0_thermal_capacity,
            f.exterior_wall_layer0_thermal_capacity_unit,
            f.exterior_wall_layer0_thermal_conductivity,
            f.exterior_wall_layer0_thermal_conductivity_unit,
            f.exterior_wall_layer0_service_life,
            f.exterior_wall_layer0_service_life_unit,
            f.exterior_wall_layer0_density,
            f.exterior_wall_layer0_density_unit,
            f.exterior_wall_layer1_position,
            f.exterior_wall_layer1_material_id,
            f.exterior_wall_layer1_material_name,
            f.exterior_wall_layer1_thickness,
            f.exterior_wall_layer1_thickness_unit,
            f.exterior_wall_layer1_solar_absorption_rate,
            f.exterior_wall_layer1_thermal_capacity,
            f.exterior_wall_layer1_thermal_capacity_unit,
            f.exterior_wall_layer1_thermal_conductivity,
            f.exterior_wall_layer1_thermal_conductivity_unit,
            f.exterior_wall_layer1_service_life,
            f.exterior_wall_layer1_service_life_unit,
            f.exterior_wall_layer1_density,
            f.exterior_wall_layer1_density_unit,
            f.exterior_wall_layer2_position,
            f.exterior_wall_layer2_material_id,
            f.exterior_wall_layer2_material_name,
            f.exterior_wall_layer2_thickness,
            f.exterior_wall_layer2_thickness_unit,
            f.exterior_wall_layer2_solar_absorption_rate,
            f.exterior_wall_layer2_thermal_capacity,
            f.exterior_wall_layer2_thermal_capacity_unit,
            f.exterior_wall_layer2_thermal_conductivity,
            f.exterior_wall_layer2_thermal_conductivity_unit,
            f.exterior_wall_layer2_service_life,
            f.exterior_wall_layer2_service_life_unit,
            f.exterior_wall_layer2_density,
            f.exterior_wall_layer2_density_unit,
            f.exterior_wall_layer3_position,
            f.exterior_wall_layer3_material_id,
            f.exterior_wall_layer3_material_name,
            f.exterior_wall_layer3_thickness,
            f.exterior_wall_layer3_thickness_unit,
            f.exterior_wall_layer3_solar_absorption_rate,
            f.exterior_wall_layer3_thermal_capacity,
            f.exterior_wall_layer3_thermal_capacity_unit,
            f.exterior_wall_layer3_thermal_conductivity,
            f.exterior_wall_layer3_thermal_conductivity_unit,
            f.exterior_wall_layer3_service_life,
            f.exterior_wall_layer3_service_life_unit,
            f.exterior_wall_layer3_density,
            f.exterior_wall_layer3_density_unit,
            f.exterior_wall_layer4_position,
            f.exterior_wall_layer4_material_id,
            f.exterior_wall_layer4_material_name,
            f.exterior_wall_layer4_thickness,
            f.exterior_wall_layer4_thickness_unit,
            f.exterior_wall_layer4_solar_absorption_rate,
            f.exterior_wall_layer4_thermal_capacity,
            f.exterior_wall_layer4_thermal_capacity_unit,
            f.exterior_wall_layer4_thermal_conductivity,
            f.exterior_wall_layer4_thermal_conductivity_unit,
            f.exterior_wall_layer4_service_life,
            f.exterior_wall_layer4_service_life_unit,
            f.exterior_wall_layer4_density,
            f.exterior_wall_layer4_density_unit,
            f.exterior_wall_layer5_position,
            f.exterior_wall_layer5_material_id,
            f.exterior_wall_layer5_material_name,
            f.exterior_wall_layer5_thickness,
            f.exterior_wall_layer5_thickness_unit,
            f.exterior_wall_layer5_solar_absorption_rate,
            f.exterior_wall_layer5_thermal_capacity,
            f.exterior_wall_layer5_thermal_capacity_unit,
            f.exterior_wall_layer5_thermal_conductivity,
            f.exterior_wall_layer5_thermal_conductivity_unit,
            f.exterior_wall_layer5_service_life,
            f.exterior_wall_layer5_service_life_unit,
            f.exterior_wall_layer5_density,
            f.exterior_wall_layer5_density_unit,
            f.exterior_wall_layer0_epd1_oekobaudat_name,
            f.exterior_wall_layer0_epd1_oekobaudat_uuid,
            f.exterior_wall_layer0_epd2_oekobaudat_name,
            f.exterior_wall_layer0_epd2_oekobaudat_uuid,
            f.exterior_wall_layer1_epd1_oekobaudat_name,
            f.exterior_wall_layer1_epd1_oekobaudat_uuid,
            f.exterior_wall_layer1_epd2_oekobaudat_name,
            f.exterior_wall_layer1_epd2_oekobaudat_uuid,
            f.exterior_wall_layer2_epd1_oekobaudat_name,
            f.exterior_wall_layer2_epd1_oekobaudat_uuid,
            f.exterior_wall_layer2_epd2_oekobaudat_name,
            f.exterior_wall_layer2_epd2_oekobaudat_uuid,
            f.exterior_wall_layer3_epd1_oekobaudat_name,
            f.exterior_wall_layer3_epd1_oekobaudat_uuid,
            f.exterior_wall_layer3_epd2_oekobaudat_name,
            f.exterior_wall_layer3_epd2_oekobaudat_uuid,
            f.exterior_wall_layer4_epd1_oekobaudat_name,
            f.exterior_wall_layer4_epd1_oekobaudat_uuid,
            f.exterior_wall_layer4_epd2_oekobaudat_name,
            f.exterior_wall_layer4_epd2_oekobaudat_uuid,
            f.exterior_wall_layer5_epd1_oekobaudat_name,
            f.exterior_wall_layer5_epd1_oekobaudat_uuid,
            f.exterior_wall_layer5_epd2_oekobaudat_name,
            f.exterior_wall_layer5_epd2_oekobaudat_uuid,
            f.interior_wall_name,
            f.interior_wall_u_value_typical_min,
            f.interior_wall_u_value_typical_max,
            f.interior_wall_u_value,
            f.interior_wall_u_value_unit,
            f.interior_wall_inner_radiation,
            f.interior_wall_inner_radiation_unit,
            f.interior_wall_inner_convection,
            f.interior_wall_inner_convection_unit,
            f.interior_wall_layer0_position,
            f.interior_wall_layer0_material_id,
            f.interior_wall_layer0_material_name,
            f.interior_wall_layer0_thickness,
            f.interior_wall_layer0_thickness_unit,
            f.interior_wall_layer0_solar_absorption_rate,
            f.interior_wall_layer0_thermal_capacity,
            f.interior_wall_layer0_thermal_capacity_unit,
            f.interior_wall_layer0_thermal_conductivity,
            f.interior_wall_layer0_thermal_conductivity_unit,
            f.interior_wall_layer0_service_life,
            f.interior_wall_layer0_service_life_unit,
            f.interior_wall_layer0_density,
            f.interior_wall_layer0_density_unit,
            f.interior_wall_layer1_position,
            f.interior_wall_layer1_material_id,
            f.interior_wall_layer1_material_name,
            f.interior_wall_layer1_thickness,
            f.interior_wall_layer1_thickness_unit,
            f.interior_wall_layer1_solar_absorption_rate,
            f.interior_wall_layer1_thermal_capacity,
            f.interior_wall_layer1_thermal_capacity_unit,
            f.interior_wall_layer1_thermal_conductivity,
            f.interior_wall_layer1_thermal_conductivity_unit,
            f.interior_wall_layer1_service_life,
            f.interior_wall_layer1_service_life_unit,
            f.interior_wall_layer1_density,
            f.interior_wall_layer1_density_unit,
            f.interior_wall_layer2_position,
            f.interior_wall_layer2_material_id,
            f.interior_wall_layer2_material_name,
            f.interior_wall_layer2_thickness,
            f.interior_wall_layer2_thickness_unit,
            f.interior_wall_layer2_solar_absorption_rate,
            f.interior_wall_layer2_thermal_capacity,
            f.interior_wall_layer2_thermal_capacity_unit,
            f.interior_wall_layer2_thermal_conductivity,
            f.interior_wall_layer2_thermal_conductivity_unit,
            f.interior_wall_layer2_service_life,
            f.interior_wall_layer2_service_life_unit,
            f.interior_wall_layer2_density,
            f.interior_wall_layer2_density_unit,
            f.interior_wall_layer0_epd1_oekobaudat_name,
            f.interior_wall_layer0_epd1_oekobaudat_uuid,
            f.interior_wall_layer0_epd2_oekobaudat_name,
            f.interior_wall_layer0_epd2_oekobaudat_uuid,
            f.interior_wall_layer1_epd1_oekobaudat_name,
            f.interior_wall_layer1_epd1_oekobaudat_uuid,
            f.interior_wall_layer1_epd2_oekobaudat_name,
            f.interior_wall_layer1_epd2_oekobaudat_uuid,
            f.interior_wall_layer2_epd1_oekobaudat_name,
            f.interior_wall_layer2_epd1_oekobaudat_uuid,
            f.interior_wall_layer2_epd2_oekobaudat_name,
            f.interior_wall_layer2_epd2_oekobaudat_uuid,
            f.roof_name,
            f.roof_construction_type,
            f.roof_pitch_type,
            f.roof_u_value_typical_min,
            f.roof_u_value_typical_max,
            f.roof_u_value,
            f.roof_u_value_unit,
            f.roof_inner_radiation,
            f.roof_inner_radiation_unit,
            f.roof_outer_radiation,
            f.roof_outer_radiation_unit,
            f.roof_inner_convection,
            f.roof_inner_convection_unit,
            f.roof_outer_convection,
            f.roof_outer_convection_unit,
            f.roof_layer0_position,
            f.roof_layer0_material_id,
            f.roof_layer0_material_name,
            f.roof_layer0_thickness,
            f.roof_layer0_thickness_unit,
            f.roof_layer0_solar_absorption_rate,
            f.roof_layer0_thermal_capacity,
            f.roof_layer0_thermal_capacity_unit,
            f.roof_layer0_thermal_conductivity,
            f.roof_layer0_thermal_conductivity_unit,
            f.roof_layer0_service_life,
            f.roof_layer0_service_life_unit,
            f.roof_layer0_density,
            f.roof_layer0_density_unit,
            f.roof_layer1_position,
            f.roof_layer1_material_id,
            f.roof_layer1_material_name,
            f.roof_layer1_thickness,
            f.roof_layer1_thickness_unit,
            f.roof_layer1_solar_absorption_rate,
            f.roof_layer1_thermal_capacity,
            f.roof_layer1_thermal_capacity_unit,
            f.roof_layer1_thermal_conductivity,
            f.roof_layer1_thermal_conductivity_unit,
            f.roof_layer1_service_life,
            f.roof_layer1_service_life_unit,
            f.roof_layer1_density,
            f.roof_layer1_density_unit,
            f.roof_layer2_position,
            f.roof_layer2_material_id,
            f.roof_layer2_material_name,
            f.roof_layer2_thickness,
            f.roof_layer2_thickness_unit,
            f.roof_layer2_solar_absorption_rate,
            f.roof_layer2_thermal_capacity,
            f.roof_layer2_thermal_capacity_unit,
            f.roof_layer2_thermal_conductivity,
            f.roof_layer2_thermal_conductivity_unit,
            f.roof_layer2_service_life,
            f.roof_layer2_service_life_unit,
            f.roof_layer2_density,
            f.roof_layer2_density_unit,
            f.roof_layer3_position,
            f.roof_layer3_material_id,
            f.roof_layer3_material_name,
            f.roof_layer3_thickness,
            f.roof_layer3_thickness_unit,
            f.roof_layer3_solar_absorption_rate,
            f.roof_layer3_thermal_capacity,
            f.roof_layer3_thermal_capacity_unit,
            f.roof_layer3_thermal_conductivity,
            f.roof_layer3_thermal_conductivity_unit,
            f.roof_layer3_service_life,
            f.roof_layer3_service_life_unit,
            f.roof_layer3_density,
            f.roof_layer3_density_unit,
            f.roof_layer4_position,
            f.roof_layer4_material_id,
            f.roof_layer4_material_name,
            f.roof_layer4_thickness,
            f.roof_layer4_thickness_unit,
            f.roof_layer4_solar_absorption_rate,
            f.roof_layer4_thermal_capacity,
            f.roof_layer4_thermal_capacity_unit,
            f.roof_layer4_thermal_conductivity,
            f.roof_layer4_thermal_conductivity_unit,
            f.roof_layer4_service_life,
            f.roof_layer4_service_life_unit,
            f.roof_layer4_density,
            f.roof_layer4_density_unit,
            f.roof_layer5_position,
            f.roof_layer5_material_id,
            f.roof_layer5_material_name,
            f.roof_layer5_thickness,
            f.roof_layer5_thickness_unit,
            f.roof_layer5_solar_absorption_rate,
            f.roof_layer5_thermal_capacity,
            f.roof_layer5_thermal_capacity_unit,
            f.roof_layer5_thermal_conductivity,
            f.roof_layer5_thermal_conductivity_unit,
            f.roof_layer5_service_life,
            f.roof_layer5_service_life_unit,
            f.roof_layer5_density,
            f.roof_layer5_density_unit,
            f.roof_layer0_epd1_oekobaudat_name,
            f.roof_layer0_epd1_oekobaudat_uuid,
            f.roof_layer0_epd2_oekobaudat_name,
            f.roof_layer0_epd2_oekobaudat_uuid,
            f.roof_layer1_epd1_oekobaudat_name,
            f.roof_layer1_epd1_oekobaudat_uuid,
            f.roof_layer1_epd2_oekobaudat_name,
            f.roof_layer1_epd2_oekobaudat_uuid,
            f.roof_layer2_epd1_oekobaudat_name,
            f.roof_layer2_epd1_oekobaudat_uuid,
            f.roof_layer2_epd2_oekobaudat_name,
            f.roof_layer2_epd2_oekobaudat_uuid,
            f.roof_layer3_epd1_oekobaudat_name,
            f.roof_layer3_epd1_oekobaudat_uuid,
            f.roof_layer3_epd2_oekobaudat_name,
            f.roof_layer3_epd2_oekobaudat_uuid,
            f.roof_layer4_epd1_oekobaudat_name,
            f.roof_layer4_epd1_oekobaudat_uuid,
            f.roof_layer4_epd2_oekobaudat_name,
            f.roof_layer4_epd2_oekobaudat_uuid,
            f.roof_layer5_epd1_oekobaudat_name,
            f.roof_layer5_epd1_oekobaudat_uuid,
            f.roof_layer5_epd2_oekobaudat_name,
            f.roof_layer5_epd2_oekobaudat_uuid,
            f.foundation_name,
            f.foundation_construction_type,
            f.foundation_u_value_typical_min,
            f.foundation_u_value_typical_max,
            f.foundation_u_value,
            f.foundation_u_value_unit,
            f.foundation_inner_radiation,
            f.foundation_inner_radiation_unit,
            f.foundation_inner_convection,
            f.foundation_inner_convection_unit,
            f.foundation_layer0_position,
            f.foundation_layer0_material_id,
            f.foundation_layer0_material_name,
            f.foundation_layer0_thickness,
            f.foundation_layer0_thickness_unit,
            f.foundation_layer0_solar_absorption_rate,
            f.foundation_layer0_thermal_capacity,
            f.foundation_layer0_thermal_capacity_unit,
            f.foundation_layer0_thermal_conductivity,
            f.foundation_layer0_thermal_conductivity_unit,
            f.foundation_layer0_service_life,
            f.foundation_layer0_service_life_unit,
            f.foundation_layer0_density,
            f.foundation_layer0_density_unit,
            f.foundation_layer1_position,
            f.foundation_layer1_material_id,
            f.foundation_layer1_material_name,
            f.foundation_layer1_thickness,
            f.foundation_layer1_thickness_unit,
            f.foundation_layer1_solar_absorption_rate,
            f.foundation_layer1_thermal_capacity,
            f.foundation_layer1_thermal_capacity_unit,
            f.foundation_layer1_thermal_conductivity,
            f.foundation_layer1_thermal_conductivity_unit,
            f.foundation_layer1_service_life,
            f.foundation_layer1_service_life_unit,
            f.foundation_layer1_density,
            f.foundation_layer1_density_unit,
            f.foundation_layer2_position,
            f.foundation_layer2_material_id,
            f.foundation_layer2_material_name,
            f.foundation_layer2_thickness,
            f.foundation_layer2_thickness_unit,
            f.foundation_layer2_solar_absorption_rate,
            f.foundation_layer2_thermal_capacity,
            f.foundation_layer2_thermal_capacity_unit,
            f.foundation_layer2_thermal_conductivity,
            f.foundation_layer2_thermal_conductivity_unit,
            f.foundation_layer2_service_life,
            f.foundation_layer2_service_life_unit,
            f.foundation_layer2_density,
            f.foundation_layer2_density_unit,
            f.foundation_layer3_position,
            f.foundation_layer3_material_id,
            f.foundation_layer3_material_name,
            f.foundation_layer3_thickness,
            f.foundation_layer3_thickness_unit,
            f.foundation_layer3_solar_absorption_rate,
            f.foundation_layer3_thermal_capacity,
            f.foundation_layer3_thermal_capacity_unit,
            f.foundation_layer3_thermal_conductivity,
            f.foundation_layer3_thermal_conductivity_unit,
            f.foundation_layer3_service_life,
            f.foundation_layer3_service_life_unit,
            f.foundation_layer3_density,
            f.foundation_layer3_density_unit,
            f.foundation_layer4_position,
            f.foundation_layer4_material_id,
            f.foundation_layer4_material_name,
            f.foundation_layer4_thickness,
            f.foundation_layer4_thickness_unit,
            f.foundation_layer4_solar_absorption_rate,
            f.foundation_layer4_thermal_capacity,
            f.foundation_layer4_thermal_capacity_unit,
            f.foundation_layer4_thermal_conductivity,
            f.foundation_layer4_thermal_conductivity_unit,
            f.foundation_layer4_service_life,
            f.foundation_layer4_service_life_unit,
            f.foundation_layer4_density,
            f.foundation_layer4_density_unit,
            f.foundation_layer5_position,
            f.foundation_layer5_material_id,
            f.foundation_layer5_material_name,
            f.foundation_layer5_thickness,
            f.foundation_layer5_thickness_unit,
            f.foundation_layer5_solar_absorption_rate,
            f.foundation_layer5_thermal_capacity,
            f.foundation_layer5_thermal_capacity_unit,
            f.foundation_layer5_thermal_conductivity,
            f.foundation_layer5_thermal_conductivity_unit,
            f.foundation_layer5_service_life,
            f.foundation_layer5_service_life_unit,
            f.foundation_layer5_density,
            f.foundation_layer5_density_unit,
            epd0_1.environmental_product_declaration_name AS foundation_layer0_epd1_oekobaudat_name,
            epd0_1.database_uuid AS foundation_layer0_epd1_oekobaudat_uuid,
            epd0_2.environmental_product_declaration_name AS foundation_layer0_epd2_oekobaudat_name,
            epd0_2.database_uuid AS foundation_layer0_epd2_oekobaudat_uuid,
            epd1_1.environmental_product_declaration_name AS foundation_layer1_epd1_oekobaudat_name,
            epd1_1.database_uuid AS foundation_layer1_epd1_oekobaudat_uuid,
            epd1_2.environmental_product_declaration_name AS foundation_layer1_epd2_oekobaudat_name,
            epd1_2.database_uuid AS foundation_layer1_epd2_oekobaudat_uuid,
            epd2_1.environmental_product_declaration_name AS foundation_layer2_epd1_oekobaudat_name,
            epd2_1.database_uuid AS foundation_layer2_epd1_oekobaudat_uuid,
            epd2_2.environmental_product_declaration_name AS foundation_layer2_epd2_oekobaudat_name,
            epd2_2.database_uuid AS foundation_layer2_epd2_oekobaudat_uuid,
            epd3_1.environmental_product_declaration_name AS foundation_layer3_epd1_oekobaudat_name,
            epd3_1.database_uuid AS foundation_layer3_epd1_oekobaudat_uuid,
            epd3_2.environmental_product_declaration_name AS foundation_layer3_epd2_oekobaudat_name,
            epd3_2.database_uuid AS foundation_layer3_epd2_oekobaudat_uuid,
            epd4_1.environmental_product_declaration_name AS foundation_layer4_epd1_oekobaudat_name,
            epd4_1.database_uuid AS foundation_layer4_epd1_oekobaudat_uuid,
            epd4_2.environmental_product_declaration_name AS foundation_layer4_epd2_oekobaudat_name,
            epd4_2.database_uuid AS foundation_layer4_epd2_oekobaudat_uuid,
            epd5_1.environmental_product_declaration_name AS foundation_layer5_epd1_oekobaudat_name,
            epd5_1.database_uuid AS foundation_layer5_epd1_oekobaudat_uuid,
            epd5_2.environmental_product_declaration_name AS foundation_layer5_epd2_oekobaudat_name,
            epd5_2.database_uuid AS foundation_layer5_epd2_oekobaudat_uuid
           FROM ((((((((((((((((((((((((step_013 f
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = f.foundation_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_1 ON ((epd0_1.environmental_product_declaration_id = bm0.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_2 ON ((epd0_2.environmental_product_declaration_id = bm0.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = f.foundation_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_1 ON ((epd1_1.environmental_product_declaration_id = bm1.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_2 ON ((epd1_2.environmental_product_declaration_id = bm1.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = f.foundation_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_1 ON ((epd2_1.environmental_product_declaration_id = bm2.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_2 ON ((epd2_2.environmental_product_declaration_id = bm2.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l3 ON (((l3.building_element_id = f.foundation_building_element_id) AND (l3."position" = 3))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm3 ON ((bm3.building_material_id = l3.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd3_1 ON ((epd3_1.environmental_product_declaration_id = bm3.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd3_2 ON ((epd3_2.environmental_product_declaration_id = bm3.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l4 ON (((l4.building_element_id = f.foundation_building_element_id) AND (l4."position" = 4))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm4 ON ((bm4.building_material_id = l4.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd4_1 ON ((epd4_1.environmental_product_declaration_id = bm4.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd4_2 ON ((epd4_2.environmental_product_declaration_id = bm4.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l5 ON (((l5.building_element_id = f.foundation_building_element_id) AND (l5."position" = 5))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm5 ON ((bm5.building_material_id = l5.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd5_1 ON ((epd5_1.environmental_product_declaration_id = bm5.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd5_2 ON ((epd5_2.environmental_product_declaration_id = bm5.environmental_product_declaration_id_2)))
        ), step_015 AS (
         SELECT v.building_archetype_id,
            v.building_archetype_name,
            v.share_of_building_type,
            v.share_of_building_type_in_region,
            v.share_of_building_type_in_region_mun,
            v.exterior_wall_building_element_id,
            v.interior_wall_building_element_id,
            v.roof_building_element_id,
            v.foundation_building_element_id,
            v.floor_building_element_id,
            v.window_building_element_id,
            v.energy_system_id,
            v.building_type_name,
            v.region_name,
            v.municipality_size_name,
            v.municipality_growth_name,
            v.age_class_name,
            v.building_adjacency_name,
            v.facade_to_net_leased_area_ratio_mean,
            v.facade_to_net_leased_area_ratio_se_min,
            v.facade_to_net_leased_area_ratio_se_max,
            v.roof_to_net_leased_area_ratio_mean,
            v.roof_to_net_leased_area_ratio_se_min,
            v.roof_to_net_leased_area_ratio_se_max,
            v.foundation_to_net_leased_area_ratio_mean,
            v.foundation_to_net_leased_area_ratio_se_min,
            v.foundation_to_net_leased_area_ratio_se_max,
            v.window_to_net_leased_area_ratio_mean,
            v.window_to_net_leased_area_ratio_se_min,
            v.window_to_net_leased_area_ratio_se_max,
            v.building_height_mean,
            v.building_height_se,
            v.height_unit,
            v.aspect_ratio_mean,
            v.aspect_ratio_se_min,
            v.aspect_ratio_se_max,
            v.storeys_below_ground_mean,
            v.storeys_below_ground_se,
            v.storeys_above_ground_mean,
            v.storeys_above_ground_se,
            v.storeys_above_ground_se_min,
            v.storeys_above_ground_se_max,
            v.storey_height_mean,
            v.storey_height_se_min,
            v.storey_height_se_max,
            v.window_share,
            v.net_leased_area_mean,
            v.net_leased_area_se,
            v.net_leased_area_se_min,
            v.net_leased_area_se_max,
            v.net_leased_area_unit,
            v.facade_area_north_mean,
            v.facade_area_north_se,
            v.facade_area_east_mean,
            v.facade_area_east_se,
            v.facade_area_south_mean,
            v.facade_area_south_se,
            v.facade_area_west_mean,
            v.facade_area_west_se,
            v.facade_area_unit,
            v.facade_length_north_mean,
            v.facade_length_north_se,
            v.facade_length_east_mean,
            v.facade_length_east_se,
            v.facade_length_south_mean,
            v.facade_length_south_se,
            v.facade_length_west_mean,
            v.facade_length_west_se,
            v.facade_length_unit,
            v.exterior_wall_name,
            v.exterior_wall_construction_type,
            v.exterior_wall_u_value_typical_min,
            v.exterior_wall_u_value_typical_max,
            v.exterior_wall_u_value,
            v.exterior_wall_u_value_unit,
            v.exterior_wall_inner_radiation,
            v.exterior_wall_inner_radiation_unit,
            v.exterior_wall_outer_radiation,
            v.exterior_wall_outer_radiation_unit,
            v.exterior_wall_inner_convection,
            v.exterior_wall_inner_convection_unit,
            v.exterior_wall_outer_convection,
            v.exterior_wall_outer_convection_unit,
            v.exterior_wall_layer0_position,
            v.exterior_wall_layer0_material_id,
            v.exterior_wall_layer0_material_name,
            v.exterior_wall_layer0_thickness,
            v.exterior_wall_layer0_thickness_unit,
            v.exterior_wall_layer0_solar_absorption_rate,
            v.exterior_wall_layer0_thermal_capacity,
            v.exterior_wall_layer0_thermal_capacity_unit,
            v.exterior_wall_layer0_thermal_conductivity,
            v.exterior_wall_layer0_thermal_conductivity_unit,
            v.exterior_wall_layer0_service_life,
            v.exterior_wall_layer0_service_life_unit,
            v.exterior_wall_layer0_density,
            v.exterior_wall_layer0_density_unit,
            v.exterior_wall_layer1_position,
            v.exterior_wall_layer1_material_id,
            v.exterior_wall_layer1_material_name,
            v.exterior_wall_layer1_thickness,
            v.exterior_wall_layer1_thickness_unit,
            v.exterior_wall_layer1_solar_absorption_rate,
            v.exterior_wall_layer1_thermal_capacity,
            v.exterior_wall_layer1_thermal_capacity_unit,
            v.exterior_wall_layer1_thermal_conductivity,
            v.exterior_wall_layer1_thermal_conductivity_unit,
            v.exterior_wall_layer1_service_life,
            v.exterior_wall_layer1_service_life_unit,
            v.exterior_wall_layer1_density,
            v.exterior_wall_layer1_density_unit,
            v.exterior_wall_layer2_position,
            v.exterior_wall_layer2_material_id,
            v.exterior_wall_layer2_material_name,
            v.exterior_wall_layer2_thickness,
            v.exterior_wall_layer2_thickness_unit,
            v.exterior_wall_layer2_solar_absorption_rate,
            v.exterior_wall_layer2_thermal_capacity,
            v.exterior_wall_layer2_thermal_capacity_unit,
            v.exterior_wall_layer2_thermal_conductivity,
            v.exterior_wall_layer2_thermal_conductivity_unit,
            v.exterior_wall_layer2_service_life,
            v.exterior_wall_layer2_service_life_unit,
            v.exterior_wall_layer2_density,
            v.exterior_wall_layer2_density_unit,
            v.exterior_wall_layer3_position,
            v.exterior_wall_layer3_material_id,
            v.exterior_wall_layer3_material_name,
            v.exterior_wall_layer3_thickness,
            v.exterior_wall_layer3_thickness_unit,
            v.exterior_wall_layer3_solar_absorption_rate,
            v.exterior_wall_layer3_thermal_capacity,
            v.exterior_wall_layer3_thermal_capacity_unit,
            v.exterior_wall_layer3_thermal_conductivity,
            v.exterior_wall_layer3_thermal_conductivity_unit,
            v.exterior_wall_layer3_service_life,
            v.exterior_wall_layer3_service_life_unit,
            v.exterior_wall_layer3_density,
            v.exterior_wall_layer3_density_unit,
            v.exterior_wall_layer4_position,
            v.exterior_wall_layer4_material_id,
            v.exterior_wall_layer4_material_name,
            v.exterior_wall_layer4_thickness,
            v.exterior_wall_layer4_thickness_unit,
            v.exterior_wall_layer4_solar_absorption_rate,
            v.exterior_wall_layer4_thermal_capacity,
            v.exterior_wall_layer4_thermal_capacity_unit,
            v.exterior_wall_layer4_thermal_conductivity,
            v.exterior_wall_layer4_thermal_conductivity_unit,
            v.exterior_wall_layer4_service_life,
            v.exterior_wall_layer4_service_life_unit,
            v.exterior_wall_layer4_density,
            v.exterior_wall_layer4_density_unit,
            v.exterior_wall_layer5_position,
            v.exterior_wall_layer5_material_id,
            v.exterior_wall_layer5_material_name,
            v.exterior_wall_layer5_thickness,
            v.exterior_wall_layer5_thickness_unit,
            v.exterior_wall_layer5_solar_absorption_rate,
            v.exterior_wall_layer5_thermal_capacity,
            v.exterior_wall_layer5_thermal_capacity_unit,
            v.exterior_wall_layer5_thermal_conductivity,
            v.exterior_wall_layer5_thermal_conductivity_unit,
            v.exterior_wall_layer5_service_life,
            v.exterior_wall_layer5_service_life_unit,
            v.exterior_wall_layer5_density,
            v.exterior_wall_layer5_density_unit,
            v.exterior_wall_layer0_epd1_oekobaudat_name,
            v.exterior_wall_layer0_epd1_oekobaudat_uuid,
            v.exterior_wall_layer0_epd2_oekobaudat_name,
            v.exterior_wall_layer0_epd2_oekobaudat_uuid,
            v.exterior_wall_layer1_epd1_oekobaudat_name,
            v.exterior_wall_layer1_epd1_oekobaudat_uuid,
            v.exterior_wall_layer1_epd2_oekobaudat_name,
            v.exterior_wall_layer1_epd2_oekobaudat_uuid,
            v.exterior_wall_layer2_epd1_oekobaudat_name,
            v.exterior_wall_layer2_epd1_oekobaudat_uuid,
            v.exterior_wall_layer2_epd2_oekobaudat_name,
            v.exterior_wall_layer2_epd2_oekobaudat_uuid,
            v.exterior_wall_layer3_epd1_oekobaudat_name,
            v.exterior_wall_layer3_epd1_oekobaudat_uuid,
            v.exterior_wall_layer3_epd2_oekobaudat_name,
            v.exterior_wall_layer3_epd2_oekobaudat_uuid,
            v.exterior_wall_layer4_epd1_oekobaudat_name,
            v.exterior_wall_layer4_epd1_oekobaudat_uuid,
            v.exterior_wall_layer4_epd2_oekobaudat_name,
            v.exterior_wall_layer4_epd2_oekobaudat_uuid,
            v.exterior_wall_layer5_epd1_oekobaudat_name,
            v.exterior_wall_layer5_epd1_oekobaudat_uuid,
            v.exterior_wall_layer5_epd2_oekobaudat_name,
            v.exterior_wall_layer5_epd2_oekobaudat_uuid,
            v.interior_wall_name,
            v.interior_wall_u_value_typical_min,
            v.interior_wall_u_value_typical_max,
            v.interior_wall_u_value,
            v.interior_wall_u_value_unit,
            v.interior_wall_inner_radiation,
            v.interior_wall_inner_radiation_unit,
            v.interior_wall_inner_convection,
            v.interior_wall_inner_convection_unit,
            v.interior_wall_layer0_position,
            v.interior_wall_layer0_material_id,
            v.interior_wall_layer0_material_name,
            v.interior_wall_layer0_thickness,
            v.interior_wall_layer0_thickness_unit,
            v.interior_wall_layer0_solar_absorption_rate,
            v.interior_wall_layer0_thermal_capacity,
            v.interior_wall_layer0_thermal_capacity_unit,
            v.interior_wall_layer0_thermal_conductivity,
            v.interior_wall_layer0_thermal_conductivity_unit,
            v.interior_wall_layer0_service_life,
            v.interior_wall_layer0_service_life_unit,
            v.interior_wall_layer0_density,
            v.interior_wall_layer0_density_unit,
            v.interior_wall_layer1_position,
            v.interior_wall_layer1_material_id,
            v.interior_wall_layer1_material_name,
            v.interior_wall_layer1_thickness,
            v.interior_wall_layer1_thickness_unit,
            v.interior_wall_layer1_solar_absorption_rate,
            v.interior_wall_layer1_thermal_capacity,
            v.interior_wall_layer1_thermal_capacity_unit,
            v.interior_wall_layer1_thermal_conductivity,
            v.interior_wall_layer1_thermal_conductivity_unit,
            v.interior_wall_layer1_service_life,
            v.interior_wall_layer1_service_life_unit,
            v.interior_wall_layer1_density,
            v.interior_wall_layer1_density_unit,
            v.interior_wall_layer2_position,
            v.interior_wall_layer2_material_id,
            v.interior_wall_layer2_material_name,
            v.interior_wall_layer2_thickness,
            v.interior_wall_layer2_thickness_unit,
            v.interior_wall_layer2_solar_absorption_rate,
            v.interior_wall_layer2_thermal_capacity,
            v.interior_wall_layer2_thermal_capacity_unit,
            v.interior_wall_layer2_thermal_conductivity,
            v.interior_wall_layer2_thermal_conductivity_unit,
            v.interior_wall_layer2_service_life,
            v.interior_wall_layer2_service_life_unit,
            v.interior_wall_layer2_density,
            v.interior_wall_layer2_density_unit,
            v.interior_wall_layer0_epd1_oekobaudat_name,
            v.interior_wall_layer0_epd1_oekobaudat_uuid,
            v.interior_wall_layer0_epd2_oekobaudat_name,
            v.interior_wall_layer0_epd2_oekobaudat_uuid,
            v.interior_wall_layer1_epd1_oekobaudat_name,
            v.interior_wall_layer1_epd1_oekobaudat_uuid,
            v.interior_wall_layer1_epd2_oekobaudat_name,
            v.interior_wall_layer1_epd2_oekobaudat_uuid,
            v.interior_wall_layer2_epd1_oekobaudat_name,
            v.interior_wall_layer2_epd1_oekobaudat_uuid,
            v.interior_wall_layer2_epd2_oekobaudat_name,
            v.interior_wall_layer2_epd2_oekobaudat_uuid,
            v.roof_name,
            v.roof_construction_type,
            v.roof_pitch_type,
            v.roof_u_value_typical_min,
            v.roof_u_value_typical_max,
            v.roof_u_value,
            v.roof_u_value_unit,
            v.roof_inner_radiation,
            v.roof_inner_radiation_unit,
            v.roof_outer_radiation,
            v.roof_outer_radiation_unit,
            v.roof_inner_convection,
            v.roof_inner_convection_unit,
            v.roof_outer_convection,
            v.roof_outer_convection_unit,
            v.roof_layer0_position,
            v.roof_layer0_material_id,
            v.roof_layer0_material_name,
            v.roof_layer0_thickness,
            v.roof_layer0_thickness_unit,
            v.roof_layer0_solar_absorption_rate,
            v.roof_layer0_thermal_capacity,
            v.roof_layer0_thermal_capacity_unit,
            v.roof_layer0_thermal_conductivity,
            v.roof_layer0_thermal_conductivity_unit,
            v.roof_layer0_service_life,
            v.roof_layer0_service_life_unit,
            v.roof_layer0_density,
            v.roof_layer0_density_unit,
            v.roof_layer1_position,
            v.roof_layer1_material_id,
            v.roof_layer1_material_name,
            v.roof_layer1_thickness,
            v.roof_layer1_thickness_unit,
            v.roof_layer1_solar_absorption_rate,
            v.roof_layer1_thermal_capacity,
            v.roof_layer1_thermal_capacity_unit,
            v.roof_layer1_thermal_conductivity,
            v.roof_layer1_thermal_conductivity_unit,
            v.roof_layer1_service_life,
            v.roof_layer1_service_life_unit,
            v.roof_layer1_density,
            v.roof_layer1_density_unit,
            v.roof_layer2_position,
            v.roof_layer2_material_id,
            v.roof_layer2_material_name,
            v.roof_layer2_thickness,
            v.roof_layer2_thickness_unit,
            v.roof_layer2_solar_absorption_rate,
            v.roof_layer2_thermal_capacity,
            v.roof_layer2_thermal_capacity_unit,
            v.roof_layer2_thermal_conductivity,
            v.roof_layer2_thermal_conductivity_unit,
            v.roof_layer2_service_life,
            v.roof_layer2_service_life_unit,
            v.roof_layer2_density,
            v.roof_layer2_density_unit,
            v.roof_layer3_position,
            v.roof_layer3_material_id,
            v.roof_layer3_material_name,
            v.roof_layer3_thickness,
            v.roof_layer3_thickness_unit,
            v.roof_layer3_solar_absorption_rate,
            v.roof_layer3_thermal_capacity,
            v.roof_layer3_thermal_capacity_unit,
            v.roof_layer3_thermal_conductivity,
            v.roof_layer3_thermal_conductivity_unit,
            v.roof_layer3_service_life,
            v.roof_layer3_service_life_unit,
            v.roof_layer3_density,
            v.roof_layer3_density_unit,
            v.roof_layer4_position,
            v.roof_layer4_material_id,
            v.roof_layer4_material_name,
            v.roof_layer4_thickness,
            v.roof_layer4_thickness_unit,
            v.roof_layer4_solar_absorption_rate,
            v.roof_layer4_thermal_capacity,
            v.roof_layer4_thermal_capacity_unit,
            v.roof_layer4_thermal_conductivity,
            v.roof_layer4_thermal_conductivity_unit,
            v.roof_layer4_service_life,
            v.roof_layer4_service_life_unit,
            v.roof_layer4_density,
            v.roof_layer4_density_unit,
            v.roof_layer5_position,
            v.roof_layer5_material_id,
            v.roof_layer5_material_name,
            v.roof_layer5_thickness,
            v.roof_layer5_thickness_unit,
            v.roof_layer5_solar_absorption_rate,
            v.roof_layer5_thermal_capacity,
            v.roof_layer5_thermal_capacity_unit,
            v.roof_layer5_thermal_conductivity,
            v.roof_layer5_thermal_conductivity_unit,
            v.roof_layer5_service_life,
            v.roof_layer5_service_life_unit,
            v.roof_layer5_density,
            v.roof_layer5_density_unit,
            v.roof_layer0_epd1_oekobaudat_name,
            v.roof_layer0_epd1_oekobaudat_uuid,
            v.roof_layer0_epd2_oekobaudat_name,
            v.roof_layer0_epd2_oekobaudat_uuid,
            v.roof_layer1_epd1_oekobaudat_name,
            v.roof_layer1_epd1_oekobaudat_uuid,
            v.roof_layer1_epd2_oekobaudat_name,
            v.roof_layer1_epd2_oekobaudat_uuid,
            v.roof_layer2_epd1_oekobaudat_name,
            v.roof_layer2_epd1_oekobaudat_uuid,
            v.roof_layer2_epd2_oekobaudat_name,
            v.roof_layer2_epd2_oekobaudat_uuid,
            v.roof_layer3_epd1_oekobaudat_name,
            v.roof_layer3_epd1_oekobaudat_uuid,
            v.roof_layer3_epd2_oekobaudat_name,
            v.roof_layer3_epd2_oekobaudat_uuid,
            v.roof_layer4_epd1_oekobaudat_name,
            v.roof_layer4_epd1_oekobaudat_uuid,
            v.roof_layer4_epd2_oekobaudat_name,
            v.roof_layer4_epd2_oekobaudat_uuid,
            v.roof_layer5_epd1_oekobaudat_name,
            v.roof_layer5_epd1_oekobaudat_uuid,
            v.roof_layer5_epd2_oekobaudat_name,
            v.roof_layer5_epd2_oekobaudat_uuid,
            v.foundation_name,
            v.foundation_construction_type,
            v.foundation_u_value_typical_min,
            v.foundation_u_value_typical_max,
            v.foundation_u_value,
            v.foundation_u_value_unit,
            v.foundation_inner_radiation,
            v.foundation_inner_radiation_unit,
            v.foundation_inner_convection,
            v.foundation_inner_convection_unit,
            v.foundation_layer0_position,
            v.foundation_layer0_material_id,
            v.foundation_layer0_material_name,
            v.foundation_layer0_thickness,
            v.foundation_layer0_thickness_unit,
            v.foundation_layer0_solar_absorption_rate,
            v.foundation_layer0_thermal_capacity,
            v.foundation_layer0_thermal_capacity_unit,
            v.foundation_layer0_thermal_conductivity,
            v.foundation_layer0_thermal_conductivity_unit,
            v.foundation_layer0_service_life,
            v.foundation_layer0_service_life_unit,
            v.foundation_layer0_density,
            v.foundation_layer0_density_unit,
            v.foundation_layer1_position,
            v.foundation_layer1_material_id,
            v.foundation_layer1_material_name,
            v.foundation_layer1_thickness,
            v.foundation_layer1_thickness_unit,
            v.foundation_layer1_solar_absorption_rate,
            v.foundation_layer1_thermal_capacity,
            v.foundation_layer1_thermal_capacity_unit,
            v.foundation_layer1_thermal_conductivity,
            v.foundation_layer1_thermal_conductivity_unit,
            v.foundation_layer1_service_life,
            v.foundation_layer1_service_life_unit,
            v.foundation_layer1_density,
            v.foundation_layer1_density_unit,
            v.foundation_layer2_position,
            v.foundation_layer2_material_id,
            v.foundation_layer2_material_name,
            v.foundation_layer2_thickness,
            v.foundation_layer2_thickness_unit,
            v.foundation_layer2_solar_absorption_rate,
            v.foundation_layer2_thermal_capacity,
            v.foundation_layer2_thermal_capacity_unit,
            v.foundation_layer2_thermal_conductivity,
            v.foundation_layer2_thermal_conductivity_unit,
            v.foundation_layer2_service_life,
            v.foundation_layer2_service_life_unit,
            v.foundation_layer2_density,
            v.foundation_layer2_density_unit,
            v.foundation_layer3_position,
            v.foundation_layer3_material_id,
            v.foundation_layer3_material_name,
            v.foundation_layer3_thickness,
            v.foundation_layer3_thickness_unit,
            v.foundation_layer3_solar_absorption_rate,
            v.foundation_layer3_thermal_capacity,
            v.foundation_layer3_thermal_capacity_unit,
            v.foundation_layer3_thermal_conductivity,
            v.foundation_layer3_thermal_conductivity_unit,
            v.foundation_layer3_service_life,
            v.foundation_layer3_service_life_unit,
            v.foundation_layer3_density,
            v.foundation_layer3_density_unit,
            v.foundation_layer4_position,
            v.foundation_layer4_material_id,
            v.foundation_layer4_material_name,
            v.foundation_layer4_thickness,
            v.foundation_layer4_thickness_unit,
            v.foundation_layer4_solar_absorption_rate,
            v.foundation_layer4_thermal_capacity,
            v.foundation_layer4_thermal_capacity_unit,
            v.foundation_layer4_thermal_conductivity,
            v.foundation_layer4_thermal_conductivity_unit,
            v.foundation_layer4_service_life,
            v.foundation_layer4_service_life_unit,
            v.foundation_layer4_density,
            v.foundation_layer4_density_unit,
            v.foundation_layer5_position,
            v.foundation_layer5_material_id,
            v.foundation_layer5_material_name,
            v.foundation_layer5_thickness,
            v.foundation_layer5_thickness_unit,
            v.foundation_layer5_solar_absorption_rate,
            v.foundation_layer5_thermal_capacity,
            v.foundation_layer5_thermal_capacity_unit,
            v.foundation_layer5_thermal_conductivity,
            v.foundation_layer5_thermal_conductivity_unit,
            v.foundation_layer5_service_life,
            v.foundation_layer5_service_life_unit,
            v.foundation_layer5_density,
            v.foundation_layer5_density_unit,
            v.foundation_layer0_epd1_oekobaudat_name,
            v.foundation_layer0_epd1_oekobaudat_uuid,
            v.foundation_layer0_epd2_oekobaudat_name,
            v.foundation_layer0_epd2_oekobaudat_uuid,
            v.foundation_layer1_epd1_oekobaudat_name,
            v.foundation_layer1_epd1_oekobaudat_uuid,
            v.foundation_layer1_epd2_oekobaudat_name,
            v.foundation_layer1_epd2_oekobaudat_uuid,
            v.foundation_layer2_epd1_oekobaudat_name,
            v.foundation_layer2_epd1_oekobaudat_uuid,
            v.foundation_layer2_epd2_oekobaudat_name,
            v.foundation_layer2_epd2_oekobaudat_uuid,
            v.foundation_layer3_epd1_oekobaudat_name,
            v.foundation_layer3_epd1_oekobaudat_uuid,
            v.foundation_layer3_epd2_oekobaudat_name,
            v.foundation_layer3_epd2_oekobaudat_uuid,
            v.foundation_layer4_epd1_oekobaudat_name,
            v.foundation_layer4_epd1_oekobaudat_uuid,
            v.foundation_layer4_epd2_oekobaudat_name,
            v.foundation_layer4_epd2_oekobaudat_uuid,
            v.foundation_layer5_epd1_oekobaudat_name,
            v.foundation_layer5_epd1_oekobaudat_uuid,
            v.foundation_layer5_epd2_oekobaudat_name,
            v.foundation_layer5_epd2_oekobaudat_uuid,
            be.building_element_name AS floor_name,
            be.u_value_typical_min AS floor_u_value_typical_min,
            be.u_value_typical_max AS floor_u_value_typical_max,
            be.u_value AS floor_u_value,
            u.unit_name AS floor_u_value_unit,
            be.inner_radiation AS floor_inner_radiation,
            u1.unit_name AS floor_inner_radiation_unit,
            be.inner_convection AS floor_inner_convection,
            u3.unit_name AS floor_inner_convection_unit
           FROM ((((step_014 v
             LEFT JOIN hub4lca_post_simulation.building_elements be ON ((be.building_element_id = v.interior_wall_building_element_id)))
             LEFT JOIN hub4lca_post_simulation.units u ON ((u.unit_id = be.u_value_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1 ON ((u1.unit_id = be.inner_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3 ON ((u3.unit_id = be.inner_convection_unit_id)))
        ), step_016 AS (
         SELECT b.building_archetype_id,
            b.building_archetype_name,
            b.share_of_building_type,
            b.share_of_building_type_in_region,
            b.share_of_building_type_in_region_mun,
            b.exterior_wall_building_element_id,
            b.interior_wall_building_element_id,
            b.roof_building_element_id,
            b.foundation_building_element_id,
            b.floor_building_element_id,
            b.window_building_element_id,
            b.energy_system_id,
            b.building_type_name,
            b.region_name,
            b.municipality_size_name,
            b.municipality_growth_name,
            b.age_class_name,
            b.building_adjacency_name,
            b.facade_to_net_leased_area_ratio_mean,
            b.facade_to_net_leased_area_ratio_se_min,
            b.facade_to_net_leased_area_ratio_se_max,
            b.roof_to_net_leased_area_ratio_mean,
            b.roof_to_net_leased_area_ratio_se_min,
            b.roof_to_net_leased_area_ratio_se_max,
            b.foundation_to_net_leased_area_ratio_mean,
            b.foundation_to_net_leased_area_ratio_se_min,
            b.foundation_to_net_leased_area_ratio_se_max,
            b.window_to_net_leased_area_ratio_mean,
            b.window_to_net_leased_area_ratio_se_min,
            b.window_to_net_leased_area_ratio_se_max,
            b.building_height_mean,
            b.building_height_se,
            b.height_unit,
            b.aspect_ratio_mean,
            b.aspect_ratio_se_min,
            b.aspect_ratio_se_max,
            b.storeys_below_ground_mean,
            b.storeys_below_ground_se,
            b.storeys_above_ground_mean,
            b.storeys_above_ground_se,
            b.storeys_above_ground_se_min,
            b.storeys_above_ground_se_max,
            b.storey_height_mean,
            b.storey_height_se_min,
            b.storey_height_se_max,
            b.window_share,
            b.net_leased_area_mean,
            b.net_leased_area_se,
            b.net_leased_area_se_min,
            b.net_leased_area_se_max,
            b.net_leased_area_unit,
            b.facade_area_north_mean,
            b.facade_area_north_se,
            b.facade_area_east_mean,
            b.facade_area_east_se,
            b.facade_area_south_mean,
            b.facade_area_south_se,
            b.facade_area_west_mean,
            b.facade_area_west_se,
            b.facade_area_unit,
            b.facade_length_north_mean,
            b.facade_length_north_se,
            b.facade_length_east_mean,
            b.facade_length_east_se,
            b.facade_length_south_mean,
            b.facade_length_south_se,
            b.facade_length_west_mean,
            b.facade_length_west_se,
            b.facade_length_unit,
            b.exterior_wall_name,
            b.exterior_wall_construction_type,
            b.exterior_wall_u_value_typical_min,
            b.exterior_wall_u_value_typical_max,
            b.exterior_wall_u_value,
            b.exterior_wall_u_value_unit,
            b.exterior_wall_inner_radiation,
            b.exterior_wall_inner_radiation_unit,
            b.exterior_wall_outer_radiation,
            b.exterior_wall_outer_radiation_unit,
            b.exterior_wall_inner_convection,
            b.exterior_wall_inner_convection_unit,
            b.exterior_wall_outer_convection,
            b.exterior_wall_outer_convection_unit,
            b.exterior_wall_layer0_position,
            b.exterior_wall_layer0_material_id,
            b.exterior_wall_layer0_material_name,
            b.exterior_wall_layer0_thickness,
            b.exterior_wall_layer0_thickness_unit,
            b.exterior_wall_layer0_solar_absorption_rate,
            b.exterior_wall_layer0_thermal_capacity,
            b.exterior_wall_layer0_thermal_capacity_unit,
            b.exterior_wall_layer0_thermal_conductivity,
            b.exterior_wall_layer0_thermal_conductivity_unit,
            b.exterior_wall_layer0_service_life,
            b.exterior_wall_layer0_service_life_unit,
            b.exterior_wall_layer0_density,
            b.exterior_wall_layer0_density_unit,
            b.exterior_wall_layer1_position,
            b.exterior_wall_layer1_material_id,
            b.exterior_wall_layer1_material_name,
            b.exterior_wall_layer1_thickness,
            b.exterior_wall_layer1_thickness_unit,
            b.exterior_wall_layer1_solar_absorption_rate,
            b.exterior_wall_layer1_thermal_capacity,
            b.exterior_wall_layer1_thermal_capacity_unit,
            b.exterior_wall_layer1_thermal_conductivity,
            b.exterior_wall_layer1_thermal_conductivity_unit,
            b.exterior_wall_layer1_service_life,
            b.exterior_wall_layer1_service_life_unit,
            b.exterior_wall_layer1_density,
            b.exterior_wall_layer1_density_unit,
            b.exterior_wall_layer2_position,
            b.exterior_wall_layer2_material_id,
            b.exterior_wall_layer2_material_name,
            b.exterior_wall_layer2_thickness,
            b.exterior_wall_layer2_thickness_unit,
            b.exterior_wall_layer2_solar_absorption_rate,
            b.exterior_wall_layer2_thermal_capacity,
            b.exterior_wall_layer2_thermal_capacity_unit,
            b.exterior_wall_layer2_thermal_conductivity,
            b.exterior_wall_layer2_thermal_conductivity_unit,
            b.exterior_wall_layer2_service_life,
            b.exterior_wall_layer2_service_life_unit,
            b.exterior_wall_layer2_density,
            b.exterior_wall_layer2_density_unit,
            b.exterior_wall_layer3_position,
            b.exterior_wall_layer3_material_id,
            b.exterior_wall_layer3_material_name,
            b.exterior_wall_layer3_thickness,
            b.exterior_wall_layer3_thickness_unit,
            b.exterior_wall_layer3_solar_absorption_rate,
            b.exterior_wall_layer3_thermal_capacity,
            b.exterior_wall_layer3_thermal_capacity_unit,
            b.exterior_wall_layer3_thermal_conductivity,
            b.exterior_wall_layer3_thermal_conductivity_unit,
            b.exterior_wall_layer3_service_life,
            b.exterior_wall_layer3_service_life_unit,
            b.exterior_wall_layer3_density,
            b.exterior_wall_layer3_density_unit,
            b.exterior_wall_layer4_position,
            b.exterior_wall_layer4_material_id,
            b.exterior_wall_layer4_material_name,
            b.exterior_wall_layer4_thickness,
            b.exterior_wall_layer4_thickness_unit,
            b.exterior_wall_layer4_solar_absorption_rate,
            b.exterior_wall_layer4_thermal_capacity,
            b.exterior_wall_layer4_thermal_capacity_unit,
            b.exterior_wall_layer4_thermal_conductivity,
            b.exterior_wall_layer4_thermal_conductivity_unit,
            b.exterior_wall_layer4_service_life,
            b.exterior_wall_layer4_service_life_unit,
            b.exterior_wall_layer4_density,
            b.exterior_wall_layer4_density_unit,
            b.exterior_wall_layer5_position,
            b.exterior_wall_layer5_material_id,
            b.exterior_wall_layer5_material_name,
            b.exterior_wall_layer5_thickness,
            b.exterior_wall_layer5_thickness_unit,
            b.exterior_wall_layer5_solar_absorption_rate,
            b.exterior_wall_layer5_thermal_capacity,
            b.exterior_wall_layer5_thermal_capacity_unit,
            b.exterior_wall_layer5_thermal_conductivity,
            b.exterior_wall_layer5_thermal_conductivity_unit,
            b.exterior_wall_layer5_service_life,
            b.exterior_wall_layer5_service_life_unit,
            b.exterior_wall_layer5_density,
            b.exterior_wall_layer5_density_unit,
            b.exterior_wall_layer0_epd1_oekobaudat_name,
            b.exterior_wall_layer0_epd1_oekobaudat_uuid,
            b.exterior_wall_layer0_epd2_oekobaudat_name,
            b.exterior_wall_layer0_epd2_oekobaudat_uuid,
            b.exterior_wall_layer1_epd1_oekobaudat_name,
            b.exterior_wall_layer1_epd1_oekobaudat_uuid,
            b.exterior_wall_layer1_epd2_oekobaudat_name,
            b.exterior_wall_layer1_epd2_oekobaudat_uuid,
            b.exterior_wall_layer2_epd1_oekobaudat_name,
            b.exterior_wall_layer2_epd1_oekobaudat_uuid,
            b.exterior_wall_layer2_epd2_oekobaudat_name,
            b.exterior_wall_layer2_epd2_oekobaudat_uuid,
            b.exterior_wall_layer3_epd1_oekobaudat_name,
            b.exterior_wall_layer3_epd1_oekobaudat_uuid,
            b.exterior_wall_layer3_epd2_oekobaudat_name,
            b.exterior_wall_layer3_epd2_oekobaudat_uuid,
            b.exterior_wall_layer4_epd1_oekobaudat_name,
            b.exterior_wall_layer4_epd1_oekobaudat_uuid,
            b.exterior_wall_layer4_epd2_oekobaudat_name,
            b.exterior_wall_layer4_epd2_oekobaudat_uuid,
            b.exterior_wall_layer5_epd1_oekobaudat_name,
            b.exterior_wall_layer5_epd1_oekobaudat_uuid,
            b.exterior_wall_layer5_epd2_oekobaudat_name,
            b.exterior_wall_layer5_epd2_oekobaudat_uuid,
            b.interior_wall_name,
            b.interior_wall_u_value_typical_min,
            b.interior_wall_u_value_typical_max,
            b.interior_wall_u_value,
            b.interior_wall_u_value_unit,
            b.interior_wall_inner_radiation,
            b.interior_wall_inner_radiation_unit,
            b.interior_wall_inner_convection,
            b.interior_wall_inner_convection_unit,
            b.interior_wall_layer0_position,
            b.interior_wall_layer0_material_id,
            b.interior_wall_layer0_material_name,
            b.interior_wall_layer0_thickness,
            b.interior_wall_layer0_thickness_unit,
            b.interior_wall_layer0_solar_absorption_rate,
            b.interior_wall_layer0_thermal_capacity,
            b.interior_wall_layer0_thermal_capacity_unit,
            b.interior_wall_layer0_thermal_conductivity,
            b.interior_wall_layer0_thermal_conductivity_unit,
            b.interior_wall_layer0_service_life,
            b.interior_wall_layer0_service_life_unit,
            b.interior_wall_layer0_density,
            b.interior_wall_layer0_density_unit,
            b.interior_wall_layer1_position,
            b.interior_wall_layer1_material_id,
            b.interior_wall_layer1_material_name,
            b.interior_wall_layer1_thickness,
            b.interior_wall_layer1_thickness_unit,
            b.interior_wall_layer1_solar_absorption_rate,
            b.interior_wall_layer1_thermal_capacity,
            b.interior_wall_layer1_thermal_capacity_unit,
            b.interior_wall_layer1_thermal_conductivity,
            b.interior_wall_layer1_thermal_conductivity_unit,
            b.interior_wall_layer1_service_life,
            b.interior_wall_layer1_service_life_unit,
            b.interior_wall_layer1_density,
            b.interior_wall_layer1_density_unit,
            b.interior_wall_layer2_position,
            b.interior_wall_layer2_material_id,
            b.interior_wall_layer2_material_name,
            b.interior_wall_layer2_thickness,
            b.interior_wall_layer2_thickness_unit,
            b.interior_wall_layer2_solar_absorption_rate,
            b.interior_wall_layer2_thermal_capacity,
            b.interior_wall_layer2_thermal_capacity_unit,
            b.interior_wall_layer2_thermal_conductivity,
            b.interior_wall_layer2_thermal_conductivity_unit,
            b.interior_wall_layer2_service_life,
            b.interior_wall_layer2_service_life_unit,
            b.interior_wall_layer2_density,
            b.interior_wall_layer2_density_unit,
            b.interior_wall_layer0_epd1_oekobaudat_name,
            b.interior_wall_layer0_epd1_oekobaudat_uuid,
            b.interior_wall_layer0_epd2_oekobaudat_name,
            b.interior_wall_layer0_epd2_oekobaudat_uuid,
            b.interior_wall_layer1_epd1_oekobaudat_name,
            b.interior_wall_layer1_epd1_oekobaudat_uuid,
            b.interior_wall_layer1_epd2_oekobaudat_name,
            b.interior_wall_layer1_epd2_oekobaudat_uuid,
            b.interior_wall_layer2_epd1_oekobaudat_name,
            b.interior_wall_layer2_epd1_oekobaudat_uuid,
            b.interior_wall_layer2_epd2_oekobaudat_name,
            b.interior_wall_layer2_epd2_oekobaudat_uuid,
            b.roof_name,
            b.roof_construction_type,
            b.roof_pitch_type,
            b.roof_u_value_typical_min,
            b.roof_u_value_typical_max,
            b.roof_u_value,
            b.roof_u_value_unit,
            b.roof_inner_radiation,
            b.roof_inner_radiation_unit,
            b.roof_outer_radiation,
            b.roof_outer_radiation_unit,
            b.roof_inner_convection,
            b.roof_inner_convection_unit,
            b.roof_outer_convection,
            b.roof_outer_convection_unit,
            b.roof_layer0_position,
            b.roof_layer0_material_id,
            b.roof_layer0_material_name,
            b.roof_layer0_thickness,
            b.roof_layer0_thickness_unit,
            b.roof_layer0_solar_absorption_rate,
            b.roof_layer0_thermal_capacity,
            b.roof_layer0_thermal_capacity_unit,
            b.roof_layer0_thermal_conductivity,
            b.roof_layer0_thermal_conductivity_unit,
            b.roof_layer0_service_life,
            b.roof_layer0_service_life_unit,
            b.roof_layer0_density,
            b.roof_layer0_density_unit,
            b.roof_layer1_position,
            b.roof_layer1_material_id,
            b.roof_layer1_material_name,
            b.roof_layer1_thickness,
            b.roof_layer1_thickness_unit,
            b.roof_layer1_solar_absorption_rate,
            b.roof_layer1_thermal_capacity,
            b.roof_layer1_thermal_capacity_unit,
            b.roof_layer1_thermal_conductivity,
            b.roof_layer1_thermal_conductivity_unit,
            b.roof_layer1_service_life,
            b.roof_layer1_service_life_unit,
            b.roof_layer1_density,
            b.roof_layer1_density_unit,
            b.roof_layer2_position,
            b.roof_layer2_material_id,
            b.roof_layer2_material_name,
            b.roof_layer2_thickness,
            b.roof_layer2_thickness_unit,
            b.roof_layer2_solar_absorption_rate,
            b.roof_layer2_thermal_capacity,
            b.roof_layer2_thermal_capacity_unit,
            b.roof_layer2_thermal_conductivity,
            b.roof_layer2_thermal_conductivity_unit,
            b.roof_layer2_service_life,
            b.roof_layer2_service_life_unit,
            b.roof_layer2_density,
            b.roof_layer2_density_unit,
            b.roof_layer3_position,
            b.roof_layer3_material_id,
            b.roof_layer3_material_name,
            b.roof_layer3_thickness,
            b.roof_layer3_thickness_unit,
            b.roof_layer3_solar_absorption_rate,
            b.roof_layer3_thermal_capacity,
            b.roof_layer3_thermal_capacity_unit,
            b.roof_layer3_thermal_conductivity,
            b.roof_layer3_thermal_conductivity_unit,
            b.roof_layer3_service_life,
            b.roof_layer3_service_life_unit,
            b.roof_layer3_density,
            b.roof_layer3_density_unit,
            b.roof_layer4_position,
            b.roof_layer4_material_id,
            b.roof_layer4_material_name,
            b.roof_layer4_thickness,
            b.roof_layer4_thickness_unit,
            b.roof_layer4_solar_absorption_rate,
            b.roof_layer4_thermal_capacity,
            b.roof_layer4_thermal_capacity_unit,
            b.roof_layer4_thermal_conductivity,
            b.roof_layer4_thermal_conductivity_unit,
            b.roof_layer4_service_life,
            b.roof_layer4_service_life_unit,
            b.roof_layer4_density,
            b.roof_layer4_density_unit,
            b.roof_layer5_position,
            b.roof_layer5_material_id,
            b.roof_layer5_material_name,
            b.roof_layer5_thickness,
            b.roof_layer5_thickness_unit,
            b.roof_layer5_solar_absorption_rate,
            b.roof_layer5_thermal_capacity,
            b.roof_layer5_thermal_capacity_unit,
            b.roof_layer5_thermal_conductivity,
            b.roof_layer5_thermal_conductivity_unit,
            b.roof_layer5_service_life,
            b.roof_layer5_service_life_unit,
            b.roof_layer5_density,
            b.roof_layer5_density_unit,
            b.roof_layer0_epd1_oekobaudat_name,
            b.roof_layer0_epd1_oekobaudat_uuid,
            b.roof_layer0_epd2_oekobaudat_name,
            b.roof_layer0_epd2_oekobaudat_uuid,
            b.roof_layer1_epd1_oekobaudat_name,
            b.roof_layer1_epd1_oekobaudat_uuid,
            b.roof_layer1_epd2_oekobaudat_name,
            b.roof_layer1_epd2_oekobaudat_uuid,
            b.roof_layer2_epd1_oekobaudat_name,
            b.roof_layer2_epd1_oekobaudat_uuid,
            b.roof_layer2_epd2_oekobaudat_name,
            b.roof_layer2_epd2_oekobaudat_uuid,
            b.roof_layer3_epd1_oekobaudat_name,
            b.roof_layer3_epd1_oekobaudat_uuid,
            b.roof_layer3_epd2_oekobaudat_name,
            b.roof_layer3_epd2_oekobaudat_uuid,
            b.roof_layer4_epd1_oekobaudat_name,
            b.roof_layer4_epd1_oekobaudat_uuid,
            b.roof_layer4_epd2_oekobaudat_name,
            b.roof_layer4_epd2_oekobaudat_uuid,
            b.roof_layer5_epd1_oekobaudat_name,
            b.roof_layer5_epd1_oekobaudat_uuid,
            b.roof_layer5_epd2_oekobaudat_name,
            b.roof_layer5_epd2_oekobaudat_uuid,
            b.foundation_name,
            b.foundation_construction_type,
            b.foundation_u_value_typical_min,
            b.foundation_u_value_typical_max,
            b.foundation_u_value,
            b.foundation_u_value_unit,
            b.foundation_inner_radiation,
            b.foundation_inner_radiation_unit,
            b.foundation_inner_convection,
            b.foundation_inner_convection_unit,
            b.foundation_layer0_position,
            b.foundation_layer0_material_id,
            b.foundation_layer0_material_name,
            b.foundation_layer0_thickness,
            b.foundation_layer0_thickness_unit,
            b.foundation_layer0_solar_absorption_rate,
            b.foundation_layer0_thermal_capacity,
            b.foundation_layer0_thermal_capacity_unit,
            b.foundation_layer0_thermal_conductivity,
            b.foundation_layer0_thermal_conductivity_unit,
            b.foundation_layer0_service_life,
            b.foundation_layer0_service_life_unit,
            b.foundation_layer0_density,
            b.foundation_layer0_density_unit,
            b.foundation_layer1_position,
            b.foundation_layer1_material_id,
            b.foundation_layer1_material_name,
            b.foundation_layer1_thickness,
            b.foundation_layer1_thickness_unit,
            b.foundation_layer1_solar_absorption_rate,
            b.foundation_layer1_thermal_capacity,
            b.foundation_layer1_thermal_capacity_unit,
            b.foundation_layer1_thermal_conductivity,
            b.foundation_layer1_thermal_conductivity_unit,
            b.foundation_layer1_service_life,
            b.foundation_layer1_service_life_unit,
            b.foundation_layer1_density,
            b.foundation_layer1_density_unit,
            b.foundation_layer2_position,
            b.foundation_layer2_material_id,
            b.foundation_layer2_material_name,
            b.foundation_layer2_thickness,
            b.foundation_layer2_thickness_unit,
            b.foundation_layer2_solar_absorption_rate,
            b.foundation_layer2_thermal_capacity,
            b.foundation_layer2_thermal_capacity_unit,
            b.foundation_layer2_thermal_conductivity,
            b.foundation_layer2_thermal_conductivity_unit,
            b.foundation_layer2_service_life,
            b.foundation_layer2_service_life_unit,
            b.foundation_layer2_density,
            b.foundation_layer2_density_unit,
            b.foundation_layer3_position,
            b.foundation_layer3_material_id,
            b.foundation_layer3_material_name,
            b.foundation_layer3_thickness,
            b.foundation_layer3_thickness_unit,
            b.foundation_layer3_solar_absorption_rate,
            b.foundation_layer3_thermal_capacity,
            b.foundation_layer3_thermal_capacity_unit,
            b.foundation_layer3_thermal_conductivity,
            b.foundation_layer3_thermal_conductivity_unit,
            b.foundation_layer3_service_life,
            b.foundation_layer3_service_life_unit,
            b.foundation_layer3_density,
            b.foundation_layer3_density_unit,
            b.foundation_layer4_position,
            b.foundation_layer4_material_id,
            b.foundation_layer4_material_name,
            b.foundation_layer4_thickness,
            b.foundation_layer4_thickness_unit,
            b.foundation_layer4_solar_absorption_rate,
            b.foundation_layer4_thermal_capacity,
            b.foundation_layer4_thermal_capacity_unit,
            b.foundation_layer4_thermal_conductivity,
            b.foundation_layer4_thermal_conductivity_unit,
            b.foundation_layer4_service_life,
            b.foundation_layer4_service_life_unit,
            b.foundation_layer4_density,
            b.foundation_layer4_density_unit,
            b.foundation_layer5_position,
            b.foundation_layer5_material_id,
            b.foundation_layer5_material_name,
            b.foundation_layer5_thickness,
            b.foundation_layer5_thickness_unit,
            b.foundation_layer5_solar_absorption_rate,
            b.foundation_layer5_thermal_capacity,
            b.foundation_layer5_thermal_capacity_unit,
            b.foundation_layer5_thermal_conductivity,
            b.foundation_layer5_thermal_conductivity_unit,
            b.foundation_layer5_service_life,
            b.foundation_layer5_service_life_unit,
            b.foundation_layer5_density,
            b.foundation_layer5_density_unit,
            b.foundation_layer0_epd1_oekobaudat_name,
            b.foundation_layer0_epd1_oekobaudat_uuid,
            b.foundation_layer0_epd2_oekobaudat_name,
            b.foundation_layer0_epd2_oekobaudat_uuid,
            b.foundation_layer1_epd1_oekobaudat_name,
            b.foundation_layer1_epd1_oekobaudat_uuid,
            b.foundation_layer1_epd2_oekobaudat_name,
            b.foundation_layer1_epd2_oekobaudat_uuid,
            b.foundation_layer2_epd1_oekobaudat_name,
            b.foundation_layer2_epd1_oekobaudat_uuid,
            b.foundation_layer2_epd2_oekobaudat_name,
            b.foundation_layer2_epd2_oekobaudat_uuid,
            b.foundation_layer3_epd1_oekobaudat_name,
            b.foundation_layer3_epd1_oekobaudat_uuid,
            b.foundation_layer3_epd2_oekobaudat_name,
            b.foundation_layer3_epd2_oekobaudat_uuid,
            b.foundation_layer4_epd1_oekobaudat_name,
            b.foundation_layer4_epd1_oekobaudat_uuid,
            b.foundation_layer4_epd2_oekobaudat_name,
            b.foundation_layer4_epd2_oekobaudat_uuid,
            b.foundation_layer5_epd1_oekobaudat_name,
            b.foundation_layer5_epd1_oekobaudat_uuid,
            b.foundation_layer5_epd2_oekobaudat_name,
            b.foundation_layer5_epd2_oekobaudat_uuid,
            b.floor_name,
            b.floor_u_value_typical_min,
            b.floor_u_value_typical_max,
            b.floor_u_value,
            b.floor_u_value_unit,
            b.floor_inner_radiation,
            b.floor_inner_radiation_unit,
            b.floor_inner_convection,
            b.floor_inner_convection_unit,
            l0."position" AS floor_layer0_position,
            l0.building_material_id AS floor_layer0_material_id,
            bm0.building_material_name AS floor_layer0_material_name,
            l0.thickness AS floor_layer0_thickness,
            u0_th.unit_name AS floor_layer0_thickness_unit,
            bm0.solar_absorption_rate AS floor_layer0_solar_absorption_rate,
            bm0.thermal_capacity AS floor_layer0_thermal_capacity,
            u0_tc.unit_name AS floor_layer0_thermal_capacity_unit,
            bm0.thermal_conductivity AS floor_layer0_thermal_conductivity,
            u0_tco.unit_name AS floor_layer0_thermal_conductivity_unit,
            sl0.service_life AS floor_layer0_service_life,
            u0_sl.unit_name AS floor_layer0_service_life_unit,
            bm0.density AS floor_layer0_density,
            u0_d.unit_name AS floor_layer0_density_unit,
            l1."position" AS floor_layer1_position,
            l1.building_material_id AS floor_layer1_material_id,
            bm1.building_material_name AS floor_layer1_material_name,
            l1.thickness AS floor_layer1_thickness,
            u1_th.unit_name AS floor_layer1_thickness_unit,
            bm1.solar_absorption_rate AS floor_layer1_solar_absorption_rate,
            bm1.thermal_capacity AS floor_layer1_thermal_capacity,
            u1_tc.unit_name AS floor_layer1_thermal_capacity_unit,
            bm1.thermal_conductivity AS floor_layer1_thermal_conductivity,
            u1_tco.unit_name AS floor_layer1_thermal_conductivity_unit,
            sl1.service_life AS floor_layer1_service_life,
            u1_sl.unit_name AS floor_layer1_service_life_unit,
            bm1.density AS floor_layer1_density,
            u1_d.unit_name AS floor_layer1_density_unit,
            l2."position" AS floor_layer2_position,
            l2.building_material_id AS floor_layer2_material_id,
            bm2.building_material_name AS floor_layer2_material_name,
            l2.thickness AS floor_layer2_thickness,
            u2_th.unit_name AS floor_layer2_thickness_unit,
            bm2.solar_absorption_rate AS floor_layer2_solar_absorption_rate,
            bm2.thermal_capacity AS floor_layer2_thermal_capacity,
            u2_tc.unit_name AS floor_layer2_thermal_capacity_unit,
            bm2.thermal_conductivity AS floor_layer2_thermal_conductivity,
            u2_tco.unit_name AS floor_layer2_thermal_conductivity_unit,
            sl2.service_life AS floor_layer2_service_life,
            u2_sl.unit_name AS floor_layer2_service_life_unit,
            bm2.density AS floor_layer2_density,
            u2_d.unit_name AS floor_layer2_density_unit
           FROM ((((((((((((((((((((((((step_015 b
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = b.floor_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_th ON ((u0_th.unit_id = l0.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tc ON ((u0_tc.unit_id = bm0.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tco ON ((u0_tco.unit_id = bm0.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl0 ON ((sl0.service_life_id = bm0.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_sl ON ((u0_sl.unit_id = sl0.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_d ON ((u0_d.unit_id = bm0.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = b.floor_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_th ON ((u1_th.unit_id = l1.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tc ON ((u1_tc.unit_id = bm1.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tco ON ((u1_tco.unit_id = bm1.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl1 ON ((sl1.service_life_id = bm1.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_sl ON ((u1_sl.unit_id = sl1.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_d ON ((u1_d.unit_id = bm1.density_unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = b.floor_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_th ON ((u2_th.unit_id = l2.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tc ON ((u2_tc.unit_id = bm2.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tco ON ((u2_tco.unit_id = bm2.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl2 ON ((sl2.service_life_id = bm2.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_sl ON ((u2_sl.unit_id = sl2.unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_d ON ((u2_d.unit_id = bm2.density_unit_id)))
        ), step_017 AS (
         SELECT f.building_archetype_id,
            f.building_archetype_name,
            f.share_of_building_type,
            f.share_of_building_type_in_region,
            f.share_of_building_type_in_region_mun,
            f.exterior_wall_building_element_id,
            f.interior_wall_building_element_id,
            f.roof_building_element_id,
            f.foundation_building_element_id,
            f.floor_building_element_id,
            f.window_building_element_id,
            f.energy_system_id,
            f.building_type_name,
            f.region_name,
            f.municipality_size_name,
            f.municipality_growth_name,
            f.age_class_name,
            f.building_adjacency_name,
            f.facade_to_net_leased_area_ratio_mean,
            f.facade_to_net_leased_area_ratio_se_min,
            f.facade_to_net_leased_area_ratio_se_max,
            f.roof_to_net_leased_area_ratio_mean,
            f.roof_to_net_leased_area_ratio_se_min,
            f.roof_to_net_leased_area_ratio_se_max,
            f.foundation_to_net_leased_area_ratio_mean,
            f.foundation_to_net_leased_area_ratio_se_min,
            f.foundation_to_net_leased_area_ratio_se_max,
            f.window_to_net_leased_area_ratio_mean,
            f.window_to_net_leased_area_ratio_se_min,
            f.window_to_net_leased_area_ratio_se_max,
            f.building_height_mean,
            f.building_height_se,
            f.height_unit,
            f.aspect_ratio_mean,
            f.aspect_ratio_se_min,
            f.aspect_ratio_se_max,
            f.storeys_below_ground_mean,
            f.storeys_below_ground_se,
            f.storeys_above_ground_mean,
            f.storeys_above_ground_se,
            f.storeys_above_ground_se_min,
            f.storeys_above_ground_se_max,
            f.storey_height_mean,
            f.storey_height_se_min,
            f.storey_height_se_max,
            f.window_share,
            f.net_leased_area_mean,
            f.net_leased_area_se,
            f.net_leased_area_se_min,
            f.net_leased_area_se_max,
            f.net_leased_area_unit,
            f.facade_area_north_mean,
            f.facade_area_north_se,
            f.facade_area_east_mean,
            f.facade_area_east_se,
            f.facade_area_south_mean,
            f.facade_area_south_se,
            f.facade_area_west_mean,
            f.facade_area_west_se,
            f.facade_area_unit,
            f.facade_length_north_mean,
            f.facade_length_north_se,
            f.facade_length_east_mean,
            f.facade_length_east_se,
            f.facade_length_south_mean,
            f.facade_length_south_se,
            f.facade_length_west_mean,
            f.facade_length_west_se,
            f.facade_length_unit,
            f.exterior_wall_name,
            f.exterior_wall_construction_type,
            f.exterior_wall_u_value_typical_min,
            f.exterior_wall_u_value_typical_max,
            f.exterior_wall_u_value,
            f.exterior_wall_u_value_unit,
            f.exterior_wall_inner_radiation,
            f.exterior_wall_inner_radiation_unit,
            f.exterior_wall_outer_radiation,
            f.exterior_wall_outer_radiation_unit,
            f.exterior_wall_inner_convection,
            f.exterior_wall_inner_convection_unit,
            f.exterior_wall_outer_convection,
            f.exterior_wall_outer_convection_unit,
            f.exterior_wall_layer0_position,
            f.exterior_wall_layer0_material_id,
            f.exterior_wall_layer0_material_name,
            f.exterior_wall_layer0_thickness,
            f.exterior_wall_layer0_thickness_unit,
            f.exterior_wall_layer0_solar_absorption_rate,
            f.exterior_wall_layer0_thermal_capacity,
            f.exterior_wall_layer0_thermal_capacity_unit,
            f.exterior_wall_layer0_thermal_conductivity,
            f.exterior_wall_layer0_thermal_conductivity_unit,
            f.exterior_wall_layer0_service_life,
            f.exterior_wall_layer0_service_life_unit,
            f.exterior_wall_layer0_density,
            f.exterior_wall_layer0_density_unit,
            f.exterior_wall_layer1_position,
            f.exterior_wall_layer1_material_id,
            f.exterior_wall_layer1_material_name,
            f.exterior_wall_layer1_thickness,
            f.exterior_wall_layer1_thickness_unit,
            f.exterior_wall_layer1_solar_absorption_rate,
            f.exterior_wall_layer1_thermal_capacity,
            f.exterior_wall_layer1_thermal_capacity_unit,
            f.exterior_wall_layer1_thermal_conductivity,
            f.exterior_wall_layer1_thermal_conductivity_unit,
            f.exterior_wall_layer1_service_life,
            f.exterior_wall_layer1_service_life_unit,
            f.exterior_wall_layer1_density,
            f.exterior_wall_layer1_density_unit,
            f.exterior_wall_layer2_position,
            f.exterior_wall_layer2_material_id,
            f.exterior_wall_layer2_material_name,
            f.exterior_wall_layer2_thickness,
            f.exterior_wall_layer2_thickness_unit,
            f.exterior_wall_layer2_solar_absorption_rate,
            f.exterior_wall_layer2_thermal_capacity,
            f.exterior_wall_layer2_thermal_capacity_unit,
            f.exterior_wall_layer2_thermal_conductivity,
            f.exterior_wall_layer2_thermal_conductivity_unit,
            f.exterior_wall_layer2_service_life,
            f.exterior_wall_layer2_service_life_unit,
            f.exterior_wall_layer2_density,
            f.exterior_wall_layer2_density_unit,
            f.exterior_wall_layer3_position,
            f.exterior_wall_layer3_material_id,
            f.exterior_wall_layer3_material_name,
            f.exterior_wall_layer3_thickness,
            f.exterior_wall_layer3_thickness_unit,
            f.exterior_wall_layer3_solar_absorption_rate,
            f.exterior_wall_layer3_thermal_capacity,
            f.exterior_wall_layer3_thermal_capacity_unit,
            f.exterior_wall_layer3_thermal_conductivity,
            f.exterior_wall_layer3_thermal_conductivity_unit,
            f.exterior_wall_layer3_service_life,
            f.exterior_wall_layer3_service_life_unit,
            f.exterior_wall_layer3_density,
            f.exterior_wall_layer3_density_unit,
            f.exterior_wall_layer4_position,
            f.exterior_wall_layer4_material_id,
            f.exterior_wall_layer4_material_name,
            f.exterior_wall_layer4_thickness,
            f.exterior_wall_layer4_thickness_unit,
            f.exterior_wall_layer4_solar_absorption_rate,
            f.exterior_wall_layer4_thermal_capacity,
            f.exterior_wall_layer4_thermal_capacity_unit,
            f.exterior_wall_layer4_thermal_conductivity,
            f.exterior_wall_layer4_thermal_conductivity_unit,
            f.exterior_wall_layer4_service_life,
            f.exterior_wall_layer4_service_life_unit,
            f.exterior_wall_layer4_density,
            f.exterior_wall_layer4_density_unit,
            f.exterior_wall_layer5_position,
            f.exterior_wall_layer5_material_id,
            f.exterior_wall_layer5_material_name,
            f.exterior_wall_layer5_thickness,
            f.exterior_wall_layer5_thickness_unit,
            f.exterior_wall_layer5_solar_absorption_rate,
            f.exterior_wall_layer5_thermal_capacity,
            f.exterior_wall_layer5_thermal_capacity_unit,
            f.exterior_wall_layer5_thermal_conductivity,
            f.exterior_wall_layer5_thermal_conductivity_unit,
            f.exterior_wall_layer5_service_life,
            f.exterior_wall_layer5_service_life_unit,
            f.exterior_wall_layer5_density,
            f.exterior_wall_layer5_density_unit,
            f.exterior_wall_layer0_epd1_oekobaudat_name,
            f.exterior_wall_layer0_epd1_oekobaudat_uuid,
            f.exterior_wall_layer0_epd2_oekobaudat_name,
            f.exterior_wall_layer0_epd2_oekobaudat_uuid,
            f.exterior_wall_layer1_epd1_oekobaudat_name,
            f.exterior_wall_layer1_epd1_oekobaudat_uuid,
            f.exterior_wall_layer1_epd2_oekobaudat_name,
            f.exterior_wall_layer1_epd2_oekobaudat_uuid,
            f.exterior_wall_layer2_epd1_oekobaudat_name,
            f.exterior_wall_layer2_epd1_oekobaudat_uuid,
            f.exterior_wall_layer2_epd2_oekobaudat_name,
            f.exterior_wall_layer2_epd2_oekobaudat_uuid,
            f.exterior_wall_layer3_epd1_oekobaudat_name,
            f.exterior_wall_layer3_epd1_oekobaudat_uuid,
            f.exterior_wall_layer3_epd2_oekobaudat_name,
            f.exterior_wall_layer3_epd2_oekobaudat_uuid,
            f.exterior_wall_layer4_epd1_oekobaudat_name,
            f.exterior_wall_layer4_epd1_oekobaudat_uuid,
            f.exterior_wall_layer4_epd2_oekobaudat_name,
            f.exterior_wall_layer4_epd2_oekobaudat_uuid,
            f.exterior_wall_layer5_epd1_oekobaudat_name,
            f.exterior_wall_layer5_epd1_oekobaudat_uuid,
            f.exterior_wall_layer5_epd2_oekobaudat_name,
            f.exterior_wall_layer5_epd2_oekobaudat_uuid,
            f.interior_wall_name,
            f.interior_wall_u_value_typical_min,
            f.interior_wall_u_value_typical_max,
            f.interior_wall_u_value,
            f.interior_wall_u_value_unit,
            f.interior_wall_inner_radiation,
            f.interior_wall_inner_radiation_unit,
            f.interior_wall_inner_convection,
            f.interior_wall_inner_convection_unit,
            f.interior_wall_layer0_position,
            f.interior_wall_layer0_material_id,
            f.interior_wall_layer0_material_name,
            f.interior_wall_layer0_thickness,
            f.interior_wall_layer0_thickness_unit,
            f.interior_wall_layer0_solar_absorption_rate,
            f.interior_wall_layer0_thermal_capacity,
            f.interior_wall_layer0_thermal_capacity_unit,
            f.interior_wall_layer0_thermal_conductivity,
            f.interior_wall_layer0_thermal_conductivity_unit,
            f.interior_wall_layer0_service_life,
            f.interior_wall_layer0_service_life_unit,
            f.interior_wall_layer0_density,
            f.interior_wall_layer0_density_unit,
            f.interior_wall_layer1_position,
            f.interior_wall_layer1_material_id,
            f.interior_wall_layer1_material_name,
            f.interior_wall_layer1_thickness,
            f.interior_wall_layer1_thickness_unit,
            f.interior_wall_layer1_solar_absorption_rate,
            f.interior_wall_layer1_thermal_capacity,
            f.interior_wall_layer1_thermal_capacity_unit,
            f.interior_wall_layer1_thermal_conductivity,
            f.interior_wall_layer1_thermal_conductivity_unit,
            f.interior_wall_layer1_service_life,
            f.interior_wall_layer1_service_life_unit,
            f.interior_wall_layer1_density,
            f.interior_wall_layer1_density_unit,
            f.interior_wall_layer2_position,
            f.interior_wall_layer2_material_id,
            f.interior_wall_layer2_material_name,
            f.interior_wall_layer2_thickness,
            f.interior_wall_layer2_thickness_unit,
            f.interior_wall_layer2_solar_absorption_rate,
            f.interior_wall_layer2_thermal_capacity,
            f.interior_wall_layer2_thermal_capacity_unit,
            f.interior_wall_layer2_thermal_conductivity,
            f.interior_wall_layer2_thermal_conductivity_unit,
            f.interior_wall_layer2_service_life,
            f.interior_wall_layer2_service_life_unit,
            f.interior_wall_layer2_density,
            f.interior_wall_layer2_density_unit,
            f.interior_wall_layer0_epd1_oekobaudat_name,
            f.interior_wall_layer0_epd1_oekobaudat_uuid,
            f.interior_wall_layer0_epd2_oekobaudat_name,
            f.interior_wall_layer0_epd2_oekobaudat_uuid,
            f.interior_wall_layer1_epd1_oekobaudat_name,
            f.interior_wall_layer1_epd1_oekobaudat_uuid,
            f.interior_wall_layer1_epd2_oekobaudat_name,
            f.interior_wall_layer1_epd2_oekobaudat_uuid,
            f.interior_wall_layer2_epd1_oekobaudat_name,
            f.interior_wall_layer2_epd1_oekobaudat_uuid,
            f.interior_wall_layer2_epd2_oekobaudat_name,
            f.interior_wall_layer2_epd2_oekobaudat_uuid,
            f.roof_name,
            f.roof_construction_type,
            f.roof_pitch_type,
            f.roof_u_value_typical_min,
            f.roof_u_value_typical_max,
            f.roof_u_value,
            f.roof_u_value_unit,
            f.roof_inner_radiation,
            f.roof_inner_radiation_unit,
            f.roof_outer_radiation,
            f.roof_outer_radiation_unit,
            f.roof_inner_convection,
            f.roof_inner_convection_unit,
            f.roof_outer_convection,
            f.roof_outer_convection_unit,
            f.roof_layer0_position,
            f.roof_layer0_material_id,
            f.roof_layer0_material_name,
            f.roof_layer0_thickness,
            f.roof_layer0_thickness_unit,
            f.roof_layer0_solar_absorption_rate,
            f.roof_layer0_thermal_capacity,
            f.roof_layer0_thermal_capacity_unit,
            f.roof_layer0_thermal_conductivity,
            f.roof_layer0_thermal_conductivity_unit,
            f.roof_layer0_service_life,
            f.roof_layer0_service_life_unit,
            f.roof_layer0_density,
            f.roof_layer0_density_unit,
            f.roof_layer1_position,
            f.roof_layer1_material_id,
            f.roof_layer1_material_name,
            f.roof_layer1_thickness,
            f.roof_layer1_thickness_unit,
            f.roof_layer1_solar_absorption_rate,
            f.roof_layer1_thermal_capacity,
            f.roof_layer1_thermal_capacity_unit,
            f.roof_layer1_thermal_conductivity,
            f.roof_layer1_thermal_conductivity_unit,
            f.roof_layer1_service_life,
            f.roof_layer1_service_life_unit,
            f.roof_layer1_density,
            f.roof_layer1_density_unit,
            f.roof_layer2_position,
            f.roof_layer2_material_id,
            f.roof_layer2_material_name,
            f.roof_layer2_thickness,
            f.roof_layer2_thickness_unit,
            f.roof_layer2_solar_absorption_rate,
            f.roof_layer2_thermal_capacity,
            f.roof_layer2_thermal_capacity_unit,
            f.roof_layer2_thermal_conductivity,
            f.roof_layer2_thermal_conductivity_unit,
            f.roof_layer2_service_life,
            f.roof_layer2_service_life_unit,
            f.roof_layer2_density,
            f.roof_layer2_density_unit,
            f.roof_layer3_position,
            f.roof_layer3_material_id,
            f.roof_layer3_material_name,
            f.roof_layer3_thickness,
            f.roof_layer3_thickness_unit,
            f.roof_layer3_solar_absorption_rate,
            f.roof_layer3_thermal_capacity,
            f.roof_layer3_thermal_capacity_unit,
            f.roof_layer3_thermal_conductivity,
            f.roof_layer3_thermal_conductivity_unit,
            f.roof_layer3_service_life,
            f.roof_layer3_service_life_unit,
            f.roof_layer3_density,
            f.roof_layer3_density_unit,
            f.roof_layer4_position,
            f.roof_layer4_material_id,
            f.roof_layer4_material_name,
            f.roof_layer4_thickness,
            f.roof_layer4_thickness_unit,
            f.roof_layer4_solar_absorption_rate,
            f.roof_layer4_thermal_capacity,
            f.roof_layer4_thermal_capacity_unit,
            f.roof_layer4_thermal_conductivity,
            f.roof_layer4_thermal_conductivity_unit,
            f.roof_layer4_service_life,
            f.roof_layer4_service_life_unit,
            f.roof_layer4_density,
            f.roof_layer4_density_unit,
            f.roof_layer5_position,
            f.roof_layer5_material_id,
            f.roof_layer5_material_name,
            f.roof_layer5_thickness,
            f.roof_layer5_thickness_unit,
            f.roof_layer5_solar_absorption_rate,
            f.roof_layer5_thermal_capacity,
            f.roof_layer5_thermal_capacity_unit,
            f.roof_layer5_thermal_conductivity,
            f.roof_layer5_thermal_conductivity_unit,
            f.roof_layer5_service_life,
            f.roof_layer5_service_life_unit,
            f.roof_layer5_density,
            f.roof_layer5_density_unit,
            f.roof_layer0_epd1_oekobaudat_name,
            f.roof_layer0_epd1_oekobaudat_uuid,
            f.roof_layer0_epd2_oekobaudat_name,
            f.roof_layer0_epd2_oekobaudat_uuid,
            f.roof_layer1_epd1_oekobaudat_name,
            f.roof_layer1_epd1_oekobaudat_uuid,
            f.roof_layer1_epd2_oekobaudat_name,
            f.roof_layer1_epd2_oekobaudat_uuid,
            f.roof_layer2_epd1_oekobaudat_name,
            f.roof_layer2_epd1_oekobaudat_uuid,
            f.roof_layer2_epd2_oekobaudat_name,
            f.roof_layer2_epd2_oekobaudat_uuid,
            f.roof_layer3_epd1_oekobaudat_name,
            f.roof_layer3_epd1_oekobaudat_uuid,
            f.roof_layer3_epd2_oekobaudat_name,
            f.roof_layer3_epd2_oekobaudat_uuid,
            f.roof_layer4_epd1_oekobaudat_name,
            f.roof_layer4_epd1_oekobaudat_uuid,
            f.roof_layer4_epd2_oekobaudat_name,
            f.roof_layer4_epd2_oekobaudat_uuid,
            f.roof_layer5_epd1_oekobaudat_name,
            f.roof_layer5_epd1_oekobaudat_uuid,
            f.roof_layer5_epd2_oekobaudat_name,
            f.roof_layer5_epd2_oekobaudat_uuid,
            f.foundation_name,
            f.foundation_construction_type,
            f.foundation_u_value_typical_min,
            f.foundation_u_value_typical_max,
            f.foundation_u_value,
            f.foundation_u_value_unit,
            f.foundation_inner_radiation,
            f.foundation_inner_radiation_unit,
            f.foundation_inner_convection,
            f.foundation_inner_convection_unit,
            f.foundation_layer0_position,
            f.foundation_layer0_material_id,
            f.foundation_layer0_material_name,
            f.foundation_layer0_thickness,
            f.foundation_layer0_thickness_unit,
            f.foundation_layer0_solar_absorption_rate,
            f.foundation_layer0_thermal_capacity,
            f.foundation_layer0_thermal_capacity_unit,
            f.foundation_layer0_thermal_conductivity,
            f.foundation_layer0_thermal_conductivity_unit,
            f.foundation_layer0_service_life,
            f.foundation_layer0_service_life_unit,
            f.foundation_layer0_density,
            f.foundation_layer0_density_unit,
            f.foundation_layer1_position,
            f.foundation_layer1_material_id,
            f.foundation_layer1_material_name,
            f.foundation_layer1_thickness,
            f.foundation_layer1_thickness_unit,
            f.foundation_layer1_solar_absorption_rate,
            f.foundation_layer1_thermal_capacity,
            f.foundation_layer1_thermal_capacity_unit,
            f.foundation_layer1_thermal_conductivity,
            f.foundation_layer1_thermal_conductivity_unit,
            f.foundation_layer1_service_life,
            f.foundation_layer1_service_life_unit,
            f.foundation_layer1_density,
            f.foundation_layer1_density_unit,
            f.foundation_layer2_position,
            f.foundation_layer2_material_id,
            f.foundation_layer2_material_name,
            f.foundation_layer2_thickness,
            f.foundation_layer2_thickness_unit,
            f.foundation_layer2_solar_absorption_rate,
            f.foundation_layer2_thermal_capacity,
            f.foundation_layer2_thermal_capacity_unit,
            f.foundation_layer2_thermal_conductivity,
            f.foundation_layer2_thermal_conductivity_unit,
            f.foundation_layer2_service_life,
            f.foundation_layer2_service_life_unit,
            f.foundation_layer2_density,
            f.foundation_layer2_density_unit,
            f.foundation_layer3_position,
            f.foundation_layer3_material_id,
            f.foundation_layer3_material_name,
            f.foundation_layer3_thickness,
            f.foundation_layer3_thickness_unit,
            f.foundation_layer3_solar_absorption_rate,
            f.foundation_layer3_thermal_capacity,
            f.foundation_layer3_thermal_capacity_unit,
            f.foundation_layer3_thermal_conductivity,
            f.foundation_layer3_thermal_conductivity_unit,
            f.foundation_layer3_service_life,
            f.foundation_layer3_service_life_unit,
            f.foundation_layer3_density,
            f.foundation_layer3_density_unit,
            f.foundation_layer4_position,
            f.foundation_layer4_material_id,
            f.foundation_layer4_material_name,
            f.foundation_layer4_thickness,
            f.foundation_layer4_thickness_unit,
            f.foundation_layer4_solar_absorption_rate,
            f.foundation_layer4_thermal_capacity,
            f.foundation_layer4_thermal_capacity_unit,
            f.foundation_layer4_thermal_conductivity,
            f.foundation_layer4_thermal_conductivity_unit,
            f.foundation_layer4_service_life,
            f.foundation_layer4_service_life_unit,
            f.foundation_layer4_density,
            f.foundation_layer4_density_unit,
            f.foundation_layer5_position,
            f.foundation_layer5_material_id,
            f.foundation_layer5_material_name,
            f.foundation_layer5_thickness,
            f.foundation_layer5_thickness_unit,
            f.foundation_layer5_solar_absorption_rate,
            f.foundation_layer5_thermal_capacity,
            f.foundation_layer5_thermal_capacity_unit,
            f.foundation_layer5_thermal_conductivity,
            f.foundation_layer5_thermal_conductivity_unit,
            f.foundation_layer5_service_life,
            f.foundation_layer5_service_life_unit,
            f.foundation_layer5_density,
            f.foundation_layer5_density_unit,
            f.foundation_layer0_epd1_oekobaudat_name,
            f.foundation_layer0_epd1_oekobaudat_uuid,
            f.foundation_layer0_epd2_oekobaudat_name,
            f.foundation_layer0_epd2_oekobaudat_uuid,
            f.foundation_layer1_epd1_oekobaudat_name,
            f.foundation_layer1_epd1_oekobaudat_uuid,
            f.foundation_layer1_epd2_oekobaudat_name,
            f.foundation_layer1_epd2_oekobaudat_uuid,
            f.foundation_layer2_epd1_oekobaudat_name,
            f.foundation_layer2_epd1_oekobaudat_uuid,
            f.foundation_layer2_epd2_oekobaudat_name,
            f.foundation_layer2_epd2_oekobaudat_uuid,
            f.foundation_layer3_epd1_oekobaudat_name,
            f.foundation_layer3_epd1_oekobaudat_uuid,
            f.foundation_layer3_epd2_oekobaudat_name,
            f.foundation_layer3_epd2_oekobaudat_uuid,
            f.foundation_layer4_epd1_oekobaudat_name,
            f.foundation_layer4_epd1_oekobaudat_uuid,
            f.foundation_layer4_epd2_oekobaudat_name,
            f.foundation_layer4_epd2_oekobaudat_uuid,
            f.foundation_layer5_epd1_oekobaudat_name,
            f.foundation_layer5_epd1_oekobaudat_uuid,
            f.foundation_layer5_epd2_oekobaudat_name,
            f.foundation_layer5_epd2_oekobaudat_uuid,
            f.floor_name,
            f.floor_u_value_typical_min,
            f.floor_u_value_typical_max,
            f.floor_u_value,
            f.floor_u_value_unit,
            f.floor_inner_radiation,
            f.floor_inner_radiation_unit,
            f.floor_inner_convection,
            f.floor_inner_convection_unit,
            f.floor_layer0_position,
            f.floor_layer0_material_id,
            f.floor_layer0_material_name,
            f.floor_layer0_thickness,
            f.floor_layer0_thickness_unit,
            f.floor_layer0_solar_absorption_rate,
            f.floor_layer0_thermal_capacity,
            f.floor_layer0_thermal_capacity_unit,
            f.floor_layer0_thermal_conductivity,
            f.floor_layer0_thermal_conductivity_unit,
            f.floor_layer0_service_life,
            f.floor_layer0_service_life_unit,
            f.floor_layer0_density,
            f.floor_layer0_density_unit,
            f.floor_layer1_position,
            f.floor_layer1_material_id,
            f.floor_layer1_material_name,
            f.floor_layer1_thickness,
            f.floor_layer1_thickness_unit,
            f.floor_layer1_solar_absorption_rate,
            f.floor_layer1_thermal_capacity,
            f.floor_layer1_thermal_capacity_unit,
            f.floor_layer1_thermal_conductivity,
            f.floor_layer1_thermal_conductivity_unit,
            f.floor_layer1_service_life,
            f.floor_layer1_service_life_unit,
            f.floor_layer1_density,
            f.floor_layer1_density_unit,
            f.floor_layer2_position,
            f.floor_layer2_material_id,
            f.floor_layer2_material_name,
            f.floor_layer2_thickness,
            f.floor_layer2_thickness_unit,
            f.floor_layer2_solar_absorption_rate,
            f.floor_layer2_thermal_capacity,
            f.floor_layer2_thermal_capacity_unit,
            f.floor_layer2_thermal_conductivity,
            f.floor_layer2_thermal_conductivity_unit,
            f.floor_layer2_service_life,
            f.floor_layer2_service_life_unit,
            f.floor_layer2_density,
            f.floor_layer2_density_unit,
            epd0_1.environmental_product_declaration_name AS floor_layer0_epd1_oekobaudat_name,
            epd0_1.database_uuid AS floor_layer0_epd1_oekobaudat_uuid,
            epd0_2.environmental_product_declaration_name AS floor_layer0_epd2_oekobaudat_name,
            epd0_2.database_uuid AS floor_layer0_epd2_oekobaudat_uuid,
            epd1_1.environmental_product_declaration_name AS floor_layer1_epd1_oekobaudat_name,
            epd1_1.database_uuid AS floor_layer1_epd1_oekobaudat_uuid,
            epd1_2.environmental_product_declaration_name AS floor_layer1_epd2_oekobaudat_name,
            epd1_2.database_uuid AS floor_layer1_epd2_oekobaudat_uuid,
            epd2_1.environmental_product_declaration_name AS floor_layer2_epd1_oekobaudat_name,
            epd2_1.database_uuid AS floor_layer2_epd1_oekobaudat_uuid,
            epd2_2.environmental_product_declaration_name AS floor_layer2_epd2_oekobaudat_name,
            epd2_2.database_uuid AS floor_layer2_epd2_oekobaudat_uuid
           FROM ((((((((((((step_016 f
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = f.floor_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_1 ON ((epd0_1.environmental_product_declaration_id = bm0.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_2 ON ((epd0_2.environmental_product_declaration_id = bm0.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = f.floor_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_1 ON ((epd1_1.environmental_product_declaration_id = bm1.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_2 ON ((epd1_2.environmental_product_declaration_id = bm1.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = f.floor_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_1 ON ((epd2_1.environmental_product_declaration_id = bm2.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_2 ON ((epd2_2.environmental_product_declaration_id = bm2.environmental_product_declaration_id_2)))
        ), step_018 AS (
         SELECT b.building_archetype_id,
            b.building_archetype_name,
            b.share_of_building_type,
            b.share_of_building_type_in_region,
            b.share_of_building_type_in_region_mun,
            b.exterior_wall_building_element_id,
            b.interior_wall_building_element_id,
            b.roof_building_element_id,
            b.foundation_building_element_id,
            b.floor_building_element_id,
            b.window_building_element_id,
            b.energy_system_id,
            b.building_type_name,
            b.region_name,
            b.municipality_size_name,
            b.municipality_growth_name,
            b.age_class_name,
            b.building_adjacency_name,
            b.facade_to_net_leased_area_ratio_mean,
            b.facade_to_net_leased_area_ratio_se_min,
            b.facade_to_net_leased_area_ratio_se_max,
            b.roof_to_net_leased_area_ratio_mean,
            b.roof_to_net_leased_area_ratio_se_min,
            b.roof_to_net_leased_area_ratio_se_max,
            b.foundation_to_net_leased_area_ratio_mean,
            b.foundation_to_net_leased_area_ratio_se_min,
            b.foundation_to_net_leased_area_ratio_se_max,
            b.window_to_net_leased_area_ratio_mean,
            b.window_to_net_leased_area_ratio_se_min,
            b.window_to_net_leased_area_ratio_se_max,
            b.building_height_mean,
            b.building_height_se,
            b.height_unit,
            b.aspect_ratio_mean,
            b.aspect_ratio_se_min,
            b.aspect_ratio_se_max,
            b.storeys_below_ground_mean,
            b.storeys_below_ground_se,
            b.storeys_above_ground_mean,
            b.storeys_above_ground_se,
            b.storeys_above_ground_se_min,
            b.storeys_above_ground_se_max,
            b.storey_height_mean,
            b.storey_height_se_min,
            b.storey_height_se_max,
            b.window_share,
            b.net_leased_area_mean,
            b.net_leased_area_se,
            b.net_leased_area_se_min,
            b.net_leased_area_se_max,
            b.net_leased_area_unit,
            b.facade_area_north_mean,
            b.facade_area_north_se,
            b.facade_area_east_mean,
            b.facade_area_east_se,
            b.facade_area_south_mean,
            b.facade_area_south_se,
            b.facade_area_west_mean,
            b.facade_area_west_se,
            b.facade_area_unit,
            b.facade_length_north_mean,
            b.facade_length_north_se,
            b.facade_length_east_mean,
            b.facade_length_east_se,
            b.facade_length_south_mean,
            b.facade_length_south_se,
            b.facade_length_west_mean,
            b.facade_length_west_se,
            b.facade_length_unit,
            b.exterior_wall_name,
            b.exterior_wall_construction_type,
            b.exterior_wall_u_value_typical_min,
            b.exterior_wall_u_value_typical_max,
            b.exterior_wall_u_value,
            b.exterior_wall_u_value_unit,
            b.exterior_wall_inner_radiation,
            b.exterior_wall_inner_radiation_unit,
            b.exterior_wall_outer_radiation,
            b.exterior_wall_outer_radiation_unit,
            b.exterior_wall_inner_convection,
            b.exterior_wall_inner_convection_unit,
            b.exterior_wall_outer_convection,
            b.exterior_wall_outer_convection_unit,
            b.exterior_wall_layer0_position,
            b.exterior_wall_layer0_material_id,
            b.exterior_wall_layer0_material_name,
            b.exterior_wall_layer0_thickness,
            b.exterior_wall_layer0_thickness_unit,
            b.exterior_wall_layer0_solar_absorption_rate,
            b.exterior_wall_layer0_thermal_capacity,
            b.exterior_wall_layer0_thermal_capacity_unit,
            b.exterior_wall_layer0_thermal_conductivity,
            b.exterior_wall_layer0_thermal_conductivity_unit,
            b.exterior_wall_layer0_service_life,
            b.exterior_wall_layer0_service_life_unit,
            b.exterior_wall_layer0_density,
            b.exterior_wall_layer0_density_unit,
            b.exterior_wall_layer1_position,
            b.exterior_wall_layer1_material_id,
            b.exterior_wall_layer1_material_name,
            b.exterior_wall_layer1_thickness,
            b.exterior_wall_layer1_thickness_unit,
            b.exterior_wall_layer1_solar_absorption_rate,
            b.exterior_wall_layer1_thermal_capacity,
            b.exterior_wall_layer1_thermal_capacity_unit,
            b.exterior_wall_layer1_thermal_conductivity,
            b.exterior_wall_layer1_thermal_conductivity_unit,
            b.exterior_wall_layer1_service_life,
            b.exterior_wall_layer1_service_life_unit,
            b.exterior_wall_layer1_density,
            b.exterior_wall_layer1_density_unit,
            b.exterior_wall_layer2_position,
            b.exterior_wall_layer2_material_id,
            b.exterior_wall_layer2_material_name,
            b.exterior_wall_layer2_thickness,
            b.exterior_wall_layer2_thickness_unit,
            b.exterior_wall_layer2_solar_absorption_rate,
            b.exterior_wall_layer2_thermal_capacity,
            b.exterior_wall_layer2_thermal_capacity_unit,
            b.exterior_wall_layer2_thermal_conductivity,
            b.exterior_wall_layer2_thermal_conductivity_unit,
            b.exterior_wall_layer2_service_life,
            b.exterior_wall_layer2_service_life_unit,
            b.exterior_wall_layer2_density,
            b.exterior_wall_layer2_density_unit,
            b.exterior_wall_layer3_position,
            b.exterior_wall_layer3_material_id,
            b.exterior_wall_layer3_material_name,
            b.exterior_wall_layer3_thickness,
            b.exterior_wall_layer3_thickness_unit,
            b.exterior_wall_layer3_solar_absorption_rate,
            b.exterior_wall_layer3_thermal_capacity,
            b.exterior_wall_layer3_thermal_capacity_unit,
            b.exterior_wall_layer3_thermal_conductivity,
            b.exterior_wall_layer3_thermal_conductivity_unit,
            b.exterior_wall_layer3_service_life,
            b.exterior_wall_layer3_service_life_unit,
            b.exterior_wall_layer3_density,
            b.exterior_wall_layer3_density_unit,
            b.exterior_wall_layer4_position,
            b.exterior_wall_layer4_material_id,
            b.exterior_wall_layer4_material_name,
            b.exterior_wall_layer4_thickness,
            b.exterior_wall_layer4_thickness_unit,
            b.exterior_wall_layer4_solar_absorption_rate,
            b.exterior_wall_layer4_thermal_capacity,
            b.exterior_wall_layer4_thermal_capacity_unit,
            b.exterior_wall_layer4_thermal_conductivity,
            b.exterior_wall_layer4_thermal_conductivity_unit,
            b.exterior_wall_layer4_service_life,
            b.exterior_wall_layer4_service_life_unit,
            b.exterior_wall_layer4_density,
            b.exterior_wall_layer4_density_unit,
            b.exterior_wall_layer5_position,
            b.exterior_wall_layer5_material_id,
            b.exterior_wall_layer5_material_name,
            b.exterior_wall_layer5_thickness,
            b.exterior_wall_layer5_thickness_unit,
            b.exterior_wall_layer5_solar_absorption_rate,
            b.exterior_wall_layer5_thermal_capacity,
            b.exterior_wall_layer5_thermal_capacity_unit,
            b.exterior_wall_layer5_thermal_conductivity,
            b.exterior_wall_layer5_thermal_conductivity_unit,
            b.exterior_wall_layer5_service_life,
            b.exterior_wall_layer5_service_life_unit,
            b.exterior_wall_layer5_density,
            b.exterior_wall_layer5_density_unit,
            b.exterior_wall_layer0_epd1_oekobaudat_name,
            b.exterior_wall_layer0_epd1_oekobaudat_uuid,
            b.exterior_wall_layer0_epd2_oekobaudat_name,
            b.exterior_wall_layer0_epd2_oekobaudat_uuid,
            b.exterior_wall_layer1_epd1_oekobaudat_name,
            b.exterior_wall_layer1_epd1_oekobaudat_uuid,
            b.exterior_wall_layer1_epd2_oekobaudat_name,
            b.exterior_wall_layer1_epd2_oekobaudat_uuid,
            b.exterior_wall_layer2_epd1_oekobaudat_name,
            b.exterior_wall_layer2_epd1_oekobaudat_uuid,
            b.exterior_wall_layer2_epd2_oekobaudat_name,
            b.exterior_wall_layer2_epd2_oekobaudat_uuid,
            b.exterior_wall_layer3_epd1_oekobaudat_name,
            b.exterior_wall_layer3_epd1_oekobaudat_uuid,
            b.exterior_wall_layer3_epd2_oekobaudat_name,
            b.exterior_wall_layer3_epd2_oekobaudat_uuid,
            b.exterior_wall_layer4_epd1_oekobaudat_name,
            b.exterior_wall_layer4_epd1_oekobaudat_uuid,
            b.exterior_wall_layer4_epd2_oekobaudat_name,
            b.exterior_wall_layer4_epd2_oekobaudat_uuid,
            b.exterior_wall_layer5_epd1_oekobaudat_name,
            b.exterior_wall_layer5_epd1_oekobaudat_uuid,
            b.exterior_wall_layer5_epd2_oekobaudat_name,
            b.exterior_wall_layer5_epd2_oekobaudat_uuid,
            b.interior_wall_name,
            b.interior_wall_u_value_typical_min,
            b.interior_wall_u_value_typical_max,
            b.interior_wall_u_value,
            b.interior_wall_u_value_unit,
            b.interior_wall_inner_radiation,
            b.interior_wall_inner_radiation_unit,
            b.interior_wall_inner_convection,
            b.interior_wall_inner_convection_unit,
            b.interior_wall_layer0_position,
            b.interior_wall_layer0_material_id,
            b.interior_wall_layer0_material_name,
            b.interior_wall_layer0_thickness,
            b.interior_wall_layer0_thickness_unit,
            b.interior_wall_layer0_solar_absorption_rate,
            b.interior_wall_layer0_thermal_capacity,
            b.interior_wall_layer0_thermal_capacity_unit,
            b.interior_wall_layer0_thermal_conductivity,
            b.interior_wall_layer0_thermal_conductivity_unit,
            b.interior_wall_layer0_service_life,
            b.interior_wall_layer0_service_life_unit,
            b.interior_wall_layer0_density,
            b.interior_wall_layer0_density_unit,
            b.interior_wall_layer1_position,
            b.interior_wall_layer1_material_id,
            b.interior_wall_layer1_material_name,
            b.interior_wall_layer1_thickness,
            b.interior_wall_layer1_thickness_unit,
            b.interior_wall_layer1_solar_absorption_rate,
            b.interior_wall_layer1_thermal_capacity,
            b.interior_wall_layer1_thermal_capacity_unit,
            b.interior_wall_layer1_thermal_conductivity,
            b.interior_wall_layer1_thermal_conductivity_unit,
            b.interior_wall_layer1_service_life,
            b.interior_wall_layer1_service_life_unit,
            b.interior_wall_layer1_density,
            b.interior_wall_layer1_density_unit,
            b.interior_wall_layer2_position,
            b.interior_wall_layer2_material_id,
            b.interior_wall_layer2_material_name,
            b.interior_wall_layer2_thickness,
            b.interior_wall_layer2_thickness_unit,
            b.interior_wall_layer2_solar_absorption_rate,
            b.interior_wall_layer2_thermal_capacity,
            b.interior_wall_layer2_thermal_capacity_unit,
            b.interior_wall_layer2_thermal_conductivity,
            b.interior_wall_layer2_thermal_conductivity_unit,
            b.interior_wall_layer2_service_life,
            b.interior_wall_layer2_service_life_unit,
            b.interior_wall_layer2_density,
            b.interior_wall_layer2_density_unit,
            b.interior_wall_layer0_epd1_oekobaudat_name,
            b.interior_wall_layer0_epd1_oekobaudat_uuid,
            b.interior_wall_layer0_epd2_oekobaudat_name,
            b.interior_wall_layer0_epd2_oekobaudat_uuid,
            b.interior_wall_layer1_epd1_oekobaudat_name,
            b.interior_wall_layer1_epd1_oekobaudat_uuid,
            b.interior_wall_layer1_epd2_oekobaudat_name,
            b.interior_wall_layer1_epd2_oekobaudat_uuid,
            b.interior_wall_layer2_epd1_oekobaudat_name,
            b.interior_wall_layer2_epd1_oekobaudat_uuid,
            b.interior_wall_layer2_epd2_oekobaudat_name,
            b.interior_wall_layer2_epd2_oekobaudat_uuid,
            b.roof_name,
            b.roof_construction_type,
            b.roof_pitch_type,
            b.roof_u_value_typical_min,
            b.roof_u_value_typical_max,
            b.roof_u_value,
            b.roof_u_value_unit,
            b.roof_inner_radiation,
            b.roof_inner_radiation_unit,
            b.roof_outer_radiation,
            b.roof_outer_radiation_unit,
            b.roof_inner_convection,
            b.roof_inner_convection_unit,
            b.roof_outer_convection,
            b.roof_outer_convection_unit,
            b.roof_layer0_position,
            b.roof_layer0_material_id,
            b.roof_layer0_material_name,
            b.roof_layer0_thickness,
            b.roof_layer0_thickness_unit,
            b.roof_layer0_solar_absorption_rate,
            b.roof_layer0_thermal_capacity,
            b.roof_layer0_thermal_capacity_unit,
            b.roof_layer0_thermal_conductivity,
            b.roof_layer0_thermal_conductivity_unit,
            b.roof_layer0_service_life,
            b.roof_layer0_service_life_unit,
            b.roof_layer0_density,
            b.roof_layer0_density_unit,
            b.roof_layer1_position,
            b.roof_layer1_material_id,
            b.roof_layer1_material_name,
            b.roof_layer1_thickness,
            b.roof_layer1_thickness_unit,
            b.roof_layer1_solar_absorption_rate,
            b.roof_layer1_thermal_capacity,
            b.roof_layer1_thermal_capacity_unit,
            b.roof_layer1_thermal_conductivity,
            b.roof_layer1_thermal_conductivity_unit,
            b.roof_layer1_service_life,
            b.roof_layer1_service_life_unit,
            b.roof_layer1_density,
            b.roof_layer1_density_unit,
            b.roof_layer2_position,
            b.roof_layer2_material_id,
            b.roof_layer2_material_name,
            b.roof_layer2_thickness,
            b.roof_layer2_thickness_unit,
            b.roof_layer2_solar_absorption_rate,
            b.roof_layer2_thermal_capacity,
            b.roof_layer2_thermal_capacity_unit,
            b.roof_layer2_thermal_conductivity,
            b.roof_layer2_thermal_conductivity_unit,
            b.roof_layer2_service_life,
            b.roof_layer2_service_life_unit,
            b.roof_layer2_density,
            b.roof_layer2_density_unit,
            b.roof_layer3_position,
            b.roof_layer3_material_id,
            b.roof_layer3_material_name,
            b.roof_layer3_thickness,
            b.roof_layer3_thickness_unit,
            b.roof_layer3_solar_absorption_rate,
            b.roof_layer3_thermal_capacity,
            b.roof_layer3_thermal_capacity_unit,
            b.roof_layer3_thermal_conductivity,
            b.roof_layer3_thermal_conductivity_unit,
            b.roof_layer3_service_life,
            b.roof_layer3_service_life_unit,
            b.roof_layer3_density,
            b.roof_layer3_density_unit,
            b.roof_layer4_position,
            b.roof_layer4_material_id,
            b.roof_layer4_material_name,
            b.roof_layer4_thickness,
            b.roof_layer4_thickness_unit,
            b.roof_layer4_solar_absorption_rate,
            b.roof_layer4_thermal_capacity,
            b.roof_layer4_thermal_capacity_unit,
            b.roof_layer4_thermal_conductivity,
            b.roof_layer4_thermal_conductivity_unit,
            b.roof_layer4_service_life,
            b.roof_layer4_service_life_unit,
            b.roof_layer4_density,
            b.roof_layer4_density_unit,
            b.roof_layer5_position,
            b.roof_layer5_material_id,
            b.roof_layer5_material_name,
            b.roof_layer5_thickness,
            b.roof_layer5_thickness_unit,
            b.roof_layer5_solar_absorption_rate,
            b.roof_layer5_thermal_capacity,
            b.roof_layer5_thermal_capacity_unit,
            b.roof_layer5_thermal_conductivity,
            b.roof_layer5_thermal_conductivity_unit,
            b.roof_layer5_service_life,
            b.roof_layer5_service_life_unit,
            b.roof_layer5_density,
            b.roof_layer5_density_unit,
            b.roof_layer0_epd1_oekobaudat_name,
            b.roof_layer0_epd1_oekobaudat_uuid,
            b.roof_layer0_epd2_oekobaudat_name,
            b.roof_layer0_epd2_oekobaudat_uuid,
            b.roof_layer1_epd1_oekobaudat_name,
            b.roof_layer1_epd1_oekobaudat_uuid,
            b.roof_layer1_epd2_oekobaudat_name,
            b.roof_layer1_epd2_oekobaudat_uuid,
            b.roof_layer2_epd1_oekobaudat_name,
            b.roof_layer2_epd1_oekobaudat_uuid,
            b.roof_layer2_epd2_oekobaudat_name,
            b.roof_layer2_epd2_oekobaudat_uuid,
            b.roof_layer3_epd1_oekobaudat_name,
            b.roof_layer3_epd1_oekobaudat_uuid,
            b.roof_layer3_epd2_oekobaudat_name,
            b.roof_layer3_epd2_oekobaudat_uuid,
            b.roof_layer4_epd1_oekobaudat_name,
            b.roof_layer4_epd1_oekobaudat_uuid,
            b.roof_layer4_epd2_oekobaudat_name,
            b.roof_layer4_epd2_oekobaudat_uuid,
            b.roof_layer5_epd1_oekobaudat_name,
            b.roof_layer5_epd1_oekobaudat_uuid,
            b.roof_layer5_epd2_oekobaudat_name,
            b.roof_layer5_epd2_oekobaudat_uuid,
            b.foundation_name,
            b.foundation_construction_type,
            b.foundation_u_value_typical_min,
            b.foundation_u_value_typical_max,
            b.foundation_u_value,
            b.foundation_u_value_unit,
            b.foundation_inner_radiation,
            b.foundation_inner_radiation_unit,
            b.foundation_inner_convection,
            b.foundation_inner_convection_unit,
            b.foundation_layer0_position,
            b.foundation_layer0_material_id,
            b.foundation_layer0_material_name,
            b.foundation_layer0_thickness,
            b.foundation_layer0_thickness_unit,
            b.foundation_layer0_solar_absorption_rate,
            b.foundation_layer0_thermal_capacity,
            b.foundation_layer0_thermal_capacity_unit,
            b.foundation_layer0_thermal_conductivity,
            b.foundation_layer0_thermal_conductivity_unit,
            b.foundation_layer0_service_life,
            b.foundation_layer0_service_life_unit,
            b.foundation_layer0_density,
            b.foundation_layer0_density_unit,
            b.foundation_layer1_position,
            b.foundation_layer1_material_id,
            b.foundation_layer1_material_name,
            b.foundation_layer1_thickness,
            b.foundation_layer1_thickness_unit,
            b.foundation_layer1_solar_absorption_rate,
            b.foundation_layer1_thermal_capacity,
            b.foundation_layer1_thermal_capacity_unit,
            b.foundation_layer1_thermal_conductivity,
            b.foundation_layer1_thermal_conductivity_unit,
            b.foundation_layer1_service_life,
            b.foundation_layer1_service_life_unit,
            b.foundation_layer1_density,
            b.foundation_layer1_density_unit,
            b.foundation_layer2_position,
            b.foundation_layer2_material_id,
            b.foundation_layer2_material_name,
            b.foundation_layer2_thickness,
            b.foundation_layer2_thickness_unit,
            b.foundation_layer2_solar_absorption_rate,
            b.foundation_layer2_thermal_capacity,
            b.foundation_layer2_thermal_capacity_unit,
            b.foundation_layer2_thermal_conductivity,
            b.foundation_layer2_thermal_conductivity_unit,
            b.foundation_layer2_service_life,
            b.foundation_layer2_service_life_unit,
            b.foundation_layer2_density,
            b.foundation_layer2_density_unit,
            b.foundation_layer3_position,
            b.foundation_layer3_material_id,
            b.foundation_layer3_material_name,
            b.foundation_layer3_thickness,
            b.foundation_layer3_thickness_unit,
            b.foundation_layer3_solar_absorption_rate,
            b.foundation_layer3_thermal_capacity,
            b.foundation_layer3_thermal_capacity_unit,
            b.foundation_layer3_thermal_conductivity,
            b.foundation_layer3_thermal_conductivity_unit,
            b.foundation_layer3_service_life,
            b.foundation_layer3_service_life_unit,
            b.foundation_layer3_density,
            b.foundation_layer3_density_unit,
            b.foundation_layer4_position,
            b.foundation_layer4_material_id,
            b.foundation_layer4_material_name,
            b.foundation_layer4_thickness,
            b.foundation_layer4_thickness_unit,
            b.foundation_layer4_solar_absorption_rate,
            b.foundation_layer4_thermal_capacity,
            b.foundation_layer4_thermal_capacity_unit,
            b.foundation_layer4_thermal_conductivity,
            b.foundation_layer4_thermal_conductivity_unit,
            b.foundation_layer4_service_life,
            b.foundation_layer4_service_life_unit,
            b.foundation_layer4_density,
            b.foundation_layer4_density_unit,
            b.foundation_layer5_position,
            b.foundation_layer5_material_id,
            b.foundation_layer5_material_name,
            b.foundation_layer5_thickness,
            b.foundation_layer5_thickness_unit,
            b.foundation_layer5_solar_absorption_rate,
            b.foundation_layer5_thermal_capacity,
            b.foundation_layer5_thermal_capacity_unit,
            b.foundation_layer5_thermal_conductivity,
            b.foundation_layer5_thermal_conductivity_unit,
            b.foundation_layer5_service_life,
            b.foundation_layer5_service_life_unit,
            b.foundation_layer5_density,
            b.foundation_layer5_density_unit,
            b.foundation_layer0_epd1_oekobaudat_name,
            b.foundation_layer0_epd1_oekobaudat_uuid,
            b.foundation_layer0_epd2_oekobaudat_name,
            b.foundation_layer0_epd2_oekobaudat_uuid,
            b.foundation_layer1_epd1_oekobaudat_name,
            b.foundation_layer1_epd1_oekobaudat_uuid,
            b.foundation_layer1_epd2_oekobaudat_name,
            b.foundation_layer1_epd2_oekobaudat_uuid,
            b.foundation_layer2_epd1_oekobaudat_name,
            b.foundation_layer2_epd1_oekobaudat_uuid,
            b.foundation_layer2_epd2_oekobaudat_name,
            b.foundation_layer2_epd2_oekobaudat_uuid,
            b.foundation_layer3_epd1_oekobaudat_name,
            b.foundation_layer3_epd1_oekobaudat_uuid,
            b.foundation_layer3_epd2_oekobaudat_name,
            b.foundation_layer3_epd2_oekobaudat_uuid,
            b.foundation_layer4_epd1_oekobaudat_name,
            b.foundation_layer4_epd1_oekobaudat_uuid,
            b.foundation_layer4_epd2_oekobaudat_name,
            b.foundation_layer4_epd2_oekobaudat_uuid,
            b.foundation_layer5_epd1_oekobaudat_name,
            b.foundation_layer5_epd1_oekobaudat_uuid,
            b.foundation_layer5_epd2_oekobaudat_name,
            b.foundation_layer5_epd2_oekobaudat_uuid,
            b.floor_name,
            b.floor_u_value_typical_min,
            b.floor_u_value_typical_max,
            b.floor_u_value,
            b.floor_u_value_unit,
            b.floor_inner_radiation,
            b.floor_inner_radiation_unit,
            b.floor_inner_convection,
            b.floor_inner_convection_unit,
            b.floor_layer0_position,
            b.floor_layer0_material_id,
            b.floor_layer0_material_name,
            b.floor_layer0_thickness,
            b.floor_layer0_thickness_unit,
            b.floor_layer0_solar_absorption_rate,
            b.floor_layer0_thermal_capacity,
            b.floor_layer0_thermal_capacity_unit,
            b.floor_layer0_thermal_conductivity,
            b.floor_layer0_thermal_conductivity_unit,
            b.floor_layer0_service_life,
            b.floor_layer0_service_life_unit,
            b.floor_layer0_density,
            b.floor_layer0_density_unit,
            b.floor_layer1_position,
            b.floor_layer1_material_id,
            b.floor_layer1_material_name,
            b.floor_layer1_thickness,
            b.floor_layer1_thickness_unit,
            b.floor_layer1_solar_absorption_rate,
            b.floor_layer1_thermal_capacity,
            b.floor_layer1_thermal_capacity_unit,
            b.floor_layer1_thermal_conductivity,
            b.floor_layer1_thermal_conductivity_unit,
            b.floor_layer1_service_life,
            b.floor_layer1_service_life_unit,
            b.floor_layer1_density,
            b.floor_layer1_density_unit,
            b.floor_layer2_position,
            b.floor_layer2_material_id,
            b.floor_layer2_material_name,
            b.floor_layer2_thickness,
            b.floor_layer2_thickness_unit,
            b.floor_layer2_solar_absorption_rate,
            b.floor_layer2_thermal_capacity,
            b.floor_layer2_thermal_capacity_unit,
            b.floor_layer2_thermal_conductivity,
            b.floor_layer2_thermal_conductivity_unit,
            b.floor_layer2_service_life,
            b.floor_layer2_service_life_unit,
            b.floor_layer2_density,
            b.floor_layer2_density_unit,
            b.floor_layer0_epd1_oekobaudat_name,
            b.floor_layer0_epd1_oekobaudat_uuid,
            b.floor_layer0_epd2_oekobaudat_name,
            b.floor_layer0_epd2_oekobaudat_uuid,
            b.floor_layer1_epd1_oekobaudat_name,
            b.floor_layer1_epd1_oekobaudat_uuid,
            b.floor_layer1_epd2_oekobaudat_name,
            b.floor_layer1_epd2_oekobaudat_uuid,
            b.floor_layer2_epd1_oekobaudat_name,
            b.floor_layer2_epd1_oekobaudat_uuid,
            b.floor_layer2_epd2_oekobaudat_name,
            b.floor_layer2_epd2_oekobaudat_uuid,
            be_win.building_element_name AS window_name,
            be_win.inner_radiation AS window_inner_radiation,
            u1.unit_name AS window_inner_radiation_unit,
            be_win.outer_radiation AS window_outer_radiation,
            u2.unit_name AS window_outer_radiation_unit,
            be_win.inner_convection AS window_inner_convection,
            u3.unit_name AS window_inner_convection_unit,
            be_win.outer_convection AS window_outer_convection,
            u4.unit_name AS window_outer_convection_unit,
            w.glazing,
            w.frame_per_window,
            u_fpw.unit_name AS frame_per_window_unit,
            w.window_frame_area_share,
            w.g_value,
            w.a_conv,
            st.shading_type_name,
            wft.window_frame_type_name
           FROM (((((((((step_017 b
             LEFT JOIN hub4lca_post_simulation.building_elements be_win ON ((be_win.building_element_id = b.window_building_element_id)))
             LEFT JOIN hub4lca_post_simulation.windows w ON ((w.building_element_id = be_win.building_element_id)))
             LEFT JOIN hub4lca_post_simulation.shading_types st ON ((st.shading_type_id = w.shading_type_id)))
             LEFT JOIN hub4lca_post_simulation.window_frame_types wft ON ((wft.window_frame_type_id = w.window_frame_type_id)))
             LEFT JOIN hub4lca_post_simulation.units u_fpw ON ((u_fpw.unit_id = w.frame_per_window_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1 ON ((u1.unit_id = be_win.inner_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2 ON ((u2.unit_id = be_win.outer_radiation_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u3 ON ((u3.unit_id = be_win.inner_convection_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u4 ON ((u4.unit_id = be_win.outer_convection_unit_id)))
        ), step_019 AS (
         SELECT b.building_archetype_id,
            b.building_archetype_name,
            b.share_of_building_type,
            b.share_of_building_type_in_region,
            b.share_of_building_type_in_region_mun,
            b.exterior_wall_building_element_id,
            b.interior_wall_building_element_id,
            b.roof_building_element_id,
            b.foundation_building_element_id,
            b.floor_building_element_id,
            b.window_building_element_id,
            b.energy_system_id,
            b.building_type_name,
            b.region_name,
            b.municipality_size_name,
            b.municipality_growth_name,
            b.age_class_name,
            b.building_adjacency_name,
            b.facade_to_net_leased_area_ratio_mean,
            b.facade_to_net_leased_area_ratio_se_min,
            b.facade_to_net_leased_area_ratio_se_max,
            b.roof_to_net_leased_area_ratio_mean,
            b.roof_to_net_leased_area_ratio_se_min,
            b.roof_to_net_leased_area_ratio_se_max,
            b.foundation_to_net_leased_area_ratio_mean,
            b.foundation_to_net_leased_area_ratio_se_min,
            b.foundation_to_net_leased_area_ratio_se_max,
            b.window_to_net_leased_area_ratio_mean,
            b.window_to_net_leased_area_ratio_se_min,
            b.window_to_net_leased_area_ratio_se_max,
            b.building_height_mean,
            b.building_height_se,
            b.height_unit,
            b.aspect_ratio_mean,
            b.aspect_ratio_se_min,
            b.aspect_ratio_se_max,
            b.storeys_below_ground_mean,
            b.storeys_below_ground_se,
            b.storeys_above_ground_mean,
            b.storeys_above_ground_se,
            b.storeys_above_ground_se_min,
            b.storeys_above_ground_se_max,
            b.storey_height_mean,
            b.storey_height_se_min,
            b.storey_height_se_max,
            b.window_share,
            b.net_leased_area_mean,
            b.net_leased_area_se,
            b.net_leased_area_se_min,
            b.net_leased_area_se_max,
            b.net_leased_area_unit,
            b.facade_area_north_mean,
            b.facade_area_north_se,
            b.facade_area_east_mean,
            b.facade_area_east_se,
            b.facade_area_south_mean,
            b.facade_area_south_se,
            b.facade_area_west_mean,
            b.facade_area_west_se,
            b.facade_area_unit,
            b.facade_length_north_mean,
            b.facade_length_north_se,
            b.facade_length_east_mean,
            b.facade_length_east_se,
            b.facade_length_south_mean,
            b.facade_length_south_se,
            b.facade_length_west_mean,
            b.facade_length_west_se,
            b.facade_length_unit,
            b.exterior_wall_name,
            b.exterior_wall_construction_type,
            b.exterior_wall_u_value_typical_min,
            b.exterior_wall_u_value_typical_max,
            b.exterior_wall_u_value,
            b.exterior_wall_u_value_unit,
            b.exterior_wall_inner_radiation,
            b.exterior_wall_inner_radiation_unit,
            b.exterior_wall_outer_radiation,
            b.exterior_wall_outer_radiation_unit,
            b.exterior_wall_inner_convection,
            b.exterior_wall_inner_convection_unit,
            b.exterior_wall_outer_convection,
            b.exterior_wall_outer_convection_unit,
            b.exterior_wall_layer0_position,
            b.exterior_wall_layer0_material_id,
            b.exterior_wall_layer0_material_name,
            b.exterior_wall_layer0_thickness,
            b.exterior_wall_layer0_thickness_unit,
            b.exterior_wall_layer0_solar_absorption_rate,
            b.exterior_wall_layer0_thermal_capacity,
            b.exterior_wall_layer0_thermal_capacity_unit,
            b.exterior_wall_layer0_thermal_conductivity,
            b.exterior_wall_layer0_thermal_conductivity_unit,
            b.exterior_wall_layer0_service_life,
            b.exterior_wall_layer0_service_life_unit,
            b.exterior_wall_layer0_density,
            b.exterior_wall_layer0_density_unit,
            b.exterior_wall_layer1_position,
            b.exterior_wall_layer1_material_id,
            b.exterior_wall_layer1_material_name,
            b.exterior_wall_layer1_thickness,
            b.exterior_wall_layer1_thickness_unit,
            b.exterior_wall_layer1_solar_absorption_rate,
            b.exterior_wall_layer1_thermal_capacity,
            b.exterior_wall_layer1_thermal_capacity_unit,
            b.exterior_wall_layer1_thermal_conductivity,
            b.exterior_wall_layer1_thermal_conductivity_unit,
            b.exterior_wall_layer1_service_life,
            b.exterior_wall_layer1_service_life_unit,
            b.exterior_wall_layer1_density,
            b.exterior_wall_layer1_density_unit,
            b.exterior_wall_layer2_position,
            b.exterior_wall_layer2_material_id,
            b.exterior_wall_layer2_material_name,
            b.exterior_wall_layer2_thickness,
            b.exterior_wall_layer2_thickness_unit,
            b.exterior_wall_layer2_solar_absorption_rate,
            b.exterior_wall_layer2_thermal_capacity,
            b.exterior_wall_layer2_thermal_capacity_unit,
            b.exterior_wall_layer2_thermal_conductivity,
            b.exterior_wall_layer2_thermal_conductivity_unit,
            b.exterior_wall_layer2_service_life,
            b.exterior_wall_layer2_service_life_unit,
            b.exterior_wall_layer2_density,
            b.exterior_wall_layer2_density_unit,
            b.exterior_wall_layer3_position,
            b.exterior_wall_layer3_material_id,
            b.exterior_wall_layer3_material_name,
            b.exterior_wall_layer3_thickness,
            b.exterior_wall_layer3_thickness_unit,
            b.exterior_wall_layer3_solar_absorption_rate,
            b.exterior_wall_layer3_thermal_capacity,
            b.exterior_wall_layer3_thermal_capacity_unit,
            b.exterior_wall_layer3_thermal_conductivity,
            b.exterior_wall_layer3_thermal_conductivity_unit,
            b.exterior_wall_layer3_service_life,
            b.exterior_wall_layer3_service_life_unit,
            b.exterior_wall_layer3_density,
            b.exterior_wall_layer3_density_unit,
            b.exterior_wall_layer4_position,
            b.exterior_wall_layer4_material_id,
            b.exterior_wall_layer4_material_name,
            b.exterior_wall_layer4_thickness,
            b.exterior_wall_layer4_thickness_unit,
            b.exterior_wall_layer4_solar_absorption_rate,
            b.exterior_wall_layer4_thermal_capacity,
            b.exterior_wall_layer4_thermal_capacity_unit,
            b.exterior_wall_layer4_thermal_conductivity,
            b.exterior_wall_layer4_thermal_conductivity_unit,
            b.exterior_wall_layer4_service_life,
            b.exterior_wall_layer4_service_life_unit,
            b.exterior_wall_layer4_density,
            b.exterior_wall_layer4_density_unit,
            b.exterior_wall_layer5_position,
            b.exterior_wall_layer5_material_id,
            b.exterior_wall_layer5_material_name,
            b.exterior_wall_layer5_thickness,
            b.exterior_wall_layer5_thickness_unit,
            b.exterior_wall_layer5_solar_absorption_rate,
            b.exterior_wall_layer5_thermal_capacity,
            b.exterior_wall_layer5_thermal_capacity_unit,
            b.exterior_wall_layer5_thermal_conductivity,
            b.exterior_wall_layer5_thermal_conductivity_unit,
            b.exterior_wall_layer5_service_life,
            b.exterior_wall_layer5_service_life_unit,
            b.exterior_wall_layer5_density,
            b.exterior_wall_layer5_density_unit,
            b.exterior_wall_layer0_epd1_oekobaudat_name,
            b.exterior_wall_layer0_epd1_oekobaudat_uuid,
            b.exterior_wall_layer0_epd2_oekobaudat_name,
            b.exterior_wall_layer0_epd2_oekobaudat_uuid,
            b.exterior_wall_layer1_epd1_oekobaudat_name,
            b.exterior_wall_layer1_epd1_oekobaudat_uuid,
            b.exterior_wall_layer1_epd2_oekobaudat_name,
            b.exterior_wall_layer1_epd2_oekobaudat_uuid,
            b.exterior_wall_layer2_epd1_oekobaudat_name,
            b.exterior_wall_layer2_epd1_oekobaudat_uuid,
            b.exterior_wall_layer2_epd2_oekobaudat_name,
            b.exterior_wall_layer2_epd2_oekobaudat_uuid,
            b.exterior_wall_layer3_epd1_oekobaudat_name,
            b.exterior_wall_layer3_epd1_oekobaudat_uuid,
            b.exterior_wall_layer3_epd2_oekobaudat_name,
            b.exterior_wall_layer3_epd2_oekobaudat_uuid,
            b.exterior_wall_layer4_epd1_oekobaudat_name,
            b.exterior_wall_layer4_epd1_oekobaudat_uuid,
            b.exterior_wall_layer4_epd2_oekobaudat_name,
            b.exterior_wall_layer4_epd2_oekobaudat_uuid,
            b.exterior_wall_layer5_epd1_oekobaudat_name,
            b.exterior_wall_layer5_epd1_oekobaudat_uuid,
            b.exterior_wall_layer5_epd2_oekobaudat_name,
            b.exterior_wall_layer5_epd2_oekobaudat_uuid,
            b.interior_wall_name,
            b.interior_wall_u_value_typical_min,
            b.interior_wall_u_value_typical_max,
            b.interior_wall_u_value,
            b.interior_wall_u_value_unit,
            b.interior_wall_inner_radiation,
            b.interior_wall_inner_radiation_unit,
            b.interior_wall_inner_convection,
            b.interior_wall_inner_convection_unit,
            b.interior_wall_layer0_position,
            b.interior_wall_layer0_material_id,
            b.interior_wall_layer0_material_name,
            b.interior_wall_layer0_thickness,
            b.interior_wall_layer0_thickness_unit,
            b.interior_wall_layer0_solar_absorption_rate,
            b.interior_wall_layer0_thermal_capacity,
            b.interior_wall_layer0_thermal_capacity_unit,
            b.interior_wall_layer0_thermal_conductivity,
            b.interior_wall_layer0_thermal_conductivity_unit,
            b.interior_wall_layer0_service_life,
            b.interior_wall_layer0_service_life_unit,
            b.interior_wall_layer0_density,
            b.interior_wall_layer0_density_unit,
            b.interior_wall_layer1_position,
            b.interior_wall_layer1_material_id,
            b.interior_wall_layer1_material_name,
            b.interior_wall_layer1_thickness,
            b.interior_wall_layer1_thickness_unit,
            b.interior_wall_layer1_solar_absorption_rate,
            b.interior_wall_layer1_thermal_capacity,
            b.interior_wall_layer1_thermal_capacity_unit,
            b.interior_wall_layer1_thermal_conductivity,
            b.interior_wall_layer1_thermal_conductivity_unit,
            b.interior_wall_layer1_service_life,
            b.interior_wall_layer1_service_life_unit,
            b.interior_wall_layer1_density,
            b.interior_wall_layer1_density_unit,
            b.interior_wall_layer2_position,
            b.interior_wall_layer2_material_id,
            b.interior_wall_layer2_material_name,
            b.interior_wall_layer2_thickness,
            b.interior_wall_layer2_thickness_unit,
            b.interior_wall_layer2_solar_absorption_rate,
            b.interior_wall_layer2_thermal_capacity,
            b.interior_wall_layer2_thermal_capacity_unit,
            b.interior_wall_layer2_thermal_conductivity,
            b.interior_wall_layer2_thermal_conductivity_unit,
            b.interior_wall_layer2_service_life,
            b.interior_wall_layer2_service_life_unit,
            b.interior_wall_layer2_density,
            b.interior_wall_layer2_density_unit,
            b.interior_wall_layer0_epd1_oekobaudat_name,
            b.interior_wall_layer0_epd1_oekobaudat_uuid,
            b.interior_wall_layer0_epd2_oekobaudat_name,
            b.interior_wall_layer0_epd2_oekobaudat_uuid,
            b.interior_wall_layer1_epd1_oekobaudat_name,
            b.interior_wall_layer1_epd1_oekobaudat_uuid,
            b.interior_wall_layer1_epd2_oekobaudat_name,
            b.interior_wall_layer1_epd2_oekobaudat_uuid,
            b.interior_wall_layer2_epd1_oekobaudat_name,
            b.interior_wall_layer2_epd1_oekobaudat_uuid,
            b.interior_wall_layer2_epd2_oekobaudat_name,
            b.interior_wall_layer2_epd2_oekobaudat_uuid,
            b.roof_name,
            b.roof_construction_type,
            b.roof_pitch_type,
            b.roof_u_value_typical_min,
            b.roof_u_value_typical_max,
            b.roof_u_value,
            b.roof_u_value_unit,
            b.roof_inner_radiation,
            b.roof_inner_radiation_unit,
            b.roof_outer_radiation,
            b.roof_outer_radiation_unit,
            b.roof_inner_convection,
            b.roof_inner_convection_unit,
            b.roof_outer_convection,
            b.roof_outer_convection_unit,
            b.roof_layer0_position,
            b.roof_layer0_material_id,
            b.roof_layer0_material_name,
            b.roof_layer0_thickness,
            b.roof_layer0_thickness_unit,
            b.roof_layer0_solar_absorption_rate,
            b.roof_layer0_thermal_capacity,
            b.roof_layer0_thermal_capacity_unit,
            b.roof_layer0_thermal_conductivity,
            b.roof_layer0_thermal_conductivity_unit,
            b.roof_layer0_service_life,
            b.roof_layer0_service_life_unit,
            b.roof_layer0_density,
            b.roof_layer0_density_unit,
            b.roof_layer1_position,
            b.roof_layer1_material_id,
            b.roof_layer1_material_name,
            b.roof_layer1_thickness,
            b.roof_layer1_thickness_unit,
            b.roof_layer1_solar_absorption_rate,
            b.roof_layer1_thermal_capacity,
            b.roof_layer1_thermal_capacity_unit,
            b.roof_layer1_thermal_conductivity,
            b.roof_layer1_thermal_conductivity_unit,
            b.roof_layer1_service_life,
            b.roof_layer1_service_life_unit,
            b.roof_layer1_density,
            b.roof_layer1_density_unit,
            b.roof_layer2_position,
            b.roof_layer2_material_id,
            b.roof_layer2_material_name,
            b.roof_layer2_thickness,
            b.roof_layer2_thickness_unit,
            b.roof_layer2_solar_absorption_rate,
            b.roof_layer2_thermal_capacity,
            b.roof_layer2_thermal_capacity_unit,
            b.roof_layer2_thermal_conductivity,
            b.roof_layer2_thermal_conductivity_unit,
            b.roof_layer2_service_life,
            b.roof_layer2_service_life_unit,
            b.roof_layer2_density,
            b.roof_layer2_density_unit,
            b.roof_layer3_position,
            b.roof_layer3_material_id,
            b.roof_layer3_material_name,
            b.roof_layer3_thickness,
            b.roof_layer3_thickness_unit,
            b.roof_layer3_solar_absorption_rate,
            b.roof_layer3_thermal_capacity,
            b.roof_layer3_thermal_capacity_unit,
            b.roof_layer3_thermal_conductivity,
            b.roof_layer3_thermal_conductivity_unit,
            b.roof_layer3_service_life,
            b.roof_layer3_service_life_unit,
            b.roof_layer3_density,
            b.roof_layer3_density_unit,
            b.roof_layer4_position,
            b.roof_layer4_material_id,
            b.roof_layer4_material_name,
            b.roof_layer4_thickness,
            b.roof_layer4_thickness_unit,
            b.roof_layer4_solar_absorption_rate,
            b.roof_layer4_thermal_capacity,
            b.roof_layer4_thermal_capacity_unit,
            b.roof_layer4_thermal_conductivity,
            b.roof_layer4_thermal_conductivity_unit,
            b.roof_layer4_service_life,
            b.roof_layer4_service_life_unit,
            b.roof_layer4_density,
            b.roof_layer4_density_unit,
            b.roof_layer5_position,
            b.roof_layer5_material_id,
            b.roof_layer5_material_name,
            b.roof_layer5_thickness,
            b.roof_layer5_thickness_unit,
            b.roof_layer5_solar_absorption_rate,
            b.roof_layer5_thermal_capacity,
            b.roof_layer5_thermal_capacity_unit,
            b.roof_layer5_thermal_conductivity,
            b.roof_layer5_thermal_conductivity_unit,
            b.roof_layer5_service_life,
            b.roof_layer5_service_life_unit,
            b.roof_layer5_density,
            b.roof_layer5_density_unit,
            b.roof_layer0_epd1_oekobaudat_name,
            b.roof_layer0_epd1_oekobaudat_uuid,
            b.roof_layer0_epd2_oekobaudat_name,
            b.roof_layer0_epd2_oekobaudat_uuid,
            b.roof_layer1_epd1_oekobaudat_name,
            b.roof_layer1_epd1_oekobaudat_uuid,
            b.roof_layer1_epd2_oekobaudat_name,
            b.roof_layer1_epd2_oekobaudat_uuid,
            b.roof_layer2_epd1_oekobaudat_name,
            b.roof_layer2_epd1_oekobaudat_uuid,
            b.roof_layer2_epd2_oekobaudat_name,
            b.roof_layer2_epd2_oekobaudat_uuid,
            b.roof_layer3_epd1_oekobaudat_name,
            b.roof_layer3_epd1_oekobaudat_uuid,
            b.roof_layer3_epd2_oekobaudat_name,
            b.roof_layer3_epd2_oekobaudat_uuid,
            b.roof_layer4_epd1_oekobaudat_name,
            b.roof_layer4_epd1_oekobaudat_uuid,
            b.roof_layer4_epd2_oekobaudat_name,
            b.roof_layer4_epd2_oekobaudat_uuid,
            b.roof_layer5_epd1_oekobaudat_name,
            b.roof_layer5_epd1_oekobaudat_uuid,
            b.roof_layer5_epd2_oekobaudat_name,
            b.roof_layer5_epd2_oekobaudat_uuid,
            b.foundation_name,
            b.foundation_construction_type,
            b.foundation_u_value_typical_min,
            b.foundation_u_value_typical_max,
            b.foundation_u_value,
            b.foundation_u_value_unit,
            b.foundation_inner_radiation,
            b.foundation_inner_radiation_unit,
            b.foundation_inner_convection,
            b.foundation_inner_convection_unit,
            b.foundation_layer0_position,
            b.foundation_layer0_material_id,
            b.foundation_layer0_material_name,
            b.foundation_layer0_thickness,
            b.foundation_layer0_thickness_unit,
            b.foundation_layer0_solar_absorption_rate,
            b.foundation_layer0_thermal_capacity,
            b.foundation_layer0_thermal_capacity_unit,
            b.foundation_layer0_thermal_conductivity,
            b.foundation_layer0_thermal_conductivity_unit,
            b.foundation_layer0_service_life,
            b.foundation_layer0_service_life_unit,
            b.foundation_layer0_density,
            b.foundation_layer0_density_unit,
            b.foundation_layer1_position,
            b.foundation_layer1_material_id,
            b.foundation_layer1_material_name,
            b.foundation_layer1_thickness,
            b.foundation_layer1_thickness_unit,
            b.foundation_layer1_solar_absorption_rate,
            b.foundation_layer1_thermal_capacity,
            b.foundation_layer1_thermal_capacity_unit,
            b.foundation_layer1_thermal_conductivity,
            b.foundation_layer1_thermal_conductivity_unit,
            b.foundation_layer1_service_life,
            b.foundation_layer1_service_life_unit,
            b.foundation_layer1_density,
            b.foundation_layer1_density_unit,
            b.foundation_layer2_position,
            b.foundation_layer2_material_id,
            b.foundation_layer2_material_name,
            b.foundation_layer2_thickness,
            b.foundation_layer2_thickness_unit,
            b.foundation_layer2_solar_absorption_rate,
            b.foundation_layer2_thermal_capacity,
            b.foundation_layer2_thermal_capacity_unit,
            b.foundation_layer2_thermal_conductivity,
            b.foundation_layer2_thermal_conductivity_unit,
            b.foundation_layer2_service_life,
            b.foundation_layer2_service_life_unit,
            b.foundation_layer2_density,
            b.foundation_layer2_density_unit,
            b.foundation_layer3_position,
            b.foundation_layer3_material_id,
            b.foundation_layer3_material_name,
            b.foundation_layer3_thickness,
            b.foundation_layer3_thickness_unit,
            b.foundation_layer3_solar_absorption_rate,
            b.foundation_layer3_thermal_capacity,
            b.foundation_layer3_thermal_capacity_unit,
            b.foundation_layer3_thermal_conductivity,
            b.foundation_layer3_thermal_conductivity_unit,
            b.foundation_layer3_service_life,
            b.foundation_layer3_service_life_unit,
            b.foundation_layer3_density,
            b.foundation_layer3_density_unit,
            b.foundation_layer4_position,
            b.foundation_layer4_material_id,
            b.foundation_layer4_material_name,
            b.foundation_layer4_thickness,
            b.foundation_layer4_thickness_unit,
            b.foundation_layer4_solar_absorption_rate,
            b.foundation_layer4_thermal_capacity,
            b.foundation_layer4_thermal_capacity_unit,
            b.foundation_layer4_thermal_conductivity,
            b.foundation_layer4_thermal_conductivity_unit,
            b.foundation_layer4_service_life,
            b.foundation_layer4_service_life_unit,
            b.foundation_layer4_density,
            b.foundation_layer4_density_unit,
            b.foundation_layer5_position,
            b.foundation_layer5_material_id,
            b.foundation_layer5_material_name,
            b.foundation_layer5_thickness,
            b.foundation_layer5_thickness_unit,
            b.foundation_layer5_solar_absorption_rate,
            b.foundation_layer5_thermal_capacity,
            b.foundation_layer5_thermal_capacity_unit,
            b.foundation_layer5_thermal_conductivity,
            b.foundation_layer5_thermal_conductivity_unit,
            b.foundation_layer5_service_life,
            b.foundation_layer5_service_life_unit,
            b.foundation_layer5_density,
            b.foundation_layer5_density_unit,
            b.foundation_layer0_epd1_oekobaudat_name,
            b.foundation_layer0_epd1_oekobaudat_uuid,
            b.foundation_layer0_epd2_oekobaudat_name,
            b.foundation_layer0_epd2_oekobaudat_uuid,
            b.foundation_layer1_epd1_oekobaudat_name,
            b.foundation_layer1_epd1_oekobaudat_uuid,
            b.foundation_layer1_epd2_oekobaudat_name,
            b.foundation_layer1_epd2_oekobaudat_uuid,
            b.foundation_layer2_epd1_oekobaudat_name,
            b.foundation_layer2_epd1_oekobaudat_uuid,
            b.foundation_layer2_epd2_oekobaudat_name,
            b.foundation_layer2_epd2_oekobaudat_uuid,
            b.foundation_layer3_epd1_oekobaudat_name,
            b.foundation_layer3_epd1_oekobaudat_uuid,
            b.foundation_layer3_epd2_oekobaudat_name,
            b.foundation_layer3_epd2_oekobaudat_uuid,
            b.foundation_layer4_epd1_oekobaudat_name,
            b.foundation_layer4_epd1_oekobaudat_uuid,
            b.foundation_layer4_epd2_oekobaudat_name,
            b.foundation_layer4_epd2_oekobaudat_uuid,
            b.foundation_layer5_epd1_oekobaudat_name,
            b.foundation_layer5_epd1_oekobaudat_uuid,
            b.foundation_layer5_epd2_oekobaudat_name,
            b.foundation_layer5_epd2_oekobaudat_uuid,
            b.floor_name,
            b.floor_u_value_typical_min,
            b.floor_u_value_typical_max,
            b.floor_u_value,
            b.floor_u_value_unit,
            b.floor_inner_radiation,
            b.floor_inner_radiation_unit,
            b.floor_inner_convection,
            b.floor_inner_convection_unit,
            b.floor_layer0_position,
            b.floor_layer0_material_id,
            b.floor_layer0_material_name,
            b.floor_layer0_thickness,
            b.floor_layer0_thickness_unit,
            b.floor_layer0_solar_absorption_rate,
            b.floor_layer0_thermal_capacity,
            b.floor_layer0_thermal_capacity_unit,
            b.floor_layer0_thermal_conductivity,
            b.floor_layer0_thermal_conductivity_unit,
            b.floor_layer0_service_life,
            b.floor_layer0_service_life_unit,
            b.floor_layer0_density,
            b.floor_layer0_density_unit,
            b.floor_layer1_position,
            b.floor_layer1_material_id,
            b.floor_layer1_material_name,
            b.floor_layer1_thickness,
            b.floor_layer1_thickness_unit,
            b.floor_layer1_solar_absorption_rate,
            b.floor_layer1_thermal_capacity,
            b.floor_layer1_thermal_capacity_unit,
            b.floor_layer1_thermal_conductivity,
            b.floor_layer1_thermal_conductivity_unit,
            b.floor_layer1_service_life,
            b.floor_layer1_service_life_unit,
            b.floor_layer1_density,
            b.floor_layer1_density_unit,
            b.floor_layer2_position,
            b.floor_layer2_material_id,
            b.floor_layer2_material_name,
            b.floor_layer2_thickness,
            b.floor_layer2_thickness_unit,
            b.floor_layer2_solar_absorption_rate,
            b.floor_layer2_thermal_capacity,
            b.floor_layer2_thermal_capacity_unit,
            b.floor_layer2_thermal_conductivity,
            b.floor_layer2_thermal_conductivity_unit,
            b.floor_layer2_service_life,
            b.floor_layer2_service_life_unit,
            b.floor_layer2_density,
            b.floor_layer2_density_unit,
            b.floor_layer0_epd1_oekobaudat_name,
            b.floor_layer0_epd1_oekobaudat_uuid,
            b.floor_layer0_epd2_oekobaudat_name,
            b.floor_layer0_epd2_oekobaudat_uuid,
            b.floor_layer1_epd1_oekobaudat_name,
            b.floor_layer1_epd1_oekobaudat_uuid,
            b.floor_layer1_epd2_oekobaudat_name,
            b.floor_layer1_epd2_oekobaudat_uuid,
            b.floor_layer2_epd1_oekobaudat_name,
            b.floor_layer2_epd1_oekobaudat_uuid,
            b.floor_layer2_epd2_oekobaudat_name,
            b.floor_layer2_epd2_oekobaudat_uuid,
            b.window_name,
            b.window_inner_radiation,
            b.window_inner_radiation_unit,
            b.window_outer_radiation,
            b.window_outer_radiation_unit,
            b.window_inner_convection,
            b.window_inner_convection_unit,
            b.window_outer_convection,
            b.window_outer_convection_unit,
            b.glazing,
            b.frame_per_window,
            b.frame_per_window_unit,
            b.window_frame_area_share,
            b.g_value,
            b.a_conv,
            b.shading_type_name,
            b.window_frame_type_name,
            l0."position" AS window_layer0_position,
            l0.building_material_id AS window_layer0_material_id,
            bm0.building_material_name AS window_layer0_material_name,
            l0.thickness AS window_layer0_thickness,
            u0_th.unit_name AS window_layer0_thickness_unit,
            bm0.solar_absorption_rate AS window_layer0_solar_absorption_rate,
            bm0.thermal_capacity AS window_layer0_thermal_capacity,
            u0_tc.unit_name AS window_layer0_thermal_capacity_unit,
            bm0.thermal_conductivity AS window_layer0_thermal_conductivity,
            u0_tco.unit_name AS window_layer0_thermal_conductivity_unit,
            sl0.service_life AS window_layer0_service_life,
            u0_sl.unit_name AS window_layer0_service_life_unit,
            l1."position" AS window_layer1_position,
            l1.building_material_id AS window_layer1_material_id,
            bm1.building_material_name AS window_layer1_material_name,
            l1.thickness AS window_layer1_thickness,
            u1_th.unit_name AS window_layer1_thickness_unit,
            bm1.solar_absorption_rate AS window_layer1_solar_absorption_rate,
            bm1.thermal_capacity AS window_layer1_thermal_capacity,
            u1_tc.unit_name AS window_layer1_thermal_capacity_unit,
            bm1.thermal_conductivity AS window_layer1_thermal_conductivity,
            u1_tco.unit_name AS window_layer1_thermal_conductivity_unit,
            sl1.service_life AS window_layer1_service_life,
            u1_sl.unit_name AS window_layer1_service_life_unit,
            l2."position" AS window_layer2_position,
            l2.building_material_id AS window_layer2_material_id,
            bm2.building_material_name AS window_layer2_material_name,
            l2.thickness AS window_layer2_thickness,
            u2_th.unit_name AS window_layer2_thickness_unit,
            bm2.solar_absorption_rate AS window_layer2_solar_absorption_rate,
            bm2.thermal_capacity AS window_layer2_thermal_capacity,
            u2_tc.unit_name AS window_layer2_thermal_capacity_unit,
            bm2.thermal_conductivity AS window_layer2_thermal_conductivity,
            u2_tco.unit_name AS window_layer2_thermal_conductivity_unit,
            sl2.service_life AS window_layer2_service_life,
            u2_sl.unit_name AS window_layer2_service_life_unit
           FROM (((((((((((((((((((((step_018 b
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = b.window_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_th ON ((u0_th.unit_id = l0.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tc ON ((u0_tc.unit_id = bm0.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_tco ON ((u0_tco.unit_id = bm0.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl0 ON ((sl0.service_life_id = bm0.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u0_sl ON ((u0_sl.unit_id = sl0.unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = b.window_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_th ON ((u1_th.unit_id = l1.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tc ON ((u1_tc.unit_id = bm1.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_tco ON ((u1_tco.unit_id = bm1.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl1 ON ((sl1.service_life_id = bm1.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u1_sl ON ((u1_sl.unit_id = sl1.unit_id)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = b.window_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_th ON ((u2_th.unit_id = l2.thickness_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tc ON ((u2_tc.unit_id = bm2.thermal_capacity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_tco ON ((u2_tco.unit_id = bm2.thermal_conductivity_unit_id)))
             LEFT JOIN hub4lca_post_simulation.service_lives sl2 ON ((sl2.service_life_id = bm2.service_life_id)))
             LEFT JOIN hub4lca_post_simulation.units u2_sl ON ((u2_sl.unit_id = sl2.unit_id)))
        ), step_020 AS (
         SELECT f.building_archetype_id,
            f.building_archetype_name,
            f.share_of_building_type,
            f.share_of_building_type_in_region,
            f.share_of_building_type_in_region_mun,
            f.exterior_wall_building_element_id,
            f.interior_wall_building_element_id,
            f.roof_building_element_id,
            f.foundation_building_element_id,
            f.floor_building_element_id,
            f.window_building_element_id,
            f.energy_system_id,
            f.building_type_name,
            f.region_name,
            f.municipality_size_name,
            f.municipality_growth_name,
            f.age_class_name,
            f.building_adjacency_name,
            f.facade_to_net_leased_area_ratio_mean,
            f.facade_to_net_leased_area_ratio_se_min,
            f.facade_to_net_leased_area_ratio_se_max,
            f.roof_to_net_leased_area_ratio_mean,
            f.roof_to_net_leased_area_ratio_se_min,
            f.roof_to_net_leased_area_ratio_se_max,
            f.foundation_to_net_leased_area_ratio_mean,
            f.foundation_to_net_leased_area_ratio_se_min,
            f.foundation_to_net_leased_area_ratio_se_max,
            f.window_to_net_leased_area_ratio_mean,
            f.window_to_net_leased_area_ratio_se_min,
            f.window_to_net_leased_area_ratio_se_max,
            f.building_height_mean,
            f.building_height_se,
            f.height_unit,
            f.aspect_ratio_mean,
            f.aspect_ratio_se_min,
            f.aspect_ratio_se_max,
            f.storeys_below_ground_mean,
            f.storeys_below_ground_se,
            f.storeys_above_ground_mean,
            f.storeys_above_ground_se,
            f.storeys_above_ground_se_min,
            f.storeys_above_ground_se_max,
            f.storey_height_mean,
            f.storey_height_se_min,
            f.storey_height_se_max,
            f.window_share,
            f.net_leased_area_mean,
            f.net_leased_area_se,
            f.net_leased_area_se_min,
            f.net_leased_area_se_max,
            f.net_leased_area_unit,
            f.facade_area_north_mean,
            f.facade_area_north_se,
            f.facade_area_east_mean,
            f.facade_area_east_se,
            f.facade_area_south_mean,
            f.facade_area_south_se,
            f.facade_area_west_mean,
            f.facade_area_west_se,
            f.facade_area_unit,
            f.facade_length_north_mean,
            f.facade_length_north_se,
            f.facade_length_east_mean,
            f.facade_length_east_se,
            f.facade_length_south_mean,
            f.facade_length_south_se,
            f.facade_length_west_mean,
            f.facade_length_west_se,
            f.facade_length_unit,
            f.exterior_wall_name,
            f.exterior_wall_construction_type,
            f.exterior_wall_u_value_typical_min,
            f.exterior_wall_u_value_typical_max,
            f.exterior_wall_u_value,
            f.exterior_wall_u_value_unit,
            f.exterior_wall_inner_radiation,
            f.exterior_wall_inner_radiation_unit,
            f.exterior_wall_outer_radiation,
            f.exterior_wall_outer_radiation_unit,
            f.exterior_wall_inner_convection,
            f.exterior_wall_inner_convection_unit,
            f.exterior_wall_outer_convection,
            f.exterior_wall_outer_convection_unit,
            f.exterior_wall_layer0_position,
            f.exterior_wall_layer0_material_id,
            f.exterior_wall_layer0_material_name,
            f.exterior_wall_layer0_thickness,
            f.exterior_wall_layer0_thickness_unit,
            f.exterior_wall_layer0_solar_absorption_rate,
            f.exterior_wall_layer0_thermal_capacity,
            f.exterior_wall_layer0_thermal_capacity_unit,
            f.exterior_wall_layer0_thermal_conductivity,
            f.exterior_wall_layer0_thermal_conductivity_unit,
            f.exterior_wall_layer0_service_life,
            f.exterior_wall_layer0_service_life_unit,
            f.exterior_wall_layer0_density,
            f.exterior_wall_layer0_density_unit,
            f.exterior_wall_layer1_position,
            f.exterior_wall_layer1_material_id,
            f.exterior_wall_layer1_material_name,
            f.exterior_wall_layer1_thickness,
            f.exterior_wall_layer1_thickness_unit,
            f.exterior_wall_layer1_solar_absorption_rate,
            f.exterior_wall_layer1_thermal_capacity,
            f.exterior_wall_layer1_thermal_capacity_unit,
            f.exterior_wall_layer1_thermal_conductivity,
            f.exterior_wall_layer1_thermal_conductivity_unit,
            f.exterior_wall_layer1_service_life,
            f.exterior_wall_layer1_service_life_unit,
            f.exterior_wall_layer1_density,
            f.exterior_wall_layer1_density_unit,
            f.exterior_wall_layer2_position,
            f.exterior_wall_layer2_material_id,
            f.exterior_wall_layer2_material_name,
            f.exterior_wall_layer2_thickness,
            f.exterior_wall_layer2_thickness_unit,
            f.exterior_wall_layer2_solar_absorption_rate,
            f.exterior_wall_layer2_thermal_capacity,
            f.exterior_wall_layer2_thermal_capacity_unit,
            f.exterior_wall_layer2_thermal_conductivity,
            f.exterior_wall_layer2_thermal_conductivity_unit,
            f.exterior_wall_layer2_service_life,
            f.exterior_wall_layer2_service_life_unit,
            f.exterior_wall_layer2_density,
            f.exterior_wall_layer2_density_unit,
            f.exterior_wall_layer3_position,
            f.exterior_wall_layer3_material_id,
            f.exterior_wall_layer3_material_name,
            f.exterior_wall_layer3_thickness,
            f.exterior_wall_layer3_thickness_unit,
            f.exterior_wall_layer3_solar_absorption_rate,
            f.exterior_wall_layer3_thermal_capacity,
            f.exterior_wall_layer3_thermal_capacity_unit,
            f.exterior_wall_layer3_thermal_conductivity,
            f.exterior_wall_layer3_thermal_conductivity_unit,
            f.exterior_wall_layer3_service_life,
            f.exterior_wall_layer3_service_life_unit,
            f.exterior_wall_layer3_density,
            f.exterior_wall_layer3_density_unit,
            f.exterior_wall_layer4_position,
            f.exterior_wall_layer4_material_id,
            f.exterior_wall_layer4_material_name,
            f.exterior_wall_layer4_thickness,
            f.exterior_wall_layer4_thickness_unit,
            f.exterior_wall_layer4_solar_absorption_rate,
            f.exterior_wall_layer4_thermal_capacity,
            f.exterior_wall_layer4_thermal_capacity_unit,
            f.exterior_wall_layer4_thermal_conductivity,
            f.exterior_wall_layer4_thermal_conductivity_unit,
            f.exterior_wall_layer4_service_life,
            f.exterior_wall_layer4_service_life_unit,
            f.exterior_wall_layer4_density,
            f.exterior_wall_layer4_density_unit,
            f.exterior_wall_layer5_position,
            f.exterior_wall_layer5_material_id,
            f.exterior_wall_layer5_material_name,
            f.exterior_wall_layer5_thickness,
            f.exterior_wall_layer5_thickness_unit,
            f.exterior_wall_layer5_solar_absorption_rate,
            f.exterior_wall_layer5_thermal_capacity,
            f.exterior_wall_layer5_thermal_capacity_unit,
            f.exterior_wall_layer5_thermal_conductivity,
            f.exterior_wall_layer5_thermal_conductivity_unit,
            f.exterior_wall_layer5_service_life,
            f.exterior_wall_layer5_service_life_unit,
            f.exterior_wall_layer5_density,
            f.exterior_wall_layer5_density_unit,
            f.exterior_wall_layer0_epd1_oekobaudat_name,
            f.exterior_wall_layer0_epd1_oekobaudat_uuid,
            f.exterior_wall_layer0_epd2_oekobaudat_name,
            f.exterior_wall_layer0_epd2_oekobaudat_uuid,
            f.exterior_wall_layer1_epd1_oekobaudat_name,
            f.exterior_wall_layer1_epd1_oekobaudat_uuid,
            f.exterior_wall_layer1_epd2_oekobaudat_name,
            f.exterior_wall_layer1_epd2_oekobaudat_uuid,
            f.exterior_wall_layer2_epd1_oekobaudat_name,
            f.exterior_wall_layer2_epd1_oekobaudat_uuid,
            f.exterior_wall_layer2_epd2_oekobaudat_name,
            f.exterior_wall_layer2_epd2_oekobaudat_uuid,
            f.exterior_wall_layer3_epd1_oekobaudat_name,
            f.exterior_wall_layer3_epd1_oekobaudat_uuid,
            f.exterior_wall_layer3_epd2_oekobaudat_name,
            f.exterior_wall_layer3_epd2_oekobaudat_uuid,
            f.exterior_wall_layer4_epd1_oekobaudat_name,
            f.exterior_wall_layer4_epd1_oekobaudat_uuid,
            f.exterior_wall_layer4_epd2_oekobaudat_name,
            f.exterior_wall_layer4_epd2_oekobaudat_uuid,
            f.exterior_wall_layer5_epd1_oekobaudat_name,
            f.exterior_wall_layer5_epd1_oekobaudat_uuid,
            f.exterior_wall_layer5_epd2_oekobaudat_name,
            f.exterior_wall_layer5_epd2_oekobaudat_uuid,
            f.interior_wall_name,
            f.interior_wall_u_value_typical_min,
            f.interior_wall_u_value_typical_max,
            f.interior_wall_u_value,
            f.interior_wall_u_value_unit,
            f.interior_wall_inner_radiation,
            f.interior_wall_inner_radiation_unit,
            f.interior_wall_inner_convection,
            f.interior_wall_inner_convection_unit,
            f.interior_wall_layer0_position,
            f.interior_wall_layer0_material_id,
            f.interior_wall_layer0_material_name,
            f.interior_wall_layer0_thickness,
            f.interior_wall_layer0_thickness_unit,
            f.interior_wall_layer0_solar_absorption_rate,
            f.interior_wall_layer0_thermal_capacity,
            f.interior_wall_layer0_thermal_capacity_unit,
            f.interior_wall_layer0_thermal_conductivity,
            f.interior_wall_layer0_thermal_conductivity_unit,
            f.interior_wall_layer0_service_life,
            f.interior_wall_layer0_service_life_unit,
            f.interior_wall_layer0_density,
            f.interior_wall_layer0_density_unit,
            f.interior_wall_layer1_position,
            f.interior_wall_layer1_material_id,
            f.interior_wall_layer1_material_name,
            f.interior_wall_layer1_thickness,
            f.interior_wall_layer1_thickness_unit,
            f.interior_wall_layer1_solar_absorption_rate,
            f.interior_wall_layer1_thermal_capacity,
            f.interior_wall_layer1_thermal_capacity_unit,
            f.interior_wall_layer1_thermal_conductivity,
            f.interior_wall_layer1_thermal_conductivity_unit,
            f.interior_wall_layer1_service_life,
            f.interior_wall_layer1_service_life_unit,
            f.interior_wall_layer1_density,
            f.interior_wall_layer1_density_unit,
            f.interior_wall_layer2_position,
            f.interior_wall_layer2_material_id,
            f.interior_wall_layer2_material_name,
            f.interior_wall_layer2_thickness,
            f.interior_wall_layer2_thickness_unit,
            f.interior_wall_layer2_solar_absorption_rate,
            f.interior_wall_layer2_thermal_capacity,
            f.interior_wall_layer2_thermal_capacity_unit,
            f.interior_wall_layer2_thermal_conductivity,
            f.interior_wall_layer2_thermal_conductivity_unit,
            f.interior_wall_layer2_service_life,
            f.interior_wall_layer2_service_life_unit,
            f.interior_wall_layer2_density,
            f.interior_wall_layer2_density_unit,
            f.interior_wall_layer0_epd1_oekobaudat_name,
            f.interior_wall_layer0_epd1_oekobaudat_uuid,
            f.interior_wall_layer0_epd2_oekobaudat_name,
            f.interior_wall_layer0_epd2_oekobaudat_uuid,
            f.interior_wall_layer1_epd1_oekobaudat_name,
            f.interior_wall_layer1_epd1_oekobaudat_uuid,
            f.interior_wall_layer1_epd2_oekobaudat_name,
            f.interior_wall_layer1_epd2_oekobaudat_uuid,
            f.interior_wall_layer2_epd1_oekobaudat_name,
            f.interior_wall_layer2_epd1_oekobaudat_uuid,
            f.interior_wall_layer2_epd2_oekobaudat_name,
            f.interior_wall_layer2_epd2_oekobaudat_uuid,
            f.roof_name,
            f.roof_construction_type,
            f.roof_pitch_type,
            f.roof_u_value_typical_min,
            f.roof_u_value_typical_max,
            f.roof_u_value,
            f.roof_u_value_unit,
            f.roof_inner_radiation,
            f.roof_inner_radiation_unit,
            f.roof_outer_radiation,
            f.roof_outer_radiation_unit,
            f.roof_inner_convection,
            f.roof_inner_convection_unit,
            f.roof_outer_convection,
            f.roof_outer_convection_unit,
            f.roof_layer0_position,
            f.roof_layer0_material_id,
            f.roof_layer0_material_name,
            f.roof_layer0_thickness,
            f.roof_layer0_thickness_unit,
            f.roof_layer0_solar_absorption_rate,
            f.roof_layer0_thermal_capacity,
            f.roof_layer0_thermal_capacity_unit,
            f.roof_layer0_thermal_conductivity,
            f.roof_layer0_thermal_conductivity_unit,
            f.roof_layer0_service_life,
            f.roof_layer0_service_life_unit,
            f.roof_layer0_density,
            f.roof_layer0_density_unit,
            f.roof_layer1_position,
            f.roof_layer1_material_id,
            f.roof_layer1_material_name,
            f.roof_layer1_thickness,
            f.roof_layer1_thickness_unit,
            f.roof_layer1_solar_absorption_rate,
            f.roof_layer1_thermal_capacity,
            f.roof_layer1_thermal_capacity_unit,
            f.roof_layer1_thermal_conductivity,
            f.roof_layer1_thermal_conductivity_unit,
            f.roof_layer1_service_life,
            f.roof_layer1_service_life_unit,
            f.roof_layer1_density,
            f.roof_layer1_density_unit,
            f.roof_layer2_position,
            f.roof_layer2_material_id,
            f.roof_layer2_material_name,
            f.roof_layer2_thickness,
            f.roof_layer2_thickness_unit,
            f.roof_layer2_solar_absorption_rate,
            f.roof_layer2_thermal_capacity,
            f.roof_layer2_thermal_capacity_unit,
            f.roof_layer2_thermal_conductivity,
            f.roof_layer2_thermal_conductivity_unit,
            f.roof_layer2_service_life,
            f.roof_layer2_service_life_unit,
            f.roof_layer2_density,
            f.roof_layer2_density_unit,
            f.roof_layer3_position,
            f.roof_layer3_material_id,
            f.roof_layer3_material_name,
            f.roof_layer3_thickness,
            f.roof_layer3_thickness_unit,
            f.roof_layer3_solar_absorption_rate,
            f.roof_layer3_thermal_capacity,
            f.roof_layer3_thermal_capacity_unit,
            f.roof_layer3_thermal_conductivity,
            f.roof_layer3_thermal_conductivity_unit,
            f.roof_layer3_service_life,
            f.roof_layer3_service_life_unit,
            f.roof_layer3_density,
            f.roof_layer3_density_unit,
            f.roof_layer4_position,
            f.roof_layer4_material_id,
            f.roof_layer4_material_name,
            f.roof_layer4_thickness,
            f.roof_layer4_thickness_unit,
            f.roof_layer4_solar_absorption_rate,
            f.roof_layer4_thermal_capacity,
            f.roof_layer4_thermal_capacity_unit,
            f.roof_layer4_thermal_conductivity,
            f.roof_layer4_thermal_conductivity_unit,
            f.roof_layer4_service_life,
            f.roof_layer4_service_life_unit,
            f.roof_layer4_density,
            f.roof_layer4_density_unit,
            f.roof_layer5_position,
            f.roof_layer5_material_id,
            f.roof_layer5_material_name,
            f.roof_layer5_thickness,
            f.roof_layer5_thickness_unit,
            f.roof_layer5_solar_absorption_rate,
            f.roof_layer5_thermal_capacity,
            f.roof_layer5_thermal_capacity_unit,
            f.roof_layer5_thermal_conductivity,
            f.roof_layer5_thermal_conductivity_unit,
            f.roof_layer5_service_life,
            f.roof_layer5_service_life_unit,
            f.roof_layer5_density,
            f.roof_layer5_density_unit,
            f.roof_layer0_epd1_oekobaudat_name,
            f.roof_layer0_epd1_oekobaudat_uuid,
            f.roof_layer0_epd2_oekobaudat_name,
            f.roof_layer0_epd2_oekobaudat_uuid,
            f.roof_layer1_epd1_oekobaudat_name,
            f.roof_layer1_epd1_oekobaudat_uuid,
            f.roof_layer1_epd2_oekobaudat_name,
            f.roof_layer1_epd2_oekobaudat_uuid,
            f.roof_layer2_epd1_oekobaudat_name,
            f.roof_layer2_epd1_oekobaudat_uuid,
            f.roof_layer2_epd2_oekobaudat_name,
            f.roof_layer2_epd2_oekobaudat_uuid,
            f.roof_layer3_epd1_oekobaudat_name,
            f.roof_layer3_epd1_oekobaudat_uuid,
            f.roof_layer3_epd2_oekobaudat_name,
            f.roof_layer3_epd2_oekobaudat_uuid,
            f.roof_layer4_epd1_oekobaudat_name,
            f.roof_layer4_epd1_oekobaudat_uuid,
            f.roof_layer4_epd2_oekobaudat_name,
            f.roof_layer4_epd2_oekobaudat_uuid,
            f.roof_layer5_epd1_oekobaudat_name,
            f.roof_layer5_epd1_oekobaudat_uuid,
            f.roof_layer5_epd2_oekobaudat_name,
            f.roof_layer5_epd2_oekobaudat_uuid,
            f.foundation_name,
            f.foundation_construction_type,
            f.foundation_u_value_typical_min,
            f.foundation_u_value_typical_max,
            f.foundation_u_value,
            f.foundation_u_value_unit,
            f.foundation_inner_radiation,
            f.foundation_inner_radiation_unit,
            f.foundation_inner_convection,
            f.foundation_inner_convection_unit,
            f.foundation_layer0_position,
            f.foundation_layer0_material_id,
            f.foundation_layer0_material_name,
            f.foundation_layer0_thickness,
            f.foundation_layer0_thickness_unit,
            f.foundation_layer0_solar_absorption_rate,
            f.foundation_layer0_thermal_capacity,
            f.foundation_layer0_thermal_capacity_unit,
            f.foundation_layer0_thermal_conductivity,
            f.foundation_layer0_thermal_conductivity_unit,
            f.foundation_layer0_service_life,
            f.foundation_layer0_service_life_unit,
            f.foundation_layer0_density,
            f.foundation_layer0_density_unit,
            f.foundation_layer1_position,
            f.foundation_layer1_material_id,
            f.foundation_layer1_material_name,
            f.foundation_layer1_thickness,
            f.foundation_layer1_thickness_unit,
            f.foundation_layer1_solar_absorption_rate,
            f.foundation_layer1_thermal_capacity,
            f.foundation_layer1_thermal_capacity_unit,
            f.foundation_layer1_thermal_conductivity,
            f.foundation_layer1_thermal_conductivity_unit,
            f.foundation_layer1_service_life,
            f.foundation_layer1_service_life_unit,
            f.foundation_layer1_density,
            f.foundation_layer1_density_unit,
            f.foundation_layer2_position,
            f.foundation_layer2_material_id,
            f.foundation_layer2_material_name,
            f.foundation_layer2_thickness,
            f.foundation_layer2_thickness_unit,
            f.foundation_layer2_solar_absorption_rate,
            f.foundation_layer2_thermal_capacity,
            f.foundation_layer2_thermal_capacity_unit,
            f.foundation_layer2_thermal_conductivity,
            f.foundation_layer2_thermal_conductivity_unit,
            f.foundation_layer2_service_life,
            f.foundation_layer2_service_life_unit,
            f.foundation_layer2_density,
            f.foundation_layer2_density_unit,
            f.foundation_layer3_position,
            f.foundation_layer3_material_id,
            f.foundation_layer3_material_name,
            f.foundation_layer3_thickness,
            f.foundation_layer3_thickness_unit,
            f.foundation_layer3_solar_absorption_rate,
            f.foundation_layer3_thermal_capacity,
            f.foundation_layer3_thermal_capacity_unit,
            f.foundation_layer3_thermal_conductivity,
            f.foundation_layer3_thermal_conductivity_unit,
            f.foundation_layer3_service_life,
            f.foundation_layer3_service_life_unit,
            f.foundation_layer3_density,
            f.foundation_layer3_density_unit,
            f.foundation_layer4_position,
            f.foundation_layer4_material_id,
            f.foundation_layer4_material_name,
            f.foundation_layer4_thickness,
            f.foundation_layer4_thickness_unit,
            f.foundation_layer4_solar_absorption_rate,
            f.foundation_layer4_thermal_capacity,
            f.foundation_layer4_thermal_capacity_unit,
            f.foundation_layer4_thermal_conductivity,
            f.foundation_layer4_thermal_conductivity_unit,
            f.foundation_layer4_service_life,
            f.foundation_layer4_service_life_unit,
            f.foundation_layer4_density,
            f.foundation_layer4_density_unit,
            f.foundation_layer5_position,
            f.foundation_layer5_material_id,
            f.foundation_layer5_material_name,
            f.foundation_layer5_thickness,
            f.foundation_layer5_thickness_unit,
            f.foundation_layer5_solar_absorption_rate,
            f.foundation_layer5_thermal_capacity,
            f.foundation_layer5_thermal_capacity_unit,
            f.foundation_layer5_thermal_conductivity,
            f.foundation_layer5_thermal_conductivity_unit,
            f.foundation_layer5_service_life,
            f.foundation_layer5_service_life_unit,
            f.foundation_layer5_density,
            f.foundation_layer5_density_unit,
            f.foundation_layer0_epd1_oekobaudat_name,
            f.foundation_layer0_epd1_oekobaudat_uuid,
            f.foundation_layer0_epd2_oekobaudat_name,
            f.foundation_layer0_epd2_oekobaudat_uuid,
            f.foundation_layer1_epd1_oekobaudat_name,
            f.foundation_layer1_epd1_oekobaudat_uuid,
            f.foundation_layer1_epd2_oekobaudat_name,
            f.foundation_layer1_epd2_oekobaudat_uuid,
            f.foundation_layer2_epd1_oekobaudat_name,
            f.foundation_layer2_epd1_oekobaudat_uuid,
            f.foundation_layer2_epd2_oekobaudat_name,
            f.foundation_layer2_epd2_oekobaudat_uuid,
            f.foundation_layer3_epd1_oekobaudat_name,
            f.foundation_layer3_epd1_oekobaudat_uuid,
            f.foundation_layer3_epd2_oekobaudat_name,
            f.foundation_layer3_epd2_oekobaudat_uuid,
            f.foundation_layer4_epd1_oekobaudat_name,
            f.foundation_layer4_epd1_oekobaudat_uuid,
            f.foundation_layer4_epd2_oekobaudat_name,
            f.foundation_layer4_epd2_oekobaudat_uuid,
            f.foundation_layer5_epd1_oekobaudat_name,
            f.foundation_layer5_epd1_oekobaudat_uuid,
            f.foundation_layer5_epd2_oekobaudat_name,
            f.foundation_layer5_epd2_oekobaudat_uuid,
            f.floor_name,
            f.floor_u_value_typical_min,
            f.floor_u_value_typical_max,
            f.floor_u_value,
            f.floor_u_value_unit,
            f.floor_inner_radiation,
            f.floor_inner_radiation_unit,
            f.floor_inner_convection,
            f.floor_inner_convection_unit,
            f.floor_layer0_position,
            f.floor_layer0_material_id,
            f.floor_layer0_material_name,
            f.floor_layer0_thickness,
            f.floor_layer0_thickness_unit,
            f.floor_layer0_solar_absorption_rate,
            f.floor_layer0_thermal_capacity,
            f.floor_layer0_thermal_capacity_unit,
            f.floor_layer0_thermal_conductivity,
            f.floor_layer0_thermal_conductivity_unit,
            f.floor_layer0_service_life,
            f.floor_layer0_service_life_unit,
            f.floor_layer0_density,
            f.floor_layer0_density_unit,
            f.floor_layer1_position,
            f.floor_layer1_material_id,
            f.floor_layer1_material_name,
            f.floor_layer1_thickness,
            f.floor_layer1_thickness_unit,
            f.floor_layer1_solar_absorption_rate,
            f.floor_layer1_thermal_capacity,
            f.floor_layer1_thermal_capacity_unit,
            f.floor_layer1_thermal_conductivity,
            f.floor_layer1_thermal_conductivity_unit,
            f.floor_layer1_service_life,
            f.floor_layer1_service_life_unit,
            f.floor_layer1_density,
            f.floor_layer1_density_unit,
            f.floor_layer2_position,
            f.floor_layer2_material_id,
            f.floor_layer2_material_name,
            f.floor_layer2_thickness,
            f.floor_layer2_thickness_unit,
            f.floor_layer2_solar_absorption_rate,
            f.floor_layer2_thermal_capacity,
            f.floor_layer2_thermal_capacity_unit,
            f.floor_layer2_thermal_conductivity,
            f.floor_layer2_thermal_conductivity_unit,
            f.floor_layer2_service_life,
            f.floor_layer2_service_life_unit,
            f.floor_layer2_density,
            f.floor_layer2_density_unit,
            f.floor_layer0_epd1_oekobaudat_name,
            f.floor_layer0_epd1_oekobaudat_uuid,
            f.floor_layer0_epd2_oekobaudat_name,
            f.floor_layer0_epd2_oekobaudat_uuid,
            f.floor_layer1_epd1_oekobaudat_name,
            f.floor_layer1_epd1_oekobaudat_uuid,
            f.floor_layer1_epd2_oekobaudat_name,
            f.floor_layer1_epd2_oekobaudat_uuid,
            f.floor_layer2_epd1_oekobaudat_name,
            f.floor_layer2_epd1_oekobaudat_uuid,
            f.floor_layer2_epd2_oekobaudat_name,
            f.floor_layer2_epd2_oekobaudat_uuid,
            f.window_name,
            f.window_inner_radiation,
            f.window_inner_radiation_unit,
            f.window_outer_radiation,
            f.window_outer_radiation_unit,
            f.window_inner_convection,
            f.window_inner_convection_unit,
            f.window_outer_convection,
            f.window_outer_convection_unit,
            f.glazing,
            f.frame_per_window,
            f.frame_per_window_unit,
            f.window_frame_area_share,
            f.g_value,
            f.a_conv,
            f.shading_type_name,
            f.window_frame_type_name,
            f.window_layer0_position,
            f.window_layer0_material_id,
            f.window_layer0_material_name,
            f.window_layer0_thickness,
            f.window_layer0_thickness_unit,
            f.window_layer0_solar_absorption_rate,
            f.window_layer0_thermal_capacity,
            f.window_layer0_thermal_capacity_unit,
            f.window_layer0_thermal_conductivity,
            f.window_layer0_thermal_conductivity_unit,
            f.window_layer0_service_life,
            f.window_layer0_service_life_unit,
            f.window_layer1_position,
            f.window_layer1_material_id,
            f.window_layer1_material_name,
            f.window_layer1_thickness,
            f.window_layer1_thickness_unit,
            f.window_layer1_solar_absorption_rate,
            f.window_layer1_thermal_capacity,
            f.window_layer1_thermal_capacity_unit,
            f.window_layer1_thermal_conductivity,
            f.window_layer1_thermal_conductivity_unit,
            f.window_layer1_service_life,
            f.window_layer1_service_life_unit,
            f.window_layer2_position,
            f.window_layer2_material_id,
            f.window_layer2_material_name,
            f.window_layer2_thickness,
            f.window_layer2_thickness_unit,
            f.window_layer2_solar_absorption_rate,
            f.window_layer2_thermal_capacity,
            f.window_layer2_thermal_capacity_unit,
            f.window_layer2_thermal_conductivity,
            f.window_layer2_thermal_conductivity_unit,
            f.window_layer2_service_life,
            f.window_layer2_service_life_unit,
            epd0_1.environmental_product_declaration_name AS window_layer0_epd1_oekobaudat_name,
            epd0_1.database_uuid AS window_layer0_epd1_oekobaudat_uuid,
            epd0_2.environmental_product_declaration_name AS window_layer0_epd2_oekobaudat_name,
            epd0_2.database_uuid AS window_layer0_epd2_oekobaudat_uuid,
            epd1_1.environmental_product_declaration_name AS window_layer1_epd1_oekobaudat_name,
            epd1_1.database_uuid AS window_layer1_epd1_oekobaudat_uuid,
            epd1_2.environmental_product_declaration_name AS window_layer1_epd2_oekobaudat_name,
            epd1_2.database_uuid AS window_layer1_epd2_oekobaudat_uuid,
            epd2_1.environmental_product_declaration_name AS window_layer2_epd1_oekobaudat_name,
            epd2_1.database_uuid AS window_layer2_epd1_oekobaudat_uuid,
            epd2_2.environmental_product_declaration_name AS window_layer2_epd2_oekobaudat_name,
            epd2_2.database_uuid AS window_layer2_epd2_oekobaudat_uuid
           FROM ((((((((((((step_019 f
             LEFT JOIN hub4lca_post_simulation.layers l0 ON (((l0.building_element_id = f.window_building_element_id) AND (l0."position" = 0))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm0 ON ((bm0.building_material_id = l0.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_1 ON ((epd0_1.environmental_product_declaration_id = bm0.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd0_2 ON ((epd0_2.environmental_product_declaration_id = bm0.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l1 ON (((l1.building_element_id = f.window_building_element_id) AND (l1."position" = 1))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm1 ON ((bm1.building_material_id = l1.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_1 ON ((epd1_1.environmental_product_declaration_id = bm1.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1_2 ON ((epd1_2.environmental_product_declaration_id = bm1.environmental_product_declaration_id_2)))
             LEFT JOIN hub4lca_post_simulation.layers l2 ON (((l2.building_element_id = f.window_building_element_id) AND (l2."position" = 2))))
             LEFT JOIN hub4lca_post_simulation.building_materials bm2 ON ((bm2.building_material_id = l2.building_material_id)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_1 ON ((epd2_1.environmental_product_declaration_id = bm2.environmental_product_declaration_id_1)))
             LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2_2 ON ((epd2_2.environmental_product_declaration_id = bm2.environmental_product_declaration_id_2)))
        ), step_021 AS (
         SELECT v.building_archetype_id,
            v.building_archetype_name,
            v.share_of_building_type,
            v.share_of_building_type_in_region,
            v.share_of_building_type_in_region_mun,
            v.exterior_wall_building_element_id,
            v.interior_wall_building_element_id,
            v.roof_building_element_id,
            v.foundation_building_element_id,
            v.floor_building_element_id,
            v.window_building_element_id,
            v.energy_system_id,
            v.building_type_name,
            v.region_name,
            v.municipality_size_name,
            v.municipality_growth_name,
            v.age_class_name,
            v.building_adjacency_name,
            v.facade_to_net_leased_area_ratio_mean,
            v.facade_to_net_leased_area_ratio_se_min,
            v.facade_to_net_leased_area_ratio_se_max,
            v.roof_to_net_leased_area_ratio_mean,
            v.roof_to_net_leased_area_ratio_se_min,
            v.roof_to_net_leased_area_ratio_se_max,
            v.foundation_to_net_leased_area_ratio_mean,
            v.foundation_to_net_leased_area_ratio_se_min,
            v.foundation_to_net_leased_area_ratio_se_max,
            v.window_to_net_leased_area_ratio_mean,
            v.window_to_net_leased_area_ratio_se_min,
            v.window_to_net_leased_area_ratio_se_max,
            v.building_height_mean,
            v.building_height_se,
            v.height_unit,
            v.aspect_ratio_mean,
            v.aspect_ratio_se_min,
            v.aspect_ratio_se_max,
            v.storeys_below_ground_mean,
            v.storeys_below_ground_se,
            v.storeys_above_ground_mean,
            v.storeys_above_ground_se,
            v.storeys_above_ground_se_min,
            v.storeys_above_ground_se_max,
            v.storey_height_mean,
            v.storey_height_se_min,
            v.storey_height_se_max,
            v.window_share,
            v.net_leased_area_mean,
            v.net_leased_area_se,
            v.net_leased_area_se_min,
            v.net_leased_area_se_max,
            v.net_leased_area_unit,
            v.facade_area_north_mean,
            v.facade_area_north_se,
            v.facade_area_east_mean,
            v.facade_area_east_se,
            v.facade_area_south_mean,
            v.facade_area_south_se,
            v.facade_area_west_mean,
            v.facade_area_west_se,
            v.facade_area_unit,
            v.facade_length_north_mean,
            v.facade_length_north_se,
            v.facade_length_east_mean,
            v.facade_length_east_se,
            v.facade_length_south_mean,
            v.facade_length_south_se,
            v.facade_length_west_mean,
            v.facade_length_west_se,
            v.facade_length_unit,
            v.exterior_wall_name,
            v.exterior_wall_construction_type,
            v.exterior_wall_u_value_typical_min,
            v.exterior_wall_u_value_typical_max,
            v.exterior_wall_u_value,
            v.exterior_wall_u_value_unit,
            v.exterior_wall_inner_radiation,
            v.exterior_wall_inner_radiation_unit,
            v.exterior_wall_outer_radiation,
            v.exterior_wall_outer_radiation_unit,
            v.exterior_wall_inner_convection,
            v.exterior_wall_inner_convection_unit,
            v.exterior_wall_outer_convection,
            v.exterior_wall_outer_convection_unit,
            v.exterior_wall_layer0_position,
            v.exterior_wall_layer0_material_id,
            v.exterior_wall_layer0_material_name,
            v.exterior_wall_layer0_thickness,
            v.exterior_wall_layer0_thickness_unit,
            v.exterior_wall_layer0_solar_absorption_rate,
            v.exterior_wall_layer0_thermal_capacity,
            v.exterior_wall_layer0_thermal_capacity_unit,
            v.exterior_wall_layer0_thermal_conductivity,
            v.exterior_wall_layer0_thermal_conductivity_unit,
            v.exterior_wall_layer0_service_life,
            v.exterior_wall_layer0_service_life_unit,
            v.exterior_wall_layer0_density,
            v.exterior_wall_layer0_density_unit,
            v.exterior_wall_layer1_position,
            v.exterior_wall_layer1_material_id,
            v.exterior_wall_layer1_material_name,
            v.exterior_wall_layer1_thickness,
            v.exterior_wall_layer1_thickness_unit,
            v.exterior_wall_layer1_solar_absorption_rate,
            v.exterior_wall_layer1_thermal_capacity,
            v.exterior_wall_layer1_thermal_capacity_unit,
            v.exterior_wall_layer1_thermal_conductivity,
            v.exterior_wall_layer1_thermal_conductivity_unit,
            v.exterior_wall_layer1_service_life,
            v.exterior_wall_layer1_service_life_unit,
            v.exterior_wall_layer1_density,
            v.exterior_wall_layer1_density_unit,
            v.exterior_wall_layer2_position,
            v.exterior_wall_layer2_material_id,
            v.exterior_wall_layer2_material_name,
            v.exterior_wall_layer2_thickness,
            v.exterior_wall_layer2_thickness_unit,
            v.exterior_wall_layer2_solar_absorption_rate,
            v.exterior_wall_layer2_thermal_capacity,
            v.exterior_wall_layer2_thermal_capacity_unit,
            v.exterior_wall_layer2_thermal_conductivity,
            v.exterior_wall_layer2_thermal_conductivity_unit,
            v.exterior_wall_layer2_service_life,
            v.exterior_wall_layer2_service_life_unit,
            v.exterior_wall_layer2_density,
            v.exterior_wall_layer2_density_unit,
            v.exterior_wall_layer3_position,
            v.exterior_wall_layer3_material_id,
            v.exterior_wall_layer3_material_name,
            v.exterior_wall_layer3_thickness,
            v.exterior_wall_layer3_thickness_unit,
            v.exterior_wall_layer3_solar_absorption_rate,
            v.exterior_wall_layer3_thermal_capacity,
            v.exterior_wall_layer3_thermal_capacity_unit,
            v.exterior_wall_layer3_thermal_conductivity,
            v.exterior_wall_layer3_thermal_conductivity_unit,
            v.exterior_wall_layer3_service_life,
            v.exterior_wall_layer3_service_life_unit,
            v.exterior_wall_layer3_density,
            v.exterior_wall_layer3_density_unit,
            v.exterior_wall_layer4_position,
            v.exterior_wall_layer4_material_id,
            v.exterior_wall_layer4_material_name,
            v.exterior_wall_layer4_thickness,
            v.exterior_wall_layer4_thickness_unit,
            v.exterior_wall_layer4_solar_absorption_rate,
            v.exterior_wall_layer4_thermal_capacity,
            v.exterior_wall_layer4_thermal_capacity_unit,
            v.exterior_wall_layer4_thermal_conductivity,
            v.exterior_wall_layer4_thermal_conductivity_unit,
            v.exterior_wall_layer4_service_life,
            v.exterior_wall_layer4_service_life_unit,
            v.exterior_wall_layer4_density,
            v.exterior_wall_layer4_density_unit,
            v.exterior_wall_layer5_position,
            v.exterior_wall_layer5_material_id,
            v.exterior_wall_layer5_material_name,
            v.exterior_wall_layer5_thickness,
            v.exterior_wall_layer5_thickness_unit,
            v.exterior_wall_layer5_solar_absorption_rate,
            v.exterior_wall_layer5_thermal_capacity,
            v.exterior_wall_layer5_thermal_capacity_unit,
            v.exterior_wall_layer5_thermal_conductivity,
            v.exterior_wall_layer5_thermal_conductivity_unit,
            v.exterior_wall_layer5_service_life,
            v.exterior_wall_layer5_service_life_unit,
            v.exterior_wall_layer5_density,
            v.exterior_wall_layer5_density_unit,
            v.exterior_wall_layer0_epd1_oekobaudat_name,
            v.exterior_wall_layer0_epd1_oekobaudat_uuid,
            v.exterior_wall_layer0_epd2_oekobaudat_name,
            v.exterior_wall_layer0_epd2_oekobaudat_uuid,
            v.exterior_wall_layer1_epd1_oekobaudat_name,
            v.exterior_wall_layer1_epd1_oekobaudat_uuid,
            v.exterior_wall_layer1_epd2_oekobaudat_name,
            v.exterior_wall_layer1_epd2_oekobaudat_uuid,
            v.exterior_wall_layer2_epd1_oekobaudat_name,
            v.exterior_wall_layer2_epd1_oekobaudat_uuid,
            v.exterior_wall_layer2_epd2_oekobaudat_name,
            v.exterior_wall_layer2_epd2_oekobaudat_uuid,
            v.exterior_wall_layer3_epd1_oekobaudat_name,
            v.exterior_wall_layer3_epd1_oekobaudat_uuid,
            v.exterior_wall_layer3_epd2_oekobaudat_name,
            v.exterior_wall_layer3_epd2_oekobaudat_uuid,
            v.exterior_wall_layer4_epd1_oekobaudat_name,
            v.exterior_wall_layer4_epd1_oekobaudat_uuid,
            v.exterior_wall_layer4_epd2_oekobaudat_name,
            v.exterior_wall_layer4_epd2_oekobaudat_uuid,
            v.exterior_wall_layer5_epd1_oekobaudat_name,
            v.exterior_wall_layer5_epd1_oekobaudat_uuid,
            v.exterior_wall_layer5_epd2_oekobaudat_name,
            v.exterior_wall_layer5_epd2_oekobaudat_uuid,
            v.interior_wall_name,
            v.interior_wall_u_value_typical_min,
            v.interior_wall_u_value_typical_max,
            v.interior_wall_u_value,
            v.interior_wall_u_value_unit,
            v.interior_wall_inner_radiation,
            v.interior_wall_inner_radiation_unit,
            v.interior_wall_inner_convection,
            v.interior_wall_inner_convection_unit,
            v.interior_wall_layer0_position,
            v.interior_wall_layer0_material_id,
            v.interior_wall_layer0_material_name,
            v.interior_wall_layer0_thickness,
            v.interior_wall_layer0_thickness_unit,
            v.interior_wall_layer0_solar_absorption_rate,
            v.interior_wall_layer0_thermal_capacity,
            v.interior_wall_layer0_thermal_capacity_unit,
            v.interior_wall_layer0_thermal_conductivity,
            v.interior_wall_layer0_thermal_conductivity_unit,
            v.interior_wall_layer0_service_life,
            v.interior_wall_layer0_service_life_unit,
            v.interior_wall_layer0_density,
            v.interior_wall_layer0_density_unit,
            v.interior_wall_layer1_position,
            v.interior_wall_layer1_material_id,
            v.interior_wall_layer1_material_name,
            v.interior_wall_layer1_thickness,
            v.interior_wall_layer1_thickness_unit,
            v.interior_wall_layer1_solar_absorption_rate,
            v.interior_wall_layer1_thermal_capacity,
            v.interior_wall_layer1_thermal_capacity_unit,
            v.interior_wall_layer1_thermal_conductivity,
            v.interior_wall_layer1_thermal_conductivity_unit,
            v.interior_wall_layer1_service_life,
            v.interior_wall_layer1_service_life_unit,
            v.interior_wall_layer1_density,
            v.interior_wall_layer1_density_unit,
            v.interior_wall_layer2_position,
            v.interior_wall_layer2_material_id,
            v.interior_wall_layer2_material_name,
            v.interior_wall_layer2_thickness,
            v.interior_wall_layer2_thickness_unit,
            v.interior_wall_layer2_solar_absorption_rate,
            v.interior_wall_layer2_thermal_capacity,
            v.interior_wall_layer2_thermal_capacity_unit,
            v.interior_wall_layer2_thermal_conductivity,
            v.interior_wall_layer2_thermal_conductivity_unit,
            v.interior_wall_layer2_service_life,
            v.interior_wall_layer2_service_life_unit,
            v.interior_wall_layer2_density,
            v.interior_wall_layer2_density_unit,
            v.interior_wall_layer0_epd1_oekobaudat_name,
            v.interior_wall_layer0_epd1_oekobaudat_uuid,
            v.interior_wall_layer0_epd2_oekobaudat_name,
            v.interior_wall_layer0_epd2_oekobaudat_uuid,
            v.interior_wall_layer1_epd1_oekobaudat_name,
            v.interior_wall_layer1_epd1_oekobaudat_uuid,
            v.interior_wall_layer1_epd2_oekobaudat_name,
            v.interior_wall_layer1_epd2_oekobaudat_uuid,
            v.interior_wall_layer2_epd1_oekobaudat_name,
            v.interior_wall_layer2_epd1_oekobaudat_uuid,
            v.interior_wall_layer2_epd2_oekobaudat_name,
            v.interior_wall_layer2_epd2_oekobaudat_uuid,
            v.roof_name,
            v.roof_construction_type,
            v.roof_pitch_type,
            v.roof_u_value_typical_min,
            v.roof_u_value_typical_max,
            v.roof_u_value,
            v.roof_u_value_unit,
            v.roof_inner_radiation,
            v.roof_inner_radiation_unit,
            v.roof_outer_radiation,
            v.roof_outer_radiation_unit,
            v.roof_inner_convection,
            v.roof_inner_convection_unit,
            v.roof_outer_convection,
            v.roof_outer_convection_unit,
            v.roof_layer0_position,
            v.roof_layer0_material_id,
            v.roof_layer0_material_name,
            v.roof_layer0_thickness,
            v.roof_layer0_thickness_unit,
            v.roof_layer0_solar_absorption_rate,
            v.roof_layer0_thermal_capacity,
            v.roof_layer0_thermal_capacity_unit,
            v.roof_layer0_thermal_conductivity,
            v.roof_layer0_thermal_conductivity_unit,
            v.roof_layer0_service_life,
            v.roof_layer0_service_life_unit,
            v.roof_layer0_density,
            v.roof_layer0_density_unit,
            v.roof_layer1_position,
            v.roof_layer1_material_id,
            v.roof_layer1_material_name,
            v.roof_layer1_thickness,
            v.roof_layer1_thickness_unit,
            v.roof_layer1_solar_absorption_rate,
            v.roof_layer1_thermal_capacity,
            v.roof_layer1_thermal_capacity_unit,
            v.roof_layer1_thermal_conductivity,
            v.roof_layer1_thermal_conductivity_unit,
            v.roof_layer1_service_life,
            v.roof_layer1_service_life_unit,
            v.roof_layer1_density,
            v.roof_layer1_density_unit,
            v.roof_layer2_position,
            v.roof_layer2_material_id,
            v.roof_layer2_material_name,
            v.roof_layer2_thickness,
            v.roof_layer2_thickness_unit,
            v.roof_layer2_solar_absorption_rate,
            v.roof_layer2_thermal_capacity,
            v.roof_layer2_thermal_capacity_unit,
            v.roof_layer2_thermal_conductivity,
            v.roof_layer2_thermal_conductivity_unit,
            v.roof_layer2_service_life,
            v.roof_layer2_service_life_unit,
            v.roof_layer2_density,
            v.roof_layer2_density_unit,
            v.roof_layer3_position,
            v.roof_layer3_material_id,
            v.roof_layer3_material_name,
            v.roof_layer3_thickness,
            v.roof_layer3_thickness_unit,
            v.roof_layer3_solar_absorption_rate,
            v.roof_layer3_thermal_capacity,
            v.roof_layer3_thermal_capacity_unit,
            v.roof_layer3_thermal_conductivity,
            v.roof_layer3_thermal_conductivity_unit,
            v.roof_layer3_service_life,
            v.roof_layer3_service_life_unit,
            v.roof_layer3_density,
            v.roof_layer3_density_unit,
            v.roof_layer4_position,
            v.roof_layer4_material_id,
            v.roof_layer4_material_name,
            v.roof_layer4_thickness,
            v.roof_layer4_thickness_unit,
            v.roof_layer4_solar_absorption_rate,
            v.roof_layer4_thermal_capacity,
            v.roof_layer4_thermal_capacity_unit,
            v.roof_layer4_thermal_conductivity,
            v.roof_layer4_thermal_conductivity_unit,
            v.roof_layer4_service_life,
            v.roof_layer4_service_life_unit,
            v.roof_layer4_density,
            v.roof_layer4_density_unit,
            v.roof_layer5_position,
            v.roof_layer5_material_id,
            v.roof_layer5_material_name,
            v.roof_layer5_thickness,
            v.roof_layer5_thickness_unit,
            v.roof_layer5_solar_absorption_rate,
            v.roof_layer5_thermal_capacity,
            v.roof_layer5_thermal_capacity_unit,
            v.roof_layer5_thermal_conductivity,
            v.roof_layer5_thermal_conductivity_unit,
            v.roof_layer5_service_life,
            v.roof_layer5_service_life_unit,
            v.roof_layer5_density,
            v.roof_layer5_density_unit,
            v.roof_layer0_epd1_oekobaudat_name,
            v.roof_layer0_epd1_oekobaudat_uuid,
            v.roof_layer0_epd2_oekobaudat_name,
            v.roof_layer0_epd2_oekobaudat_uuid,
            v.roof_layer1_epd1_oekobaudat_name,
            v.roof_layer1_epd1_oekobaudat_uuid,
            v.roof_layer1_epd2_oekobaudat_name,
            v.roof_layer1_epd2_oekobaudat_uuid,
            v.roof_layer2_epd1_oekobaudat_name,
            v.roof_layer2_epd1_oekobaudat_uuid,
            v.roof_layer2_epd2_oekobaudat_name,
            v.roof_layer2_epd2_oekobaudat_uuid,
            v.roof_layer3_epd1_oekobaudat_name,
            v.roof_layer3_epd1_oekobaudat_uuid,
            v.roof_layer3_epd2_oekobaudat_name,
            v.roof_layer3_epd2_oekobaudat_uuid,
            v.roof_layer4_epd1_oekobaudat_name,
            v.roof_layer4_epd1_oekobaudat_uuid,
            v.roof_layer4_epd2_oekobaudat_name,
            v.roof_layer4_epd2_oekobaudat_uuid,
            v.roof_layer5_epd1_oekobaudat_name,
            v.roof_layer5_epd1_oekobaudat_uuid,
            v.roof_layer5_epd2_oekobaudat_name,
            v.roof_layer5_epd2_oekobaudat_uuid,
            v.foundation_name,
            v.foundation_construction_type,
            v.foundation_u_value_typical_min,
            v.foundation_u_value_typical_max,
            v.foundation_u_value,
            v.foundation_u_value_unit,
            v.foundation_inner_radiation,
            v.foundation_inner_radiation_unit,
            v.foundation_inner_convection,
            v.foundation_inner_convection_unit,
            v.foundation_layer0_position,
            v.foundation_layer0_material_id,
            v.foundation_layer0_material_name,
            v.foundation_layer0_thickness,
            v.foundation_layer0_thickness_unit,
            v.foundation_layer0_solar_absorption_rate,
            v.foundation_layer0_thermal_capacity,
            v.foundation_layer0_thermal_capacity_unit,
            v.foundation_layer0_thermal_conductivity,
            v.foundation_layer0_thermal_conductivity_unit,
            v.foundation_layer0_service_life,
            v.foundation_layer0_service_life_unit,
            v.foundation_layer0_density,
            v.foundation_layer0_density_unit,
            v.foundation_layer1_position,
            v.foundation_layer1_material_id,
            v.foundation_layer1_material_name,
            v.foundation_layer1_thickness,
            v.foundation_layer1_thickness_unit,
            v.foundation_layer1_solar_absorption_rate,
            v.foundation_layer1_thermal_capacity,
            v.foundation_layer1_thermal_capacity_unit,
            v.foundation_layer1_thermal_conductivity,
            v.foundation_layer1_thermal_conductivity_unit,
            v.foundation_layer1_service_life,
            v.foundation_layer1_service_life_unit,
            v.foundation_layer1_density,
            v.foundation_layer1_density_unit,
            v.foundation_layer2_position,
            v.foundation_layer2_material_id,
            v.foundation_layer2_material_name,
            v.foundation_layer2_thickness,
            v.foundation_layer2_thickness_unit,
            v.foundation_layer2_solar_absorption_rate,
            v.foundation_layer2_thermal_capacity,
            v.foundation_layer2_thermal_capacity_unit,
            v.foundation_layer2_thermal_conductivity,
            v.foundation_layer2_thermal_conductivity_unit,
            v.foundation_layer2_service_life,
            v.foundation_layer2_service_life_unit,
            v.foundation_layer2_density,
            v.foundation_layer2_density_unit,
            v.foundation_layer3_position,
            v.foundation_layer3_material_id,
            v.foundation_layer3_material_name,
            v.foundation_layer3_thickness,
            v.foundation_layer3_thickness_unit,
            v.foundation_layer3_solar_absorption_rate,
            v.foundation_layer3_thermal_capacity,
            v.foundation_layer3_thermal_capacity_unit,
            v.foundation_layer3_thermal_conductivity,
            v.foundation_layer3_thermal_conductivity_unit,
            v.foundation_layer3_service_life,
            v.foundation_layer3_service_life_unit,
            v.foundation_layer3_density,
            v.foundation_layer3_density_unit,
            v.foundation_layer4_position,
            v.foundation_layer4_material_id,
            v.foundation_layer4_material_name,
            v.foundation_layer4_thickness,
            v.foundation_layer4_thickness_unit,
            v.foundation_layer4_solar_absorption_rate,
            v.foundation_layer4_thermal_capacity,
            v.foundation_layer4_thermal_capacity_unit,
            v.foundation_layer4_thermal_conductivity,
            v.foundation_layer4_thermal_conductivity_unit,
            v.foundation_layer4_service_life,
            v.foundation_layer4_service_life_unit,
            v.foundation_layer4_density,
            v.foundation_layer4_density_unit,
            v.foundation_layer5_position,
            v.foundation_layer5_material_id,
            v.foundation_layer5_material_name,
            v.foundation_layer5_thickness,
            v.foundation_layer5_thickness_unit,
            v.foundation_layer5_solar_absorption_rate,
            v.foundation_layer5_thermal_capacity,
            v.foundation_layer5_thermal_capacity_unit,
            v.foundation_layer5_thermal_conductivity,
            v.foundation_layer5_thermal_conductivity_unit,
            v.foundation_layer5_service_life,
            v.foundation_layer5_service_life_unit,
            v.foundation_layer5_density,
            v.foundation_layer5_density_unit,
            v.foundation_layer0_epd1_oekobaudat_name,
            v.foundation_layer0_epd1_oekobaudat_uuid,
            v.foundation_layer0_epd2_oekobaudat_name,
            v.foundation_layer0_epd2_oekobaudat_uuid,
            v.foundation_layer1_epd1_oekobaudat_name,
            v.foundation_layer1_epd1_oekobaudat_uuid,
            v.foundation_layer1_epd2_oekobaudat_name,
            v.foundation_layer1_epd2_oekobaudat_uuid,
            v.foundation_layer2_epd1_oekobaudat_name,
            v.foundation_layer2_epd1_oekobaudat_uuid,
            v.foundation_layer2_epd2_oekobaudat_name,
            v.foundation_layer2_epd2_oekobaudat_uuid,
            v.foundation_layer3_epd1_oekobaudat_name,
            v.foundation_layer3_epd1_oekobaudat_uuid,
            v.foundation_layer3_epd2_oekobaudat_name,
            v.foundation_layer3_epd2_oekobaudat_uuid,
            v.foundation_layer4_epd1_oekobaudat_name,
            v.foundation_layer4_epd1_oekobaudat_uuid,
            v.foundation_layer4_epd2_oekobaudat_name,
            v.foundation_layer4_epd2_oekobaudat_uuid,
            v.foundation_layer5_epd1_oekobaudat_name,
            v.foundation_layer5_epd1_oekobaudat_uuid,
            v.foundation_layer5_epd2_oekobaudat_name,
            v.foundation_layer5_epd2_oekobaudat_uuid,
            v.floor_name,
            v.floor_u_value_typical_min,
            v.floor_u_value_typical_max,
            v.floor_u_value,
            v.floor_u_value_unit,
            v.floor_inner_radiation,
            v.floor_inner_radiation_unit,
            v.floor_inner_convection,
            v.floor_inner_convection_unit,
            v.floor_layer0_position,
            v.floor_layer0_material_id,
            v.floor_layer0_material_name,
            v.floor_layer0_thickness,
            v.floor_layer0_thickness_unit,
            v.floor_layer0_solar_absorption_rate,
            v.floor_layer0_thermal_capacity,
            v.floor_layer0_thermal_capacity_unit,
            v.floor_layer0_thermal_conductivity,
            v.floor_layer0_thermal_conductivity_unit,
            v.floor_layer0_service_life,
            v.floor_layer0_service_life_unit,
            v.floor_layer0_density,
            v.floor_layer0_density_unit,
            v.floor_layer1_position,
            v.floor_layer1_material_id,
            v.floor_layer1_material_name,
            v.floor_layer1_thickness,
            v.floor_layer1_thickness_unit,
            v.floor_layer1_solar_absorption_rate,
            v.floor_layer1_thermal_capacity,
            v.floor_layer1_thermal_capacity_unit,
            v.floor_layer1_thermal_conductivity,
            v.floor_layer1_thermal_conductivity_unit,
            v.floor_layer1_service_life,
            v.floor_layer1_service_life_unit,
            v.floor_layer1_density,
            v.floor_layer1_density_unit,
            v.floor_layer2_position,
            v.floor_layer2_material_id,
            v.floor_layer2_material_name,
            v.floor_layer2_thickness,
            v.floor_layer2_thickness_unit,
            v.floor_layer2_solar_absorption_rate,
            v.floor_layer2_thermal_capacity,
            v.floor_layer2_thermal_capacity_unit,
            v.floor_layer2_thermal_conductivity,
            v.floor_layer2_thermal_conductivity_unit,
            v.floor_layer2_service_life,
            v.floor_layer2_service_life_unit,
            v.floor_layer2_density,
            v.floor_layer2_density_unit,
            v.floor_layer0_epd1_oekobaudat_name,
            v.floor_layer0_epd1_oekobaudat_uuid,
            v.floor_layer0_epd2_oekobaudat_name,
            v.floor_layer0_epd2_oekobaudat_uuid,
            v.floor_layer1_epd1_oekobaudat_name,
            v.floor_layer1_epd1_oekobaudat_uuid,
            v.floor_layer1_epd2_oekobaudat_name,
            v.floor_layer1_epd2_oekobaudat_uuid,
            v.floor_layer2_epd1_oekobaudat_name,
            v.floor_layer2_epd1_oekobaudat_uuid,
            v.floor_layer2_epd2_oekobaudat_name,
            v.floor_layer2_epd2_oekobaudat_uuid,
            v.window_name,
            v.window_inner_radiation,
            v.window_inner_radiation_unit,
            v.window_outer_radiation,
            v.window_outer_radiation_unit,
            v.window_inner_convection,
            v.window_inner_convection_unit,
            v.window_outer_convection,
            v.window_outer_convection_unit,
            v.glazing,
            v.frame_per_window,
            v.frame_per_window_unit,
            v.window_frame_area_share,
            v.g_value,
            v.a_conv,
            v.shading_type_name,
            v.window_frame_type_name,
            v.window_layer0_position,
            v.window_layer0_material_id,
            v.window_layer0_material_name,
            v.window_layer0_thickness,
            v.window_layer0_thickness_unit,
            v.window_layer0_solar_absorption_rate,
            v.window_layer0_thermal_capacity,
            v.window_layer0_thermal_capacity_unit,
            v.window_layer0_thermal_conductivity,
            v.window_layer0_thermal_conductivity_unit,
            v.window_layer0_service_life,
            v.window_layer0_service_life_unit,
            v.window_layer1_position,
            v.window_layer1_material_id,
            v.window_layer1_material_name,
            v.window_layer1_thickness,
            v.window_layer1_thickness_unit,
            v.window_layer1_solar_absorption_rate,
            v.window_layer1_thermal_capacity,
            v.window_layer1_thermal_capacity_unit,
            v.window_layer1_thermal_conductivity,
            v.window_layer1_thermal_conductivity_unit,
            v.window_layer1_service_life,
            v.window_layer1_service_life_unit,
            v.window_layer2_position,
            v.window_layer2_material_id,
            v.window_layer2_material_name,
            v.window_layer2_thickness,
            v.window_layer2_thickness_unit,
            v.window_layer2_solar_absorption_rate,
            v.window_layer2_thermal_capacity,
            v.window_layer2_thermal_capacity_unit,
            v.window_layer2_thermal_conductivity,
            v.window_layer2_thermal_conductivity_unit,
            v.window_layer2_service_life,
            v.window_layer2_service_life_unit,
            v.window_layer0_epd1_oekobaudat_name,
            v.window_layer0_epd1_oekobaudat_uuid,
            v.window_layer0_epd2_oekobaudat_name,
            v.window_layer0_epd2_oekobaudat_uuid,
            v.window_layer1_epd1_oekobaudat_name,
            v.window_layer1_epd1_oekobaudat_uuid,
            v.window_layer1_epd2_oekobaudat_name,
            v.window_layer1_epd2_oekobaudat_uuid,
            v.window_layer2_epd1_oekobaudat_name,
            v.window_layer2_epd1_oekobaudat_uuid,
            v.window_layer2_epd2_oekobaudat_name,
            v.window_layer2_epd2_oekobaudat_uuid,
            es.energy_system_name
           FROM (step_020 v
             LEFT JOIN hub4lca_post_simulation.energy_systems es ON ((es.energy_system_id = v.energy_system_id)))
        ), step_022 AS (
         WITH conv_ranked AS (
                 SELECT esec.energy_system_id,
                    esec.energy_converter_id,
                    row_number() OVER (PARTITION BY esec.energy_system_id ORDER BY esec.energy_converter_id) AS rn
                   FROM hub4lca_post_simulation.energy_systems_energy_converters esec
                ), conv_enriched AS (
                 SELECT cr.energy_system_id,
                    cr.rn,
                    cr.energy_converter_id,
                    ec.energy_converter_name,
                    ec.nominal_power_min,
                    ec.nominal_power_max,
                    u_pow.unit_name AS nominal_power_unit,
                    ec.area,
                    u_area.unit_name AS area_unit,
                    esf.energy_supply_function_name,
                    esrc.energy_source_name,
                    sl.service_life,
                    u_sl.unit_name AS service_life_unit
                   FROM (((((((conv_ranked cr
                     LEFT JOIN hub4lca_post_simulation.energy_converters ec ON ((ec.energy_converter_id = cr.energy_converter_id)))
                     LEFT JOIN hub4lca_post_simulation.energy_supply_functions esf ON ((esf.energy_supply_function_id = ec.energy_supply_function_id)))
                     LEFT JOIN hub4lca_post_simulation.energy_sources esrc ON ((esrc.energy_source_id = ec.energy_source_id)))
                     LEFT JOIN hub4lca_post_simulation.units u_area ON ((u_area.unit_id = ec.area_unit_id)))
                     LEFT JOIN hub4lca_post_simulation.service_lives sl ON ((sl.service_life_id = ec.service_life_id)))
                     LEFT JOIN hub4lca_post_simulation.units u_sl ON ((u_sl.unit_id = sl.unit_id)))
                     LEFT JOIN hub4lca_post_simulation.units u_pow ON ((u_pow.unit_id = ec.nominal_power_unit_id)))
                ), conv_pivot AS (
                 SELECT ce.energy_system_id,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.energy_converter_id
                            ELSE NULL::integer
                        END) AS converter_0_id,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.energy_converter_name
                            ELSE NULL::character varying
                        END)::text) AS converter_0_energy_converter_name,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.nominal_power_min
                            ELSE NULL::real
                        END) AS converter_0_nominal_power_min,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.nominal_power_max
                            ELSE NULL::real
                        END) AS converter_0_nominal_power_max,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.nominal_power_unit
                            ELSE NULL::character varying
                        END)::text) AS converter_0_nominal_power_unit,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.area
                            ELSE NULL::real
                        END) AS converter_0_area,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.area_unit
                            ELSE NULL::character varying
                        END)::text) AS converter_0_area_unit,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.energy_supply_function_name
                            ELSE NULL::character varying
                        END)::text) AS converter_0_supply_function_name,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.energy_source_name
                            ELSE NULL::text
                        END) AS converter_0_energy_source_name,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.service_life
                            ELSE NULL::integer
                        END) AS converter_0_service_life,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.service_life_unit
                            ELSE NULL::character varying
                        END)::text) AS converter_0_service_life_unit,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.energy_converter_id
                            ELSE NULL::integer
                        END) AS converter_1_id,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.energy_converter_name
                            ELSE NULL::character varying
                        END)::text) AS converter_1_energy_converter_name,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.nominal_power_min
                            ELSE NULL::real
                        END) AS converter_1_nominal_power_min,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.nominal_power_max
                            ELSE NULL::real
                        END) AS converter_1_nominal_power_max,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.nominal_power_unit
                            ELSE NULL::character varying
                        END)::text) AS converter_1_nominal_power_unit,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.area
                            ELSE NULL::real
                        END) AS converter_1_area,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.area_unit
                            ELSE NULL::character varying
                        END)::text) AS converter_1_area_unit,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.energy_supply_function_name
                            ELSE NULL::character varying
                        END)::text) AS converter_1_supply_function_name,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.energy_source_name
                            ELSE NULL::text
                        END) AS converter_1_energy_source_name,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.service_life
                            ELSE NULL::integer
                        END) AS converter_1_service_life,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.service_life_unit
                            ELSE NULL::character varying
                        END)::text) AS converter_1_service_life_unit
                   FROM conv_enriched ce
                  GROUP BY ce.energy_system_id
                )
         SELECT g.building_archetype_id,
            g.building_archetype_name,
            g.share_of_building_type,
            g.share_of_building_type_in_region,
            g.share_of_building_type_in_region_mun,
            g.exterior_wall_building_element_id,
            g.interior_wall_building_element_id,
            g.roof_building_element_id,
            g.foundation_building_element_id,
            g.floor_building_element_id,
            g.window_building_element_id,
            g.energy_system_id,
            g.building_type_name,
            g.region_name,
            g.municipality_size_name,
            g.municipality_growth_name,
            g.age_class_name,
            g.building_adjacency_name,
            g.facade_to_net_leased_area_ratio_mean,
            g.facade_to_net_leased_area_ratio_se_min,
            g.facade_to_net_leased_area_ratio_se_max,
            g.roof_to_net_leased_area_ratio_mean,
            g.roof_to_net_leased_area_ratio_se_min,
            g.roof_to_net_leased_area_ratio_se_max,
            g.foundation_to_net_leased_area_ratio_mean,
            g.foundation_to_net_leased_area_ratio_se_min,
            g.foundation_to_net_leased_area_ratio_se_max,
            g.window_to_net_leased_area_ratio_mean,
            g.window_to_net_leased_area_ratio_se_min,
            g.window_to_net_leased_area_ratio_se_max,
            g.building_height_mean,
            g.building_height_se,
            g.height_unit,
            g.aspect_ratio_mean,
            g.aspect_ratio_se_min,
            g.aspect_ratio_se_max,
            g.storeys_below_ground_mean,
            g.storeys_below_ground_se,
            g.storeys_above_ground_mean,
            g.storeys_above_ground_se,
            g.storeys_above_ground_se_min,
            g.storeys_above_ground_se_max,
            g.storey_height_mean,
            g.storey_height_se_min,
            g.storey_height_se_max,
            g.window_share,
            g.net_leased_area_mean,
            g.net_leased_area_se,
            g.net_leased_area_se_min,
            g.net_leased_area_se_max,
            g.net_leased_area_unit,
            g.facade_area_north_mean,
            g.facade_area_north_se,
            g.facade_area_east_mean,
            g.facade_area_east_se,
            g.facade_area_south_mean,
            g.facade_area_south_se,
            g.facade_area_west_mean,
            g.facade_area_west_se,
            g.facade_area_unit,
            g.facade_length_north_mean,
            g.facade_length_north_se,
            g.facade_length_east_mean,
            g.facade_length_east_se,
            g.facade_length_south_mean,
            g.facade_length_south_se,
            g.facade_length_west_mean,
            g.facade_length_west_se,
            g.facade_length_unit,
            g.exterior_wall_name,
            g.exterior_wall_construction_type,
            g.exterior_wall_u_value_typical_min,
            g.exterior_wall_u_value_typical_max,
            g.exterior_wall_u_value,
            g.exterior_wall_u_value_unit,
            g.exterior_wall_inner_radiation,
            g.exterior_wall_inner_radiation_unit,
            g.exterior_wall_outer_radiation,
            g.exterior_wall_outer_radiation_unit,
            g.exterior_wall_inner_convection,
            g.exterior_wall_inner_convection_unit,
            g.exterior_wall_outer_convection,
            g.exterior_wall_outer_convection_unit,
            g.exterior_wall_layer0_position,
            g.exterior_wall_layer0_material_id,
            g.exterior_wall_layer0_material_name,
            g.exterior_wall_layer0_thickness,
            g.exterior_wall_layer0_thickness_unit,
            g.exterior_wall_layer0_solar_absorption_rate,
            g.exterior_wall_layer0_thermal_capacity,
            g.exterior_wall_layer0_thermal_capacity_unit,
            g.exterior_wall_layer0_thermal_conductivity,
            g.exterior_wall_layer0_thermal_conductivity_unit,
            g.exterior_wall_layer0_service_life,
            g.exterior_wall_layer0_service_life_unit,
            g.exterior_wall_layer0_density,
            g.exterior_wall_layer0_density_unit,
            g.exterior_wall_layer1_position,
            g.exterior_wall_layer1_material_id,
            g.exterior_wall_layer1_material_name,
            g.exterior_wall_layer1_thickness,
            g.exterior_wall_layer1_thickness_unit,
            g.exterior_wall_layer1_solar_absorption_rate,
            g.exterior_wall_layer1_thermal_capacity,
            g.exterior_wall_layer1_thermal_capacity_unit,
            g.exterior_wall_layer1_thermal_conductivity,
            g.exterior_wall_layer1_thermal_conductivity_unit,
            g.exterior_wall_layer1_service_life,
            g.exterior_wall_layer1_service_life_unit,
            g.exterior_wall_layer1_density,
            g.exterior_wall_layer1_density_unit,
            g.exterior_wall_layer2_position,
            g.exterior_wall_layer2_material_id,
            g.exterior_wall_layer2_material_name,
            g.exterior_wall_layer2_thickness,
            g.exterior_wall_layer2_thickness_unit,
            g.exterior_wall_layer2_solar_absorption_rate,
            g.exterior_wall_layer2_thermal_capacity,
            g.exterior_wall_layer2_thermal_capacity_unit,
            g.exterior_wall_layer2_thermal_conductivity,
            g.exterior_wall_layer2_thermal_conductivity_unit,
            g.exterior_wall_layer2_service_life,
            g.exterior_wall_layer2_service_life_unit,
            g.exterior_wall_layer2_density,
            g.exterior_wall_layer2_density_unit,
            g.exterior_wall_layer3_position,
            g.exterior_wall_layer3_material_id,
            g.exterior_wall_layer3_material_name,
            g.exterior_wall_layer3_thickness,
            g.exterior_wall_layer3_thickness_unit,
            g.exterior_wall_layer3_solar_absorption_rate,
            g.exterior_wall_layer3_thermal_capacity,
            g.exterior_wall_layer3_thermal_capacity_unit,
            g.exterior_wall_layer3_thermal_conductivity,
            g.exterior_wall_layer3_thermal_conductivity_unit,
            g.exterior_wall_layer3_service_life,
            g.exterior_wall_layer3_service_life_unit,
            g.exterior_wall_layer3_density,
            g.exterior_wall_layer3_density_unit,
            g.exterior_wall_layer4_position,
            g.exterior_wall_layer4_material_id,
            g.exterior_wall_layer4_material_name,
            g.exterior_wall_layer4_thickness,
            g.exterior_wall_layer4_thickness_unit,
            g.exterior_wall_layer4_solar_absorption_rate,
            g.exterior_wall_layer4_thermal_capacity,
            g.exterior_wall_layer4_thermal_capacity_unit,
            g.exterior_wall_layer4_thermal_conductivity,
            g.exterior_wall_layer4_thermal_conductivity_unit,
            g.exterior_wall_layer4_service_life,
            g.exterior_wall_layer4_service_life_unit,
            g.exterior_wall_layer4_density,
            g.exterior_wall_layer4_density_unit,
            g.exterior_wall_layer5_position,
            g.exterior_wall_layer5_material_id,
            g.exterior_wall_layer5_material_name,
            g.exterior_wall_layer5_thickness,
            g.exterior_wall_layer5_thickness_unit,
            g.exterior_wall_layer5_solar_absorption_rate,
            g.exterior_wall_layer5_thermal_capacity,
            g.exterior_wall_layer5_thermal_capacity_unit,
            g.exterior_wall_layer5_thermal_conductivity,
            g.exterior_wall_layer5_thermal_conductivity_unit,
            g.exterior_wall_layer5_service_life,
            g.exterior_wall_layer5_service_life_unit,
            g.exterior_wall_layer5_density,
            g.exterior_wall_layer5_density_unit,
            g.exterior_wall_layer0_epd1_oekobaudat_name,
            g.exterior_wall_layer0_epd1_oekobaudat_uuid,
            g.exterior_wall_layer0_epd2_oekobaudat_name,
            g.exterior_wall_layer0_epd2_oekobaudat_uuid,
            g.exterior_wall_layer1_epd1_oekobaudat_name,
            g.exterior_wall_layer1_epd1_oekobaudat_uuid,
            g.exterior_wall_layer1_epd2_oekobaudat_name,
            g.exterior_wall_layer1_epd2_oekobaudat_uuid,
            g.exterior_wall_layer2_epd1_oekobaudat_name,
            g.exterior_wall_layer2_epd1_oekobaudat_uuid,
            g.exterior_wall_layer2_epd2_oekobaudat_name,
            g.exterior_wall_layer2_epd2_oekobaudat_uuid,
            g.exterior_wall_layer3_epd1_oekobaudat_name,
            g.exterior_wall_layer3_epd1_oekobaudat_uuid,
            g.exterior_wall_layer3_epd2_oekobaudat_name,
            g.exterior_wall_layer3_epd2_oekobaudat_uuid,
            g.exterior_wall_layer4_epd1_oekobaudat_name,
            g.exterior_wall_layer4_epd1_oekobaudat_uuid,
            g.exterior_wall_layer4_epd2_oekobaudat_name,
            g.exterior_wall_layer4_epd2_oekobaudat_uuid,
            g.exterior_wall_layer5_epd1_oekobaudat_name,
            g.exterior_wall_layer5_epd1_oekobaudat_uuid,
            g.exterior_wall_layer5_epd2_oekobaudat_name,
            g.exterior_wall_layer5_epd2_oekobaudat_uuid,
            g.interior_wall_name,
            g.interior_wall_u_value_typical_min,
            g.interior_wall_u_value_typical_max,
            g.interior_wall_u_value,
            g.interior_wall_u_value_unit,
            g.interior_wall_inner_radiation,
            g.interior_wall_inner_radiation_unit,
            g.interior_wall_inner_convection,
            g.interior_wall_inner_convection_unit,
            g.interior_wall_layer0_position,
            g.interior_wall_layer0_material_id,
            g.interior_wall_layer0_material_name,
            g.interior_wall_layer0_thickness,
            g.interior_wall_layer0_thickness_unit,
            g.interior_wall_layer0_solar_absorption_rate,
            g.interior_wall_layer0_thermal_capacity,
            g.interior_wall_layer0_thermal_capacity_unit,
            g.interior_wall_layer0_thermal_conductivity,
            g.interior_wall_layer0_thermal_conductivity_unit,
            g.interior_wall_layer0_service_life,
            g.interior_wall_layer0_service_life_unit,
            g.interior_wall_layer0_density,
            g.interior_wall_layer0_density_unit,
            g.interior_wall_layer1_position,
            g.interior_wall_layer1_material_id,
            g.interior_wall_layer1_material_name,
            g.interior_wall_layer1_thickness,
            g.interior_wall_layer1_thickness_unit,
            g.interior_wall_layer1_solar_absorption_rate,
            g.interior_wall_layer1_thermal_capacity,
            g.interior_wall_layer1_thermal_capacity_unit,
            g.interior_wall_layer1_thermal_conductivity,
            g.interior_wall_layer1_thermal_conductivity_unit,
            g.interior_wall_layer1_service_life,
            g.interior_wall_layer1_service_life_unit,
            g.interior_wall_layer1_density,
            g.interior_wall_layer1_density_unit,
            g.interior_wall_layer2_position,
            g.interior_wall_layer2_material_id,
            g.interior_wall_layer2_material_name,
            g.interior_wall_layer2_thickness,
            g.interior_wall_layer2_thickness_unit,
            g.interior_wall_layer2_solar_absorption_rate,
            g.interior_wall_layer2_thermal_capacity,
            g.interior_wall_layer2_thermal_capacity_unit,
            g.interior_wall_layer2_thermal_conductivity,
            g.interior_wall_layer2_thermal_conductivity_unit,
            g.interior_wall_layer2_service_life,
            g.interior_wall_layer2_service_life_unit,
            g.interior_wall_layer2_density,
            g.interior_wall_layer2_density_unit,
            g.interior_wall_layer0_epd1_oekobaudat_name,
            g.interior_wall_layer0_epd1_oekobaudat_uuid,
            g.interior_wall_layer0_epd2_oekobaudat_name,
            g.interior_wall_layer0_epd2_oekobaudat_uuid,
            g.interior_wall_layer1_epd1_oekobaudat_name,
            g.interior_wall_layer1_epd1_oekobaudat_uuid,
            g.interior_wall_layer1_epd2_oekobaudat_name,
            g.interior_wall_layer1_epd2_oekobaudat_uuid,
            g.interior_wall_layer2_epd1_oekobaudat_name,
            g.interior_wall_layer2_epd1_oekobaudat_uuid,
            g.interior_wall_layer2_epd2_oekobaudat_name,
            g.interior_wall_layer2_epd2_oekobaudat_uuid,
            g.roof_name,
            g.roof_construction_type,
            g.roof_pitch_type,
            g.roof_u_value_typical_min,
            g.roof_u_value_typical_max,
            g.roof_u_value,
            g.roof_u_value_unit,
            g.roof_inner_radiation,
            g.roof_inner_radiation_unit,
            g.roof_outer_radiation,
            g.roof_outer_radiation_unit,
            g.roof_inner_convection,
            g.roof_inner_convection_unit,
            g.roof_outer_convection,
            g.roof_outer_convection_unit,
            g.roof_layer0_position,
            g.roof_layer0_material_id,
            g.roof_layer0_material_name,
            g.roof_layer0_thickness,
            g.roof_layer0_thickness_unit,
            g.roof_layer0_solar_absorption_rate,
            g.roof_layer0_thermal_capacity,
            g.roof_layer0_thermal_capacity_unit,
            g.roof_layer0_thermal_conductivity,
            g.roof_layer0_thermal_conductivity_unit,
            g.roof_layer0_service_life,
            g.roof_layer0_service_life_unit,
            g.roof_layer0_density,
            g.roof_layer0_density_unit,
            g.roof_layer1_position,
            g.roof_layer1_material_id,
            g.roof_layer1_material_name,
            g.roof_layer1_thickness,
            g.roof_layer1_thickness_unit,
            g.roof_layer1_solar_absorption_rate,
            g.roof_layer1_thermal_capacity,
            g.roof_layer1_thermal_capacity_unit,
            g.roof_layer1_thermal_conductivity,
            g.roof_layer1_thermal_conductivity_unit,
            g.roof_layer1_service_life,
            g.roof_layer1_service_life_unit,
            g.roof_layer1_density,
            g.roof_layer1_density_unit,
            g.roof_layer2_position,
            g.roof_layer2_material_id,
            g.roof_layer2_material_name,
            g.roof_layer2_thickness,
            g.roof_layer2_thickness_unit,
            g.roof_layer2_solar_absorption_rate,
            g.roof_layer2_thermal_capacity,
            g.roof_layer2_thermal_capacity_unit,
            g.roof_layer2_thermal_conductivity,
            g.roof_layer2_thermal_conductivity_unit,
            g.roof_layer2_service_life,
            g.roof_layer2_service_life_unit,
            g.roof_layer2_density,
            g.roof_layer2_density_unit,
            g.roof_layer3_position,
            g.roof_layer3_material_id,
            g.roof_layer3_material_name,
            g.roof_layer3_thickness,
            g.roof_layer3_thickness_unit,
            g.roof_layer3_solar_absorption_rate,
            g.roof_layer3_thermal_capacity,
            g.roof_layer3_thermal_capacity_unit,
            g.roof_layer3_thermal_conductivity,
            g.roof_layer3_thermal_conductivity_unit,
            g.roof_layer3_service_life,
            g.roof_layer3_service_life_unit,
            g.roof_layer3_density,
            g.roof_layer3_density_unit,
            g.roof_layer4_position,
            g.roof_layer4_material_id,
            g.roof_layer4_material_name,
            g.roof_layer4_thickness,
            g.roof_layer4_thickness_unit,
            g.roof_layer4_solar_absorption_rate,
            g.roof_layer4_thermal_capacity,
            g.roof_layer4_thermal_capacity_unit,
            g.roof_layer4_thermal_conductivity,
            g.roof_layer4_thermal_conductivity_unit,
            g.roof_layer4_service_life,
            g.roof_layer4_service_life_unit,
            g.roof_layer4_density,
            g.roof_layer4_density_unit,
            g.roof_layer5_position,
            g.roof_layer5_material_id,
            g.roof_layer5_material_name,
            g.roof_layer5_thickness,
            g.roof_layer5_thickness_unit,
            g.roof_layer5_solar_absorption_rate,
            g.roof_layer5_thermal_capacity,
            g.roof_layer5_thermal_capacity_unit,
            g.roof_layer5_thermal_conductivity,
            g.roof_layer5_thermal_conductivity_unit,
            g.roof_layer5_service_life,
            g.roof_layer5_service_life_unit,
            g.roof_layer5_density,
            g.roof_layer5_density_unit,
            g.roof_layer0_epd1_oekobaudat_name,
            g.roof_layer0_epd1_oekobaudat_uuid,
            g.roof_layer0_epd2_oekobaudat_name,
            g.roof_layer0_epd2_oekobaudat_uuid,
            g.roof_layer1_epd1_oekobaudat_name,
            g.roof_layer1_epd1_oekobaudat_uuid,
            g.roof_layer1_epd2_oekobaudat_name,
            g.roof_layer1_epd2_oekobaudat_uuid,
            g.roof_layer2_epd1_oekobaudat_name,
            g.roof_layer2_epd1_oekobaudat_uuid,
            g.roof_layer2_epd2_oekobaudat_name,
            g.roof_layer2_epd2_oekobaudat_uuid,
            g.roof_layer3_epd1_oekobaudat_name,
            g.roof_layer3_epd1_oekobaudat_uuid,
            g.roof_layer3_epd2_oekobaudat_name,
            g.roof_layer3_epd2_oekobaudat_uuid,
            g.roof_layer4_epd1_oekobaudat_name,
            g.roof_layer4_epd1_oekobaudat_uuid,
            g.roof_layer4_epd2_oekobaudat_name,
            g.roof_layer4_epd2_oekobaudat_uuid,
            g.roof_layer5_epd1_oekobaudat_name,
            g.roof_layer5_epd1_oekobaudat_uuid,
            g.roof_layer5_epd2_oekobaudat_name,
            g.roof_layer5_epd2_oekobaudat_uuid,
            g.foundation_name,
            g.foundation_construction_type,
            g.foundation_u_value_typical_min,
            g.foundation_u_value_typical_max,
            g.foundation_u_value,
            g.foundation_u_value_unit,
            g.foundation_inner_radiation,
            g.foundation_inner_radiation_unit,
            g.foundation_inner_convection,
            g.foundation_inner_convection_unit,
            g.foundation_layer0_position,
            g.foundation_layer0_material_id,
            g.foundation_layer0_material_name,
            g.foundation_layer0_thickness,
            g.foundation_layer0_thickness_unit,
            g.foundation_layer0_solar_absorption_rate,
            g.foundation_layer0_thermal_capacity,
            g.foundation_layer0_thermal_capacity_unit,
            g.foundation_layer0_thermal_conductivity,
            g.foundation_layer0_thermal_conductivity_unit,
            g.foundation_layer0_service_life,
            g.foundation_layer0_service_life_unit,
            g.foundation_layer0_density,
            g.foundation_layer0_density_unit,
            g.foundation_layer1_position,
            g.foundation_layer1_material_id,
            g.foundation_layer1_material_name,
            g.foundation_layer1_thickness,
            g.foundation_layer1_thickness_unit,
            g.foundation_layer1_solar_absorption_rate,
            g.foundation_layer1_thermal_capacity,
            g.foundation_layer1_thermal_capacity_unit,
            g.foundation_layer1_thermal_conductivity,
            g.foundation_layer1_thermal_conductivity_unit,
            g.foundation_layer1_service_life,
            g.foundation_layer1_service_life_unit,
            g.foundation_layer1_density,
            g.foundation_layer1_density_unit,
            g.foundation_layer2_position,
            g.foundation_layer2_material_id,
            g.foundation_layer2_material_name,
            g.foundation_layer2_thickness,
            g.foundation_layer2_thickness_unit,
            g.foundation_layer2_solar_absorption_rate,
            g.foundation_layer2_thermal_capacity,
            g.foundation_layer2_thermal_capacity_unit,
            g.foundation_layer2_thermal_conductivity,
            g.foundation_layer2_thermal_conductivity_unit,
            g.foundation_layer2_service_life,
            g.foundation_layer2_service_life_unit,
            g.foundation_layer2_density,
            g.foundation_layer2_density_unit,
            g.foundation_layer3_position,
            g.foundation_layer3_material_id,
            g.foundation_layer3_material_name,
            g.foundation_layer3_thickness,
            g.foundation_layer3_thickness_unit,
            g.foundation_layer3_solar_absorption_rate,
            g.foundation_layer3_thermal_capacity,
            g.foundation_layer3_thermal_capacity_unit,
            g.foundation_layer3_thermal_conductivity,
            g.foundation_layer3_thermal_conductivity_unit,
            g.foundation_layer3_service_life,
            g.foundation_layer3_service_life_unit,
            g.foundation_layer3_density,
            g.foundation_layer3_density_unit,
            g.foundation_layer4_position,
            g.foundation_layer4_material_id,
            g.foundation_layer4_material_name,
            g.foundation_layer4_thickness,
            g.foundation_layer4_thickness_unit,
            g.foundation_layer4_solar_absorption_rate,
            g.foundation_layer4_thermal_capacity,
            g.foundation_layer4_thermal_capacity_unit,
            g.foundation_layer4_thermal_conductivity,
            g.foundation_layer4_thermal_conductivity_unit,
            g.foundation_layer4_service_life,
            g.foundation_layer4_service_life_unit,
            g.foundation_layer4_density,
            g.foundation_layer4_density_unit,
            g.foundation_layer5_position,
            g.foundation_layer5_material_id,
            g.foundation_layer5_material_name,
            g.foundation_layer5_thickness,
            g.foundation_layer5_thickness_unit,
            g.foundation_layer5_solar_absorption_rate,
            g.foundation_layer5_thermal_capacity,
            g.foundation_layer5_thermal_capacity_unit,
            g.foundation_layer5_thermal_conductivity,
            g.foundation_layer5_thermal_conductivity_unit,
            g.foundation_layer5_service_life,
            g.foundation_layer5_service_life_unit,
            g.foundation_layer5_density,
            g.foundation_layer5_density_unit,
            g.foundation_layer0_epd1_oekobaudat_name,
            g.foundation_layer0_epd1_oekobaudat_uuid,
            g.foundation_layer0_epd2_oekobaudat_name,
            g.foundation_layer0_epd2_oekobaudat_uuid,
            g.foundation_layer1_epd1_oekobaudat_name,
            g.foundation_layer1_epd1_oekobaudat_uuid,
            g.foundation_layer1_epd2_oekobaudat_name,
            g.foundation_layer1_epd2_oekobaudat_uuid,
            g.foundation_layer2_epd1_oekobaudat_name,
            g.foundation_layer2_epd1_oekobaudat_uuid,
            g.foundation_layer2_epd2_oekobaudat_name,
            g.foundation_layer2_epd2_oekobaudat_uuid,
            g.foundation_layer3_epd1_oekobaudat_name,
            g.foundation_layer3_epd1_oekobaudat_uuid,
            g.foundation_layer3_epd2_oekobaudat_name,
            g.foundation_layer3_epd2_oekobaudat_uuid,
            g.foundation_layer4_epd1_oekobaudat_name,
            g.foundation_layer4_epd1_oekobaudat_uuid,
            g.foundation_layer4_epd2_oekobaudat_name,
            g.foundation_layer4_epd2_oekobaudat_uuid,
            g.foundation_layer5_epd1_oekobaudat_name,
            g.foundation_layer5_epd1_oekobaudat_uuid,
            g.foundation_layer5_epd2_oekobaudat_name,
            g.foundation_layer5_epd2_oekobaudat_uuid,
            g.floor_name,
            g.floor_u_value_typical_min,
            g.floor_u_value_typical_max,
            g.floor_u_value,
            g.floor_u_value_unit,
            g.floor_inner_radiation,
            g.floor_inner_radiation_unit,
            g.floor_inner_convection,
            g.floor_inner_convection_unit,
            g.floor_layer0_position,
            g.floor_layer0_material_id,
            g.floor_layer0_material_name,
            g.floor_layer0_thickness,
            g.floor_layer0_thickness_unit,
            g.floor_layer0_solar_absorption_rate,
            g.floor_layer0_thermal_capacity,
            g.floor_layer0_thermal_capacity_unit,
            g.floor_layer0_thermal_conductivity,
            g.floor_layer0_thermal_conductivity_unit,
            g.floor_layer0_service_life,
            g.floor_layer0_service_life_unit,
            g.floor_layer0_density,
            g.floor_layer0_density_unit,
            g.floor_layer1_position,
            g.floor_layer1_material_id,
            g.floor_layer1_material_name,
            g.floor_layer1_thickness,
            g.floor_layer1_thickness_unit,
            g.floor_layer1_solar_absorption_rate,
            g.floor_layer1_thermal_capacity,
            g.floor_layer1_thermal_capacity_unit,
            g.floor_layer1_thermal_conductivity,
            g.floor_layer1_thermal_conductivity_unit,
            g.floor_layer1_service_life,
            g.floor_layer1_service_life_unit,
            g.floor_layer1_density,
            g.floor_layer1_density_unit,
            g.floor_layer2_position,
            g.floor_layer2_material_id,
            g.floor_layer2_material_name,
            g.floor_layer2_thickness,
            g.floor_layer2_thickness_unit,
            g.floor_layer2_solar_absorption_rate,
            g.floor_layer2_thermal_capacity,
            g.floor_layer2_thermal_capacity_unit,
            g.floor_layer2_thermal_conductivity,
            g.floor_layer2_thermal_conductivity_unit,
            g.floor_layer2_service_life,
            g.floor_layer2_service_life_unit,
            g.floor_layer2_density,
            g.floor_layer2_density_unit,
            g.floor_layer0_epd1_oekobaudat_name,
            g.floor_layer0_epd1_oekobaudat_uuid,
            g.floor_layer0_epd2_oekobaudat_name,
            g.floor_layer0_epd2_oekobaudat_uuid,
            g.floor_layer1_epd1_oekobaudat_name,
            g.floor_layer1_epd1_oekobaudat_uuid,
            g.floor_layer1_epd2_oekobaudat_name,
            g.floor_layer1_epd2_oekobaudat_uuid,
            g.floor_layer2_epd1_oekobaudat_name,
            g.floor_layer2_epd1_oekobaudat_uuid,
            g.floor_layer2_epd2_oekobaudat_name,
            g.floor_layer2_epd2_oekobaudat_uuid,
            g.window_name,
            g.window_inner_radiation,
            g.window_inner_radiation_unit,
            g.window_outer_radiation,
            g.window_outer_radiation_unit,
            g.window_inner_convection,
            g.window_inner_convection_unit,
            g.window_outer_convection,
            g.window_outer_convection_unit,
            g.glazing,
            g.frame_per_window,
            g.frame_per_window_unit,
            g.window_frame_area_share,
            g.g_value,
            g.a_conv,
            g.shading_type_name,
            g.window_frame_type_name,
            g.window_layer0_position,
            g.window_layer0_material_id,
            g.window_layer0_material_name,
            g.window_layer0_thickness,
            g.window_layer0_thickness_unit,
            g.window_layer0_solar_absorption_rate,
            g.window_layer0_thermal_capacity,
            g.window_layer0_thermal_capacity_unit,
            g.window_layer0_thermal_conductivity,
            g.window_layer0_thermal_conductivity_unit,
            g.window_layer0_service_life,
            g.window_layer0_service_life_unit,
            g.window_layer1_position,
            g.window_layer1_material_id,
            g.window_layer1_material_name,
            g.window_layer1_thickness,
            g.window_layer1_thickness_unit,
            g.window_layer1_solar_absorption_rate,
            g.window_layer1_thermal_capacity,
            g.window_layer1_thermal_capacity_unit,
            g.window_layer1_thermal_conductivity,
            g.window_layer1_thermal_conductivity_unit,
            g.window_layer1_service_life,
            g.window_layer1_service_life_unit,
            g.window_layer2_position,
            g.window_layer2_material_id,
            g.window_layer2_material_name,
            g.window_layer2_thickness,
            g.window_layer2_thickness_unit,
            g.window_layer2_solar_absorption_rate,
            g.window_layer2_thermal_capacity,
            g.window_layer2_thermal_capacity_unit,
            g.window_layer2_thermal_conductivity,
            g.window_layer2_thermal_conductivity_unit,
            g.window_layer2_service_life,
            g.window_layer2_service_life_unit,
            g.window_layer0_epd1_oekobaudat_name,
            g.window_layer0_epd1_oekobaudat_uuid,
            g.window_layer0_epd2_oekobaudat_name,
            g.window_layer0_epd2_oekobaudat_uuid,
            g.window_layer1_epd1_oekobaudat_name,
            g.window_layer1_epd1_oekobaudat_uuid,
            g.window_layer1_epd2_oekobaudat_name,
            g.window_layer1_epd2_oekobaudat_uuid,
            g.window_layer2_epd1_oekobaudat_name,
            g.window_layer2_epd1_oekobaudat_uuid,
            g.window_layer2_epd2_oekobaudat_name,
            g.window_layer2_epd2_oekobaudat_uuid,
            g.energy_system_name,
            cp.converter_0_id,
            cp.converter_0_energy_converter_name,
            cp.converter_1_id,
            cp.converter_1_energy_converter_name,
            cp.converter_0_nominal_power_min,
            cp.converter_0_nominal_power_max,
            cp.converter_0_nominal_power_unit,
            cp.converter_1_nominal_power_min,
            cp.converter_1_nominal_power_max,
            cp.converter_1_nominal_power_unit,
            cp.converter_0_area,
            cp.converter_0_area_unit,
            cp.converter_1_area,
            cp.converter_1_area_unit,
            cp.converter_0_supply_function_name,
            cp.converter_1_supply_function_name,
            cp.converter_0_energy_source_name,
            cp.converter_1_energy_source_name,
            cp.converter_0_service_life,
            cp.converter_0_service_life_unit,
            cp.converter_1_service_life,
            cp.converter_1_service_life_unit
           FROM (step_021 g
             LEFT JOIN conv_pivot cp ON ((cp.energy_system_id = g.energy_system_id)))
        ), step_023 AS (
         WITH conv_ranked AS (
                 SELECT esec.energy_system_id,
                    esec.energy_converter_id,
                    row_number() OVER (PARTITION BY esec.energy_system_id ORDER BY esec.energy_converter_id) AS rn
                   FROM hub4lca_post_simulation.energy_systems_energy_converters esec
                ), conv_epds AS (
                 SELECT cr.energy_system_id,
                    cr.rn,
                    cr.energy_converter_id,
                    ec.environmental_product_declaration_id_1 AS epd_1_id,
                    ec.environmental_product_declaration_id_2 AS epd_2_id,
                    epd1.environmental_product_declaration_name AS epd_1_name,
                    epd1.database_uuid AS epd_1_database_uuid,
                    epd2.environmental_product_declaration_name AS epd_2_name,
                    epd2.database_uuid AS epd_2_database_uuid,
                    es.environmental_product_declaration_id AS es_epd_id,
                    epd_es.environmental_product_declaration_name AS es_epd_name,
                    epd_es.database_uuid AS es_epd_database_uuid
                   FROM (((((conv_ranked cr
                     LEFT JOIN hub4lca_post_simulation.energy_converters ec ON ((ec.energy_converter_id = cr.energy_converter_id)))
                     LEFT JOIN hub4lca_post_simulation.energy_sources es ON ((es.energy_source_id = ec.energy_source_id)))
                     LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd1 ON ((epd1.environmental_product_declaration_id = ec.environmental_product_declaration_id_1)))
                     LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd2 ON ((epd2.environmental_product_declaration_id = ec.environmental_product_declaration_id_2)))
                     LEFT JOIN hub4lca_post_simulation.environmental_product_declarations epd_es ON ((epd_es.environmental_product_declaration_id = es.environmental_product_declaration_id)))
                ), conv_epds_pivot AS (
                 SELECT ce.energy_system_id,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.epd_1_id
                            ELSE NULL::integer
                        END) AS converter_0_epd_1_id,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.epd_1_name
                            ELSE NULL::text
                        END) AS converter_0_epd_1_name,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.epd_1_database_uuid
                            ELSE NULL::character varying
                        END)::text) AS converter_0_epd_1_database_uuid,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.epd_2_id
                            ELSE NULL::integer
                        END) AS converter_0_epd_2_id,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.epd_2_name
                            ELSE NULL::text
                        END) AS converter_0_epd_2_name,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.epd_2_database_uuid
                            ELSE NULL::character varying
                        END)::text) AS converter_0_epd_2_database_uuid,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.es_epd_id
                            ELSE NULL::integer
                        END) AS converter_0_energy_source_epd_id,
                    max(
                        CASE
                            WHEN (ce.rn = 1) THEN ce.es_epd_name
                            ELSE NULL::text
                        END) AS converter_0_energy_source_epd_name,
                    max((
                        CASE
                            WHEN (ce.rn = 1) THEN ce.es_epd_database_uuid
                            ELSE NULL::character varying
                        END)::text) AS converter_0_energy_source_epd_database_uuid,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.epd_1_id
                            ELSE NULL::integer
                        END) AS converter_1_epd_1_id,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.epd_1_name
                            ELSE NULL::text
                        END) AS converter_1_epd_1_name,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.epd_1_database_uuid
                            ELSE NULL::character varying
                        END)::text) AS converter_1_epd_1_database_uuid,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.epd_2_id
                            ELSE NULL::integer
                        END) AS converter_1_epd_2_id,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.epd_2_name
                            ELSE NULL::text
                        END) AS converter_1_epd_2_name,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.epd_2_database_uuid
                            ELSE NULL::character varying
                        END)::text) AS converter_1_epd_2_database_uuid,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.es_epd_id
                            ELSE NULL::integer
                        END) AS converter_1_energy_source_epd_id,
                    max(
                        CASE
                            WHEN (ce.rn = 2) THEN ce.es_epd_name
                            ELSE NULL::text
                        END) AS converter_1_energy_source_epd_name,
                    max((
                        CASE
                            WHEN (ce.rn = 2) THEN ce.es_epd_database_uuid
                            ELSE NULL::character varying
                        END)::text) AS converter_1_energy_source_epd_database_uuid
                   FROM conv_epds ce
                  GROUP BY ce.energy_system_id
                )
         SELECT g.building_archetype_id,
            g.building_archetype_name,
            g.share_of_building_type,
            g.share_of_building_type_in_region,
            g.share_of_building_type_in_region_mun,
            g.exterior_wall_building_element_id,
            g.interior_wall_building_element_id,
            g.roof_building_element_id,
            g.foundation_building_element_id,
            g.floor_building_element_id,
            g.window_building_element_id,
            g.energy_system_id,
            g.building_type_name,
            g.region_name,
            g.municipality_size_name,
            g.municipality_growth_name,
            g.age_class_name,
            g.building_adjacency_name,
            g.facade_to_net_leased_area_ratio_mean,
            g.facade_to_net_leased_area_ratio_se_min,
            g.facade_to_net_leased_area_ratio_se_max,
            g.roof_to_net_leased_area_ratio_mean,
            g.roof_to_net_leased_area_ratio_se_min,
            g.roof_to_net_leased_area_ratio_se_max,
            g.foundation_to_net_leased_area_ratio_mean,
            g.foundation_to_net_leased_area_ratio_se_min,
            g.foundation_to_net_leased_area_ratio_se_max,
            g.window_to_net_leased_area_ratio_mean,
            g.window_to_net_leased_area_ratio_se_min,
            g.window_to_net_leased_area_ratio_se_max,
            g.building_height_mean,
            g.building_height_se,
            g.height_unit,
            g.aspect_ratio_mean,
            g.aspect_ratio_se_min,
            g.aspect_ratio_se_max,
            g.storeys_below_ground_mean,
            g.storeys_below_ground_se,
            g.storeys_above_ground_mean,
            g.storeys_above_ground_se,
            g.storeys_above_ground_se_min,
            g.storeys_above_ground_se_max,
            g.storey_height_mean,
            g.storey_height_se_min,
            g.storey_height_se_max,
            g.window_share,
            g.net_leased_area_mean,
            g.net_leased_area_se,
            g.net_leased_area_se_min,
            g.net_leased_area_se_max,
            g.net_leased_area_unit,
            g.facade_area_north_mean,
            g.facade_area_north_se,
            g.facade_area_east_mean,
            g.facade_area_east_se,
            g.facade_area_south_mean,
            g.facade_area_south_se,
            g.facade_area_west_mean,
            g.facade_area_west_se,
            g.facade_area_unit,
            g.facade_length_north_mean,
            g.facade_length_north_se,
            g.facade_length_east_mean,
            g.facade_length_east_se,
            g.facade_length_south_mean,
            g.facade_length_south_se,
            g.facade_length_west_mean,
            g.facade_length_west_se,
            g.facade_length_unit,
            g.exterior_wall_name,
            g.exterior_wall_construction_type,
            g.exterior_wall_u_value_typical_min,
            g.exterior_wall_u_value_typical_max,
            g.exterior_wall_u_value,
            g.exterior_wall_u_value_unit,
            g.exterior_wall_inner_radiation,
            g.exterior_wall_inner_radiation_unit,
            g.exterior_wall_outer_radiation,
            g.exterior_wall_outer_radiation_unit,
            g.exterior_wall_inner_convection,
            g.exterior_wall_inner_convection_unit,
            g.exterior_wall_outer_convection,
            g.exterior_wall_outer_convection_unit,
            g.exterior_wall_layer0_position,
            g.exterior_wall_layer0_material_id,
            g.exterior_wall_layer0_material_name,
            g.exterior_wall_layer0_thickness,
            g.exterior_wall_layer0_thickness_unit,
            g.exterior_wall_layer0_solar_absorption_rate,
            g.exterior_wall_layer0_thermal_capacity,
            g.exterior_wall_layer0_thermal_capacity_unit,
            g.exterior_wall_layer0_thermal_conductivity,
            g.exterior_wall_layer0_thermal_conductivity_unit,
            g.exterior_wall_layer0_service_life,
            g.exterior_wall_layer0_service_life_unit,
            g.exterior_wall_layer0_density,
            g.exterior_wall_layer0_density_unit,
            g.exterior_wall_layer1_position,
            g.exterior_wall_layer1_material_id,
            g.exterior_wall_layer1_material_name,
            g.exterior_wall_layer1_thickness,
            g.exterior_wall_layer1_thickness_unit,
            g.exterior_wall_layer1_solar_absorption_rate,
            g.exterior_wall_layer1_thermal_capacity,
            g.exterior_wall_layer1_thermal_capacity_unit,
            g.exterior_wall_layer1_thermal_conductivity,
            g.exterior_wall_layer1_thermal_conductivity_unit,
            g.exterior_wall_layer1_service_life,
            g.exterior_wall_layer1_service_life_unit,
            g.exterior_wall_layer1_density,
            g.exterior_wall_layer1_density_unit,
            g.exterior_wall_layer2_position,
            g.exterior_wall_layer2_material_id,
            g.exterior_wall_layer2_material_name,
            g.exterior_wall_layer2_thickness,
            g.exterior_wall_layer2_thickness_unit,
            g.exterior_wall_layer2_solar_absorption_rate,
            g.exterior_wall_layer2_thermal_capacity,
            g.exterior_wall_layer2_thermal_capacity_unit,
            g.exterior_wall_layer2_thermal_conductivity,
            g.exterior_wall_layer2_thermal_conductivity_unit,
            g.exterior_wall_layer2_service_life,
            g.exterior_wall_layer2_service_life_unit,
            g.exterior_wall_layer2_density,
            g.exterior_wall_layer2_density_unit,
            g.exterior_wall_layer3_position,
            g.exterior_wall_layer3_material_id,
            g.exterior_wall_layer3_material_name,
            g.exterior_wall_layer3_thickness,
            g.exterior_wall_layer3_thickness_unit,
            g.exterior_wall_layer3_solar_absorption_rate,
            g.exterior_wall_layer3_thermal_capacity,
            g.exterior_wall_layer3_thermal_capacity_unit,
            g.exterior_wall_layer3_thermal_conductivity,
            g.exterior_wall_layer3_thermal_conductivity_unit,
            g.exterior_wall_layer3_service_life,
            g.exterior_wall_layer3_service_life_unit,
            g.exterior_wall_layer3_density,
            g.exterior_wall_layer3_density_unit,
            g.exterior_wall_layer4_position,
            g.exterior_wall_layer4_material_id,
            g.exterior_wall_layer4_material_name,
            g.exterior_wall_layer4_thickness,
            g.exterior_wall_layer4_thickness_unit,
            g.exterior_wall_layer4_solar_absorption_rate,
            g.exterior_wall_layer4_thermal_capacity,
            g.exterior_wall_layer4_thermal_capacity_unit,
            g.exterior_wall_layer4_thermal_conductivity,
            g.exterior_wall_layer4_thermal_conductivity_unit,
            g.exterior_wall_layer4_service_life,
            g.exterior_wall_layer4_service_life_unit,
            g.exterior_wall_layer4_density,
            g.exterior_wall_layer4_density_unit,
            g.exterior_wall_layer5_position,
            g.exterior_wall_layer5_material_id,
            g.exterior_wall_layer5_material_name,
            g.exterior_wall_layer5_thickness,
            g.exterior_wall_layer5_thickness_unit,
            g.exterior_wall_layer5_solar_absorption_rate,
            g.exterior_wall_layer5_thermal_capacity,
            g.exterior_wall_layer5_thermal_capacity_unit,
            g.exterior_wall_layer5_thermal_conductivity,
            g.exterior_wall_layer5_thermal_conductivity_unit,
            g.exterior_wall_layer5_service_life,
            g.exterior_wall_layer5_service_life_unit,
            g.exterior_wall_layer5_density,
            g.exterior_wall_layer5_density_unit,
            g.exterior_wall_layer0_epd1_oekobaudat_name,
            g.exterior_wall_layer0_epd1_oekobaudat_uuid,
            g.exterior_wall_layer0_epd2_oekobaudat_name,
            g.exterior_wall_layer0_epd2_oekobaudat_uuid,
            g.exterior_wall_layer1_epd1_oekobaudat_name,
            g.exterior_wall_layer1_epd1_oekobaudat_uuid,
            g.exterior_wall_layer1_epd2_oekobaudat_name,
            g.exterior_wall_layer1_epd2_oekobaudat_uuid,
            g.exterior_wall_layer2_epd1_oekobaudat_name,
            g.exterior_wall_layer2_epd1_oekobaudat_uuid,
            g.exterior_wall_layer2_epd2_oekobaudat_name,
            g.exterior_wall_layer2_epd2_oekobaudat_uuid,
            g.exterior_wall_layer3_epd1_oekobaudat_name,
            g.exterior_wall_layer3_epd1_oekobaudat_uuid,
            g.exterior_wall_layer3_epd2_oekobaudat_name,
            g.exterior_wall_layer3_epd2_oekobaudat_uuid,
            g.exterior_wall_layer4_epd1_oekobaudat_name,
            g.exterior_wall_layer4_epd1_oekobaudat_uuid,
            g.exterior_wall_layer4_epd2_oekobaudat_name,
            g.exterior_wall_layer4_epd2_oekobaudat_uuid,
            g.exterior_wall_layer5_epd1_oekobaudat_name,
            g.exterior_wall_layer5_epd1_oekobaudat_uuid,
            g.exterior_wall_layer5_epd2_oekobaudat_name,
            g.exterior_wall_layer5_epd2_oekobaudat_uuid,
            g.interior_wall_name,
            g.interior_wall_u_value_typical_min,
            g.interior_wall_u_value_typical_max,
            g.interior_wall_u_value,
            g.interior_wall_u_value_unit,
            g.interior_wall_inner_radiation,
            g.interior_wall_inner_radiation_unit,
            g.interior_wall_inner_convection,
            g.interior_wall_inner_convection_unit,
            g.interior_wall_layer0_position,
            g.interior_wall_layer0_material_id,
            g.interior_wall_layer0_material_name,
            g.interior_wall_layer0_thickness,
            g.interior_wall_layer0_thickness_unit,
            g.interior_wall_layer0_solar_absorption_rate,
            g.interior_wall_layer0_thermal_capacity,
            g.interior_wall_layer0_thermal_capacity_unit,
            g.interior_wall_layer0_thermal_conductivity,
            g.interior_wall_layer0_thermal_conductivity_unit,
            g.interior_wall_layer0_service_life,
            g.interior_wall_layer0_service_life_unit,
            g.interior_wall_layer0_density,
            g.interior_wall_layer0_density_unit,
            g.interior_wall_layer1_position,
            g.interior_wall_layer1_material_id,
            g.interior_wall_layer1_material_name,
            g.interior_wall_layer1_thickness,
            g.interior_wall_layer1_thickness_unit,
            g.interior_wall_layer1_solar_absorption_rate,
            g.interior_wall_layer1_thermal_capacity,
            g.interior_wall_layer1_thermal_capacity_unit,
            g.interior_wall_layer1_thermal_conductivity,
            g.interior_wall_layer1_thermal_conductivity_unit,
            g.interior_wall_layer1_service_life,
            g.interior_wall_layer1_service_life_unit,
            g.interior_wall_layer1_density,
            g.interior_wall_layer1_density_unit,
            g.interior_wall_layer2_position,
            g.interior_wall_layer2_material_id,
            g.interior_wall_layer2_material_name,
            g.interior_wall_layer2_thickness,
            g.interior_wall_layer2_thickness_unit,
            g.interior_wall_layer2_solar_absorption_rate,
            g.interior_wall_layer2_thermal_capacity,
            g.interior_wall_layer2_thermal_capacity_unit,
            g.interior_wall_layer2_thermal_conductivity,
            g.interior_wall_layer2_thermal_conductivity_unit,
            g.interior_wall_layer2_service_life,
            g.interior_wall_layer2_service_life_unit,
            g.interior_wall_layer2_density,
            g.interior_wall_layer2_density_unit,
            g.interior_wall_layer0_epd1_oekobaudat_name,
            g.interior_wall_layer0_epd1_oekobaudat_uuid,
            g.interior_wall_layer0_epd2_oekobaudat_name,
            g.interior_wall_layer0_epd2_oekobaudat_uuid,
            g.interior_wall_layer1_epd1_oekobaudat_name,
            g.interior_wall_layer1_epd1_oekobaudat_uuid,
            g.interior_wall_layer1_epd2_oekobaudat_name,
            g.interior_wall_layer1_epd2_oekobaudat_uuid,
            g.interior_wall_layer2_epd1_oekobaudat_name,
            g.interior_wall_layer2_epd1_oekobaudat_uuid,
            g.interior_wall_layer2_epd2_oekobaudat_name,
            g.interior_wall_layer2_epd2_oekobaudat_uuid,
            g.roof_name,
            g.roof_construction_type,
            g.roof_pitch_type,
            g.roof_u_value_typical_min,
            g.roof_u_value_typical_max,
            g.roof_u_value,
            g.roof_u_value_unit,
            g.roof_inner_radiation,
            g.roof_inner_radiation_unit,
            g.roof_outer_radiation,
            g.roof_outer_radiation_unit,
            g.roof_inner_convection,
            g.roof_inner_convection_unit,
            g.roof_outer_convection,
            g.roof_outer_convection_unit,
            g.roof_layer0_position,
            g.roof_layer0_material_id,
            g.roof_layer0_material_name,
            g.roof_layer0_thickness,
            g.roof_layer0_thickness_unit,
            g.roof_layer0_solar_absorption_rate,
            g.roof_layer0_thermal_capacity,
            g.roof_layer0_thermal_capacity_unit,
            g.roof_layer0_thermal_conductivity,
            g.roof_layer0_thermal_conductivity_unit,
            g.roof_layer0_service_life,
            g.roof_layer0_service_life_unit,
            g.roof_layer0_density,
            g.roof_layer0_density_unit,
            g.roof_layer1_position,
            g.roof_layer1_material_id,
            g.roof_layer1_material_name,
            g.roof_layer1_thickness,
            g.roof_layer1_thickness_unit,
            g.roof_layer1_solar_absorption_rate,
            g.roof_layer1_thermal_capacity,
            g.roof_layer1_thermal_capacity_unit,
            g.roof_layer1_thermal_conductivity,
            g.roof_layer1_thermal_conductivity_unit,
            g.roof_layer1_service_life,
            g.roof_layer1_service_life_unit,
            g.roof_layer1_density,
            g.roof_layer1_density_unit,
            g.roof_layer2_position,
            g.roof_layer2_material_id,
            g.roof_layer2_material_name,
            g.roof_layer2_thickness,
            g.roof_layer2_thickness_unit,
            g.roof_layer2_solar_absorption_rate,
            g.roof_layer2_thermal_capacity,
            g.roof_layer2_thermal_capacity_unit,
            g.roof_layer2_thermal_conductivity,
            g.roof_layer2_thermal_conductivity_unit,
            g.roof_layer2_service_life,
            g.roof_layer2_service_life_unit,
            g.roof_layer2_density,
            g.roof_layer2_density_unit,
            g.roof_layer3_position,
            g.roof_layer3_material_id,
            g.roof_layer3_material_name,
            g.roof_layer3_thickness,
            g.roof_layer3_thickness_unit,
            g.roof_layer3_solar_absorption_rate,
            g.roof_layer3_thermal_capacity,
            g.roof_layer3_thermal_capacity_unit,
            g.roof_layer3_thermal_conductivity,
            g.roof_layer3_thermal_conductivity_unit,
            g.roof_layer3_service_life,
            g.roof_layer3_service_life_unit,
            g.roof_layer3_density,
            g.roof_layer3_density_unit,
            g.roof_layer4_position,
            g.roof_layer4_material_id,
            g.roof_layer4_material_name,
            g.roof_layer4_thickness,
            g.roof_layer4_thickness_unit,
            g.roof_layer4_solar_absorption_rate,
            g.roof_layer4_thermal_capacity,
            g.roof_layer4_thermal_capacity_unit,
            g.roof_layer4_thermal_conductivity,
            g.roof_layer4_thermal_conductivity_unit,
            g.roof_layer4_service_life,
            g.roof_layer4_service_life_unit,
            g.roof_layer4_density,
            g.roof_layer4_density_unit,
            g.roof_layer5_position,
            g.roof_layer5_material_id,
            g.roof_layer5_material_name,
            g.roof_layer5_thickness,
            g.roof_layer5_thickness_unit,
            g.roof_layer5_solar_absorption_rate,
            g.roof_layer5_thermal_capacity,
            g.roof_layer5_thermal_capacity_unit,
            g.roof_layer5_thermal_conductivity,
            g.roof_layer5_thermal_conductivity_unit,
            g.roof_layer5_service_life,
            g.roof_layer5_service_life_unit,
            g.roof_layer5_density,
            g.roof_layer5_density_unit,
            g.roof_layer0_epd1_oekobaudat_name,
            g.roof_layer0_epd1_oekobaudat_uuid,
            g.roof_layer0_epd2_oekobaudat_name,
            g.roof_layer0_epd2_oekobaudat_uuid,
            g.roof_layer1_epd1_oekobaudat_name,
            g.roof_layer1_epd1_oekobaudat_uuid,
            g.roof_layer1_epd2_oekobaudat_name,
            g.roof_layer1_epd2_oekobaudat_uuid,
            g.roof_layer2_epd1_oekobaudat_name,
            g.roof_layer2_epd1_oekobaudat_uuid,
            g.roof_layer2_epd2_oekobaudat_name,
            g.roof_layer2_epd2_oekobaudat_uuid,
            g.roof_layer3_epd1_oekobaudat_name,
            g.roof_layer3_epd1_oekobaudat_uuid,
            g.roof_layer3_epd2_oekobaudat_name,
            g.roof_layer3_epd2_oekobaudat_uuid,
            g.roof_layer4_epd1_oekobaudat_name,
            g.roof_layer4_epd1_oekobaudat_uuid,
            g.roof_layer4_epd2_oekobaudat_name,
            g.roof_layer4_epd2_oekobaudat_uuid,
            g.roof_layer5_epd1_oekobaudat_name,
            g.roof_layer5_epd1_oekobaudat_uuid,
            g.roof_layer5_epd2_oekobaudat_name,
            g.roof_layer5_epd2_oekobaudat_uuid,
            g.foundation_name,
            g.foundation_construction_type,
            g.foundation_u_value_typical_min,
            g.foundation_u_value_typical_max,
            g.foundation_u_value,
            g.foundation_u_value_unit,
            g.foundation_inner_radiation,
            g.foundation_inner_radiation_unit,
            g.foundation_inner_convection,
            g.foundation_inner_convection_unit,
            g.foundation_layer0_position,
            g.foundation_layer0_material_id,
            g.foundation_layer0_material_name,
            g.foundation_layer0_thickness,
            g.foundation_layer0_thickness_unit,
            g.foundation_layer0_solar_absorption_rate,
            g.foundation_layer0_thermal_capacity,
            g.foundation_layer0_thermal_capacity_unit,
            g.foundation_layer0_thermal_conductivity,
            g.foundation_layer0_thermal_conductivity_unit,
            g.foundation_layer0_service_life,
            g.foundation_layer0_service_life_unit,
            g.foundation_layer0_density,
            g.foundation_layer0_density_unit,
            g.foundation_layer1_position,
            g.foundation_layer1_material_id,
            g.foundation_layer1_material_name,
            g.foundation_layer1_thickness,
            g.foundation_layer1_thickness_unit,
            g.foundation_layer1_solar_absorption_rate,
            g.foundation_layer1_thermal_capacity,
            g.foundation_layer1_thermal_capacity_unit,
            g.foundation_layer1_thermal_conductivity,
            g.foundation_layer1_thermal_conductivity_unit,
            g.foundation_layer1_service_life,
            g.foundation_layer1_service_life_unit,
            g.foundation_layer1_density,
            g.foundation_layer1_density_unit,
            g.foundation_layer2_position,
            g.foundation_layer2_material_id,
            g.foundation_layer2_material_name,
            g.foundation_layer2_thickness,
            g.foundation_layer2_thickness_unit,
            g.foundation_layer2_solar_absorption_rate,
            g.foundation_layer2_thermal_capacity,
            g.foundation_layer2_thermal_capacity_unit,
            g.foundation_layer2_thermal_conductivity,
            g.foundation_layer2_thermal_conductivity_unit,
            g.foundation_layer2_service_life,
            g.foundation_layer2_service_life_unit,
            g.foundation_layer2_density,
            g.foundation_layer2_density_unit,
            g.foundation_layer3_position,
            g.foundation_layer3_material_id,
            g.foundation_layer3_material_name,
            g.foundation_layer3_thickness,
            g.foundation_layer3_thickness_unit,
            g.foundation_layer3_solar_absorption_rate,
            g.foundation_layer3_thermal_capacity,
            g.foundation_layer3_thermal_capacity_unit,
            g.foundation_layer3_thermal_conductivity,
            g.foundation_layer3_thermal_conductivity_unit,
            g.foundation_layer3_service_life,
            g.foundation_layer3_service_life_unit,
            g.foundation_layer3_density,
            g.foundation_layer3_density_unit,
            g.foundation_layer4_position,
            g.foundation_layer4_material_id,
            g.foundation_layer4_material_name,
            g.foundation_layer4_thickness,
            g.foundation_layer4_thickness_unit,
            g.foundation_layer4_solar_absorption_rate,
            g.foundation_layer4_thermal_capacity,
            g.foundation_layer4_thermal_capacity_unit,
            g.foundation_layer4_thermal_conductivity,
            g.foundation_layer4_thermal_conductivity_unit,
            g.foundation_layer4_service_life,
            g.foundation_layer4_service_life_unit,
            g.foundation_layer4_density,
            g.foundation_layer4_density_unit,
            g.foundation_layer5_position,
            g.foundation_layer5_material_id,
            g.foundation_layer5_material_name,
            g.foundation_layer5_thickness,
            g.foundation_layer5_thickness_unit,
            g.foundation_layer5_solar_absorption_rate,
            g.foundation_layer5_thermal_capacity,
            g.foundation_layer5_thermal_capacity_unit,
            g.foundation_layer5_thermal_conductivity,
            g.foundation_layer5_thermal_conductivity_unit,
            g.foundation_layer5_service_life,
            g.foundation_layer5_service_life_unit,
            g.foundation_layer5_density,
            g.foundation_layer5_density_unit,
            g.foundation_layer0_epd1_oekobaudat_name,
            g.foundation_layer0_epd1_oekobaudat_uuid,
            g.foundation_layer0_epd2_oekobaudat_name,
            g.foundation_layer0_epd2_oekobaudat_uuid,
            g.foundation_layer1_epd1_oekobaudat_name,
            g.foundation_layer1_epd1_oekobaudat_uuid,
            g.foundation_layer1_epd2_oekobaudat_name,
            g.foundation_layer1_epd2_oekobaudat_uuid,
            g.foundation_layer2_epd1_oekobaudat_name,
            g.foundation_layer2_epd1_oekobaudat_uuid,
            g.foundation_layer2_epd2_oekobaudat_name,
            g.foundation_layer2_epd2_oekobaudat_uuid,
            g.foundation_layer3_epd1_oekobaudat_name,
            g.foundation_layer3_epd1_oekobaudat_uuid,
            g.foundation_layer3_epd2_oekobaudat_name,
            g.foundation_layer3_epd2_oekobaudat_uuid,
            g.foundation_layer4_epd1_oekobaudat_name,
            g.foundation_layer4_epd1_oekobaudat_uuid,
            g.foundation_layer4_epd2_oekobaudat_name,
            g.foundation_layer4_epd2_oekobaudat_uuid,
            g.foundation_layer5_epd1_oekobaudat_name,
            g.foundation_layer5_epd1_oekobaudat_uuid,
            g.foundation_layer5_epd2_oekobaudat_name,
            g.foundation_layer5_epd2_oekobaudat_uuid,
            g.floor_name,
            g.floor_u_value_typical_min,
            g.floor_u_value_typical_max,
            g.floor_u_value,
            g.floor_u_value_unit,
            g.floor_inner_radiation,
            g.floor_inner_radiation_unit,
            g.floor_inner_convection,
            g.floor_inner_convection_unit,
            g.floor_layer0_position,
            g.floor_layer0_material_id,
            g.floor_layer0_material_name,
            g.floor_layer0_thickness,
            g.floor_layer0_thickness_unit,
            g.floor_layer0_solar_absorption_rate,
            g.floor_layer0_thermal_capacity,
            g.floor_layer0_thermal_capacity_unit,
            g.floor_layer0_thermal_conductivity,
            g.floor_layer0_thermal_conductivity_unit,
            g.floor_layer0_service_life,
            g.floor_layer0_service_life_unit,
            g.floor_layer0_density,
            g.floor_layer0_density_unit,
            g.floor_layer1_position,
            g.floor_layer1_material_id,
            g.floor_layer1_material_name,
            g.floor_layer1_thickness,
            g.floor_layer1_thickness_unit,
            g.floor_layer1_solar_absorption_rate,
            g.floor_layer1_thermal_capacity,
            g.floor_layer1_thermal_capacity_unit,
            g.floor_layer1_thermal_conductivity,
            g.floor_layer1_thermal_conductivity_unit,
            g.floor_layer1_service_life,
            g.floor_layer1_service_life_unit,
            g.floor_layer1_density,
            g.floor_layer1_density_unit,
            g.floor_layer2_position,
            g.floor_layer2_material_id,
            g.floor_layer2_material_name,
            g.floor_layer2_thickness,
            g.floor_layer2_thickness_unit,
            g.floor_layer2_solar_absorption_rate,
            g.floor_layer2_thermal_capacity,
            g.floor_layer2_thermal_capacity_unit,
            g.floor_layer2_thermal_conductivity,
            g.floor_layer2_thermal_conductivity_unit,
            g.floor_layer2_service_life,
            g.floor_layer2_service_life_unit,
            g.floor_layer2_density,
            g.floor_layer2_density_unit,
            g.floor_layer0_epd1_oekobaudat_name,
            g.floor_layer0_epd1_oekobaudat_uuid,
            g.floor_layer0_epd2_oekobaudat_name,
            g.floor_layer0_epd2_oekobaudat_uuid,
            g.floor_layer1_epd1_oekobaudat_name,
            g.floor_layer1_epd1_oekobaudat_uuid,
            g.floor_layer1_epd2_oekobaudat_name,
            g.floor_layer1_epd2_oekobaudat_uuid,
            g.floor_layer2_epd1_oekobaudat_name,
            g.floor_layer2_epd1_oekobaudat_uuid,
            g.floor_layer2_epd2_oekobaudat_name,
            g.floor_layer2_epd2_oekobaudat_uuid,
            g.window_name,
            g.window_inner_radiation,
            g.window_inner_radiation_unit,
            g.window_outer_radiation,
            g.window_outer_radiation_unit,
            g.window_inner_convection,
            g.window_inner_convection_unit,
            g.window_outer_convection,
            g.window_outer_convection_unit,
            g.glazing,
            g.frame_per_window,
            g.frame_per_window_unit,
            g.window_frame_area_share,
            g.g_value,
            g.a_conv,
            g.shading_type_name,
            g.window_frame_type_name,
            g.window_layer0_position,
            g.window_layer0_material_id,
            g.window_layer0_material_name,
            g.window_layer0_thickness,
            g.window_layer0_thickness_unit,
            g.window_layer0_solar_absorption_rate,
            g.window_layer0_thermal_capacity,
            g.window_layer0_thermal_capacity_unit,
            g.window_layer0_thermal_conductivity,
            g.window_layer0_thermal_conductivity_unit,
            g.window_layer0_service_life,
            g.window_layer0_service_life_unit,
            g.window_layer1_position,
            g.window_layer1_material_id,
            g.window_layer1_material_name,
            g.window_layer1_thickness,
            g.window_layer1_thickness_unit,
            g.window_layer1_solar_absorption_rate,
            g.window_layer1_thermal_capacity,
            g.window_layer1_thermal_capacity_unit,
            g.window_layer1_thermal_conductivity,
            g.window_layer1_thermal_conductivity_unit,
            g.window_layer1_service_life,
            g.window_layer1_service_life_unit,
            g.window_layer2_position,
            g.window_layer2_material_id,
            g.window_layer2_material_name,
            g.window_layer2_thickness,
            g.window_layer2_thickness_unit,
            g.window_layer2_solar_absorption_rate,
            g.window_layer2_thermal_capacity,
            g.window_layer2_thermal_capacity_unit,
            g.window_layer2_thermal_conductivity,
            g.window_layer2_thermal_conductivity_unit,
            g.window_layer2_service_life,
            g.window_layer2_service_life_unit,
            g.window_layer0_epd1_oekobaudat_name,
            g.window_layer0_epd1_oekobaudat_uuid,
            g.window_layer0_epd2_oekobaudat_name,
            g.window_layer0_epd2_oekobaudat_uuid,
            g.window_layer1_epd1_oekobaudat_name,
            g.window_layer1_epd1_oekobaudat_uuid,
            g.window_layer1_epd2_oekobaudat_name,
            g.window_layer1_epd2_oekobaudat_uuid,
            g.window_layer2_epd1_oekobaudat_name,
            g.window_layer2_epd1_oekobaudat_uuid,
            g.window_layer2_epd2_oekobaudat_name,
            g.window_layer2_epd2_oekobaudat_uuid,
            g.energy_system_name,
            g.converter_0_id,
            g.converter_0_energy_converter_name,
            g.converter_1_id,
            g.converter_1_energy_converter_name,
            g.converter_0_nominal_power_min,
            g.converter_0_nominal_power_max,
            g.converter_0_nominal_power_unit,
            g.converter_1_nominal_power_min,
            g.converter_1_nominal_power_max,
            g.converter_1_nominal_power_unit,
            g.converter_0_area,
            g.converter_0_area_unit,
            g.converter_1_area,
            g.converter_1_area_unit,
            g.converter_0_supply_function_name,
            g.converter_1_supply_function_name,
            g.converter_0_energy_source_name,
            g.converter_1_energy_source_name,
            g.converter_0_service_life,
            g.converter_0_service_life_unit,
            g.converter_1_service_life,
            g.converter_1_service_life_unit,
            p.converter_0_epd_1_id,
            p.converter_0_epd_1_name,
            p.converter_0_epd_1_database_uuid,
            p.converter_0_epd_2_id,
            p.converter_0_epd_2_name,
            p.converter_0_epd_2_database_uuid,
            p.converter_0_energy_source_epd_id,
            p.converter_0_energy_source_epd_name,
            p.converter_0_energy_source_epd_database_uuid,
            p.converter_1_epd_1_id,
            p.converter_1_epd_1_name,
            p.converter_1_epd_1_database_uuid,
            p.converter_1_epd_2_id,
            p.converter_1_epd_2_name,
            p.converter_1_epd_2_database_uuid,
            p.converter_1_energy_source_epd_id,
            p.converter_1_energy_source_epd_name,
            p.converter_1_energy_source_epd_database_uuid
           FROM (step_022 g
             LEFT JOIN conv_epds_pivot p ON ((p.energy_system_id = g.energy_system_id)))
        )
 SELECT building_archetype_id,
    building_archetype_name,
    share_of_building_type,
    share_of_building_type_in_region,
    share_of_building_type_in_region_mun,
    exterior_wall_building_element_id,
    interior_wall_building_element_id,
    roof_building_element_id,
    foundation_building_element_id,
    floor_building_element_id,
    window_building_element_id,
    energy_system_id,
    building_type_name,
    region_name,
    municipality_size_name,
    municipality_growth_name,
    age_class_name,
    building_adjacency_name,
    facade_to_net_leased_area_ratio_mean,
    facade_to_net_leased_area_ratio_se_min,
    facade_to_net_leased_area_ratio_se_max,
    roof_to_net_leased_area_ratio_mean,
    roof_to_net_leased_area_ratio_se_min,
    roof_to_net_leased_area_ratio_se_max,
    foundation_to_net_leased_area_ratio_mean,
    foundation_to_net_leased_area_ratio_se_min,
    foundation_to_net_leased_area_ratio_se_max,
    window_to_net_leased_area_ratio_mean,
    window_to_net_leased_area_ratio_se_min,
    window_to_net_leased_area_ratio_se_max,
    building_height_mean,
    building_height_se,
    height_unit,
    aspect_ratio_mean,
    aspect_ratio_se_min,
    aspect_ratio_se_max,
    storeys_below_ground_mean,
    storeys_below_ground_se,
    storeys_above_ground_mean,
    storeys_above_ground_se,
    storeys_above_ground_se_min,
    storeys_above_ground_se_max,
    storey_height_mean,
    storey_height_se_min,
    storey_height_se_max,
    window_share,
    net_leased_area_mean,
    net_leased_area_se,
    net_leased_area_se_min,
    net_leased_area_se_max,
    net_leased_area_unit,
    facade_area_north_mean,
    facade_area_north_se,
    facade_area_east_mean,
    facade_area_east_se,
    facade_area_south_mean,
    facade_area_south_se,
    facade_area_west_mean,
    facade_area_west_se,
    facade_area_unit,
    facade_length_north_mean,
    facade_length_north_se,
    facade_length_east_mean,
    facade_length_east_se,
    facade_length_south_mean,
    facade_length_south_se,
    facade_length_west_mean,
    facade_length_west_se,
    facade_length_unit,
    exterior_wall_name,
    exterior_wall_construction_type,
    exterior_wall_u_value_typical_min,
    exterior_wall_u_value_typical_max,
    exterior_wall_u_value,
    exterior_wall_u_value_unit,
    exterior_wall_inner_radiation,
    exterior_wall_inner_radiation_unit,
    exterior_wall_outer_radiation,
    exterior_wall_outer_radiation_unit,
    exterior_wall_inner_convection,
    exterior_wall_inner_convection_unit,
    exterior_wall_outer_convection,
    exterior_wall_outer_convection_unit,
    exterior_wall_layer0_position,
    exterior_wall_layer0_material_id,
    exterior_wall_layer0_material_name,
    exterior_wall_layer0_thickness,
    exterior_wall_layer0_thickness_unit,
    exterior_wall_layer0_solar_absorption_rate,
    exterior_wall_layer0_thermal_capacity,
    exterior_wall_layer0_thermal_capacity_unit,
    exterior_wall_layer0_thermal_conductivity,
    exterior_wall_layer0_thermal_conductivity_unit,
    exterior_wall_layer0_service_life,
    exterior_wall_layer0_service_life_unit,
    exterior_wall_layer0_density,
    exterior_wall_layer0_density_unit,
    exterior_wall_layer1_position,
    exterior_wall_layer1_material_id,
    exterior_wall_layer1_material_name,
    exterior_wall_layer1_thickness,
    exterior_wall_layer1_thickness_unit,
    exterior_wall_layer1_solar_absorption_rate,
    exterior_wall_layer1_thermal_capacity,
    exterior_wall_layer1_thermal_capacity_unit,
    exterior_wall_layer1_thermal_conductivity,
    exterior_wall_layer1_thermal_conductivity_unit,
    exterior_wall_layer1_service_life,
    exterior_wall_layer1_service_life_unit,
    exterior_wall_layer1_density,
    exterior_wall_layer1_density_unit,
    exterior_wall_layer2_position,
    exterior_wall_layer2_material_id,
    exterior_wall_layer2_material_name,
    exterior_wall_layer2_thickness,
    exterior_wall_layer2_thickness_unit,
    exterior_wall_layer2_solar_absorption_rate,
    exterior_wall_layer2_thermal_capacity,
    exterior_wall_layer2_thermal_capacity_unit,
    exterior_wall_layer2_thermal_conductivity,
    exterior_wall_layer2_thermal_conductivity_unit,
    exterior_wall_layer2_service_life,
    exterior_wall_layer2_service_life_unit,
    exterior_wall_layer2_density,
    exterior_wall_layer2_density_unit,
    exterior_wall_layer3_position,
    exterior_wall_layer3_material_id,
    exterior_wall_layer3_material_name,
    exterior_wall_layer3_thickness,
    exterior_wall_layer3_thickness_unit,
    exterior_wall_layer3_solar_absorption_rate,
    exterior_wall_layer3_thermal_capacity,
    exterior_wall_layer3_thermal_capacity_unit,
    exterior_wall_layer3_thermal_conductivity,
    exterior_wall_layer3_thermal_conductivity_unit,
    exterior_wall_layer3_service_life,
    exterior_wall_layer3_service_life_unit,
    exterior_wall_layer3_density,
    exterior_wall_layer3_density_unit,
    exterior_wall_layer4_position,
    exterior_wall_layer4_material_id,
    exterior_wall_layer4_material_name,
    exterior_wall_layer4_thickness,
    exterior_wall_layer4_thickness_unit,
    exterior_wall_layer4_solar_absorption_rate,
    exterior_wall_layer4_thermal_capacity,
    exterior_wall_layer4_thermal_capacity_unit,
    exterior_wall_layer4_thermal_conductivity,
    exterior_wall_layer4_thermal_conductivity_unit,
    exterior_wall_layer4_service_life,
    exterior_wall_layer4_service_life_unit,
    exterior_wall_layer4_density,
    exterior_wall_layer4_density_unit,
    exterior_wall_layer5_position,
    exterior_wall_layer5_material_id,
    exterior_wall_layer5_material_name,
    exterior_wall_layer5_thickness,
    exterior_wall_layer5_thickness_unit,
    exterior_wall_layer5_solar_absorption_rate,
    exterior_wall_layer5_thermal_capacity,
    exterior_wall_layer5_thermal_capacity_unit,
    exterior_wall_layer5_thermal_conductivity,
    exterior_wall_layer5_thermal_conductivity_unit,
    exterior_wall_layer5_service_life,
    exterior_wall_layer5_service_life_unit,
    exterior_wall_layer5_density,
    exterior_wall_layer5_density_unit,
    exterior_wall_layer0_epd1_oekobaudat_name,
    exterior_wall_layer0_epd1_oekobaudat_uuid,
    exterior_wall_layer0_epd2_oekobaudat_name,
    exterior_wall_layer0_epd2_oekobaudat_uuid,
    exterior_wall_layer1_epd1_oekobaudat_name,
    exterior_wall_layer1_epd1_oekobaudat_uuid,
    exterior_wall_layer1_epd2_oekobaudat_name,
    exterior_wall_layer1_epd2_oekobaudat_uuid,
    exterior_wall_layer2_epd1_oekobaudat_name,
    exterior_wall_layer2_epd1_oekobaudat_uuid,
    exterior_wall_layer2_epd2_oekobaudat_name,
    exterior_wall_layer2_epd2_oekobaudat_uuid,
    exterior_wall_layer3_epd1_oekobaudat_name,
    exterior_wall_layer3_epd1_oekobaudat_uuid,
    exterior_wall_layer3_epd2_oekobaudat_name,
    exterior_wall_layer3_epd2_oekobaudat_uuid,
    exterior_wall_layer4_epd1_oekobaudat_name,
    exterior_wall_layer4_epd1_oekobaudat_uuid,
    exterior_wall_layer4_epd2_oekobaudat_name,
    exterior_wall_layer4_epd2_oekobaudat_uuid,
    exterior_wall_layer5_epd1_oekobaudat_name,
    exterior_wall_layer5_epd1_oekobaudat_uuid,
    exterior_wall_layer5_epd2_oekobaudat_name,
    exterior_wall_layer5_epd2_oekobaudat_uuid,
    interior_wall_name,
    interior_wall_u_value_typical_min,
    interior_wall_u_value_typical_max,
    interior_wall_u_value,
    interior_wall_u_value_unit,
    interior_wall_inner_radiation,
    interior_wall_inner_radiation_unit,
    interior_wall_inner_convection,
    interior_wall_inner_convection_unit,
    interior_wall_layer0_position,
    interior_wall_layer0_material_id,
    interior_wall_layer0_material_name,
    interior_wall_layer0_thickness,
    interior_wall_layer0_thickness_unit,
    interior_wall_layer0_solar_absorption_rate,
    interior_wall_layer0_thermal_capacity,
    interior_wall_layer0_thermal_capacity_unit,
    interior_wall_layer0_thermal_conductivity,
    interior_wall_layer0_thermal_conductivity_unit,
    interior_wall_layer0_service_life,
    interior_wall_layer0_service_life_unit,
    interior_wall_layer0_density,
    interior_wall_layer0_density_unit,
    interior_wall_layer1_position,
    interior_wall_layer1_material_id,
    interior_wall_layer1_material_name,
    interior_wall_layer1_thickness,
    interior_wall_layer1_thickness_unit,
    interior_wall_layer1_solar_absorption_rate,
    interior_wall_layer1_thermal_capacity,
    interior_wall_layer1_thermal_capacity_unit,
    interior_wall_layer1_thermal_conductivity,
    interior_wall_layer1_thermal_conductivity_unit,
    interior_wall_layer1_service_life,
    interior_wall_layer1_service_life_unit,
    interior_wall_layer1_density,
    interior_wall_layer1_density_unit,
    interior_wall_layer2_position,
    interior_wall_layer2_material_id,
    interior_wall_layer2_material_name,
    interior_wall_layer2_thickness,
    interior_wall_layer2_thickness_unit,
    interior_wall_layer2_solar_absorption_rate,
    interior_wall_layer2_thermal_capacity,
    interior_wall_layer2_thermal_capacity_unit,
    interior_wall_layer2_thermal_conductivity,
    interior_wall_layer2_thermal_conductivity_unit,
    interior_wall_layer2_service_life,
    interior_wall_layer2_service_life_unit,
    interior_wall_layer2_density,
    interior_wall_layer2_density_unit,
    interior_wall_layer0_epd1_oekobaudat_name,
    interior_wall_layer0_epd1_oekobaudat_uuid,
    interior_wall_layer0_epd2_oekobaudat_name,
    interior_wall_layer0_epd2_oekobaudat_uuid,
    interior_wall_layer1_epd1_oekobaudat_name,
    interior_wall_layer1_epd1_oekobaudat_uuid,
    interior_wall_layer1_epd2_oekobaudat_name,
    interior_wall_layer1_epd2_oekobaudat_uuid,
    interior_wall_layer2_epd1_oekobaudat_name,
    interior_wall_layer2_epd1_oekobaudat_uuid,
    interior_wall_layer2_epd2_oekobaudat_name,
    interior_wall_layer2_epd2_oekobaudat_uuid,
    roof_name,
    roof_construction_type,
    roof_pitch_type,
    roof_u_value_typical_min,
    roof_u_value_typical_max,
    roof_u_value,
    roof_u_value_unit,
    roof_inner_radiation,
    roof_inner_radiation_unit,
    roof_outer_radiation,
    roof_outer_radiation_unit,
    roof_inner_convection,
    roof_inner_convection_unit,
    roof_outer_convection,
    roof_outer_convection_unit,
    roof_layer0_position,
    roof_layer0_material_id,
    roof_layer0_material_name,
    roof_layer0_thickness,
    roof_layer0_thickness_unit,
    roof_layer0_solar_absorption_rate,
    roof_layer0_thermal_capacity,
    roof_layer0_thermal_capacity_unit,
    roof_layer0_thermal_conductivity,
    roof_layer0_thermal_conductivity_unit,
    roof_layer0_service_life,
    roof_layer0_service_life_unit,
    roof_layer0_density,
    roof_layer0_density_unit,
    roof_layer1_position,
    roof_layer1_material_id,
    roof_layer1_material_name,
    roof_layer1_thickness,
    roof_layer1_thickness_unit,
    roof_layer1_solar_absorption_rate,
    roof_layer1_thermal_capacity,
    roof_layer1_thermal_capacity_unit,
    roof_layer1_thermal_conductivity,
    roof_layer1_thermal_conductivity_unit,
    roof_layer1_service_life,
    roof_layer1_service_life_unit,
    roof_layer1_density,
    roof_layer1_density_unit,
    roof_layer2_position,
    roof_layer2_material_id,
    roof_layer2_material_name,
    roof_layer2_thickness,
    roof_layer2_thickness_unit,
    roof_layer2_solar_absorption_rate,
    roof_layer2_thermal_capacity,
    roof_layer2_thermal_capacity_unit,
    roof_layer2_thermal_conductivity,
    roof_layer2_thermal_conductivity_unit,
    roof_layer2_service_life,
    roof_layer2_service_life_unit,
    roof_layer2_density,
    roof_layer2_density_unit,
    roof_layer3_position,
    roof_layer3_material_id,
    roof_layer3_material_name,
    roof_layer3_thickness,
    roof_layer3_thickness_unit,
    roof_layer3_solar_absorption_rate,
    roof_layer3_thermal_capacity,
    roof_layer3_thermal_capacity_unit,
    roof_layer3_thermal_conductivity,
    roof_layer3_thermal_conductivity_unit,
    roof_layer3_service_life,
    roof_layer3_service_life_unit,
    roof_layer3_density,
    roof_layer3_density_unit,
    roof_layer4_position,
    roof_layer4_material_id,
    roof_layer4_material_name,
    roof_layer4_thickness,
    roof_layer4_thickness_unit,
    roof_layer4_solar_absorption_rate,
    roof_layer4_thermal_capacity,
    roof_layer4_thermal_capacity_unit,
    roof_layer4_thermal_conductivity,
    roof_layer4_thermal_conductivity_unit,
    roof_layer4_service_life,
    roof_layer4_service_life_unit,
    roof_layer4_density,
    roof_layer4_density_unit,
    roof_layer5_position,
    roof_layer5_material_id,
    roof_layer5_material_name,
    roof_layer5_thickness,
    roof_layer5_thickness_unit,
    roof_layer5_solar_absorption_rate,
    roof_layer5_thermal_capacity,
    roof_layer5_thermal_capacity_unit,
    roof_layer5_thermal_conductivity,
    roof_layer5_thermal_conductivity_unit,
    roof_layer5_service_life,
    roof_layer5_service_life_unit,
    roof_layer5_density,
    roof_layer5_density_unit,
    roof_layer0_epd1_oekobaudat_name,
    roof_layer0_epd1_oekobaudat_uuid,
    roof_layer0_epd2_oekobaudat_name,
    roof_layer0_epd2_oekobaudat_uuid,
    roof_layer1_epd1_oekobaudat_name,
    roof_layer1_epd1_oekobaudat_uuid,
    roof_layer1_epd2_oekobaudat_name,
    roof_layer1_epd2_oekobaudat_uuid,
    roof_layer2_epd1_oekobaudat_name,
    roof_layer2_epd1_oekobaudat_uuid,
    roof_layer2_epd2_oekobaudat_name,
    roof_layer2_epd2_oekobaudat_uuid,
    roof_layer3_epd1_oekobaudat_name,
    roof_layer3_epd1_oekobaudat_uuid,
    roof_layer3_epd2_oekobaudat_name,
    roof_layer3_epd2_oekobaudat_uuid,
    roof_layer4_epd1_oekobaudat_name,
    roof_layer4_epd1_oekobaudat_uuid,
    roof_layer4_epd2_oekobaudat_name,
    roof_layer4_epd2_oekobaudat_uuid,
    roof_layer5_epd1_oekobaudat_name,
    roof_layer5_epd1_oekobaudat_uuid,
    roof_layer5_epd2_oekobaudat_name,
    roof_layer5_epd2_oekobaudat_uuid,
    foundation_name,
    foundation_construction_type,
    foundation_u_value_typical_min,
    foundation_u_value_typical_max,
    foundation_u_value,
    foundation_u_value_unit,
    foundation_inner_radiation,
    foundation_inner_radiation_unit,
    foundation_inner_convection,
    foundation_inner_convection_unit,
    foundation_layer0_position,
    foundation_layer0_material_id,
    foundation_layer0_material_name,
    foundation_layer0_thickness,
    foundation_layer0_thickness_unit,
    foundation_layer0_solar_absorption_rate,
    foundation_layer0_thermal_capacity,
    foundation_layer0_thermal_capacity_unit,
    foundation_layer0_thermal_conductivity,
    foundation_layer0_thermal_conductivity_unit,
    foundation_layer0_service_life,
    foundation_layer0_service_life_unit,
    foundation_layer0_density,
    foundation_layer0_density_unit,
    foundation_layer1_position,
    foundation_layer1_material_id,
    foundation_layer1_material_name,
    foundation_layer1_thickness,
    foundation_layer1_thickness_unit,
    foundation_layer1_solar_absorption_rate,
    foundation_layer1_thermal_capacity,
    foundation_layer1_thermal_capacity_unit,
    foundation_layer1_thermal_conductivity,
    foundation_layer1_thermal_conductivity_unit,
    foundation_layer1_service_life,
    foundation_layer1_service_life_unit,
    foundation_layer1_density,
    foundation_layer1_density_unit,
    foundation_layer2_position,
    foundation_layer2_material_id,
    foundation_layer2_material_name,
    foundation_layer2_thickness,
    foundation_layer2_thickness_unit,
    foundation_layer2_solar_absorption_rate,
    foundation_layer2_thermal_capacity,
    foundation_layer2_thermal_capacity_unit,
    foundation_layer2_thermal_conductivity,
    foundation_layer2_thermal_conductivity_unit,
    foundation_layer2_service_life,
    foundation_layer2_service_life_unit,
    foundation_layer2_density,
    foundation_layer2_density_unit,
    foundation_layer3_position,
    foundation_layer3_material_id,
    foundation_layer3_material_name,
    foundation_layer3_thickness,
    foundation_layer3_thickness_unit,
    foundation_layer3_solar_absorption_rate,
    foundation_layer3_thermal_capacity,
    foundation_layer3_thermal_capacity_unit,
    foundation_layer3_thermal_conductivity,
    foundation_layer3_thermal_conductivity_unit,
    foundation_layer3_service_life,
    foundation_layer3_service_life_unit,
    foundation_layer3_density,
    foundation_layer3_density_unit,
    foundation_layer4_position,
    foundation_layer4_material_id,
    foundation_layer4_material_name,
    foundation_layer4_thickness,
    foundation_layer4_thickness_unit,
    foundation_layer4_solar_absorption_rate,
    foundation_layer4_thermal_capacity,
    foundation_layer4_thermal_capacity_unit,
    foundation_layer4_thermal_conductivity,
    foundation_layer4_thermal_conductivity_unit,
    foundation_layer4_service_life,
    foundation_layer4_service_life_unit,
    foundation_layer4_density,
    foundation_layer4_density_unit,
    foundation_layer5_position,
    foundation_layer5_material_id,
    foundation_layer5_material_name,
    foundation_layer5_thickness,
    foundation_layer5_thickness_unit,
    foundation_layer5_solar_absorption_rate,
    foundation_layer5_thermal_capacity,
    foundation_layer5_thermal_capacity_unit,
    foundation_layer5_thermal_conductivity,
    foundation_layer5_thermal_conductivity_unit,
    foundation_layer5_service_life,
    foundation_layer5_service_life_unit,
    foundation_layer5_density,
    foundation_layer5_density_unit,
    foundation_layer0_epd1_oekobaudat_name,
    foundation_layer0_epd1_oekobaudat_uuid,
    foundation_layer0_epd2_oekobaudat_name,
    foundation_layer0_epd2_oekobaudat_uuid,
    foundation_layer1_epd1_oekobaudat_name,
    foundation_layer1_epd1_oekobaudat_uuid,
    foundation_layer1_epd2_oekobaudat_name,
    foundation_layer1_epd2_oekobaudat_uuid,
    foundation_layer2_epd1_oekobaudat_name,
    foundation_layer2_epd1_oekobaudat_uuid,
    foundation_layer2_epd2_oekobaudat_name,
    foundation_layer2_epd2_oekobaudat_uuid,
    foundation_layer3_epd1_oekobaudat_name,
    foundation_layer3_epd1_oekobaudat_uuid,
    foundation_layer3_epd2_oekobaudat_name,
    foundation_layer3_epd2_oekobaudat_uuid,
    foundation_layer4_epd1_oekobaudat_name,
    foundation_layer4_epd1_oekobaudat_uuid,
    foundation_layer4_epd2_oekobaudat_name,
    foundation_layer4_epd2_oekobaudat_uuid,
    foundation_layer5_epd1_oekobaudat_name,
    foundation_layer5_epd1_oekobaudat_uuid,
    foundation_layer5_epd2_oekobaudat_name,
    foundation_layer5_epd2_oekobaudat_uuid,
    floor_name,
    floor_u_value_typical_min,
    floor_u_value_typical_max,
    floor_u_value,
    floor_u_value_unit,
    floor_inner_radiation,
    floor_inner_radiation_unit,
    floor_inner_convection,
    floor_inner_convection_unit,
    floor_layer0_position,
    floor_layer0_material_id,
    floor_layer0_material_name,
    floor_layer0_thickness,
    floor_layer0_thickness_unit,
    floor_layer0_solar_absorption_rate,
    floor_layer0_thermal_capacity,
    floor_layer0_thermal_capacity_unit,
    floor_layer0_thermal_conductivity,
    floor_layer0_thermal_conductivity_unit,
    floor_layer0_service_life,
    floor_layer0_service_life_unit,
    floor_layer0_density,
    floor_layer0_density_unit,
    floor_layer1_position,
    floor_layer1_material_id,
    floor_layer1_material_name,
    floor_layer1_thickness,
    floor_layer1_thickness_unit,
    floor_layer1_solar_absorption_rate,
    floor_layer1_thermal_capacity,
    floor_layer1_thermal_capacity_unit,
    floor_layer1_thermal_conductivity,
    floor_layer1_thermal_conductivity_unit,
    floor_layer1_service_life,
    floor_layer1_service_life_unit,
    floor_layer1_density,
    floor_layer1_density_unit,
    floor_layer2_position,
    floor_layer2_material_id,
    floor_layer2_material_name,
    floor_layer2_thickness,
    floor_layer2_thickness_unit,
    floor_layer2_solar_absorption_rate,
    floor_layer2_thermal_capacity,
    floor_layer2_thermal_capacity_unit,
    floor_layer2_thermal_conductivity,
    floor_layer2_thermal_conductivity_unit,
    floor_layer2_service_life,
    floor_layer2_service_life_unit,
    floor_layer2_density,
    floor_layer2_density_unit,
    floor_layer0_epd1_oekobaudat_name,
    floor_layer0_epd1_oekobaudat_uuid,
    floor_layer0_epd2_oekobaudat_name,
    floor_layer0_epd2_oekobaudat_uuid,
    floor_layer1_epd1_oekobaudat_name,
    floor_layer1_epd1_oekobaudat_uuid,
    floor_layer1_epd2_oekobaudat_name,
    floor_layer1_epd2_oekobaudat_uuid,
    floor_layer2_epd1_oekobaudat_name,
    floor_layer2_epd1_oekobaudat_uuid,
    floor_layer2_epd2_oekobaudat_name,
    floor_layer2_epd2_oekobaudat_uuid,
    window_name,
    window_inner_radiation,
    window_inner_radiation_unit,
    window_outer_radiation,
    window_outer_radiation_unit,
    window_inner_convection,
    window_inner_convection_unit,
    window_outer_convection,
    window_outer_convection_unit,
    glazing,
    frame_per_window,
    frame_per_window_unit,
    window_frame_area_share,
    g_value,
    a_conv,
    shading_type_name,
    window_frame_type_name,
    window_layer0_position,
    window_layer0_material_id,
    window_layer0_material_name,
    window_layer0_thickness,
    window_layer0_thickness_unit,
    window_layer0_solar_absorption_rate,
    window_layer0_thermal_capacity,
    window_layer0_thermal_capacity_unit,
    window_layer0_thermal_conductivity,
    window_layer0_thermal_conductivity_unit,
    window_layer0_service_life,
    window_layer0_service_life_unit,
    window_layer1_position,
    window_layer1_material_id,
    window_layer1_material_name,
    window_layer1_thickness,
    window_layer1_thickness_unit,
    window_layer1_solar_absorption_rate,
    window_layer1_thermal_capacity,
    window_layer1_thermal_capacity_unit,
    window_layer1_thermal_conductivity,
    window_layer1_thermal_conductivity_unit,
    window_layer1_service_life,
    window_layer1_service_life_unit,
    window_layer2_position,
    window_layer2_material_id,
    window_layer2_material_name,
    window_layer2_thickness,
    window_layer2_thickness_unit,
    window_layer2_solar_absorption_rate,
    window_layer2_thermal_capacity,
    window_layer2_thermal_capacity_unit,
    window_layer2_thermal_conductivity,
    window_layer2_thermal_conductivity_unit,
    window_layer2_service_life,
    window_layer2_service_life_unit,
    window_layer0_epd1_oekobaudat_name,
    window_layer0_epd1_oekobaudat_uuid,
    window_layer0_epd2_oekobaudat_name,
    window_layer0_epd2_oekobaudat_uuid,
    window_layer1_epd1_oekobaudat_name,
    window_layer1_epd1_oekobaudat_uuid,
    window_layer1_epd2_oekobaudat_name,
    window_layer1_epd2_oekobaudat_uuid,
    window_layer2_epd1_oekobaudat_name,
    window_layer2_epd1_oekobaudat_uuid,
    window_layer2_epd2_oekobaudat_name,
    window_layer2_epd2_oekobaudat_uuid,
    energy_system_name,
    converter_0_id,
    converter_0_energy_converter_name,
    converter_1_id,
    converter_1_energy_converter_name,
    converter_0_nominal_power_min,
    converter_0_nominal_power_max,
    converter_0_nominal_power_unit,
    converter_1_nominal_power_min,
    converter_1_nominal_power_max,
    converter_1_nominal_power_unit,
    converter_0_area,
    converter_0_area_unit,
    converter_1_area,
    converter_1_area_unit,
    converter_0_supply_function_name,
    converter_1_supply_function_name,
    converter_0_energy_source_name,
    converter_1_energy_source_name,
    converter_0_service_life,
    converter_0_service_life_unit,
    converter_1_service_life,
    converter_1_service_life_unit,
    converter_0_epd_1_id,
    converter_0_epd_1_name,
    converter_0_epd_1_database_uuid,
    converter_0_epd_2_id,
    converter_0_epd_2_name,
    converter_0_epd_2_database_uuid,
    converter_0_energy_source_epd_id,
    converter_0_energy_source_epd_name,
    converter_0_energy_source_epd_database_uuid,
    converter_1_epd_1_id,
    converter_1_epd_1_name,
    converter_1_epd_1_database_uuid,
    converter_1_epd_2_id,
    converter_1_epd_2_name,
    converter_1_epd_2_database_uuid,
    converter_1_energy_source_epd_id,
    converter_1_energy_source_epd_name,
    converter_1_energy_source_epd_database_uuid
   FROM step_023;
 5   DROP VIEW hub4lca_post_simulation.vw_pre_simulation;
       hub4lca_post_simulation       v       max_schildt    false    278    273    273    237    237    237    273    273    273    264    237    239    239    264    262    262    262    250    250    250    260    260    259    259    252    252    254    257    257    256    256    254    254    254    256    254    254    254    254    254    254    254    224    224    227    227    229    229    229    229    229    229    229    229    229    229    229    229    229    254    229    229    229    229    229    233    233    233    233    233    233    233    233    233    233    233    233    233    233    233    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    235    300    235    235    235    300    300    300    300    235    235    235    300    300    300    300    235    235    235    298    298    291    291    235    237    237    290    290    288    288    237    237    237    282    282    280    280    237    237    237    278    6            q           1259    40900 "   boxplot_final_heat_energy_per_year    VIEW       CREATE VIEW hub4lca_post_simulation.boxplot_final_heat_energy_per_year AS
 WITH per_building AS (
         SELECT heat.project_name,
            heat.run_key,
            (heat.annual_heat_energy / ((1000.0 * 0.85))::double precision) AS final_heat_energy_per_year,
            vps.building_type_name,
            vps.building_adjacency_name,
            vps.age_class_name,
            vps.region_name,
            vps.municipality_size_name,
            vps.municipality_growth_name
           FROM ((hub4lca_post_simulation.tmp_simulation_heat_energy_final_merge heat
             JOIN hub4lca_post_simulation.tmp_simulation_input_final_merge inp ON (((heat.project_name = inp.project_name) AND (heat.run_key = inp.run_key))))
             JOIN hub4lca_post_simulation.vw_pre_simulation vps ON ((inp.building_archetype_id = vps.building_archetype_id)))
        )
 SELECT building_type_name AS building_type,
    building_adjacency_name,
    age_class_name,
    region_name,
    municipality_size_name AS municipality_size_class_name,
    municipality_growth_name AS municipality_growth_class_name,
    avg(final_heat_energy_per_year) AS mean_value,
    percentile_cont((0.50)::double precision) WITHIN GROUP (ORDER BY final_heat_energy_per_year) AS median_value,
    min(final_heat_energy_per_year) AS min_value,
    max(final_heat_energy_per_year) AS max_value,
    percentile_cont((0.25)::double precision) WITHIN GROUP (ORDER BY final_heat_energy_per_year) AS p25_value,
    percentile_cont((0.75)::double precision) WITHIN GROUP (ORDER BY final_heat_energy_per_year) AS p75_value
   FROM per_building
  GROUP BY building_type_name, building_adjacency_name, age_class_name, region_name, municipality_size_name, municipality_growth_name;
 F   DROP VIEW hub4lca_post_simulation.boxplot_final_heat_energy_per_year;
       hub4lca_post_simulation       v       max_schildt    false    362    354    354    354    342    342    342    342    342    342    342    362    362    6            p           1259    40895 )   boxplot_final_heat_energy_per_year_and_m2    VIEW     ]  CREATE VIEW hub4lca_post_simulation.boxplot_final_heat_energy_per_year_and_m2 AS
 WITH per_building AS (
         SELECT heat.project_name,
            heat.run_key,
            (heat.annual_heat_energy / (((1000.0 * 0.85))::double precision * inp.net_leased_area)) AS final_heat_energy_per_year_and_m2,
            vps.building_type_name,
            vps.building_adjacency_name,
            vps.age_class_name,
            vps.region_name,
            vps.municipality_size_name,
            vps.municipality_growth_name
           FROM ((hub4lca_post_simulation.tmp_simulation_heat_energy_final_merge heat
             JOIN hub4lca_post_simulation.tmp_simulation_input_final_merge inp ON (((heat.project_name = inp.project_name) AND (heat.run_key = inp.run_key))))
             JOIN hub4lca_post_simulation.vw_pre_simulation vps ON ((inp.building_archetype_id = vps.building_archetype_id)))
          WHERE (inp.net_leased_area > (0)::double precision)
        )
 SELECT building_type_name AS building_type,
    building_adjacency_name,
    age_class_name,
    region_name,
    municipality_size_name AS municipality_size_class_name,
    municipality_growth_name AS municipality_growth_class_name,
    avg(final_heat_energy_per_year_and_m2) AS mean_value,
    percentile_cont((0.50)::double precision) WITHIN GROUP (ORDER BY final_heat_energy_per_year_and_m2) AS median_value,
    min(final_heat_energy_per_year_and_m2) AS min_value,
    max(final_heat_energy_per_year_and_m2) AS max_value,
    percentile_cont((0.25)::double precision) WITHIN GROUP (ORDER BY final_heat_energy_per_year_and_m2) AS p25_value,
    percentile_cont((0.75)::double precision) WITHIN GROUP (ORDER BY final_heat_energy_per_year_and_m2) AS p75_value
   FROM per_building
  GROUP BY building_type_name, building_adjacency_name, age_class_name, region_name, municipality_size_name, municipality_growth_name;
 M   DROP VIEW hub4lca_post_simulation.boxplot_final_heat_energy_per_year_and_m2;
       hub4lca_post_simulation       v       max_schildt    false    362    354    362    354    354    354    342    342    342    342    342    342    362    342    6            c           1259    37854 (   tmp_simulation_gwp_buildings_final_merge    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 M   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6            ~           0    0 .   TABLE tmp_simulation_gwp_buildings_final_merge    ACL     :  REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge FROM max_schildt;
GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge TO max_schildt;
GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    355            n           1259    40885    boxplot_gwp_b6_per_year    VIEW     X  CREATE VIEW hub4lca_post_simulation.boxplot_gwp_b6_per_year AS
 WITH per_building AS (
         SELECT gwp.project_name,
            gwp.run_key,
            (gwp.b6 / (50.0)::double precision) AS gwp_b6_per_year,
            vps.building_type_name,
            vps.building_adjacency_name,
            vps.age_class_name,
            vps.region_name,
            vps.municipality_size_name,
            vps.municipality_growth_name
           FROM ((hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge gwp
             JOIN hub4lca_post_simulation.tmp_simulation_input_final_merge inp ON (((gwp.project_name = inp.project_name) AND (gwp.run_key = inp.run_key))))
             JOIN hub4lca_post_simulation.vw_pre_simulation vps ON ((inp.building_archetype_id = vps.building_archetype_id)))
        )
 SELECT building_type_name AS building_type,
    building_adjacency_name,
    age_class_name,
    region_name,
    municipality_size_name AS municipality_size_class_name,
    municipality_growth_name AS municipality_growth_class_name,
    avg(gwp_b6_per_year) AS mean_value,
    percentile_cont((0.50)::double precision) WITHIN GROUP (ORDER BY gwp_b6_per_year) AS median_value,
    min(gwp_b6_per_year) AS min_value,
    max(gwp_b6_per_year) AS max_value,
    percentile_cont((0.25)::double precision) WITHIN GROUP (ORDER BY gwp_b6_per_year) AS p25_value,
    percentile_cont((0.75)::double precision) WITHIN GROUP (ORDER BY gwp_b6_per_year) AS p75_value
   FROM per_building
  GROUP BY building_type_name, building_adjacency_name, age_class_name, region_name, municipality_size_name, municipality_growth_name;
 ;   DROP VIEW hub4lca_post_simulation.boxplot_gwp_b6_per_year;
       hub4lca_post_simulation       v       max_schildt    false    355    342    342    342    342    342    342    342    354    354    354    355    355    6            o           1259    40890    boxplot_gwp_b6_per_year_and_m2    VIEW       CREATE VIEW hub4lca_post_simulation.boxplot_gwp_b6_per_year_and_m2 AS
 WITH per_building AS (
         SELECT gwp.project_name,
            gwp.run_key,
            ((gwp.b6 / (50.0)::double precision) / inp.net_leased_area) AS gwp_b6_per_year_and_m2,
            vps.building_type_name,
            vps.building_adjacency_name,
            vps.age_class_name,
            vps.region_name,
            vps.municipality_size_name,
            vps.municipality_growth_name
           FROM ((hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge gwp
             JOIN hub4lca_post_simulation.tmp_simulation_input_final_merge inp ON (((gwp.project_name = inp.project_name) AND (gwp.run_key = inp.run_key))))
             JOIN hub4lca_post_simulation.vw_pre_simulation vps ON ((inp.building_archetype_id = vps.building_archetype_id)))
          WHERE (inp.net_leased_area > (0)::double precision)
        )
 SELECT building_type_name AS building_type,
    building_adjacency_name,
    age_class_name,
    region_name,
    municipality_size_name AS municipality_size_class_name,
    municipality_growth_name AS municipality_growth_class_name,
    avg(gwp_b6_per_year_and_m2) AS mean_value,
    percentile_cont((0.50)::double precision) WITHIN GROUP (ORDER BY gwp_b6_per_year_and_m2) AS median_value,
    min(gwp_b6_per_year_and_m2) AS min_value,
    max(gwp_b6_per_year_and_m2) AS max_value,
    percentile_cont((0.25)::double precision) WITHIN GROUP (ORDER BY gwp_b6_per_year_and_m2) AS p25_value,
    percentile_cont((0.75)::double precision) WITHIN GROUP (ORDER BY gwp_b6_per_year_and_m2) AS p75_value
   FROM per_building
  GROUP BY building_type_name, building_adjacency_name, age_class_name, region_name, municipality_size_name, municipality_growth_name;
 B   DROP VIEW hub4lca_post_simulation.boxplot_gwp_b6_per_year_and_m2;
       hub4lca_post_simulation       v       max_schildt    false    342    342    354    354    354    354    355    355    355    342    342    342    342    342    6            m           1259    40875    boxplot_gwp_total    VIEW       CREATE VIEW hub4lca_post_simulation.boxplot_gwp_total AS
 WITH per_building AS (
         SELECT gwp.project_name,
            gwp.run_key,
            ((((((((((((((COALESCE(gwp.a1_a3, (0)::double precision) + COALESCE(gwp.a4, (0)::double precision)) + COALESCE(gwp.a5, (0)::double precision)) + COALESCE(gwp.b1, (0)::double precision)) + COALESCE(gwp.b2, (0)::double precision)) + COALESCE(gwp.b3, (0)::double precision)) + COALESCE(gwp.b4, (0)::double precision)) + COALESCE(gwp.b5, (0)::double precision)) + COALESCE(gwp.b6, (0)::double precision)) + COALESCE(gwp.b7, (0)::double precision)) + COALESCE(gwp.c1, (0)::double precision)) + COALESCE(gwp.c2, (0)::double precision)) + COALESCE(gwp.c3, (0)::double precision)) + COALESCE(gwp.c4, (0)::double precision)) + COALESCE(gwp.d, (0)::double precision)) AS gwp_total,
            vps.building_type_name,
            vps.building_adjacency_name,
            vps.age_class_name,
            vps.region_name,
            vps.municipality_size_name,
            vps.municipality_growth_name
           FROM ((hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge gwp
             JOIN hub4lca_post_simulation.tmp_simulation_input_final_merge inp ON (((gwp.project_name = inp.project_name) AND (gwp.run_key = inp.run_key))))
             JOIN hub4lca_post_simulation.vw_pre_simulation vps ON ((inp.building_archetype_id = vps.building_archetype_id)))
        )
 SELECT building_type_name AS building_type,
    building_adjacency_name,
    age_class_name,
    region_name,
    municipality_size_name AS municipality_size_class_name,
    municipality_growth_name AS municipality_growth_class_name,
    avg(gwp_total) AS mean_value,
    percentile_cont((0.50)::double precision) WITHIN GROUP (ORDER BY gwp_total) AS median_value,
    min(gwp_total) AS min_value,
    max(gwp_total) AS max_value,
    percentile_cont((0.25)::double precision) WITHIN GROUP (ORDER BY gwp_total) AS p25_value,
    percentile_cont((0.75)::double precision) WITHIN GROUP (ORDER BY gwp_total) AS p75_value
   FROM per_building
  GROUP BY building_type_name, building_adjacency_name, age_class_name, region_name, municipality_size_name, municipality_growth_name;
 5   DROP VIEW hub4lca_post_simulation.boxplot_gwp_total;
       hub4lca_post_simulation       v       max_schildt    false    355    355    355    355    355    355    355    354    354    354    342    342    342    342    342    342    342    355    355    355    355    355    355    355    355    355    355    6            l           1259    40869    boxplot_gwp_total_per_m2    VIEW     $	  CREATE VIEW hub4lca_post_simulation.boxplot_gwp_total_per_m2 AS
 WITH per_building AS (
         SELECT gwp.project_name,
            gwp.run_key,
            (((((((((((((((COALESCE(gwp.a1_a3, (0)::double precision) + COALESCE(gwp.a4, (0)::double precision)) + COALESCE(gwp.a5, (0)::double precision)) + COALESCE(gwp.b1, (0)::double precision)) + COALESCE(gwp.b2, (0)::double precision)) + COALESCE(gwp.b3, (0)::double precision)) + COALESCE(gwp.b4, (0)::double precision)) + COALESCE(gwp.b5, (0)::double precision)) + COALESCE(gwp.b6, (0)::double precision)) + COALESCE(gwp.b7, (0)::double precision)) + COALESCE(gwp.c1, (0)::double precision)) + COALESCE(gwp.c2, (0)::double precision)) + COALESCE(gwp.c3, (0)::double precision)) + COALESCE(gwp.c4, (0)::double precision)) + COALESCE(gwp.d, (0)::double precision)) / inp.net_leased_area) AS gwp_total_per_m2,
            vps.building_type_name,
            vps.building_adjacency_name,
            vps.age_class_name,
            vps.region_name,
            vps.municipality_size_name,
            vps.municipality_growth_name
           FROM ((hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge gwp
             JOIN hub4lca_post_simulation.tmp_simulation_input_final_merge inp ON (((gwp.project_name = inp.project_name) AND (gwp.run_key = inp.run_key))))
             JOIN hub4lca_post_simulation.vw_pre_simulation vps ON ((inp.building_archetype_id = vps.building_archetype_id)))
          WHERE (inp.net_leased_area > (0)::double precision)
        )
 SELECT building_type_name AS building_type,
    building_adjacency_name,
    age_class_name,
    region_name,
    municipality_size_name AS municipality_size_class_name,
    municipality_growth_name AS municipality_growth_class_name,
    avg(gwp_total_per_m2) AS mean_value,
    percentile_cont((0.50)::double precision) WITHIN GROUP (ORDER BY gwp_total_per_m2) AS median_value,
    min(gwp_total_per_m2) AS min_value,
    max(gwp_total_per_m2) AS max_value,
    percentile_cont((0.25)::double precision) WITHIN GROUP (ORDER BY gwp_total_per_m2) AS p25_value,
    percentile_cont((0.75)::double precision) WITHIN GROUP (ORDER BY gwp_total_per_m2) AS p75_value
   FROM per_building
  GROUP BY building_type_name, building_adjacency_name, age_class_name, region_name, municipality_size_name, municipality_growth_name;
 <   DROP VIEW hub4lca_post_simulation.boxplot_gwp_total_per_m2;
       hub4lca_post_simulation       v       max_schildt    false    355    342    342    355    355    342    342    342    342    342    354    354    355    355    355    355    355    355    355    355    355    354    354    355    355    355    355    355    6                        1259    33779 7   building_adjacency_types_building_adjacency_type_id_seq    SEQUENCE     =  ALTER TABLE hub4lca_post_simulation.building_adjacency_types ALTER COLUMN building_adjacency_type_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.building_adjacency_types_building_adjacency_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    227                        1259    33783 -   building_archetypes_building_archetype_id_seq    SEQUENCE     )  ALTER TABLE hub4lca_post_simulation.building_archetypes ALTER COLUMN building_archetype_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.building_archetypes_building_archetype_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    229                        1259    33788    building_element_types    TABLE        CREATE TABLE hub4lca_post_simulation.building_element_types (
    building_element_type_id integer NOT NULL,
    building_element_type_name text NOT NULL,
    description text
);
 ;   DROP TABLE hub4lca_post_simulation.building_element_types;
       hub4lca_post_simulation         heap r       max_schildt    false    6                        1259    33793 3   building_element_types_building_element_type_id_seq    SEQUENCE     5  ALTER TABLE hub4lca_post_simulation.building_element_types ALTER COLUMN building_element_type_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.building_element_types_building_element_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               max_schildt    false    231    6                        1259    33799 )   building_elements_building_element_id_seq    SEQUENCE     !  ALTER TABLE hub4lca_post_simulation.building_elements ALTER COLUMN building_element_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.building_elements_building_element_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    233    6                        1259    33803 >   building_geometry_properties_building_geometry_property_id_seq    SEQUENCE     K  ALTER TABLE hub4lca_post_simulation.building_geometry_properties ALTER COLUMN building_geometry_property_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.building_geometry_properties_building_geometry_property_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               max_schildt    false    235    6                        1259    33809 +   building_materials_building_material_id_seq    SEQUENCE     %  ALTER TABLE hub4lca_post_simulation.building_materials ALTER COLUMN building_material_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.building_materials_building_material_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    237                        1259    33815 #   building_types_building_type_id_seq    SEQUENCE       ALTER TABLE hub4lca_post_simulation.building_types ALTER COLUMN building_type_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.building_types_building_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    239                        1259    33816 '   building_types_citygml_building_classes    TABLE        CREATE TABLE hub4lca_post_simulation.building_types_citygml_building_classes (
    building_type_id integer NOT NULL,
    citygml_building_class_id integer NOT NULL
);
 L   DROP TABLE hub4lca_post_simulation.building_types_citygml_building_classes;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33819 )   building_types_citygml_building_functions    TABLE        CREATE TABLE hub4lca_post_simulation.building_types_citygml_building_functions (
    building_type_id integer NOT NULL,
    citygml_building_function_id integer NOT NULL
);
 N   DROP TABLE hub4lca_post_simulation.building_types_citygml_building_functions;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33822 &   building_types_citygml_building_usages    TABLE        CREATE TABLE hub4lca_post_simulation.building_types_citygml_building_usages (
    building_type_id integer NOT NULL,
    citygml_building_usage_id integer NOT NULL
);
 K   DROP TABLE hub4lca_post_simulation.building_types_citygml_building_usages;
       hub4lca_post_simulation         heap r       postgres    false    6            ]           1259    37642 !   building_types_thermal_zone_types    TABLE        CREATE TABLE hub4lca_post_simulation.building_types_thermal_zone_types (
    building_type_id integer NOT NULL,
    thermal_zone_type_id integer NOT NULL,
    share_of_building real
);
 F   DROP TABLE hub4lca_post_simulation.building_types_thermal_zone_types;
       hub4lca_post_simulation         heap r       max_schildt    false    6                        1259    33825    citygml_building_classes    TABLE        CREATE TABLE hub4lca_post_simulation.citygml_building_classes (
    citygml_building_class_id integer NOT NULL,
    citygml_building_class_name integer NOT NULL,
    description text NOT NULL
);
 =   DROP TABLE hub4lca_post_simulation.citygml_building_classes;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33830 6   citygml_building_classes_citygml_building_class_id_seq    SEQUENCE     ;  ALTER TABLE hub4lca_post_simulation.citygml_building_classes ALTER COLUMN citygml_building_class_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.citygml_building_classes_citygml_building_class_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    244                        1259    33831    citygml_building_functions    TABLE        CREATE TABLE hub4lca_post_simulation.citygml_building_functions (
    citygml_building_function_id integer NOT NULL,
    citygml_building_function_name integer NOT NULL,
    description text NOT NULL
);
 ?   DROP TABLE hub4lca_post_simulation.citygml_building_functions;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33836 ;   citygml_building_functions_citygml_building_function_id_seq    SEQUENCE     E  ALTER TABLE hub4lca_post_simulation.citygml_building_functions ALTER COLUMN citygml_building_function_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.citygml_building_functions_citygml_building_function_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    246    6                        1259    33837    citygml_building_usages    TABLE        CREATE TABLE hub4lca_post_simulation.citygml_building_usages (
    citygml_building_usage_id integer NOT NULL,
    citygml_building_usage_name integer NOT NULL,
    description text NOT NULL
);
 <   DROP TABLE hub4lca_post_simulation.citygml_building_usages;
       hub4lca_post_simulation         heap r       postgres    false    6                        1259    33842 5   citygml_building_usages_citygml_building_usage_id_seq    SEQUENCE     9  ALTER TABLE hub4lca_post_simulation.citygml_building_usages ALTER COLUMN citygml_building_usage_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.citygml_building_usages_citygml_building_usage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    248                        1259    33848 5   component_service_lives_component_service_life_id_seq    SEQUENCE     %  ALTER TABLE hub4lca_post_simulation.service_lives ALTER COLUMN service_life_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.component_service_lives_component_service_life_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    250    6                        1259    33854 +   construction_types_construction_type_id_seq    SEQUENCE     %  ALTER TABLE hub4lca_post_simulation.construction_types ALTER COLUMN construction_type_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.construction_types_construction_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    252                        1259    33865 )   energy_converters_energy_converter_id_seq    SEQUENCE     !  ALTER TABLE hub4lca_post_simulation.energy_converters ALTER COLUMN energy_converter_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.energy_converters_energy_converter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    254                       1259    33876 4   energy_supply_function_energy_supply_function_id_seq    SEQUENCE     8  ALTER TABLE hub4lca_post_simulation.energy_supply_functions ALTER COLUMN energy_supply_function_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.energy_supply_function_energy_supply_function_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    257                       1259    33885 #   energy_systems_energy_system_id_seq    SEQUENCE       ALTER TABLE hub4lca_post_simulation.energy_systems ALTER COLUMN energy_system_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.energy_systems_energy_system_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    259                       1259    33891    reference_flows    TABLE     A  CREATE TABLE hub4lca_post_simulation.reference_flows (
    reference_flow_id integer NOT NULL,
    reference_flow real NOT NULL,
    reference_flow_unit_id integer NOT NULL,
    material_property_unit_id integer,
    description text,
    material_property_value real,
    materal_property_name character varying(100)
);
 4   DROP TABLE hub4lca_post_simulation.reference_flows;
       hub4lca_post_simulation         heap r       postgres    false    6            	           1259    33901    environmental_decl_flow_units    VIEW       CREATE VIEW hub4lca_post_simulation.environmental_decl_flow_units AS
 SELECT epd.environmental_product_declaration_name AS declaration_name,
    rf.reference_flow AS flow_name,
    u.unit_name AS flow_unit
   FROM ((hub4lca_post_simulation.environmental_product_declarations epd
     JOIN hub4lca_post_simulation.reference_flows rf ON ((epd.reference_flow_id = rf.reference_flow_id)))
     JOIN hub4lca_post_simulation.units u ON ((rf.reference_flow_unit_id = u.unit_id)));
 A   DROP VIEW hub4lca_post_simulation.environmental_decl_flow_units;
       hub4lca_post_simulation       v       max_schildt    false    264    264    263    263    263    262    262    6            
           1259    33905    environmental_indicators    TABLE       CREATE TABLE hub4lca_post_simulation.environmental_indicators (
    environmental_indicator_id integer NOT NULL,
    environmental_indicator_name character varying(100) NOT NULL,
    direction character varying(100),
    description text,
    unit_id integer NOT NULL
);
 =   DROP TABLE hub4lca_post_simulation.environmental_indicators;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33910 7   environmental_indicators_environmental_indicator_id_seq    SEQUENCE     =  ALTER TABLE hub4lca_post_simulation.environmental_indicators ALTER COLUMN environmental_indicator_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.environmental_indicators_environmental_indicator_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    266                       1259    33911 (   environmental_product_declaration_values    TABLE       CREATE TABLE hub4lca_post_simulation.environmental_product_declaration_values (
    environmental_product_declaration_value_id integer NOT NULL,
    environmental_product_declaration_id integer,
    life_cycle_module_id integer,
    environmental_indicator_id integer,
    value real
);
 M   DROP TABLE hub4lca_post_simulation.environmental_product_declaration_values;
       hub4lca_post_simulation         heap r       postgres    false    6            
           1259    33914 ?   environmental_product_declara_environmental_product_declar_seq1    SEQUENCE     e  ALTER TABLE hub4lca_post_simulation.environmental_product_declaration_values ALTER COLUMN environmental_product_declaration_value_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.environmental_product_declara_environmental_product_declar_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    268                       1259    33915 ?   environmental_product_declara_environmental_product_declara_seq    SEQUENCE     Y  ALTER TABLE hub4lca_post_simulation.environmental_product_declarations ALTER COLUMN environmental_product_declaration_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.environmental_product_declara_environmental_product_declara_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    262    6                       1259    33916    life_cycle_modules    TABLE        CREATE TABLE hub4lca_post_simulation.life_cycle_modules (
    life_cycle_module_id integer NOT NULL,
    life_cycle_module_name character varying(100) NOT NULL,
    description text
);
 7   DROP TABLE hub4lca_post_simulation.life_cycle_modules;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33921 )   environmental_product_declaration_details    VIEW        CREATE VIEW hub4lca_post_simulation.environmental_product_declaration_details AS
 SELECT v.environmental_product_declaration_id,
    p.database_uuid,
    v.life_cycle_module_id,
    m.life_cycle_module_name,
    v.environmental_indicator_id,
    i.environmental_indicator_name,
    v.value
   FROM (((hub4lca_post_simulation.environmental_product_declaration_values v
     JOIN hub4lca_post_simulation.environmental_product_declarations p ON ((v.environmental_product_declaration_id = p.environmental_product_declaration_id)))
     JOIN hub4lca_post_simulation.life_cycle_modules m ON ((v.life_cycle_module_id = m.life_cycle_module_id)))
     JOIN hub4lca_post_simulation.environmental_indicators i ON ((v.environmental_indicator_id = i.environmental_indicator_id)));
 M   DROP VIEW hub4lca_post_simulation.environmental_product_declaration_details;
       hub4lca_post_simulation       v       max_schildt    false    262    262    271    271    268    268    268    268    266    266    6            K           1259    37411 0   histogram_gwp_b6_per_year_and_m2_by_buildingtype    VIEW       CREATE VIEW hub4lca_post_simulation.histogram_gwp_b6_per_year_and_m2_by_buildingtype AS
 SELECT building_type_id,
    building_type_name,
    metric_id,
    life_cycle_module_id,
    bin_index,
    bin_lower,
    bin_upper,
    bin_count
   FROM hub4lca_post_simulation.get_histogram_by_btype(6, 12, 8, (50)::numeric) get_histogram_by_btype(building_type_id, building_type_name, metric_id, life_cycle_module_id, bin_index, bin_lower, bin_upper, bin_count);
 T   DROP VIEW hub4lca_post_simulation.histogram_gwp_b6_per_year_and_m2_by_buildingtype;
       hub4lca_post_simulation       v       max_schildt    false    370    6            J           1259    37407 )   histogram_gwp_b6_per_year_by_buildingtype    VIEW       CREATE VIEW hub4lca_post_simulation.histogram_gwp_b6_per_year_by_buildingtype AS
 SELECT building_type_id,
    building_type_name,
    metric_id,
    life_cycle_module_id,
    bin_index,
    bin_lower,
    bin_upper,
    bin_count
   FROM hub4lca_post_simulation.get_histogram_by_btype(5, 12, 8, (50)::numeric) get_histogram_by_btype(building_type_id, building_type_name, metric_id, life_cycle_module_id, bin_index, bin_lower, bin_upper, bin_count);
 M   DROP VIEW hub4lca_post_simulation.histogram_gwp_b6_per_year_by_buildingtype;
       hub4lca_post_simulation       v       max_schildt    false    370    6            I           1259    37402 :   histogram_total_final_heat_per_year_and_m2_by_buildingtype    VIEW       CREATE VIEW hub4lca_post_simulation.histogram_total_final_heat_per_year_and_m2_by_buildingtype AS
 SELECT building_type_id,
    building_type_name,
    metric_id,
    life_cycle_module_id,
    bin_index,
    bin_lower,
    bin_upper,
    bin_count
   FROM hub4lca_post_simulation.get_histogram_by_btype_1(4, 19, 8) get_histogram_by_btype(building_type_id, building_type_name, metric_id, life_cycle_module_id, bin_index, bin_lower, bin_upper, bin_count);
 ^   DROP VIEW hub4lca_post_simulation.histogram_total_final_heat_per_year_and_m2_by_buildingtype;
       hub4lca_post_simulation       v       max_schildt    false    383    6            H           1259    37398 3   histogram_total_final_heat_per_year_by_buildingtype    VIEW       CREATE VIEW hub4lca_post_simulation.histogram_total_final_heat_per_year_by_buildingtype AS
 SELECT building_type_id,
    building_type_name,
    metric_id,
    life_cycle_module_id,
    bin_index,
    bin_lower,
    bin_upper,
    bin_count
   FROM hub4lca_post_simulation.get_histogram_by_btype_1(3, 19, 8) get_histogram_by_btype(building_type_id, building_type_name, metric_id, life_cycle_module_id, bin_index, bin_lower, bin_upper, bin_count);
 W   DROP VIEW hub4lca_post_simulation.histogram_total_final_heat_per_year_by_buildingtype;
       hub4lca_post_simulation       v       max_schildt    false    383    6            L           1259    37415 #   histogram_total_gwp_by_buildingtype    VIEW       CREATE VIEW hub4lca_post_simulation.histogram_total_gwp_by_buildingtype AS
 SELECT building_type_id,
    building_type_name,
    metric_id,
    life_cycle_module_id,
    bin_index,
    bin_lower,
    bin_upper,
    bin_count
   FROM hub4lca_post_simulation.get_histogram_by_btype(5, 20, 8, (1)::numeric) get_histogram_by_btype(building_type_id, building_type_name, metric_id, life_cycle_module_id, bin_index, bin_lower, bin_upper, bin_count);
 G   DROP VIEW hub4lca_post_simulation.histogram_total_gwp_by_buildingtype;
       hub4lca_post_simulation       v       max_schildt    false    370    6            M           1259    37419 *   histogram_total_gwp_per_m2_by_buildingtype    VIEW       CREATE VIEW hub4lca_post_simulation.histogram_total_gwp_per_m2_by_buildingtype AS
 SELECT building_type_id,
    building_type_name,
    metric_id,
    life_cycle_module_id,
    bin_index,
    bin_lower,
    bin_upper,
    bin_count
   FROM hub4lca_post_simulation.get_histogram_by_btype(6, 20, 8, (1)::numeric) get_histogram_by_btype(building_type_id, building_type_name, metric_id, life_cycle_module_id, bin_index, bin_lower, bin_upper, bin_count);
 N   DROP VIEW hub4lca_post_simulation.histogram_total_gwp_per_m2_by_buildingtype;
       hub4lca_post_simulation       v       max_schildt    false    370    6            B           1259    37171    metrics    TABLE     A  CREATE TABLE hub4lca_post_simulation.metrics (
    metric_id integer NOT NULL,
    code text NOT NULL,
    name text NOT NULL,
    level text NOT NULL,
    scope text NOT NULL,
    domain text NOT NULL,
    is_derived boolean DEFAULT false NOT NULL,
    unit_id integer,
    CONSTRAINT metrics_domain_check CHECK ((domain = ANY (ARRAY['energy'::text, 'gwp'::text]))),
    CONSTRAINT metrics_level_check CHECK ((level = ANY (ARRAY['building'::text, 'building_element'::text]))),
    CONSTRAINT metrics_scope_check CHECK ((scope = ANY (ARRAY['total'::text, 'per_m2'::text])))
);
 ,   DROP TABLE hub4lca_post_simulation.metrics;
       hub4lca_post_simulation         heap r       max_schildt    false    6            O           1259    37519 
   kpi_ab_nonres    VIEW     *	  CREATE VIEW hub4lca_post_simulation.kpi_ab_nonres AS
 WITH aggregated AS (
         SELECT amb.building_archetype_id,
            ba.building_archetype_name,
            amb.metric_id,
            amb.life_cycle_module_id,
            sum(amb.n) AS total_n,
            (sum(((amb.mean_value)::numeric * (amb.n)::numeric)) / (NULLIF(sum(amb.n), 0))::numeric) AS w_mean_value,
            (sum(((amb.se_mean)::numeric * (amb.n)::numeric)) / (NULLIF(sum(amb.n), 0))::numeric) AS w_se_mean,
            (sum(((amb.cv)::numeric * (amb.n)::numeric)) / (NULLIF(sum(amb.n), 0))::numeric) AS w_cv
           FROM ((hub4lca_post_simulation.archetype_metric_stats_building amb
             JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
          WHERE (((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])) AND (((((((amb.metric_id = 3) AND (amb.life_cycle_module_id = 19)) OR ((amb.metric_id = 4) AND (amb.life_cycle_module_id = 19))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 12))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 12))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 20))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 20))))
          GROUP BY amb.building_archetype_id, ba.building_archetype_name, amb.metric_id, amb.life_cycle_module_id
        )
 SELECT a.building_archetype_id,
    a.building_archetype_name,
    m.code AS kpi,
    lcm.life_cycle_module_name AS life_cycle_scope,
    round(
        CASE
            WHEN ((a.metric_id = ANY (ARRAY[5, 6])) AND (a.life_cycle_module_id = 12)) THEN (a.w_mean_value / (50)::numeric)
            ELSE a.w_mean_value
        END, 2) AS mean_value,
    round(
        CASE
            WHEN ((a.metric_id = ANY (ARRAY[5, 6])) AND (a.life_cycle_module_id = 12)) THEN (a.w_se_mean / (50)::numeric)
            ELSE a.w_se_mean
        END, 2) AS "95%_CI",
    round(a.w_cv, 2) AS cv,
    a.total_n AS n
   FROM ((aggregated a
     JOIN hub4lca_post_simulation.metrics m ON ((a.metric_id = m.metric_id)))
     JOIN hub4lca_post_simulation.life_cycle_modules lcm ON ((a.life_cycle_module_id = lcm.life_cycle_module_id)));
 1   DROP VIEW hub4lca_post_simulation.kpi_ab_nonres;
       hub4lca_post_simulation       v       max_schildt    false    322    271    323    323    323    239    239    229    229    323    323    323    229    323    322    271    6            N           1259    37514    kpi_sfh_mfh    VIEW       CREATE VIEW hub4lca_post_simulation.kpi_sfh_mfh AS
 SELECT amb.building_archetype_id,
    ba.building_archetype_name,
    m.code AS kpi,
    lcm.life_cycle_module_name AS life_cycle_scope,
    round(
        CASE
            WHEN ((amb.metric_id = ANY (ARRAY[5, 6])) AND (amb.life_cycle_module_id = 12)) THEN ((amb.mean_value)::numeric / (50)::numeric)
            ELSE (amb.mean_value)::numeric
        END, 2) AS mean_value,
    round(
        CASE
            WHEN ((amb.metric_id = ANY (ARRAY[5, 6])) AND (amb.life_cycle_module_id = 12)) THEN ((amb.se_mean)::numeric / (50)::numeric)
            ELSE (amb.se_mean)::numeric
        END, 2) AS "95%_CI",
    round((amb.cv)::numeric, 2) AS cv,
    amb.n
   FROM ((((hub4lca_post_simulation.archetype_metric_stats_building amb
     JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
     JOIN hub4lca_post_simulation.metrics m ON ((amb.metric_id = m.metric_id)))
     JOIN hub4lca_post_simulation.life_cycle_modules lcm ON ((amb.life_cycle_module_id = lcm.life_cycle_module_id)))
  WHERE (((bt.building_type_name)::text = ANY ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])) AND (((((((amb.metric_id = 3) AND (amb.life_cycle_module_id = 19)) OR ((amb.metric_id = 4) AND (amb.life_cycle_module_id = 19))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 12))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 12))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 20))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 20))));
 /   DROP VIEW hub4lca_post_simulation.kpi_sfh_mfh;
       hub4lca_post_simulation       v       max_schildt    false    271    229    229    323    323    322    322    323    239    239    229    323    323    323    271    323    6                       1259    33931    layers_layer_id_seq    SEQUENCE        ALTER TABLE hub4lca_post_simulation.layers ALTER COLUMN layer_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.layers_layer_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    273    6                       1259    33944 
   lca_databases    TABLE        CREATE TABLE hub4lca_post_simulation.lca_databases (
    lca_database_id integer NOT NULL,
    lca_database_name character varying(100) NOT NULL,
    description text,
    version character varying(100)
);
 2   DROP TABLE hub4lca_post_simulation.lca_databases;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    33949 !   lca_databases_lca_database_id_seq    SEQUENCE       ALTER TABLE hub4lca_post_simulation.lca_databases ALTER COLUMN lca_database_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.lca_databases_lca_database_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    275    6                       1259    33950 )   life_cycle_stages_life_cycle_stage_id_seq    SEQUENCE     #  ALTER TABLE hub4lca_post_simulation.life_cycle_modules ALTER COLUMN life_cycle_module_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.life_cycle_stages_life_cycle_stage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    271            @           1259    37163    weather_stations    TABLE        CREATE TABLE hub4lca_post_simulation.weather_stations (
    weather_station_id integer NOT NULL,
    weather_station_name text,
    description text
);
 5   DROP TABLE hub4lca_post_simulation.weather_stations;
       hub4lca_post_simulation         heap r       max_schildt    false    6            P           1259    37577 #   lollipop_final_heat_energy_per_year    VIEW     %  CREATE VIEW hub4lca_post_simulation.lollipop_final_heat_energy_per_year AS
 SELECT amb.building_archetype_id,
    ba.building_archetype_name,
    ws.weather_station_name,
    round((amb.mean_value)::numeric, 2) AS mean_value
   FROM (((hub4lca_post_simulation.archetype_metric_stats_building amb
     JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
     JOIN hub4lca_post_simulation.weather_stations ws ON ((amb.weather_station_id = ws.weather_station_id)))
  WHERE ((amb.metric_id = 3) AND (amb.life_cycle_module_id = 19) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])));
 G   DROP VIEW hub4lca_post_simulation.lollipop_final_heat_energy_per_year;
       hub4lca_post_simulation       v       max_schildt    false    323    229    229    229    239    239    320    320    323    323    323    323    6            Q           1259    37582 *   lollipop_final_heat_energy_per_year_and_m2    VIEW     ,  CREATE VIEW hub4lca_post_simulation.lollipop_final_heat_energy_per_year_and_m2 AS
 SELECT amb.building_archetype_id,
    ba.building_archetype_name,
    ws.weather_station_name,
    round((amb.mean_value)::numeric, 2) AS mean_value
   FROM (((hub4lca_post_simulation.archetype_metric_stats_building amb
     JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
     JOIN hub4lca_post_simulation.weather_stations ws ON ((amb.weather_station_id = ws.weather_station_id)))
  WHERE ((amb.metric_id = 4) AND (amb.life_cycle_module_id = 19) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])));
 N   DROP VIEW hub4lca_post_simulation.lollipop_final_heat_energy_per_year_and_m2;
       hub4lca_post_simulation       v       max_schildt    false    323    323    323    320    239    239    229    229    323    229    323    320    6            R           1259    37587    lollipop_gwp_b6_per_year    VIEW     7  CREATE VIEW hub4lca_post_simulation.lollipop_gwp_b6_per_year AS
 SELECT amb.building_archetype_id,
    ba.building_archetype_name,
    ws.weather_station_name,
    round(((amb.mean_value / (50.0)::double precision))::numeric, 2) AS mean_value
   FROM (((hub4lca_post_simulation.archetype_metric_stats_building amb
     JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
     JOIN hub4lca_post_simulation.weather_stations ws ON ((amb.weather_station_id = ws.weather_station_id)))
  WHERE ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 12) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])));
 <   DROP VIEW hub4lca_post_simulation.lollipop_gwp_b6_per_year;
       hub4lca_post_simulation       v       max_schildt    false    323    323    323    323    323    320    320    239    239    229    229    229    6            S           1259    37592    lollipop_gwp_b6_per_year_and_m2    VIEW     >  CREATE VIEW hub4lca_post_simulation.lollipop_gwp_b6_per_year_and_m2 AS
 SELECT amb.building_archetype_id,
    ba.building_archetype_name,
    ws.weather_station_name,
    round(((amb.mean_value / (50.0)::double precision))::numeric, 2) AS mean_value
   FROM (((hub4lca_post_simulation.archetype_metric_stats_building amb
     JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
     JOIN hub4lca_post_simulation.weather_stations ws ON ((amb.weather_station_id = ws.weather_station_id)))
  WHERE ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 12) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])));
 C   DROP VIEW hub4lca_post_simulation.lollipop_gwp_b6_per_year_and_m2;
       hub4lca_post_simulation       v       max_schildt    false    229    323    323    323    323    320    320    239    239    323    229    229    6            T           1259    37597    lollipop_gwp_total    VIEW       CREATE VIEW hub4lca_post_simulation.lollipop_gwp_total AS
 SELECT amb.building_archetype_id,
    ba.building_archetype_name,
    ws.weather_station_name,
    round((amb.mean_value)::numeric, 2) AS mean_value
   FROM (((hub4lca_post_simulation.archetype_metric_stats_building amb
     JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
     JOIN hub4lca_post_simulation.weather_stations ws ON ((amb.weather_station_id = ws.weather_station_id)))
  WHERE ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 20) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])));
 6   DROP VIEW hub4lca_post_simulation.lollipop_gwp_total;
       hub4lca_post_simulation       v       max_schildt    false    229    323    323    323    323    323    229    320    320    239    239    229    6            U           1259    37602    lollipop_gwp_total_per_m2    VIEW       CREATE VIEW hub4lca_post_simulation.lollipop_gwp_total_per_m2 AS
 SELECT amb.building_archetype_id,
    ba.building_archetype_name,
    ws.weather_station_name,
    round((amb.mean_value)::numeric, 2) AS mean_value
   FROM (((hub4lca_post_simulation.archetype_metric_stats_building amb
     JOIN hub4lca_post_simulation.building_archetypes ba ON ((amb.building_archetype_id = ba.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt ON ((ba.building_type_id = bt.building_type_id)))
     JOIN hub4lca_post_simulation.weather_stations ws ON ((amb.weather_station_id = ws.weather_station_id)))
  WHERE ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 20) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])));
 =   DROP VIEW hub4lca_post_simulation.lollipop_gwp_total_per_m2;
       hub4lca_post_simulation       v       max_schildt    false    229    229    229    239    239    320    320    323    323    323    323    323    6            `           1259    37692 "   mean_life_cycle_gwp_abc_ab_non_res    VIEW       CREATE VIEW hub4lca_post_simulation.mean_life_cycle_gwp_abc_ab_non_res AS
 WITH archetypes AS (
         SELECT ba.building_archetype_id,
            ba.building_archetype_name,
            bt.building_type_name
           FROM (hub4lca_post_simulation.building_archetypes ba
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = ba.building_type_id)))
          WHERE ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[]))
        ), building_op AS (
         SELECT b.building_archetype_id,
            (sum((b.mean_value * (b.n)::double precision)) / (NULLIF(sum(b.n), 0))::double precision) AS operational_mean_value
           FROM ((hub4lca_post_simulation.archetype_metric_stats_building b
             JOIN hub4lca_post_simulation.building_archetypes ba ON ((ba.building_archetype_id = b.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = ba.building_type_id)))
          WHERE ((b.metric_id = 5) AND (b.life_cycle_module_id = 21) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])))
          GROUP BY b.building_archetype_id
        ), elements AS (
         SELECT e.building_archetype_id,
            (sum(
                CASE
                    WHEN (e.building_element_type_id = 1) THEN (e.mean_value * (e.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e.building_element_type_id = 1) THEN e.n
                    ELSE 0
                END), 0))::double precision) AS exterior_wall_mean_value,
            (sum(
                CASE
                    WHEN (e.building_element_type_id = 2) THEN (e.mean_value * (e.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e.building_element_type_id = 2) THEN e.n
                    ELSE 0
                END), 0))::double precision) AS roof_mean_value,
            (sum(
                CASE
                    WHEN (e.building_element_type_id = 3) THEN (e.mean_value * (e.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e.building_element_type_id = 3) THEN e.n
                    ELSE 0
                END), 0))::double precision) AS foundation_mean_value,
            (sum(
                CASE
                    WHEN (e.building_element_type_id = 5) THEN (e.mean_value * (e.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e.building_element_type_id = 5) THEN e.n
                    ELSE 0
                END), 0))::double precision) AS window_mean_value
           FROM ((hub4lca_post_simulation.archetype_metric_stats_element e
             JOIN hub4lca_post_simulation.building_archetypes ba ON ((ba.building_archetype_id = e.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = ba.building_type_id)))
          WHERE ((e.life_cycle_module_id = 21) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])))
          GROUP BY e.building_archetype_id
        ), combined AS (
         SELECT a.building_archetype_id,
            a.building_archetype_name,
            a.building_type_name,
            op.operational_mean_value,
            el.exterior_wall_mean_value,
            el.roof_mean_value,
            el.foundation_mean_value,
            el.window_mean_value
           FROM ((archetypes a
             LEFT JOIN building_op op ON ((op.building_archetype_id = a.building_archetype_id)))
             LEFT JOIN elements el ON ((el.building_archetype_id = a.building_archetype_id)))
        ), with_total AS (
         SELECT combined.building_archetype_id,
            combined.building_archetype_name,
            combined.building_type_name,
            combined.operational_mean_value,
            combined.exterior_wall_mean_value,
            combined.roof_mean_value,
            combined.foundation_mean_value,
            combined.window_mean_value,
            ((((COALESCE(combined.operational_mean_value, (0)::double precision) + COALESCE(combined.exterior_wall_mean_value, (0)::double precision)) + COALESCE(combined.roof_mean_value, (0)::double precision)) + COALESCE(combined.foundation_mean_value, (0)::double precision)) + COALESCE(combined.window_mean_value, (0)::double precision)) AS total_mean_value
           FROM combined
        )
 SELECT building_archetype_id,
    building_archetype_name,
    building_type_name,
    round((operational_mean_value)::numeric, 2) AS operational_mean_value,
    round((exterior_wall_mean_value)::numeric, 2) AS exterior_wall_mean_value,
    round((roof_mean_value)::numeric, 2) AS roof_mean_value,
    round((foundation_mean_value)::numeric, 2) AS foundation_mean_value,
    round((window_mean_value)::numeric, 2) AS window_mean_value,
    round(((operational_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS operational_mean_share,
    round(((exterior_wall_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS exterior_wall_mean_share,
    round(((roof_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS roof_mean_share,
    round(((foundation_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS foundation_mean_share,
    round(((window_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS window_mean_share
   FROM with_total;
 F   DROP VIEW hub4lca_post_simulation.mean_life_cycle_gwp_abc_ab_non_res;
       hub4lca_post_simulation       v       max_schildt    false    323    229    229    324    324    324    324    323    323    229    323    323    239    239    324    6            ^           1259    37682    mean_life_cycle_gwp_abc_sfh_mfh    VIEW       CREATE VIEW hub4lca_post_simulation.mean_life_cycle_gwp_abc_sfh_mfh AS
 WITH base AS (
         SELECT b.building_archetype_id,
            b.weather_station_id,
            ba.building_archetype_name,
            bt.building_type_name,
            b.mean_value AS operational_mean_value,
            max(
                CASE
                    WHEN (e.building_element_type_id = 1) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS exterior_wall_mean_value,
            max(
                CASE
                    WHEN (e.building_element_type_id = 2) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS roof_mean_value,
            max(
                CASE
                    WHEN (e.building_element_type_id = 3) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS foundation_mean_value,
            max(
                CASE
                    WHEN (e.building_element_type_id = 5) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS window_mean_value
           FROM (((hub4lca_post_simulation.archetype_metric_stats_building b
             JOIN hub4lca_post_simulation.building_archetypes ba ON ((ba.building_archetype_id = b.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = ba.building_type_id)))
             LEFT JOIN hub4lca_post_simulation.archetype_metric_stats_element e ON (((e.building_archetype_id = b.building_archetype_id) AND (e.weather_station_id = b.weather_station_id) AND (e.life_cycle_module_id = 21))))
          WHERE ((b.metric_id = 5) AND (b.life_cycle_module_id = 21) AND ((bt.building_type_name)::text = ANY ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])))
          GROUP BY b.building_archetype_id, b.weather_station_id, ba.building_archetype_name, bt.building_type_name, b.mean_value
        ), with_total AS (
         SELECT base.building_archetype_id,
            base.weather_station_id,
            base.building_archetype_name,
            base.building_type_name,
            base.operational_mean_value,
            base.exterior_wall_mean_value,
            base.roof_mean_value,
            base.foundation_mean_value,
            base.window_mean_value,
            ((((COALESCE(base.operational_mean_value, (0)::double precision) + COALESCE(base.exterior_wall_mean_value, (0)::double precision)) + COALESCE(base.roof_mean_value, (0)::double precision)) + COALESCE(base.foundation_mean_value, (0)::double precision)) + COALESCE(base.window_mean_value, (0)::double precision)) AS total_mean_value
           FROM base
        )
 SELECT building_archetype_id,
    weather_station_id,
    building_archetype_name,
    building_type_name,
    round((operational_mean_value)::numeric, 2) AS operational_mean_value,
    round((exterior_wall_mean_value)::numeric, 2) AS exterior_wall_mean_value,
    round((roof_mean_value)::numeric, 2) AS roof_mean_value,
    round((foundation_mean_value)::numeric, 2) AS foundation_mean_value,
    round((window_mean_value)::numeric, 2) AS window_mean_value,
    round(((operational_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS operational_mean_share,
    round(((exterior_wall_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS exterior_wall_mean_share,
    round(((roof_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS roof_mean_share,
    round(((foundation_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS foundation_mean_share,
    round(((window_mean_value / NULLIF(total_mean_value, (0)::double precision)))::numeric, 2) AS window_mean_share
   FROM with_total;
 C   DROP VIEW hub4lca_post_simulation.mean_life_cycle_gwp_abc_sfh_mfh;
       hub4lca_post_simulation       v       max_schildt    false    229    324    323    323    323    323    323    239    239    229    229    324    324    324    324    6            a           1259    37697     mean_life_cycle_gwp_d_ab_non_res    VIEW       CREATE VIEW hub4lca_post_simulation.mean_life_cycle_gwp_d_ab_non_res AS
 WITH archetypes AS (
         SELECT ba.building_archetype_id,
            ba.building_archetype_name,
            bt.building_type_name
           FROM (hub4lca_post_simulation.building_archetypes ba
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = ba.building_type_id)))
          WHERE ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[]))
        ), elements AS (
         SELECT e_1.building_archetype_id,
            (sum(
                CASE
                    WHEN (e_1.building_element_type_id = 1) THEN (e_1.mean_value * (e_1.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e_1.building_element_type_id = 1) THEN e_1.n
                    ELSE 0
                END), 0))::double precision) AS exterior_wall_mean_value,
            (sum(
                CASE
                    WHEN (e_1.building_element_type_id = 2) THEN (e_1.mean_value * (e_1.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e_1.building_element_type_id = 2) THEN e_1.n
                    ELSE 0
                END), 0))::double precision) AS roof_mean_value,
            (sum(
                CASE
                    WHEN (e_1.building_element_type_id = 3) THEN (e_1.mean_value * (e_1.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e_1.building_element_type_id = 3) THEN e_1.n
                    ELSE 0
                END), 0))::double precision) AS foundation_mean_value,
            (sum(
                CASE
                    WHEN (e_1.building_element_type_id = 5) THEN (e_1.mean_value * (e_1.n)::double precision)
                    ELSE (0)::double precision
                END) / (NULLIF(sum(
                CASE
                    WHEN (e_1.building_element_type_id = 5) THEN e_1.n
                    ELSE 0
                END), 0))::double precision) AS window_mean_value
           FROM ((hub4lca_post_simulation.archetype_metric_stats_element e_1
             JOIN hub4lca_post_simulation.building_archetypes ba ON ((ba.building_archetype_id = e_1.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = ba.building_type_id)))
          WHERE ((e_1.life_cycle_module_id = 17) AND ((bt.building_type_name)::text <> ALL ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])))
          GROUP BY e_1.building_archetype_id
        )
 SELECT a.building_archetype_id,
    a.building_archetype_name,
    a.building_type_name,
    round((e.exterior_wall_mean_value)::numeric, 2) AS exterior_wall_mean_value,
    round((e.roof_mean_value)::numeric, 2) AS roof_mean_value,
    round((e.foundation_mean_value)::numeric, 2) AS foundation_mean_value,
    round((e.window_mean_value)::numeric, 2) AS window_mean_value
   FROM (archetypes a
     LEFT JOIN elements e ON ((e.building_archetype_id = a.building_archetype_id)));
 D   DROP VIEW hub4lca_post_simulation.mean_life_cycle_gwp_d_ab_non_res;
       hub4lca_post_simulation       v       max_schildt    false    229    229    229    239    239    324    324    324    324    324    6            _           1259    37687    mean_life_cycle_gwp_d_sfh_mfh    VIEW     	  CREATE VIEW hub4lca_post_simulation.mean_life_cycle_gwp_d_sfh_mfh AS
 WITH base AS (
         SELECT e.building_archetype_id,
            e.weather_station_id,
            ba.building_archetype_name,
            bt.building_type_name,
            max(
                CASE
                    WHEN (e.building_element_type_id = 1) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS exterior_wall_mean_value,
            max(
                CASE
                    WHEN (e.building_element_type_id = 2) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS roof_mean_value,
            max(
                CASE
                    WHEN (e.building_element_type_id = 3) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS foundation_mean_value,
            max(
                CASE
                    WHEN (e.building_element_type_id = 5) THEN e.mean_value
                    ELSE NULL::double precision
                END) AS window_mean_value
           FROM ((hub4lca_post_simulation.archetype_metric_stats_element e
             JOIN hub4lca_post_simulation.building_archetypes ba ON ((ba.building_archetype_id = e.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = ba.building_type_id)))
          WHERE ((e.life_cycle_module_id = 17) AND ((bt.building_type_name)::text = ANY ((ARRAY['sfh'::character varying, 'mfh'::character varying])::text[])))
          GROUP BY e.building_archetype_id, e.weather_station_id, ba.building_archetype_name, bt.building_type_name
        )
 SELECT building_archetype_id,
    weather_station_id,
    building_archetype_name,
    building_type_name,
    round((exterior_wall_mean_value)::numeric, 2) AS exterior_wall_mean_value,
    round((roof_mean_value)::numeric, 2) AS roof_mean_value,
    round((foundation_mean_value)::numeric, 2) AS foundation_mean_value,
    round((window_mean_value)::numeric, 2) AS window_mean_value
   FROM base;
 A   DROP VIEW hub4lca_post_simulation.mean_life_cycle_gwp_d_sfh_mfh;
       hub4lca_post_simulation       v       max_schildt    false    324    229    229    239    239    324    324    324    324    229    6            E           1259    37247    metric_histogram_bins    TABLE     R  CREATE TABLE hub4lca_post_simulation.metric_histogram_bins (
    building_type_id integer NOT NULL,
    metric_id integer NOT NULL,
    bin_index integer NOT NULL,
    bin_lower double precision NOT NULL,
    bin_upper double precision NOT NULL,
    life_cycle_module_id integer NOT NULL,
    building_element_type_id integer NOT NULL
);
 :   DROP TABLE hub4lca_post_simulation.metric_histogram_bins;
       hub4lca_post_simulation         heap r       max_schildt    false    6            A           1259    37170    metrics_metric_id_seq    SEQUENCE        CREATE SEQUENCE hub4lca_post_simulation.metrics_metric_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;
 =   DROP SEQUENCE hub4lca_post_simulation.metrics_metric_id_seq;
       hub4lca_post_simulation               max_schildt    false    6    322                       0    0    metrics_metric_id_seq    SEQUENCE OWNED BY     q   ALTER SEQUENCE hub4lca_post_simulation.metrics_metric_id_seq OWNED BY hub4lca_post_simulation.metrics.metric_id;
          hub4lca_post_simulation               max_schildt    false    321                       1259    33981 :   municipality_growth_types_municipality_growth_class_id_seq    SEQUENCE     E  ALTER TABLE hub4lca_post_simulation.municipality_growth_classes ALTER COLUMN municipality_growth_class_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.municipality_growth_types_municipality_growth_class_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    278    6                       1259    33987 6   municipality_size_types_municipality_size_class_id_seq    SEQUENCE     =  ALTER TABLE hub4lca_post_simulation.municipality_size_classes ALTER COLUMN municipality_size_class_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.municipality_size_types_municipality_size_class_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    280    6                       1259    33993    pitch_types_pitch_type_id_seq    SEQUENCE     	  ALTER TABLE hub4lca_post_simulation.pitch_types ALTER COLUMN pitch_type_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.pitch_types_pitch_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    282                       1259    33994 3   primary_energy_sources_primary_energy_source_id_seq    SEQUENCE     %  ALTER TABLE hub4lca_post_simulation.energy_sources ALTER COLUMN energy_source_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.primary_energy_sources_primary_energy_source_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    256    6                       1259    33995    product_category_rules    TABLE        CREATE TABLE hub4lca_post_simulation.product_category_rules (
    product_category_rule_id integer NOT NULL,
    product_category_rule_name character varying(100) NOT NULL,
    description text,
    standard_id integer
);
 ;   DROP TABLE hub4lca_post_simulation.product_category_rules;
       hub4lca_post_simulation         heap r       postgres    false    6                       1259    34000 3   product_category_rules_product_category_rule_id_seq    SEQUENCE     5  ALTER TABLE hub4lca_post_simulation.product_category_rules ALTER COLUMN product_category_rule_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.product_category_rules_product_category_rule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    285                       1259    34001 %   reference_flows_reference_flow_id_seq    SEQUENCE       ALTER TABLE hub4lca_post_simulation.reference_flows ALTER COLUMN reference_flow_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.reference_flows_reference_flow_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    263            !           1259    34007    regions_region_id_seq    SEQUENCE        ALTER TABLE hub4lca_post_simulation.regions ALTER COLUMN region_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.regions_region_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    288    6            $           1259    34016 !   shading_types_shading_type_id_seq    SEQUENCE       ALTER TABLE hub4lca_post_simulation.shading_types ALTER COLUMN shading_type_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.shading_types_shading_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    291    6            %           1259    34017 	   standards    TABLE        CREATE TABLE hub4lca_post_simulation.standards (
    standard_id integer NOT NULL,
    standard_name character varying(100) NOT NULL,
    description text
);
 .   DROP TABLE hub4lca_post_simulation.standards;
       hub4lca_post_simulation         heap r       postgres    false    6            &           1259    34022    standards_standard_id_seq    SEQUENCE       ALTER TABLE hub4lca_post_simulation.standards ALTER COLUMN standard_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.standards_standard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    293    6            \           1259    37635    thermal_zone_types    TABLE        CREATE TABLE hub4lca_post_simulation.thermal_zone_types (
    thermal_zone_type_id integer NOT NULL,
    thermal_zone_type_name text,
    description text
);
 7   DROP TABLE hub4lca_post_simulation.thermal_zone_types;
       hub4lca_post_simulation         heap r       max_schildt    false    6            [           1259    37634 +   thermal_zone_types_thermal_zone_type_id_seq    SEQUENCE     %  ALTER TABLE hub4lca_post_simulation.thermal_zone_types ALTER COLUMN thermal_zone_type_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.thermal_zone_types_thermal_zone_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               max_schildt    false    6    348            1           1259    34705    tmp_simulation_gwp_buildings_1    TABLE     G  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 C   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 $   TABLE tmp_simulation_gwp_buildings_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    305            2           1259    34710    tmp_simulation_gwp_buildings_2    TABLE     G  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 C   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 $   TABLE tmp_simulation_gwp_buildings_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_buildings_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    306            3           1259    35630 #   tmp_simulation_gwp_exterior_walls_1    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision,
    building_adjacency text
);
 H   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 )   TABLE tmp_simulation_gwp_exterior_walls_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    307            9           1259    35660 #   tmp_simulation_gwp_exterior_walls_2    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision,
    building_adjacency text
);
 H   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 )   TABLE tmp_simulation_gwp_exterior_walls_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    313            d           1259    37860 -   tmp_simulation_gwp_exterior_walls_final_merge    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision,
    building_adjacency text
);
 R   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 3   TABLE tmp_simulation_gwp_exterior_walls_final_merge    ACL     q   GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    356            8           1259    35655    tmp_simulation_gwp_floors_1    TABLE     g  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 @   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 !   TABLE tmp_simulation_gwp_floors_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    312            >           1259    35685    tmp_simulation_gwp_floors_2    TABLE     g  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 @   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 !   TABLE tmp_simulation_gwp_floors_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    318            e           1259    37866 %   tmp_simulation_gwp_floors_final_merge    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 J   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 +   TABLE tmp_simulation_gwp_floors_final_merge    ACL     i   GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_floors_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    357            5           1259    35640     tmp_simulation_gwp_foundations_1    TABLE     l  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 E   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 &   TABLE tmp_simulation_gwp_foundations_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    309            ;           1259    35670     tmp_simulation_gwp_foundations_2    TABLE     l  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 E   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 &   TABLE tmp_simulation_gwp_foundations_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    315            f           1259    37872 *   tmp_simulation_gwp_foundations_final_merge    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 O   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 0   TABLE tmp_simulation_gwp_foundations_final_merge    ACL     n   GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_foundations_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    358            7           1259    35650 #   tmp_simulation_gwp_interior_walls_1    TABLE     o  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 H   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 )   TABLE tmp_simulation_gwp_interior_walls_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    311            =           1259    35680 #   tmp_simulation_gwp_interior_walls_2    TABLE     o  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 H   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 )   TABLE tmp_simulation_gwp_interior_walls_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    317            g           1259    37878 -   tmp_simulation_gwp_interior_walls_final_merge    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 R   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 3   TABLE tmp_simulation_gwp_interior_walls_final_merge    ACL     q   GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_interior_walls_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    359            4           1259    35635    tmp_simulation_gwp_roofs_1    TABLE     f  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 ?   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0     TABLE tmp_simulation_gwp_roofs_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    308            :           1259    35665    tmp_simulation_gwp_roofs_2    TABLE     f  CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 ?   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0     TABLE tmp_simulation_gwp_roofs_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    314            h           1259    37884 $   tmp_simulation_gwp_roofs_final_merge    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision
);
 I   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 *   TABLE tmp_simulation_gwp_roofs_final_merge    ACL     h   GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_roofs_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    360            6           1259    35645    tmp_simulation_gwp_windows_1    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision,
    window_frame_type_name text
);
 A   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 "   TABLE tmp_simulation_gwp_windows_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    310            <           1259    35675    tmp_simulation_gwp_windows_2    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision,
    window_frame_type_name text
);
 A   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 "   TABLE tmp_simulation_gwp_windows_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    316            i           1259    37890 &   tmp_simulation_gwp_windows_final_merge    TABLE       CREATE TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_final_merge (
    simulation_tag bigint NOT NULL,
    simulation_run smallint,
    project_name text,
    run_key text,
    overall_area double precision,
    a1 double precision,
    a2 double precision,
    a3 double precision,
    a1_a3 double precision,
    a4 double precision,
    a5 double precision,
    b1 double precision,
    b2 double precision,
    b3 double precision,
    b4 double precision,
    b5 double precision,
    b6 double precision,
    b7 double precision,
    c1 double precision,
    c2 double precision,
    c3 double precision,
    c4 double precision,
    d double precision,
    window_frame_type_name text
);
 K   DROP TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_final_merge;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 ,   TABLE tmp_simulation_gwp_windows_final_merge    ACL     j   GRANT SELECT ON TABLE hub4lca_post_simulation.tmp_simulation_gwp_windows_final_merge TO hub4lca_readonly;
          hub4lca_post_simulation               max_schildt    false    361            /           1259    34682    tmp_simulation_heat_energy_1    TABLE        CREATE TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_1 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    annual_heat_energy double precision NOT NULL
);
 A   DROP TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 "   TABLE tmp_simulation_heat_energy_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    303            0           1259    34687    tmp_simulation_heat_energy_2    TABLE        CREATE TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_2 (
    project_name text NOT NULL,
    run_key text NOT NULL,
    annual_heat_energy double precision NOT NULL
);
 A   DROP TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0 "   TABLE tmp_simulation_heat_energy_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_heat_energy_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    304            -           1259    34672    tmp_simulation_input_1    TABLE     (  CREATE TABLE hub4lca_post_simulation.tmp_simulation_input_1 (
    building_archetype_id bigint,
    storeys_above_ground real,
    storey_height real,
    net_leased_area real,
    rotation bigint,
    weather_station text,
    statistic_selector text,
    project_name text,
    run_key text
);
 ;   DROP TABLE hub4lca_post_simulation.tmp_simulation_input_1;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0    TABLE tmp_simulation_input_1    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_input_1 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_input_1 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    301            .           1259    34677    tmp_simulation_input_2    TABLE     (  CREATE TABLE hub4lca_post_simulation.tmp_simulation_input_2 (
    building_archetype_id bigint,
    storeys_above_ground real,
    storey_height real,
    net_leased_area real,
    rotation bigint,
    weather_station text,
    statistic_selector text,
    project_name text,
    run_key text
);
 ;   DROP TABLE hub4lca_post_simulation.tmp_simulation_input_2;
       hub4lca_post_simulation         heap r       max_schildt    false    6                       0    0    TABLE tmp_simulation_input_2    ACL        REVOKE ALL ON TABLE hub4lca_post_simulation.tmp_simulation_input_2 FROM max_schildt;
GRANT SELECT,REFERENCES,TRIGGER,MAINTAIN ON TABLE hub4lca_post_simulation.tmp_simulation_input_2 TO max_schildt;
          hub4lca_post_simulation               max_schildt    false    302            '           1259    34023    units_unit_id_seq    SEQUENCE        ALTER TABLE hub4lca_post_simulation.units ALTER COLUMN unit_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME hub4lca_post_simulation.units_unit_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);
            hub4lca_post_simulation               postgres    false    6    264            (           1259    34029    view_energy_systems_converters    VIEW       CREATE VIEW hub4lca_post_simulation.view_energy_systems_converters AS
 SELECT esc.energy_system_id,
    esc.energy_converter_id,
    es.energy_system_name,
    ec.energy_converter_name
   FROM ((hub4lca_post_simulation.energy_systems_energy_converters esc
     JOIN hub4lca_post_simulation.energy_systems es ON ((es.energy_system_id = esc.energy_system_id)))
     JOIN hub4lca_post_simulation.energy_converters ec ON ((ec.energy_converter_id = esc.energy_converter_id)));
 B   DROP VIEW hub4lca_post_simulation.view_energy_systems_converters;
       hub4lca_post_simulation       v       max_schildt    false    254    260    260    259    259    254    6            )           1259    34033    view_reference_flows_with_unit    VIEW       CREATE VIEW hub4lca_post_simulation.view_reference_flows_with_unit AS
 SELECT rf.reference_flow_id,
    rf.reference_flow,
    u.unit_name
   FROM (hub4lca_post_simulation.reference_flows rf
     JOIN hub4lca_post_simulation.units u ON ((rf.reference_flow_unit_id = u.unit_id)));
 B   DROP VIEW hub4lca_post_simulation.view_reference_flows_with_unit;
       hub4lca_post_simulation       v       max_schildt    false    264    263    263    263    264    6            k           1259    38048    vw_ml_input    VIEW     fW  CREATE VIEW hub4lca_post_simulation.vw_ml_input AS
 WITH zone_shares AS (
         SELECT bt.building_type_name,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 1) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_single_office,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 2) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_group_office_between_2_and_6_employees,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 3) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_open_plan_office_7_or_more_employees,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 4) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_meeting_conference_seminar,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 5) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_main_hall_reception,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 6) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_retail_department_store,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 7) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_retail_with_cooling,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 8) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_class_room_school_group_kindergarden,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 9) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_lecture_hall_auditorium,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 10) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_bed_room,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 11) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_hotel_room,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 12) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_canteen,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 13) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_restaurant,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 14) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_kitchen_in_non_residential_buildings,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 15) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_kitchen_preparations_storage,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 16) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_wc_and_sanitary_rooms_in_non_residential_buildings,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 17) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_further_common_rooms,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 18) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_auxiliary_areas_without_common_rooms,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 19) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_traffic_area,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 20) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_stock_technical_equipment_archives,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 21) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_data_center,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 22) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_industrial_heavy,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 23) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_industrial_medium,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 24) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_industrial_light,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 25) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_spectator_area_theater_and_event_venues,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 26) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_foyer_theater_and_event_venues,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 27) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_stage_theater_and_event_venues,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 28) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_exhibition_congress,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 29) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_exhibition_room_and_museum_conservational_demands,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 30) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_library_reading_room,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 31) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_library_open_stacks,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 32) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_library_magazine_and_depot,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 33) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_gym_without_spectator_area,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 34) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_parking_garages_office_and_private_usage,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 35) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_parking_garages_public_usage,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 36) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_sauna_area,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 37) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_exercise_room,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 38) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_laboratory,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 39) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_examination_or_treatment_room,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 40) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_special_care_area,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 41) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_corridors_in_the_general_care_area,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 42) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_medical_and_therapeutic_practices,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 43) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_storehouse_logistics_building,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 44) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_living,
            max(
                CASE
                    WHEN (tz.thermal_zone_type_id = 45) THEN btt.share_of_building
                    ELSE NULL::real
                END) AS share_zone_classroom
           FROM ((hub4lca_post_simulation.building_types_thermal_zone_types btt
             JOIN hub4lca_post_simulation.building_types bt ON ((bt.building_type_id = btt.building_type_id)))
             JOIN hub4lca_post_simulation.thermal_zone_types tz ON ((tz.thermal_zone_type_id = btt.thermal_zone_type_id)))
          GROUP BY bt.building_type_name
        )
 SELECT si.simulation_tag,
    si.simulation_run,
    si.building_archetype_id,
    si.storeys_above_ground,
    si.storey_height,
    si.net_leased_area,
    si.rotation,
    si.weather_station,
    si.statistic_selector,
    (((((((((((((
        CASE
            WHEN (b.a1_a3 IS NOT NULL) THEN b.a1_a3
            ELSE ((COALESCE(b.a1, (0)::double precision) + COALESCE(b.a2, (0)::double precision)) + COALESCE(b.a3, (0)::double precision))
        END + COALESCE(b.a4, (0)::double precision)) + COALESCE(b.a5, (0)::double precision)) + COALESCE(b.b1, (0)::double precision)) + COALESCE(b.b2, (0)::double precision)) + COALESCE(b.b3, (0)::double precision)) + COALESCE(b.b4, (0)::double precision)) + COALESCE(b.b5, (0)::double precision)) + COALESCE(b.b6, (0)::double precision)) + COALESCE(b.b7, (0)::double precision)) + COALESCE(b.c1, (0)::double precision)) + COALESCE(b.c2, (0)::double precision)) + COALESCE(b.c3, (0)::double precision)) + COALESCE(b.c4, (0)::double precision)) AS gwp_bldg_abc,
    COALESCE(b.d, (0)::double precision) AS gwp_bldg_d,
    COALESCE(b.b6, (0)::double precision) AS gwp_bldg_b6,
    (((((((((((((
        CASE
            WHEN (ew.a1_a3 IS NOT NULL) THEN ew.a1_a3
            ELSE ((COALESCE(ew.a1, (0)::double precision) + COALESCE(ew.a2, (0)::double precision)) + COALESCE(ew.a3, (0)::double precision))
        END + COALESCE(ew.a4, (0)::double precision)) + COALESCE(ew.a5, (0)::double precision)) + COALESCE(ew.b1, (0)::double precision)) + COALESCE(ew.b2, (0)::double precision)) + COALESCE(ew.b3, (0)::double precision)) + COALESCE(ew.b4, (0)::double precision)) + COALESCE(ew.b5, (0)::double precision)) + COALESCE(ew.b6, (0)::double precision)) + COALESCE(ew.b7, (0)::double precision)) + COALESCE(ew.c1, (0)::double precision)) + COALESCE(ew.c2, (0)::double precision)) + COALESCE(ew.c3, (0)::double precision)) + COALESCE(ew.c4, (0)::double precision)) AS gwp_extwall_abc,
    COALESCE(ew.d, (0)::double precision) AS gwp_extwall_d,
    (((((((((((((
        CASE
            WHEN (fnd.a1_a3 IS NOT NULL) THEN fnd.a1_a3
            ELSE ((COALESCE(fnd.a1, (0)::double precision) + COALESCE(fnd.a2, (0)::double precision)) + COALESCE(fnd.a3, (0)::double precision))
        END + COALESCE(fnd.a4, (0)::double precision)) + COALESCE(fnd.a5, (0)::double precision)) + COALESCE(fnd.b1, (0)::double precision)) + COALESCE(fnd.b2, (0)::double precision)) + COALESCE(fnd.b3, (0)::double precision)) + COALESCE(fnd.b4, (0)::double precision)) + COALESCE(fnd.b5, (0)::double precision)) + COALESCE(fnd.b6, (0)::double precision)) + COALESCE(fnd.b7, (0)::double precision)) + COALESCE(fnd.c1, (0)::double precision)) + COALESCE(fnd.c2, (0)::double precision)) + COALESCE(fnd.c3, (0)::double precision)) + COALESCE(fnd.c4, (0)::double precision)) AS gwp_foundation_abc,
    COALESCE(fnd.d, (0)::double precision) AS gwp_foundation_d,
    (((((((((((((
        CASE
            WHEN (rf.a1_a3 IS NOT NULL) THEN rf.a1_a3
            ELSE ((COALESCE(rf.a1, (0)::double precision) + COALESCE(rf.a2, (0)::double precision)) + COALESCE(rf.a3, (0)::double precision))
        END + COALESCE(rf.a4, (0)::double precision)) + COALESCE(rf.a5, (0)::double precision)) + COALESCE(rf.b1, (0)::double precision)) + COALESCE(rf.b2, (0)::double precision)) + COALESCE(rf.b3, (0)::double precision)) + COALESCE(rf.b4, (0)::double precision)) + COALESCE(rf.b5, (0)::double precision)) + COALESCE(rf.b6, (0)::double precision)) + COALESCE(rf.b7, (0)::double precision)) + COALESCE(rf.c1, (0)::double precision)) + COALESCE(rf.c2, (0)::double precision)) + COALESCE(rf.c3, (0)::double precision)) + COALESCE(rf.c4, (0)::double precision)) AS gwp_roof_abc,
    COALESCE(rf.d, (0)::double precision) AS gwp_roof_d,
    (((((((((((((
        CASE
            WHEN (win.a1_a3 IS NOT NULL) THEN win.a1_a3
            ELSE ((COALESCE(win.a1, (0)::double precision) + COALESCE(win.a2, (0)::double precision)) + COALESCE(win.a3, (0)::double precision))
        END + COALESCE(win.a4, (0)::double precision)) + COALESCE(win.a5, (0)::double precision)) + COALESCE(win.b1, (0)::double precision)) + COALESCE(win.b2, (0)::double precision)) + COALESCE(win.b3, (0)::double precision)) + COALESCE(win.b4, (0)::double precision)) + COALESCE(win.b5, (0)::double precision)) + COALESCE(win.b6, (0)::double precision)) + COALESCE(win.b7, (0)::double precision)) + COALESCE(win.c1, (0)::double precision)) + COALESCE(win.c2, (0)::double precision)) + COALESCE(win.c3, (0)::double precision)) + COALESCE(win.c4, (0)::double precision)) AS gwp_windows_abc,
    COALESCE(win.d, (0)::double precision) AS gwp_windows_d,
    COALESCE(h.annual_heat_energy, (0)::double precision) AS useful_heat_energy_demand_annual,
    ps.building_archetype_name,
    ps.share_of_building_type,
    ps.share_of_building_type_in_region,
    ps.share_of_building_type_in_region_mun,
    ps.energy_system_id,
    ps.building_type_name,
    ps.region_name,
    ps.municipality_size_name,
    ps.municipality_growth_name,
    ps.age_class_name,
    ps.building_adjacency_name,
    ps.facade_to_net_leased_area_ratio_mean,
    ps.roof_to_net_leased_area_ratio_mean,
    ps.foundation_to_net_leased_area_ratio_mean,
    ps.window_to_net_leased_area_ratio_mean,
    ps.exterior_wall_construction_type,
    ps.exterior_wall_u_value,
    ps.roof_construction_type,
    ps.roof_pitch_type,
    ps.roof_u_value,
    ps.foundation_u_value,
    ps.glazing,
    ps.g_value,
    ps.window_frame_type_name,
    ps.energy_system_name,
    ps.converter_0_energy_source_name,
        CASE
            WHEN ((ps.exterior_wall_construction_type)::text = ANY ((ARRAY['wooden'::character varying, 'lightweight-wooden'::character varying, 'lightweight-timbered'::character varying])::text[])) THEN 'wooden'::text
            ELSE 'mineral'::text
        END AS exterior_wall_construction_type_agg,
    (((((COALESCE(((ps.exterior_wall_layer0_density * ps.exterior_wall_layer0_thermal_capacity) * ps.exterior_wall_layer0_thickness), (0)::real) + COALESCE(((ps.exterior_wall_layer1_density * ps.exterior_wall_layer1_thermal_capacity) * ps.exterior_wall_layer1_thickness), (0)::real)) + COALESCE(((ps.exterior_wall_layer2_density * ps.exterior_wall_layer2_thermal_capacity) * ps.exterior_wall_layer2_thickness), (0)::real)) + COALESCE(((ps.exterior_wall_layer3_density * ps.exterior_wall_layer3_thermal_capacity) * ps.exterior_wall_layer3_thickness), (0)::real)) + COALESCE(((ps.exterior_wall_layer4_density * ps.exterior_wall_layer4_thermal_capacity) * ps.exterior_wall_layer4_thickness), (0)::real)) + COALESCE(((ps.exterior_wall_layer5_density * ps.exterior_wall_layer5_thermal_capacity) * ps.exterior_wall_layer5_thickness), (0)::real)) AS exterior_wall_capacity_per_m2,
    ((COALESCE(((ps.interior_wall_layer0_density * ps.interior_wall_layer0_thermal_capacity) * ps.interior_wall_layer0_thickness), (0)::real) + COALESCE(((ps.interior_wall_layer1_density * ps.interior_wall_layer1_thermal_capacity) * ps.interior_wall_layer1_thickness), (0)::real)) + COALESCE(((ps.interior_wall_layer2_density * ps.interior_wall_layer2_thermal_capacity) * ps.interior_wall_layer2_thickness), (0)::real)) AS interior_wall_capacity_per_m2,
    (((((COALESCE(((ps.roof_layer0_density * ps.roof_layer0_thermal_capacity) * ps.roof_layer0_thickness), (0)::real) + COALESCE(((ps.roof_layer1_density * ps.roof_layer1_thermal_capacity) * ps.roof_layer1_thickness), (0)::real)) + COALESCE(((ps.roof_layer2_density * ps.roof_layer2_thermal_capacity) * ps.roof_layer2_thickness), (0)::real)) + COALESCE(((ps.roof_layer3_density * ps.roof_layer3_thermal_capacity) * ps.roof_layer3_thickness), (0)::real)) + COALESCE(((ps.roof_layer4_density * ps.roof_layer4_thermal_capacity) * ps.roof_layer4_thickness), (0)::real)) + COALESCE(((ps.roof_layer5_density * ps.roof_layer5_thermal_capacity) * ps.roof_layer5_thickness), (0)::real)) AS roof_capacity_per_m2,
    (((((COALESCE(((ps.foundation_layer0_density * ps.foundation_layer0_thermal_capacity) * ps.foundation_layer0_thickness), (0)::real) + COALESCE(((ps.foundation_layer1_density * ps.foundation_layer1_thermal_capacity) * ps.foundation_layer1_thickness), (0)::real)) + COALESCE(((ps.foundation_layer2_density * ps.foundation_layer2_thermal_capacity) * ps.foundation_layer2_thickness), (0)::real)) + COALESCE(((ps.foundation_layer3_density * ps.foundation_layer3_thermal_capacity) * ps.foundation_layer3_thickness), (0)::real)) + COALESCE(((ps.foundation_layer4_density * ps.foundation_layer4_thermal_capacity) * ps.foundation_layer4_thickness), (0)::real)) + COALESCE(((ps.foundation_layer5_density * ps.foundation_layer5_thermal_capacity) * ps.foundation_layer5_thickness), (0)::real)) AS foundation_capacity_per_m2,
    ((COALESCE(((ps.floor_layer0_density * ps.floor_layer0_thermal_capacity) * ps.floor_layer0_thickness), (0)::real) + COALESCE(((ps.floor_layer1_density * ps.floor_layer1_thermal_capacity) * ps.floor_layer1_thickness), (0)::real)) + COALESCE(((ps.floor_layer2_density * ps.floor_layer2_thermal_capacity) * ps.floor_layer2_thickness), (0)::real)) AS floor_capacity_per_m2,
    zs.share_zone_single_office,
    zs.share_zone_group_office_between_2_and_6_employees,
    zs.share_zone_open_plan_office_7_or_more_employees,
    zs.share_zone_meeting_conference_seminar,
    zs.share_zone_main_hall_reception,
    zs.share_zone_retail_department_store,
    zs.share_zone_retail_with_cooling,
    zs.share_zone_class_room_school_group_kindergarden,
    zs.share_zone_lecture_hall_auditorium,
    zs.share_zone_bed_room,
    zs.share_zone_hotel_room,
    zs.share_zone_canteen,
    zs.share_zone_restaurant,
    zs.share_zone_kitchen_in_non_residential_buildings,
    zs.share_zone_kitchen_preparations_storage,
    zs.share_zone_wc_and_sanitary_rooms_in_non_residential_buildings,
    zs.share_zone_further_common_rooms,
    zs.share_zone_auxiliary_areas_without_common_rooms,
    zs.share_zone_traffic_area,
    zs.share_zone_stock_technical_equipment_archives,
    zs.share_zone_data_center,
    zs.share_zone_industrial_heavy,
    zs.share_zone_industrial_medium,
    zs.share_zone_industrial_light,
    zs.share_zone_spectator_area_theater_and_event_venues,
    zs.share_zone_foyer_theater_and_event_venues,
    zs.share_zone_stage_theater_and_event_venues,
    zs.share_zone_exhibition_congress,
    zs.share_zone_exhibition_room_and_museum_conservational_demands,
    zs.share_zone_library_reading_room,
    zs.share_zone_library_open_stacks,
    zs.share_zone_library_magazine_and_depot,
    zs.share_zone_gym_without_spectator_area,
    zs.share_zone_parking_garages_office_and_private_usage,
    zs.share_zone_parking_garages_public_usage,
    zs.share_zone_sauna_area,
    zs.share_zone_exercise_room,
    zs.share_zone_laboratory,
    zs.share_zone_examination_or_treatment_room,
    zs.share_zone_special_care_area,
    zs.share_zone_corridors_in_the_general_care_area,
    zs.share_zone_medical_and_therapeutic_practices,
    zs.share_zone_storehouse_logistics_building,
    zs.share_zone_living,
    zs.share_zone_classroom
   FROM ((((((((hub4lca_post_simulation.tmp_simulation_input_final_merge si
     JOIN hub4lca_post_simulation.tmp_simulation_gwp_buildings_final_merge b ON ((b.simulation_tag = si.simulation_tag)))
     JOIN hub4lca_post_simulation.tmp_simulation_gwp_exterior_walls_final_merge ew ON ((ew.simulation_tag = si.simulation_tag)))
     JOIN hub4lca_post_simulation.tmp_simulation_gwp_foundations_final_merge fnd ON ((fnd.simulation_tag = si.simulation_tag)))
     JOIN hub4lca_post_simulation.tmp_simulation_gwp_roofs_final_merge rf ON ((rf.simulation_tag = si.simulation_tag)))
     JOIN hub4lca_post_simulation.tmp_simulation_gwp_windows_final_merge win ON ((win.simulation_tag = si.simulation_tag)))
     JOIN hub4lca_post_simulation.tmp_simulation_heat_energy_final_merge h ON (((h.simulation_tag = si.simulation_tag) AND (h.simulation_run = si.simulation_run))))
     JOIN hub4lca_post_simulation.vw_pre_simulation ps ON ((ps.building_archetype_id = si.building_archetype_id)))
     LEFT JOIN zone_shares zs ON (((zs.building_type_name)::text = (ps.building_type_name)::text)));
 /   DROP VIEW hub4lca_post_simulation.vw_ml_input;
       hub4lca_post_simulation       v       max_schildt    false    358    358    358    360    360    360    360    360    360    360    360    360    362    362    362    361    361    361    361    354    354    354    355    355    355    355    355    355    355    355    355    355    355    355    355    355    355    355    355    355    355    356    356    356    356    356    356    356    356    356    356    356    356    356    356    356    356    356    356    356    358    358    358    358    358    358    358    358    358    358    358    358    358    358    358    358    361    361    361    361    361    361    361    361    361    361    361    361    361    361    361    360    360    360    360    360    360    360    360    360    360    239    239    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    348    349    349    349    354    354    354    354    354    354    6            W           1259    37613    vw_post_simulation_base    VIEW     x CREATE VIEW hub4lca_post_simulation.vw_post_simulation_base AS
 WITH step_001_building_metric_stats_agg AS (
         SELECT amb.building_archetype_id,
            amb.metric_id,
            amb.life_cycle_module_id,
            avg(amb.mean_value) AS mean_value,
            avg(amb.median_value) AS median_value,
            avg(amb.std_dev) AS std_dev,
            avg(amb.min_value) AS min_value,
            avg(amb.max_value) AS max_value,
            avg(amb.p05_value) AS p05_value,
            avg(amb.p25_value) AS p25_value,
            avg(amb.p75_value) AS p75_value,
            avg(amb.p95_value) AS p95_value,
            avg(amb.se_mean) AS se_mean,
            avg(amb.cv) AS cv
           FROM ((hub4lca_post_simulation.archetype_metric_stats_building amb
             JOIN hub4lca_post_simulation.building_archetypes bat_post ON ((bat_post.building_archetype_id = amb.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt_post ON ((bt_post.building_type_id = bat_post.building_type_id)))
          WHERE ((((((((((((((((((((((((((((((((((((((amb.metric_id = 1) AND (amb.life_cycle_module_id = 19)) OR ((amb.metric_id = 2) AND (amb.life_cycle_module_id = 19))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 4))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 5))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 6))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 7))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 8))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 9))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 10))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 11))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 12))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 18))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 13))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 14))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 15))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 16))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 17))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 20))) OR ((amb.metric_id = 5) AND (amb.life_cycle_module_id = 21))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 4))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 5))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 6))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 7))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 8))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 9))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 10))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 11))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 12))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 18))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 13))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 14))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 15))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 16))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 17))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 20))) OR ((amb.metric_id = 6) AND (amb.life_cycle_module_id = 21))) AND ((bt_post.building_type_name)::text = ANY ((ARRAY['sfh'::character varying, 'mfh'::character varying, 'ab'::character varying])::text[])))
          GROUP BY amb.building_archetype_id, amb.metric_id, amb.life_cycle_module_id
        ), step_002_building_metric_stats_pivot AS (
         SELECT step_001_building_metric_stats_agg.building_archetype_id AS bmp_building_archetype_id,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS heat_useful_total_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS heat_useful_total_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS heat_useful_total_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 1) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS heat_useful_total_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 2) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 19)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS heat_useful_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_a4_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_a4_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_a4_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_a4_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_a4_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_a4_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_a4_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_a4_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_a4_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_a4_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_a4_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_a5_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_a5_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_a5_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_a5_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_a5_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_a5_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_a5_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_a5_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_a5_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_a5_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_a5_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b1_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b1_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b1_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b1_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b1_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b1_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b1_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b1_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b1_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b1_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b1_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b3_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b3_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b3_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b3_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b3_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b3_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b3_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b3_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b3_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b3_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b3_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b4_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b4_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b4_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b4_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b4_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b4_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b4_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b4_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b4_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b4_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b4_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b5_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b5_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b5_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b5_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b5_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b5_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b5_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b5_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b5_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b5_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b5_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b6_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b6_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b6_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b6_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b6_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b6_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b6_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b6_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b6_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b6_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b6_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b7_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b7_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b7_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b7_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b7_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b7_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b7_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b7_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b7_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b7_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b7_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c1_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c1_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c1_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c1_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c1_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c1_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c1_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c1_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c1_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c1_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c1_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c3_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c3_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c3_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c3_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c3_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c3_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c3_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c3_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c3_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c3_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c3_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c4_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c4_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c4_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c4_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c4_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c4_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c4_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c4_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c4_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c4_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c4_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_d_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_d_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_d_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_d_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_d_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_d_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_d_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_d_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_d_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_d_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_d_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 5) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 4)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_a1_a3_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 5)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_a4_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 6)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_a5_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 7)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b1_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 8)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b2_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 9)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b3_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 10)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b4_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 11)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b5_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 12)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b6_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 18)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_b7_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 13)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c1_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 14)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c2_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 15)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c3_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 16)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_c4_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 17)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_d_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 20)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_per_m2_cv,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_mean_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_median_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_std_dev,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_min_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_max_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_p05_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_p25_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_p75_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_p95_value,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_se_mean,
            max(
                CASE
                    WHEN ((step_001_building_metric_stats_agg.metric_id = 6) AND (step_001_building_metric_stats_agg.life_cycle_module_id = 21)) THEN step_001_building_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_per_m2_cv
           FROM step_001_building_metric_stats_agg
          GROUP BY step_001_building_metric_stats_agg.building_archetype_id
        ), step_003_element_metric_stats_agg AS (
         SELECT ame.building_archetype_id,
            ame.building_element_type_id,
            ame.life_cycle_module_id,
            avg(ame.mean_value) AS mean_value,
            avg(ame.median_value) AS median_value,
            avg(ame.std_dev) AS std_dev,
            avg(ame.min_value) AS min_value,
            avg(ame.max_value) AS max_value,
            avg(ame.p05_value) AS p05_value,
            avg(ame.p25_value) AS p25_value,
            avg(ame.p75_value) AS p75_value,
            avg(ame.p95_value) AS p95_value,
            avg(ame.se_mean) AS se_mean,
            avg(ame.cv) AS cv
           FROM ((hub4lca_post_simulation.archetype_metric_stats_element ame
             JOIN hub4lca_post_simulation.building_archetypes bat_post ON ((bat_post.building_archetype_id = ame.building_archetype_id)))
             JOIN hub4lca_post_simulation.building_types bt_post ON ((bt_post.building_type_id = bat_post.building_type_id)))
          WHERE ((ame.metric_id = 7) AND (((((((((((((ame.building_element_type_id = 1) AND (ame.life_cycle_module_id = 20)) OR ((ame.building_element_type_id = 2) AND (ame.life_cycle_module_id = 20))) OR ((ame.building_element_type_id = 3) AND (ame.life_cycle_module_id = 20))) OR ((ame.building_element_type_id = 4) AND (ame.life_cycle_module_id = 20))) OR ((ame.building_element_type_id = 5) AND (ame.life_cycle_module_id = 20))) OR ((ame.building_element_type_id = 6) AND (ame.life_cycle_module_id = 20))) OR ((ame.building_element_type_id = 1) AND (ame.life_cycle_module_id = 21))) OR ((ame.building_element_type_id = 2) AND (ame.life_cycle_module_id = 21))) OR ((ame.building_element_type_id = 3) AND (ame.life_cycle_module_id = 21))) OR ((ame.building_element_type_id = 4) AND (ame.life_cycle_module_id = 21))) OR ((ame.building_element_type_id = 5) AND (ame.life_cycle_module_id = 21))) OR ((ame.building_element_type_id = 6) AND (ame.life_cycle_module_id = 21))) AND ((bt_post.building_type_name)::text = ANY ((ARRAY['sfh'::character varying, 'mfh'::character varying, 'ab'::character varying])::text[])))
          GROUP BY ame.building_archetype_id, ame.building_element_type_id, ame.life_cycle_module_id
        ), step_004_element_metric_stats_pivot AS (
         SELECT step_003_element_metric_stats_agg.building_archetype_id AS emp_building_archetype_id,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_exterior_wall_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_roof_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_foundation_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_floor_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_window_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 20)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_interior_wall_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 1) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_exterior_wall_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 2) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_roof_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 3) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_foundation_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 4) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_floor_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 5) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_window_cv,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.mean_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_mean_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.median_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_median_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.std_dev
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_std_dev,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.min_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_min_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.max_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_max_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p05_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_p05_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p25_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_p25_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p75_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_p75_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.p95_value
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_p95_value,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.se_mean
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_se_mean,
            max(
                CASE
                    WHEN ((step_003_element_metric_stats_agg.building_element_type_id = 6) AND (step_003_element_metric_stats_agg.life_cycle_module_id = 21)) THEN step_003_element_metric_stats_agg.cv
                    ELSE NULL::double precision
                END) AS gwp_lifecycle_no_d_interior_wall_cv
           FROM step_003_element_metric_stats_agg
          GROUP BY step_003_element_metric_stats_agg.building_archetype_id
        )
 SELECT pre.building_archetype_id,
    pre.building_archetype_name,
    pre.share_of_building_type,
    pre.share_of_building_type_in_region,
    pre.share_of_building_type_in_region_mun,
    pre.exterior_wall_building_element_id,
    pre.interior_wall_building_element_id,
    pre.roof_building_element_id,
    pre.foundation_building_element_id,
    pre.floor_building_element_id,
    pre.window_building_element_id,
    pre.energy_system_id,
    pre.building_type_name,
    pre.region_name,
    pre.municipality_size_name,
    pre.municipality_growth_name,
    pre.age_class_name,
    pre.building_adjacency_name,
    pre.facade_to_net_leased_area_ratio_mean,
    pre.facade_to_net_leased_area_ratio_se_min,
    pre.facade_to_net_leased_area_ratio_se_max,
    pre.roof_to_net_leased_area_ratio_mean,
    pre.roof_to_net_leased_area_ratio_se_min,
    pre.roof_to_net_leased_area_ratio_se_max,
    pre.foundation_to_net_leased_area_ratio_mean,
    pre.foundation_to_net_leased_area_ratio_se_min,
    pre.foundation_to_net_leased_area_ratio_se_max,
    pre.window_to_net_leased_area_ratio_mean,
    pre.window_to_net_leased_area_ratio_se_min,
    pre.window_to_net_leased_area_ratio_se_max,
    pre.building_height_mean,
    pre.building_height_se,
    pre.height_unit,
    pre.aspect_ratio_mean,
    pre.aspect_ratio_se_min,
    pre.aspect_ratio_se_max,
    pre.storeys_below_ground_mean,
    pre.storeys_below_ground_se,
    pre.storeys_above_ground_mean,
    pre.storeys_above_ground_se,
    pre.storeys_above_ground_se_min,
    pre.storeys_above_ground_se_max,
    pre.storey_height_mean,
    pre.storey_height_se_min,
    pre.storey_height_se_max,
    pre.window_share,
    pre.net_leased_area_mean,
    pre.net_leased_area_se,
    pre.net_leased_area_se_min,
    pre.net_leased_area_se_max,
    pre.net_leased_area_unit,
    pre.facade_area_north_mean,
    pre.facade_area_north_se,
    pre.facade_area_east_mean,
    pre.facade_area_east_se,
    pre.facade_area_south_mean,
    pre.facade_area_south_se,
    pre.facade_area_west_mean,
    pre.facade_area_west_se,
    pre.facade_area_unit,
    pre.facade_length_north_mean,
    pre.facade_length_north_se,
    pre.facade_length_east_mean,
    pre.facade_length_east_se,
    pre.facade_length_south_mean,
    pre.facade_length_south_se,
    pre.facade_length_west_mean,
    pre.facade_length_west_se,
    pre.facade_length_unit,
    pre.exterior_wall_name,
    pre.exterior_wall_construction_type,
    pre.exterior_wall_u_value_typical_min,
    pre.exterior_wall_u_value_typical_max,
    pre.exterior_wall_u_value,
    pre.exterior_wall_u_value_unit,
    pre.exterior_wall_inner_radiation,
    pre.exterior_wall_inner_radiation_unit,
    pre.exterior_wall_outer_radiation,
    pre.exterior_wall_outer_radiation_unit,
    pre.exterior_wall_inner_convection,
    pre.exterior_wall_inner_convection_unit,
    pre.exterior_wall_outer_convection,
    pre.exterior_wall_outer_convection_unit,
    pre.exterior_wall_layer0_position,
    pre.exterior_wall_layer0_material_id,
    pre.exterior_wall_layer0_material_name,
    pre.exterior_wall_layer0_thickness,
    pre.exterior_wall_layer0_thickness_unit,
    pre.exterior_wall_layer0_solar_absorption_rate,
    pre.exterior_wall_layer0_thermal_capacity,
    pre.exterior_wall_layer0_thermal_capacity_unit,
    pre.exterior_wall_layer0_thermal_conductivity,
    pre.exterior_wall_layer0_thermal_conductivity_unit,
    pre.exterior_wall_layer0_service_life,
    pre.exterior_wall_layer0_service_life_unit,
    pre.exterior_wall_layer0_density,
    pre.exterior_wall_layer0_density_unit,
    pre.exterior_wall_layer1_position,
    pre.exterior_wall_layer1_material_id,
    pre.exterior_wall_layer1_material_name,
    pre.exterior_wall_layer1_thickness,
    pre.exterior_wall_layer1_thickness_unit,
    pre.exterior_wall_layer1_solar_absorption_rate,
    pre.exterior_wall_layer1_thermal_capacity,
    pre.exterior_wall_layer1_thermal_capacity_unit,
    pre.exterior_wall_layer1_thermal_conductivity,
    pre.exterior_wall_layer1_thermal_conductivity_unit,
    pre.exterior_wall_layer1_service_life,
    pre.exterior_wall_layer1_service_life_unit,
    pre.exterior_wall_layer1_density,
    pre.exterior_wall_layer1_density_unit,
    pre.exterior_wall_layer2_position,
    pre.exterior_wall_layer2_material_id,
    pre.exterior_wall_layer2_material_name,
    pre.exterior_wall_layer2_thickness,
    pre.exterior_wall_layer2_thickness_unit,
    pre.exterior_wall_layer2_solar_absorption_rate,
    pre.exterior_wall_layer2_thermal_capacity,
    pre.exterior_wall_layer2_thermal_capacity_unit,
    pre.exterior_wall_layer2_thermal_conductivity,
    pre.exterior_wall_layer2_thermal_conductivity_unit,
    pre.exterior_wall_layer2_service_life,
    pre.exterior_wall_layer2_service_life_unit,
    pre.exterior_wall_layer2_density,
    pre.exterior_wall_layer2_density_unit,
    pre.exterior_wall_layer3_position,
    pre.exterior_wall_layer3_material_id,
    pre.exterior_wall_layer3_material_name,
    pre.exterior_wall_layer3_thickness,
    pre.exterior_wall_layer3_thickness_unit,
    pre.exterior_wall_layer3_solar_absorption_rate,
    pre.exterior_wall_layer3_thermal_capacity,
    pre.exterior_wall_layer3_thermal_capacity_unit,
    pre.exterior_wall_layer3_thermal_conductivity,
    pre.exterior_wall_layer3_thermal_conductivity_unit,
    pre.exterior_wall_layer3_service_life,
    pre.exterior_wall_layer3_service_life_unit,
    pre.exterior_wall_layer3_density,
    pre.exterior_wall_layer3_density_unit,
    pre.exterior_wall_layer4_position,
    pre.exterior_wall_layer4_material_id,
    pre.exterior_wall_layer4_material_name,
    pre.exterior_wall_layer4_thickness,
    pre.exterior_wall_layer4_thickness_unit,
    pre.exterior_wall_layer4_solar_absorption_rate,
    pre.exterior_wall_layer4_thermal_capacity,
    pre.exterior_wall_layer4_thermal_capacity_unit,
    pre.exterior_wall_layer4_thermal_conductivity,
    pre.exterior_wall_layer4_thermal_conductivity_unit,
    pre.exterior_wall_layer4_service_life,
    pre.exterior_wall_layer4_service_life_unit,
    pre.exterior_wall_layer4_density,
    pre.exterior_wall_layer4_density_unit,
    pre.exterior_wall_layer5_position,
    pre.exterior_wall_layer5_material_id,
    pre.exterior_wall_layer5_material_name,
    pre.exterior_wall_layer5_thickness,
    pre.exterior_wall_layer5_thickness_unit,
    pre.exterior_wall_layer5_solar_absorption_rate,
    pre.exterior_wall_layer5_thermal_capacity,
    pre.exterior_wall_layer5_thermal_capacity_unit,
    pre.exterior_wall_layer5_thermal_conductivity,
    pre.exterior_wall_layer5_thermal_conductivity_unit,
    pre.exterior_wall_layer5_service_life,
    pre.exterior_wall_layer5_service_life_unit,
    pre.exterior_wall_layer5_density,
    pre.exterior_wall_layer5_density_unit,
    pre.exterior_wall_layer0_epd1_oekobaudat_name,
    pre.exterior_wall_layer0_epd1_oekobaudat_uuid,
    pre.exterior_wall_layer0_epd2_oekobaudat_name,
    pre.exterior_wall_layer0_epd2_oekobaudat_uuid,
    pre.exterior_wall_layer1_epd1_oekobaudat_name,
    pre.exterior_wall_layer1_epd1_oekobaudat_uuid,
    pre.exterior_wall_layer1_epd2_oekobaudat_name,
    pre.exterior_wall_layer1_epd2_oekobaudat_uuid,
    pre.exterior_wall_layer2_epd1_oekobaudat_name,
    pre.exterior_wall_layer2_epd1_oekobaudat_uuid,
    pre.exterior_wall_layer2_epd2_oekobaudat_name,
    pre.exterior_wall_layer2_epd2_oekobaudat_uuid,
    pre.exterior_wall_layer3_epd1_oekobaudat_name,
    pre.exterior_wall_layer3_epd1_oekobaudat_uuid,
    pre.exterior_wall_layer3_epd2_oekobaudat_name,
    pre.exterior_wall_layer3_epd2_oekobaudat_uuid,
    pre.exterior_wall_layer4_epd1_oekobaudat_name,
    pre.exterior_wall_layer4_epd1_oekobaudat_uuid,
    pre.exterior_wall_layer4_epd2_oekobaudat_name,
    pre.exterior_wall_layer4_epd2_oekobaudat_uuid,
    pre.exterior_wall_layer5_epd1_oekobaudat_name,
    pre.exterior_wall_layer5_epd1_oekobaudat_uuid,
    pre.exterior_wall_layer5_epd2_oekobaudat_name,
    pre.exterior_wall_layer5_epd2_oekobaudat_uuid,
    pre.interior_wall_name,
    pre.interior_wall_u_value_typical_min,
    pre.interior_wall_u_value_typical_max,
    pre.interior_wall_u_value,
    pre.interior_wall_u_value_unit,
    pre.interior_wall_inner_radiation,
    pre.interior_wall_inner_radiation_unit,
    pre.interior_wall_inner_convection,
    pre.interior_wall_inner_convection_unit,
    pre.interior_wall_layer0_position,
    pre.interior_wall_layer0_material_id,
    pre.interior_wall_layer0_material_name,
    pre.interior_wall_layer0_thickness,
    pre.interior_wall_layer0_thickness_unit,
    pre.interior_wall_layer0_solar_absorption_rate,
    pre.interior_wall_layer0_thermal_capacity,
    pre.interior_wall_layer0_thermal_capacity_unit,
    pre.interior_wall_layer0_thermal_conductivity,
    pre.interior_wall_layer0_thermal_conductivity_unit,
    pre.interior_wall_layer0_service_life,
    pre.interior_wall_layer0_service_life_unit,
    pre.interior_wall_layer0_density,
    pre.interior_wall_layer0_density_unit,
    pre.interior_wall_layer1_position,
    pre.interior_wall_layer1_material_id,
    pre.interior_wall_layer1_material_name,
    pre.interior_wall_layer1_thickness,
    pre.interior_wall_layer1_thickness_unit,
    pre.interior_wall_layer1_solar_absorption_rate,
    pre.interior_wall_layer1_thermal_capacity,
    pre.interior_wall_layer1_thermal_capacity_unit,
    pre.interior_wall_layer1_thermal_conductivity,
    pre.interior_wall_layer1_thermal_conductivity_unit,
    pre.interior_wall_layer1_service_life,
    pre.interior_wall_layer1_service_life_unit,
    pre.interior_wall_layer1_density,
    pre.interior_wall_layer1_density_unit,
    pre.interior_wall_layer2_position,
    pre.interior_wall_layer2_material_id,
    pre.interior_wall_layer2_material_name,
    pre.interior_wall_layer2_thickness,
    pre.interior_wall_layer2_thickness_unit,
    pre.interior_wall_layer2_solar_absorption_rate,
    pre.interior_wall_layer2_thermal_capacity,
    pre.interior_wall_layer2_thermal_capacity_unit,
    pre.interior_wall_layer2_thermal_conductivity,
    pre.interior_wall_layer2_thermal_conductivity_unit,
    pre.interior_wall_layer2_service_life,
    pre.interior_wall_layer2_service_life_unit,
    pre.interior_wall_layer2_density,
    pre.interior_wall_layer2_density_unit,
    pre.interior_wall_layer0_epd1_oekobaudat_name,
    pre.interior_wall_layer0_epd1_oekobaudat_uuid,
    pre.interior_wall_layer0_epd2_oekobaudat_name,
    pre.interior_wall_layer0_epd2_oekobaudat_uuid,
    pre.interior_wall_layer1_epd1_oekobaudat_name,
    pre.interior_wall_layer1_epd1_oekobaudat_uuid,
    pre.interior_wall_layer1_epd2_oekobaudat_name,
    pre.interior_wall_layer1_epd2_oekobaudat_uuid,
    pre.interior_wall_layer2_epd1_oekobaudat_name,
    pre.interior_wall_layer2_epd1_oekobaudat_uuid,
    pre.interior_wall_layer2_epd2_oekobaudat_name,
    pre.interior_wall_layer2_epd2_oekobaudat_uuid,
    pre.roof_name,
    pre.roof_construction_type,
    pre.roof_pitch_type,
    pre.roof_u_value_typical_min,
    pre.roof_u_value_typical_max,
    pre.roof_u_value,
    pre.roof_u_value_unit,
    pre.roof_inner_radiation,
    pre.roof_inner_radiation_unit,
    pre.roof_outer_radiation,
    pre.roof_outer_radiation_unit,
    pre.roof_inner_convection,
    pre.roof_inner_convection_unit,
    pre.roof_outer_convection,
    pre.roof_outer_convection_unit,
    pre.roof_layer0_position,
    pre.roof_layer0_material_id,
    pre.roof_layer0_material_name,
    pre.roof_layer0_thickness,
    pre.roof_layer0_thickness_unit,
    pre.roof_layer0_solar_absorption_rate,
    pre.roof_layer0_thermal_capacity,
    pre.roof_layer0_thermal_capacity_unit,
    pre.roof_layer0_thermal_conductivity,
    pre.roof_layer0_thermal_conductivity_unit,
    pre.roof_layer0_service_life,
    pre.roof_layer0_service_life_unit,
    pre.roof_layer0_density,
    pre.roof_layer0_density_unit,
    pre.roof_layer1_position,
    pre.roof_layer1_material_id,
    pre.roof_layer1_material_name,
    pre.roof_layer1_thickness,
    pre.roof_layer1_thickness_unit,
    pre.roof_layer1_solar_absorption_rate,
    pre.roof_layer1_thermal_capacity,
    pre.roof_layer1_thermal_capacity_unit,
    pre.roof_layer1_thermal_conductivity,
    pre.roof_layer1_thermal_conductivity_unit,
    pre.roof_layer1_service_life,
    pre.roof_layer1_service_life_unit,
    pre.roof_layer1_density,
    pre.roof_layer1_density_unit,
    pre.roof_layer2_position,
    pre.roof_layer2_material_id,
    pre.roof_layer2_material_name,
    pre.roof_layer2_thickness,
    pre.roof_layer2_thickness_unit,
    pre.roof_layer2_solar_absorption_rate,
    pre.roof_layer2_thermal_capacity,
    pre.roof_layer2_thermal_capacity_unit,
    pre.roof_layer2_thermal_conductivity,
    pre.roof_layer2_thermal_conductivity_unit,
    pre.roof_layer2_service_life,
    pre.roof_layer2_service_life_unit,
    pre.roof_layer2_density,
    pre.roof_layer2_density_unit,
    pre.roof_layer3_position,
    pre.roof_layer3_material_id,
    pre.roof_layer3_material_name,
    pre.roof_layer3_thickness,
    pre.roof_layer3_thickness_unit,
    pre.roof_layer3_solar_absorption_rate,
    pre.roof_layer3_thermal_capacity,
    pre.roof_layer3_thermal_capacity_unit,
    pre.roof_layer3_thermal_conductivity,
    pre.roof_layer3_thermal_conductivity_unit,
    pre.roof_layer3_service_life,
    pre.roof_layer3_service_life_unit,
    pre.roof_layer3_density,
    pre.roof_layer3_density_unit,
    pre.roof_layer4_position,
    pre.roof_layer4_material_id,
    pre.roof_layer4_material_name,
    pre.roof_layer4_thickness,
    pre.roof_layer4_thickness_unit,
    pre.roof_layer4_solar_absorption_rate,
    pre.roof_layer4_thermal_capacity,
    pre.roof_layer4_thermal_capacity_unit,
    pre.roof_layer4_thermal_conductivity,
    pre.roof_layer4_thermal_conductivity_unit,
    pre.roof_layer4_service_life,
    pre.roof_layer4_service_life_unit,
    pre.roof_layer4_density,
    pre.roof_layer4_density_unit,
    pre.roof_layer5_position,
    pre.roof_layer5_material_id,
    pre.roof_layer5_material_name,
    pre.roof_layer5_thickness,
    pre.roof_layer5_thickness_unit,
    pre.roof_layer5_solar_absorption_rate,
    pre.roof_layer5_thermal_capacity,
    pre.roof_layer5_thermal_capacity_unit,
    pre.roof_layer5_thermal_conductivity,
    pre.roof_layer5_thermal_conductivity_unit,
    pre.roof_layer5_service_life,
    pre.roof_layer5_service_life_unit,
    pre.roof_layer5_density,
    pre.roof_layer5_density_unit,
    pre.roof_layer0_epd1_oekobaudat_name,
    pre.roof_layer0_epd1_oekobaudat_uuid,
    pre.roof_layer0_epd2_oekobaudat_name,
    pre.roof_layer0_epd2_oekobaudat_uuid,
    pre.roof_layer1_epd1_oekobaudat_name,
    pre.roof_layer1_epd1_oekobaudat_uuid,
    pre.roof_layer1_epd2_oekobaudat_name,
    pre.roof_layer1_epd2_oekobaudat_uuid,
    pre.roof_layer2_epd1_oekobaudat_name,
    pre.roof_layer2_epd1_oekobaudat_uuid,
    pre.roof_layer2_epd2_oekobaudat_name,
    pre.roof_layer2_epd2_oekobaudat_uuid,
    pre.roof_layer3_epd1_oekobaudat_name,
    pre.roof_layer3_epd1_oekobaudat_uuid,
    pre.roof_layer3_epd2_oekobaudat_name,
    pre.roof_layer3_epd2_oekobaudat_uuid,
    pre.roof_layer4_epd1_oekobaudat_name,
    pre.roof_layer4_epd1_oekobaudat_uuid,
    pre.roof_layer4_epd2_oekobaudat_name,
    pre.roof_layer4_epd2_oekobaudat_uuid,
    pre.roof_layer5_epd1_oekobaudat_name,
    pre.roof_layer5_epd1_oekobaudat_uuid,
    pre.roof_layer5_epd2_oekobaudat_name,
    pre.roof_layer5_epd2_oekobaudat_uuid,
    pre.foundation_name,
    pre.foundation_construction_type,
    pre.foundation_u_value_typical_min,
    pre.foundation_u_value_typical_max,
    pre.foundation_u_value,
    pre.foundation_u_value_unit,
    pre.foundation_inner_radiation,
    pre.foundation_inner_radiation_unit,
    pre.foundation_inner_convection,
    pre.foundation_inner_convection_unit,
    pre.foundation_layer0_position,
    pre.foundation_layer0_material_id,
    pre.foundation_layer0_material_name,
    pre.foundation_layer0_thickness,
    pre.foundation_layer0_thickness_unit,
    pre.foundation_layer0_solar_absorption_rate,
    pre.foundation_layer0_thermal_capacity,
    pre.foundation_layer0_thermal_capacity_unit,
    pre.foundation_layer0_thermal_conductivity,
    pre.foundation_layer0_thermal_conductivity_unit,
    pre.foundation_layer0_service_life,
    pre.foundation_layer0_service_life_unit,
    pre.foundation_layer0_density,
    pre.foundation_layer0_density_unit,
    pre.foundation_layer1_position,
    pre.foundation_layer1_material_id,
    pre.foundation_layer1_material_name,
    pre.foundation_layer1_thickness,
    pre.foundation_layer1_thickness_unit,
    pre.foundation_layer1_solar_absorption_rate,
    pre.foundation_layer1_thermal_capacity,
    pre.foundation_layer1_thermal_capacity_unit,
    pre.foundation_layer1_thermal_conductivity,
    pre.foundation_layer1_thermal_conductivity_unit,
    pre.foundation_layer1_service_life,
    pre.foundation_layer1_service_life_unit,
    pre.foundation_layer1_density,
    pre.foundation_layer1_density_unit,
    pre.foundation_layer2_position,
    pre.foundation_layer2_material_id,
    pre.foundation_layer2_material_name,
    pre.foundation_layer2_thickness,
    pre.foundation_layer2_thickness_unit,
    pre.foundation_layer2_solar_absorption_rate,
    pre.foundation_layer2_thermal_capacity,
    pre.foundation_layer2_thermal_capacity_unit,
    pre.foundation_layer2_thermal_conductivity,
    pre.foundation_layer2_thermal_conductivity_unit,
    pre.foundation_layer2_service_life,
    pre.foundation_layer2_service_life_unit,
    pre.foundation_layer2_density,
    pre.foundation_layer2_density_unit,
    pre.foundation_layer3_position,
    pre.foundation_layer3_material_id,
    pre.foundation_layer3_material_name,
    pre.foundation_layer3_thickness,
    pre.foundation_layer3_thickness_unit,
    pre.foundation_layer3_solar_absorption_rate,
    pre.foundation_layer3_thermal_capacity,
    pre.foundation_layer3_thermal_capacity_unit,
    pre.foundation_layer3_thermal_conductivity,
    pre.foundation_layer3_thermal_conductivity_unit,
    pre.foundation_layer3_service_life,
    pre.foundation_layer3_service_life_unit,
    pre.foundation_layer3_density,
    pre.foundation_layer3_density_unit,
    pre.foundation_layer4_position,
    pre.foundation_layer4_material_id,
    pre.foundation_layer4_material_name,
    pre.foundation_layer4_thickness,
    pre.foundation_layer4_thickness_unit,
    pre.foundation_layer4_solar_absorption_rate,
    pre.foundation_layer4_thermal_capacity,
    pre.foundation_layer4_thermal_capacity_unit,
    pre.foundation_layer4_thermal_conductivity,
    pre.foundation_layer4_thermal_conductivity_unit,
    pre.foundation_layer4_service_life,
    pre.foundation_layer4_service_life_unit,
    pre.foundation_layer4_density,
    pre.foundation_layer4_density_unit,
    pre.foundation_layer5_position,
    pre.foundation_layer5_material_id,
    pre.foundation_layer5_material_name,
    pre.foundation_layer5_thickness,
    pre.foundation_layer5_thickness_unit,
    pre.foundation_layer5_solar_absorption_rate,
    pre.foundation_layer5_thermal_capacity,
    pre.foundation_layer5_thermal_capacity_unit,
    pre.foundation_layer5_thermal_conductivity,
    pre.foundation_layer5_thermal_conductivity_unit,
    pre.foundation_layer5_service_life,
    pre.foundation_layer5_service_life_unit,
    pre.foundation_layer5_density,
    pre.foundation_layer5_density_unit,
    pre.foundation_layer0_epd1_oekobaudat_name,
    pre.foundation_layer0_epd1_oekobaudat_uuid,
    pre.foundation_layer0_epd2_oekobaudat_name,
    pre.foundation_layer0_epd2_oekobaudat_uuid,
    pre.foundation_layer1_epd1_oekobaudat_name,
    pre.foundation_layer1_epd1_oekobaudat_uuid,
    pre.foundation_layer1_epd2_oekobaudat_name,
    pre.foundation_layer1_epd2_oekobaudat_uuid,
    pre.foundation_layer2_epd1_oekobaudat_name,
    pre.foundation_layer2_epd1_oekobaudat_uuid,
    pre.foundation_layer2_epd2_oekobaudat_name,
    pre.foundation_layer2_epd2_oekobaudat_uuid,
    pre.foundation_layer3_epd1_oekobaudat_name,
    pre.foundation_layer3_epd1_oekobaudat_uuid,
    pre.foundation_layer3_epd2_oekobaudat_name,
    pre.foundation_layer3_epd2_oekobaudat_uuid,
    pre.foundation_layer4_epd1_oekobaudat_name,
    pre.foundation_layer4_epd1_oekobaudat_uuid,
    pre.foundation_layer4_epd2_oekobaudat_name,
    pre.foundation_layer4_epd2_oekobaudat_uuid,
    pre.foundation_layer5_epd1_oekobaudat_name,
    pre.foundation_layer5_epd1_oekobaudat_uuid,
    pre.foundation_layer5_epd2_oekobaudat_name,
    pre.foundation_layer5_epd2_oekobaudat_uuid,
    pre.floor_name,
    pre.floor_u_value_typical_min,
    pre.floor_u_value_typical_max,
    pre.floor_u_value,
    pre.floor_u_value_unit,
    pre.floor_inner_radiation,
    pre.floor_inner_radiation_unit,
    pre.floor_inner_convection,
    pre.floor_inner_convection_unit,
    pre.floor_layer0_position,
    pre.floor_layer0_material_id,
    pre.floor_layer0_material_name,
    pre.floor_layer0_thickness,
    pre.floor_layer0_thickness_unit,
    pre.floor_layer0_solar_absorption_rate,
    pre.floor_layer0_thermal_capacity,
    pre.floor_layer0_thermal_capacity_unit,
    pre.floor_layer0_thermal_conductivity,
    pre.floor_layer0_thermal_conductivity_unit,
    pre.floor_layer0_service_life,
    pre.floor_layer0_service_life_unit,
    pre.floor_layer0_density,
    pre.floor_layer0_density_unit,
    pre.floor_layer1_position,
    pre.floor_layer1_material_id,
    pre.floor_layer1_material_name,
    pre.floor_layer1_thickness,
    pre.floor_layer1_thickness_unit,
    pre.floor_layer1_solar_absorption_rate,
    pre.floor_layer1_thermal_capacity,
    pre.floor_layer1_thermal_capacity_unit,
    pre.floor_layer1_thermal_conductivity,
    pre.floor_layer1_thermal_conductivity_unit,
    pre.floor_layer1_service_life,
    pre.floor_layer1_service_life_unit,
    pre.floor_layer1_density,
    pre.floor_layer1_density_unit,
    pre.floor_layer2_position,
    pre.floor_layer2_material_id,
    pre.floor_layer2_material_name,
    pre.floor_layer2_thickness,
    pre.floor_layer2_thickness_unit,
    pre.floor_layer2_solar_absorption_rate,
    pre.floor_layer2_thermal_capacity,
    pre.floor_layer2_thermal_capacity_unit,
    pre.floor_layer2_thermal_conductivity,
    pre.floor_layer2_thermal_conductivity_unit,
    pre.floor_layer2_service_life,
    pre.floor_layer2_service_life_unit,
    pre.floor_layer2_density,
    pre.floor_layer2_density_unit,
    pre.floor_layer0_epd1_oekobaudat_name,
    pre.floor_layer0_epd1_oekobaudat_uuid,
    pre.floor_layer0_epd2_oekobaudat_name,
    pre.floor_layer0_epd2_oekobaudat_uuid,
    pre.floor_layer1_epd1_oekobaudat_name,
    pre.floor_layer1_epd1_oekobaudat_uuid,
    pre.floor_layer1_epd2_oekobaudat_name,
    pre.floor_layer1_epd2_oekobaudat_uuid,
    pre.floor_layer2_epd1_oekobaudat_name,
    pre.floor_layer2_epd1_oekobaudat_uuid,
    pre.floor_layer2_epd2_oekobaudat_name,
    pre.floor_layer2_epd2_oekobaudat_uuid,
    pre.window_name,
    pre.window_inner_radiation,
    pre.window_inner_radiation_unit,
    pre.window_outer_radiation,
    pre.window_outer_radiation_unit,
    pre.window_inner_convection,
    pre.window_inner_convection_unit,
    pre.window_outer_convection,
    pre.window_outer_convection_unit,
    pre.glazing,
    pre.frame_per_window,
    pre.frame_per_window_unit,
    pre.window_frame_area_share,
    pre.g_value,
    pre.a_conv,
    pre.shading_type_name,
    pre.window_frame_type_name,
    pre.window_layer0_position,
    pre.window_layer0_material_id,
    pre.window_layer0_material_name,
    pre.window_layer0_thickness,
    pre.window_layer0_thickness_unit,
    pre.window_layer0_solar_absorption_rate,
    pre.window_layer0_thermal_capacity,
    pre.window_layer0_thermal_capacity_unit,
    pre.window_layer0_thermal_conductivity,
    pre.window_layer0_thermal_conductivity_unit,
    pre.window_layer0_service_life,
    pre.window_layer0_service_life_unit,
    pre.window_layer1_position,
    pre.window_layer1_material_id,
    pre.window_layer1_material_name,
    pre.window_layer1_thickness,
    pre.window_layer1_thickness_unit,
    pre.window_layer1_solar_absorption_rate,
    pre.window_layer1_thermal_capacity,
    pre.window_layer1_thermal_capacity_unit,
    pre.window_layer1_thermal_conductivity,
    pre.window_layer1_thermal_conductivity_unit,
    pre.window_layer1_service_life,
    pre.window_layer1_service_life_unit,
    pre.window_layer2_position,
    pre.window_layer2_material_id,
    pre.window_layer2_material_name,
    pre.window_layer2_thickness,
    pre.window_layer2_thickness_unit,
    pre.window_layer2_solar_absorption_rate,
    pre.window_layer2_thermal_capacity,
    pre.window_layer2_thermal_capacity_unit,
    pre.window_layer2_thermal_conductivity,
    pre.window_layer2_thermal_conductivity_unit,
    pre.window_layer2_service_life,
    pre.window_layer2_service_life_unit,
    pre.window_layer0_epd1_oekobaudat_name,
    pre.window_layer0_epd1_oekobaudat_uuid,
    pre.window_layer0_epd2_oekobaudat_name,
    pre.window_layer0_epd2_oekobaudat_uuid,
    pre.window_layer1_epd1_oekobaudat_name,
    pre.window_layer1_epd1_oekobaudat_uuid,
    pre.window_layer1_epd2_oekobaudat_name,
    pre.window_layer1_epd2_oekobaudat_uuid,
    pre.window_layer2_epd1_oekobaudat_name,
    pre.window_layer2_epd1_oekobaudat_uuid,
    pre.window_layer2_epd2_oekobaudat_name,
    pre.window_layer2_epd2_oekobaudat_uuid,
    pre.energy_system_name,
    pre.converter_0_id,
    pre.converter_0_energy_converter_name,
    pre.converter_1_id,
    pre.converter_1_energy_converter_name,
    pre.converter_0_nominal_power_min,
    pre.converter_0_nominal_power_max,
    pre.converter_0_nominal_power_unit,
    pre.converter_1_nominal_power_min,
    pre.converter_1_nominal_power_max,
    pre.converter_1_nominal_power_unit,
    pre.converter_0_area,
    pre.converter_0_area_unit,
    pre.converter_1_area,
    pre.converter_1_area_unit,
    pre.converter_0_supply_function_name,
    pre.converter_1_supply_function_name,
    pre.converter_0_energy_source_name,
    pre.converter_1_energy_source_name,
    pre.converter_0_service_life,
    pre.converter_0_service_life_unit,
    pre.converter_1_service_life,
    pre.converter_1_service_life_unit,
    pre.converter_0_epd_1_id,
    pre.converter_0_epd_1_name,
    pre.converter_0_epd_1_database_uuid,
    pre.converter_0_epd_2_id,
    pre.converter_0_epd_2_name,
    pre.converter_0_epd_2_database_uuid,
    pre.converter_0_energy_source_epd_id,
    pre.converter_0_energy_source_epd_name,
    pre.converter_0_energy_source_epd_database_uuid,
    pre.converter_1_epd_1_id,
    pre.converter_1_epd_1_name,
    pre.converter_1_epd_1_database_uuid,
    pre.converter_1_epd_2_id,
    pre.converter_1_epd_2_name,
    pre.converter_1_epd_2_database_uuid,
    pre.converter_1_energy_source_epd_id,
    pre.converter_1_energy_source_epd_name,
    pre.converter_1_energy_source_epd_database_uuid,
    bmp.bmp_building_archetype_id,
    bmp.heat_useful_total_mean_value,
    bmp.heat_useful_total_median_value,
    bmp.heat_useful_total_std_dev,
    bmp.heat_useful_total_min_value,
    bmp.heat_useful_total_max_value,
    bmp.heat_useful_total_p05_value,
    bmp.heat_useful_total_p25_value,
    bmp.heat_useful_total_p75_value,
    bmp.heat_useful_total_p95_value,
    bmp.heat_useful_total_se_mean,
    bmp.heat_useful_total_cv,
    bmp.heat_useful_per_m2_mean_value,
    bmp.heat_useful_per_m2_median_value,
    bmp.heat_useful_per_m2_std_dev,
    bmp.heat_useful_per_m2_min_value,
    bmp.heat_useful_per_m2_max_value,
    bmp.heat_useful_per_m2_p05_value,
    bmp.heat_useful_per_m2_p25_value,
    bmp.heat_useful_per_m2_p75_value,
    bmp.heat_useful_per_m2_p95_value,
    bmp.heat_useful_per_m2_se_mean,
    bmp.heat_useful_per_m2_cv,
    bmp.gwp_a1_a3_mean_value,
    bmp.gwp_a1_a3_median_value,
    bmp.gwp_a1_a3_std_dev,
    bmp.gwp_a1_a3_min_value,
    bmp.gwp_a1_a3_max_value,
    bmp.gwp_a1_a3_p05_value,
    bmp.gwp_a1_a3_p25_value,
    bmp.gwp_a1_a3_p75_value,
    bmp.gwp_a1_a3_p95_value,
    bmp.gwp_a1_a3_se_mean,
    bmp.gwp_a1_a3_cv,
    bmp.gwp_a4_mean_value,
    bmp.gwp_a4_median_value,
    bmp.gwp_a4_std_dev,
    bmp.gwp_a4_min_value,
    bmp.gwp_a4_max_value,
    bmp.gwp_a4_p05_value,
    bmp.gwp_a4_p25_value,
    bmp.gwp_a4_p75_value,
    bmp.gwp_a4_p95_value,
    bmp.gwp_a4_se_mean,
    bmp.gwp_a4_cv,
    bmp.gwp_a5_mean_value,
    bmp.gwp_a5_median_value,
    bmp.gwp_a5_std_dev,
    bmp.gwp_a5_min_value,
    bmp.gwp_a5_max_value,
    bmp.gwp_a5_p05_value,
    bmp.gwp_a5_p25_value,
    bmp.gwp_a5_p75_value,
    bmp.gwp_a5_p95_value,
    bmp.gwp_a5_se_mean,
    bmp.gwp_a5_cv,
    bmp.gwp_b1_mean_value,
    bmp.gwp_b1_median_value,
    bmp.gwp_b1_std_dev,
    bmp.gwp_b1_min_value,
    bmp.gwp_b1_max_value,
    bmp.gwp_b1_p05_value,
    bmp.gwp_b1_p25_value,
    bmp.gwp_b1_p75_value,
    bmp.gwp_b1_p95_value,
    bmp.gwp_b1_se_mean,
    bmp.gwp_b1_cv,
    bmp.gwp_b2_mean_value,
    bmp.gwp_b2_median_value,
    bmp.gwp_b2_std_dev,
    bmp.gwp_b2_min_value,
    bmp.gwp_b2_max_value,
    bmp.gwp_b2_p05_value,
    bmp.gwp_b2_p25_value,
    bmp.gwp_b2_p75_value,
    bmp.gwp_b2_p95_value,
    bmp.gwp_b2_se_mean,
    bmp.gwp_b2_cv,
    bmp.gwp_b3_mean_value,
    bmp.gwp_b3_median_value,
    bmp.gwp_b3_std_dev,
    bmp.gwp_b3_min_value,
    bmp.gwp_b3_max_value,
    bmp.gwp_b3_p05_value,
    bmp.gwp_b3_p25_value,
    bmp.gwp_b3_p75_value,
    bmp.gwp_b3_p95_value,
    bmp.gwp_b3_se_mean,
    bmp.gwp_b3_cv,
    bmp.gwp_b4_mean_value,
    bmp.gwp_b4_median_value,
    bmp.gwp_b4_std_dev,
    bmp.gwp_b4_min_value,
    bmp.gwp_b4_max_value,
    bmp.gwp_b4_p05_value,
    bmp.gwp_b4_p25_value,
    bmp.gwp_b4_p75_value,
    bmp.gwp_b4_p95_value,
    bmp.gwp_b4_se_mean,
    bmp.gwp_b4_cv,
    bmp.gwp_b5_mean_value,
    bmp.gwp_b5_median_value,
    bmp.gwp_b5_std_dev,
    bmp.gwp_b5_min_value,
    bmp.gwp_b5_max_value,
    bmp.gwp_b5_p05_value,
    bmp.gwp_b5_p25_value,
    bmp.gwp_b5_p75_value,
    bmp.gwp_b5_p95_value,
    bmp.gwp_b5_se_mean,
    bmp.gwp_b5_cv,
    bmp.gwp_b6_mean_value,
    bmp.gwp_b6_median_value,
    bmp.gwp_b6_std_dev,
    bmp.gwp_b6_min_value,
    bmp.gwp_b6_max_value,
    bmp.gwp_b6_p05_value,
    bmp.gwp_b6_p25_value,
    bmp.gwp_b6_p75_value,
    bmp.gwp_b6_p95_value,
    bmp.gwp_b6_se_mean,
    bmp.gwp_b6_cv,
    bmp.gwp_b7_mean_value,
    bmp.gwp_b7_median_value,
    bmp.gwp_b7_std_dev,
    bmp.gwp_b7_min_value,
    bmp.gwp_b7_max_value,
    bmp.gwp_b7_p05_value,
    bmp.gwp_b7_p25_value,
    bmp.gwp_b7_p75_value,
    bmp.gwp_b7_p95_value,
    bmp.gwp_b7_se_mean,
    bmp.gwp_b7_cv,
    bmp.gwp_c1_mean_value,
    bmp.gwp_c1_median_value,
    bmp.gwp_c1_std_dev,
    bmp.gwp_c1_min_value,
    bmp.gwp_c1_max_value,
    bmp.gwp_c1_p05_value,
    bmp.gwp_c1_p25_value,
    bmp.gwp_c1_p75_value,
    bmp.gwp_c1_p95_value,
    bmp.gwp_c1_se_mean,
    bmp.gwp_c1_cv,
    bmp.gwp_c2_mean_value,
    bmp.gwp_c2_median_value,
    bmp.gwp_c2_std_dev,
    bmp.gwp_c2_min_value,
    bmp.gwp_c2_max_value,
    bmp.gwp_c2_p05_value,
    bmp.gwp_c2_p25_value,
    bmp.gwp_c2_p75_value,
    bmp.gwp_c2_p95_value,
    bmp.gwp_c2_se_mean,
    bmp.gwp_c2_cv,
    bmp.gwp_c3_mean_value,
    bmp.gwp_c3_median_value,
    bmp.gwp_c3_std_dev,
    bmp.gwp_c3_min_value,
    bmp.gwp_c3_max_value,
    bmp.gwp_c3_p05_value,
    bmp.gwp_c3_p25_value,
    bmp.gwp_c3_p75_value,
    bmp.gwp_c3_p95_value,
    bmp.gwp_c3_se_mean,
    bmp.gwp_c3_cv,
    bmp.gwp_c4_mean_value,
    bmp.gwp_c4_median_value,
    bmp.gwp_c4_std_dev,
    bmp.gwp_c4_min_value,
    bmp.gwp_c4_max_value,
    bmp.gwp_c4_p05_value,
    bmp.gwp_c4_p25_value,
    bmp.gwp_c4_p75_value,
    bmp.gwp_c4_p95_value,
    bmp.gwp_c4_se_mean,
    bmp.gwp_c4_cv,
    bmp.gwp_d_mean_value,
    bmp.gwp_d_median_value,
    bmp.gwp_d_std_dev,
    bmp.gwp_d_min_value,
    bmp.gwp_d_max_value,
    bmp.gwp_d_p05_value,
    bmp.gwp_d_p25_value,
    bmp.gwp_d_p75_value,
    bmp.gwp_d_p95_value,
    bmp.gwp_d_se_mean,
    bmp.gwp_d_cv,
    bmp.gwp_lifecycle_mean_value,
    bmp.gwp_lifecycle_median_value,
    bmp.gwp_lifecycle_std_dev,
    bmp.gwp_lifecycle_min_value,
    bmp.gwp_lifecycle_max_value,
    bmp.gwp_lifecycle_p05_value,
    bmp.gwp_lifecycle_p25_value,
    bmp.gwp_lifecycle_p75_value,
    bmp.gwp_lifecycle_p95_value,
    bmp.gwp_lifecycle_se_mean,
    bmp.gwp_lifecycle_cv,
    bmp.gwp_lifecycle_no_d_mean_value,
    bmp.gwp_lifecycle_no_d_median_value,
    bmp.gwp_lifecycle_no_d_std_dev,
    bmp.gwp_lifecycle_no_d_min_value,
    bmp.gwp_lifecycle_no_d_max_value,
    bmp.gwp_lifecycle_no_d_p05_value,
    bmp.gwp_lifecycle_no_d_p25_value,
    bmp.gwp_lifecycle_no_d_p75_value,
    bmp.gwp_lifecycle_no_d_p95_value,
    bmp.gwp_lifecycle_no_d_se_mean,
    bmp.gwp_lifecycle_no_d_cv,
    bmp.gwp_a1_a3_per_m2_mean_value,
    bmp.gwp_a1_a3_per_m2_median_value,
    bmp.gwp_a1_a3_per_m2_std_dev,
    bmp.gwp_a1_a3_per_m2_min_value,
    bmp.gwp_a1_a3_per_m2_max_value,
    bmp.gwp_a1_a3_per_m2_p05_value,
    bmp.gwp_a1_a3_per_m2_p25_value,
    bmp.gwp_a1_a3_per_m2_p75_value,
    bmp.gwp_a1_a3_per_m2_p95_value,
    bmp.gwp_a1_a3_per_m2_se_mean,
    bmp.gwp_a1_a3_per_m2_cv,
    bmp.gwp_a4_per_m2_mean_value,
    bmp.gwp_a4_per_m2_median_value,
    bmp.gwp_a4_per_m2_std_dev,
    bmp.gwp_a4_per_m2_min_value,
    bmp.gwp_a4_per_m2_max_value,
    bmp.gwp_a4_per_m2_p05_value,
    bmp.gwp_a4_per_m2_p25_value,
    bmp.gwp_a4_per_m2_p75_value,
    bmp.gwp_a4_per_m2_p95_value,
    bmp.gwp_a4_per_m2_se_mean,
    bmp.gwp_a4_per_m2_cv,
    bmp.gwp_a5_per_m2_mean_value,
    bmp.gwp_a5_per_m2_median_value,
    bmp.gwp_a5_per_m2_std_dev,
    bmp.gwp_a5_per_m2_min_value,
    bmp.gwp_a5_per_m2_max_value,
    bmp.gwp_a5_per_m2_p05_value,
    bmp.gwp_a5_per_m2_p25_value,
    bmp.gwp_a5_per_m2_p75_value,
    bmp.gwp_a5_per_m2_p95_value,
    bmp.gwp_a5_per_m2_se_mean,
    bmp.gwp_a5_per_m2_cv,
    bmp.gwp_b1_per_m2_mean_value,
    bmp.gwp_b1_per_m2_median_value,
    bmp.gwp_b1_per_m2_std_dev,
    bmp.gwp_b1_per_m2_min_value,
    bmp.gwp_b1_per_m2_max_value,
    bmp.gwp_b1_per_m2_p05_value,
    bmp.gwp_b1_per_m2_p25_value,
    bmp.gwp_b1_per_m2_p75_value,
    bmp.gwp_b1_per_m2_p95_value,
    bmp.gwp_b1_per_m2_se_mean,
    bmp.gwp_b1_per_m2_cv,
    bmp.gwp_b2_per_m2_mean_value,
    bmp.gwp_b2_per_m2_median_value,
    bmp.gwp_b2_per_m2_std_dev,
    bmp.gwp_b2_per_m2_min_value,
    bmp.gwp_b2_per_m2_max_value,
    bmp.gwp_b2_per_m2_p05_value,
    bmp.gwp_b2_per_m2_p25_value,
    bmp.gwp_b2_per_m2_p75_value,
    bmp.gwp_b2_per_m2_p95_value,
    bmp.gwp_b2_per_m2_se_mean,
    bmp.gwp_b2_per_m2_cv,
    bmp.gwp_b3_per_m2_mean_value,
    bmp.gwp_b3_per_m2_median_value,
    bmp.gwp_b3_per_m2_std_dev,
    bmp.gwp_b3_per_m2_min_value,
    bmp.gwp_b3_per_m2_max_value,
    bmp.gwp_b3_per_m2_p05_value,
    bmp.gwp_b3_per_m2_p25_value,
    bmp.gwp_b3_per_m2_p75_value,
    bmp.gwp_b3_per_m2_p95_value,
    bmp.gwp_b3_per_m2_se_mean,
    bmp.gwp_b3_per_m2_cv,
    bmp.gwp_b4_per_m2_mean_value,
    bmp.gwp_b4_per_m2_median_value,
    bmp.gwp_b4_per_m2_std_dev,
    bmp.gwp_b4_per_m2_min_value,
    bmp.gwp_b4_per_m2_max_value,
    bmp.gwp_b4_per_m2_p05_value,
    bmp.gwp_b4_per_m2_p25_value,
    bmp.gwp_b4_per_m2_p75_value,
    bmp.gwp_b4_per_m2_p95_value,
    bmp.gwp_b4_per_m2_se_mean,
    bmp.gwp_b4_per_m2_cv,
    bmp.gwp_b5_per_m2_mean_value,
    bmp.gwp_b5_per_m2_median_value,
    bmp.gwp_b5_per_m2_std_dev,
    bmp.gwp_b5_per_m2_min_value,
    bmp.gwp_b5_per_m2_max_value,
    bmp.gwp_b5_per_m2_p05_value,
    bmp.gwp_b5_per_m2_p25_value,
    bmp.gwp_b5_per_m2_p75_value,
    bmp.gwp_b5_per_m2_p95_value,
    bmp.gwp_b5_per_m2_se_mean,
    bmp.gwp_b5_per_m2_cv,
    bmp.gwp_b6_per_m2_mean_value,
    bmp.gwp_b6_per_m2_median_value,
    bmp.gwp_b6_per_m2_std_dev,
    bmp.gwp_b6_per_m2_min_value,
    bmp.gwp_b6_per_m2_max_value,
    bmp.gwp_b6_per_m2_p05_value,
    bmp.gwp_b6_per_m2_p25_value,
    bmp.gwp_b6_per_m2_p75_value,
    bmp.gwp_b6_per_m2_p95_value,
    bmp.gwp_b6_per_m2_se_mean,
    bmp.gwp_b6_per_m2_cv,
    bmp.gwp_b7_per_m2_mean_value,
    bmp.gwp_b7_per_m2_median_value,
    bmp.gwp_b7_per_m2_std_dev,
    bmp.gwp_b7_per_m2_min_value,
    bmp.gwp_b7_per_m2_max_value,
    bmp.gwp_b7_per_m2_p05_value,
    bmp.gwp_b7_per_m2_p25_value,
    bmp.gwp_b7_per_m2_p75_value,
    bmp.gwp_b7_per_m2_p95_value,
    bmp.gwp_b7_per_m2_se_mean,
    bmp.gwp_b7_per_m2_cv,
    bmp.gwp_c1_per_m2_mean_value,
    bmp.gwp_c1_per_m2_median_value,
    bmp.gwp_c1_per_m2_std_dev,
    bmp.gwp_c1_per_m2_min_value,
    bmp.gwp_c1_per_m2_max_value,
    bmp.gwp_c1_per_m2_p05_value,
    bmp.gwp_c1_per_m2_p25_value,
    bmp.gwp_c1_per_m2_p75_value,
    bmp.gwp_c1_per_m2_p95_value,
    bmp.gwp_c1_per_m2_se_mean,
    bmp.gwp_c1_per_m2_cv,
    bmp.gwp_c2_per_m2_mean_value,
    bmp.gwp_c2_per_m2_median_value,
    bmp.gwp_c2_per_m2_std_dev,
    bmp.gwp_c2_per_m2_min_value,
    bmp.gwp_c2_per_m2_max_value,
    bmp.gwp_c2_per_m2_p05_value,
    bmp.gwp_c2_per_m2_p25_value,
    bmp.gwp_c2_per_m2_p75_value,
    bmp.gwp_c2_per_m2_p95_value,
    bmp.gwp_c2_per_m2_se_mean,
    bmp.gwp_c2_per_m2_cv,
    bmp.gwp_c3_per_m2_mean_value,
    bmp.gwp_c3_per_m2_median_value,
    bmp.gwp_c3_per_m2_std_dev,
    bmp.gwp_c3_per_m2_min_value,
    bmp.gwp_c3_per_m2_max_value,
    bmp.gwp_c3_per_m2_p05_value,
    bmp.gwp_c3_per_m2_p25_value,
    bmp.gwp_c3_per_m2_p75_value,
    bmp.gwp_c3_per_m2_p95_value,
    bmp.gwp_c3_per_m2_se_mean,
    bmp.gwp_c3_per_m2_cv,
    bmp.gwp_c4_per_m2_mean_value,
    bmp.gwp_c4_per_m2_median_value,
    bmp.gwp_c4_per_m2_std_dev,
    bmp.gwp_c4_per_m2_min_value,
    bmp.gwp_c4_per_m2_max_value,
    bmp.gwp_c4_per_m2_p05_value,
    bmp.gwp_c4_per_m2_p25_value,
    bmp.gwp_c4_per_m2_p75_value,
    bmp.gwp_c4_per_m2_p95_value,
    bmp.gwp_c4_per_m2_se_mean,
    bmp.gwp_c4_per_m2_cv,
    bmp.gwp_d_per_m2_mean_value,
    bmp.gwp_d_per_m2_median_value,
    bmp.gwp_d_per_m2_std_dev,
    bmp.gwp_d_per_m2_min_value,
    bmp.gwp_d_per_m2_max_value,
    bmp.gwp_d_per_m2_p05_value,
    bmp.gwp_d_per_m2_p25_value,
    bmp.gwp_d_per_m2_p75_value,
    bmp.gwp_d_per_m2_p95_value,
    bmp.gwp_d_per_m2_se_mean,
    bmp.gwp_d_per_m2_cv,
    bmp.gwp_lifecycle_per_m2_mean_value,
    bmp.gwp_lifecycle_per_m2_median_value,
    bmp.gwp_lifecycle_per_m2_std_dev,
    bmp.gwp_lifecycle_per_m2_min_value,
    bmp.gwp_lifecycle_per_m2_max_value,
    bmp.gwp_lifecycle_per_m2_p05_value,
    bmp.gwp_lifecycle_per_m2_p25_value,
    bmp.gwp_lifecycle_per_m2_p75_value,
    bmp.gwp_lifecycle_per_m2_p95_value,
    bmp.gwp_lifecycle_per_m2_se_mean,
    bmp.gwp_lifecycle_per_m2_cv,
    bmp.gwp_lifecycle_no_d_per_m2_mean_value,
    bmp.gwp_lifecycle_no_d_per_m2_median_value,
    bmp.gwp_lifecycle_no_d_per_m2_std_dev,
    bmp.gwp_lifecycle_no_d_per_m2_min_value,
    bmp.gwp_lifecycle_no_d_per_m2_max_value,
    bmp.gwp_lifecycle_no_d_per_m2_p05_value,
    bmp.gwp_lifecycle_no_d_per_m2_p25_value,
    bmp.gwp_lifecycle_no_d_per_m2_p75_value,
    bmp.gwp_lifecycle_no_d_per_m2_p95_value,
    bmp.gwp_lifecycle_no_d_per_m2_se_mean,
    bmp.gwp_lifecycle_no_d_per_m2_cv,
    emp.emp_building_archetype_id,
    emp.gwp_lifecycle_exterior_wall_mean_value,
    emp.gwp_lifecycle_exterior_wall_median_value,
    emp.gwp_lifecycle_exterior_wall_std_dev,
    emp.gwp_lifecycle_exterior_wall_min_value,
    emp.gwp_lifecycle_exterior_wall_max_value,
    emp.gwp_lifecycle_exterior_wall_p05_value,
    emp.gwp_lifecycle_exterior_wall_p25_value,
    emp.gwp_lifecycle_exterior_wall_p75_value,
    emp.gwp_lifecycle_exterior_wall_p95_value,
    emp.gwp_lifecycle_exterior_wall_se_mean,
    emp.gwp_lifecycle_exterior_wall_cv,
    emp.gwp_lifecycle_roof_mean_value,
    emp.gwp_lifecycle_roof_median_value,
    emp.gwp_lifecycle_roof_std_dev,
    emp.gwp_lifecycle_roof_min_value,
    emp.gwp_lifecycle_roof_max_value,
    emp.gwp_lifecycle_roof_p05_value,
    emp.gwp_lifecycle_roof_p25_value,
    emp.gwp_lifecycle_roof_p75_value,
    emp.gwp_lifecycle_roof_p95_value,
    emp.gwp_lifecycle_roof_se_mean,
    emp.gwp_lifecycle_roof_cv,
    emp.gwp_lifecycle_foundation_mean_value,
    emp.gwp_lifecycle_foundation_median_value,
    emp.gwp_lifecycle_foundation_std_dev,
    emp.gwp_lifecycle_foundation_min_value,
    emp.gwp_lifecycle_foundation_max_value,
    emp.gwp_lifecycle_foundation_p05_value,
    emp.gwp_lifecycle_foundation_p25_value,
    emp.gwp_lifecycle_foundation_p75_value,
    emp.gwp_lifecycle_foundation_p95_value,
    emp.gwp_lifecycle_foundation_se_mean,
    emp.gwp_lifecycle_foundation_cv,
    emp.gwp_lifecycle_floor_mean_value,
    emp.gwp_lifecycle_floor_median_value,
    emp.gwp_lifecycle_floor_std_dev,
    emp.gwp_lifecycle_floor_min_value,
    emp.gwp_lifecycle_floor_max_value,
    emp.gwp_lifecycle_floor_p05_value,
    emp.gwp_lifecycle_floor_p25_value,
    emp.gwp_lifecycle_floor_p75_value,
    emp.gwp_lifecycle_floor_p95_value,
    emp.gwp_lifecycle_floor_se_mean,
    emp.gwp_lifecycle_floor_cv,
    emp.gwp_lifecycle_window_mean_value,
    emp.gwp_lifecycle_window_median_value,
    emp.gwp_lifecycle_window_std_dev,
    emp.gwp_lifecycle_window_min_value,
    emp.gwp_lifecycle_window_max_value,
    emp.gwp_lifecycle_window_p05_value,
    emp.gwp_lifecycle_window_p25_value,
    emp.gwp_lifecycle_window_p75_value,
    emp.gwp_lifecycle_window_p95_value,
    emp.gwp_lifecycle_window_se_mean,
    emp.gwp_lifecycle_window_cv,
    emp.gwp_lifecycle_interior_wall_mean_value,
    emp.gwp_lifecycle_interior_wall_median_value,
    emp.gwp_lifecycle_interior_wall_std_dev,
    emp.gwp_lifecycle_interior_wall_min_value,
    emp.gwp_lifecycle_interior_wall_max_value,
    emp.gwp_lifecycle_interior_wall_p05_value,
    emp.gwp_lifecycle_interior_wall_p25_value,
    emp.gwp_lifecycle_interior_wall_p75_value,
    emp.gwp_lifecycle_interior_wall_p95_value,
    emp.gwp_lifecycle_interior_wall_se_mean,
    emp.gwp_lifecycle_interior_wall_cv,
    emp.gwp_lifecycle_no_d_exterior_wall_mean_value,
    emp.gwp_lifecycle_no_d_exterior_wall_median_value,
    emp.gwp_lifecycle_no_d_exterior_wall_std_dev,
    emp.gwp_lifecycle_no_d_exterior_wall_min_value,
    emp.gwp_lifecycle_no_d_exterior_wall_max_value,
    emp.gwp_lifecycle_no_d_exterior_wall_p05_value,
    emp.gwp_lifecycle_no_d_exterior_wall_p25_value,
    emp.gwp_lifecycle_no_d_exterior_wall_p75_value,
    emp.gwp_lifecycle_no_d_exterior_wall_p95_value,
    emp.gwp_lifecycle_no_d_exterior_wall_se_mean,
    emp.gwp_lifecycle_no_d_exterior_wall_cv,
    emp.gwp_lifecycle_no_d_roof_mean_value,
    emp.gwp_lifecycle_no_d_roof_median_value,
    emp.gwp_lifecycle_no_d_roof_std_dev,
    emp.gwp_lifecycle_no_d_roof_min_value,
    emp.gwp_lifecycle_no_d_roof_max_value,
    emp.gwp_lifecycle_no_d_roof_p05_value,
    emp.gwp_lifecycle_no_d_roof_p25_value,
    emp.gwp_lifecycle_no_d_roof_p75_value,
    emp.gwp_lifecycle_no_d_roof_p95_value,
    emp.gwp_lifecycle_no_d_roof_se_mean,
    emp.gwp_lifecycle_no_d_roof_cv,
    emp.gwp_lifecycle_no_d_foundation_mean_value,
    emp.gwp_lifecycle_no_d_foundation_median_value,
    emp.gwp_lifecycle_no_d_foundation_std_dev,
    emp.gwp_lifecycle_no_d_foundation_min_value,
    emp.gwp_lifecycle_no_d_foundation_max_value,
    emp.gwp_lifecycle_no_d_foundation_p05_value,
    emp.gwp_lifecycle_no_d_foundation_p25_value,
    emp.gwp_lifecycle_no_d_foundation_p75_value,
    emp.gwp_lifecycle_no_d_foundation_p95_value,
    emp.gwp_lifecycle_no_d_foundation_se_mean,
    emp.gwp_lifecycle_no_d_foundation_cv,
    emp.gwp_lifecycle_no_d_floor_mean_value,
    emp.gwp_lifecycle_no_d_floor_median_value,
    emp.gwp_lifecycle_no_d_floor_std_dev,
    emp.gwp_lifecycle_no_d_floor_min_value,
    emp.gwp_lifecycle_no_d_floor_max_value,
    emp.gwp_lifecycle_no_d_floor_p05_value,
    emp.gwp_lifecycle_no_d_floor_p25_value,
    emp.gwp_lifecycle_no_d_floor_p75_value,
    emp.gwp_lifecycle_no_d_floor_p95_value,
    emp.gwp_lifecycle_no_d_floor_se_mean,
    emp.gwp_lifecycle_no_d_floor_cv,
    emp.gwp_lifecycle_no_d_window_mean_value,
    emp.gwp_lifecycle_no_d_window_median_value,
    emp.gwp_lifecycle_no_d_window_std_dev,
    emp.gwp_lifecycle_no_d_window_min_value,
    emp.gwp_lifecycle_no_d_window_max_value,
    emp.gwp_lifecycle_no_d_window_p05_value,
    emp.gwp_lifecycle_no_d_window_p25_value,
    emp.gwp_lifecycle_no_d_window_p75_value,
    emp.gwp_lifecycle_no_d_window_p95_value,
    emp.gwp_lifecycle_no_d_window_se_mean,
    emp.gwp_lifecycle_no_d_window_cv,
    emp.gwp_lifecycle_no_d_interior_wall_mean_value,
    emp.gwp_lifecycle_no_d_interior_wall_median_value,
    emp.gwp_lifecycle_no_d_interior_wall_std_dev,
    emp.gwp_lifecycle_no_d_interior_wall_min_value,
    emp.gwp_lifecycle_no_d_interior_wall_max_value,
    emp.gwp_lifecycle_no_d_interior_wall_p05_value,
    emp.gwp_lifecycle_no_d_interior_wall_p25_value,
    emp.gwp_lifecycle_no_d_interior_wall_p75_value,
    emp.gwp_lifecycle_no_d_interior_wall_p95_value,
    emp.gwp_lifecycle_no_d_interior_wall_se_mean,
    emp.gwp_lifecycle_no_d_interior_wall_cv
   FROM (((hub4lca_post_simulation.vw_pre_simulation pre
     JOIN hub4lca_post_simulation.building_archetypes bat ON ((bat.building_archetype_id = pre.building_archetype_id)))
     LEFT JOIN step_002_building_metric_stats_pivot bmp ON ((bmp.bmp_building_archetype_id = pre.building_archetype_id)))
     LEFT JOIN step_004_element_metric_stats_pivot emp ON ((emp.emp_building_archetype_id = pre.building_archetype_id)));
 ;   DROP VIEW hub4lca_post_simulation.vw_post_simulation_base;
       hub4lca_post_simulation       v       max_schildt    false    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    342    324    324    324    324    324    324    324    324    324    324    324    324    324    324    324    323    323    323    323    323    323    323    323    323    323    323    323    323    323    239    239    229    229    6            Z           1259    37628    vw_post_simulation_ab    VIEW       CREATE VIEW hub4lca_post_simulation.vw_post_simulation_ab AS
 SELECT v.building_archetype_id,
    v.building_archetype_name,
    v.share_of_building_type,
    v.share_of_building_type_in_region,
    v.share_of_building_type_in_region_mun,
    v.exterior_wall_building_element_id,
    v.interior_wall_building_element_id,
    v.roof_building_element_id,
    v.foundation_building_element_id,
    v.floor_building_element_id,
    v.window_building_element_id,
    v.energy_system_id,
    v.building_type_name,
    v.region_name,
    v.municipality_size_name,
    v.municipality_growth_name,
    v.age_class_name,
    v.building_adjacency_name,
    v.facade_to_net_leased_area_ratio_mean,
    v.facade_to_net_leased_area_ratio_se_min,
    v.facade_to_net_leased_area_ratio_se_max,
    v.roof_to_net_leased_area_ratio_mean,
    v.roof_to_net_leased_area_ratio_se_min,
    v.roof_to_net_leased_area_ratio_se_max,
    v.foundation_to_net_leased_area_ratio_mean,
    v.foundation_to_net_leased_area_ratio_se_min,
    v.foundation_to_net_leased_area_ratio_se_max,
    v.window_to_net_leased_area_ratio_mean,
    v.window_to_net_leased_area_ratio_se_min,
    v.window_to_net_leased_area_ratio_se_max,
    v.building_height_mean,
    v.building_height_se,
    v.height_unit,
    v.aspect_ratio_mean,
    v.aspect_ratio_se_min,
    v.aspect_ratio_se_max,
    v.storeys_below_ground_mean,
    v.storeys_below_ground_se,
    v.storeys_above_ground_mean,
    v.storeys_above_ground_se,
    v.storeys_above_ground_se_min,
    v.storeys_above_ground_se_max,
    v.storey_height_mean,
    v.storey_height_se_min,
    v.storey_height_se_max,
    v.window_share,
    v.net_leased_area_mean,
    v.net_leased_area_se,
    v.net_leased_area_se_min,
    v.net_leased_area_se_max,
    v.net_leased_area_unit,
    v.facade_area_north_mean,
    v.facade_area_north_se,
    v.facade_area_east_mean,
    v.facade_area_east_se,
    v.facade_area_south_mean,
    v.facade_area_south_se,
    v.facade_area_west_mean,
    v.facade_area_west_se,
    v.facade_area_unit,
    v.facade_length_north_mean,
    v.facade_length_north_se,
    v.facade_length_east_mean,
    v.facade_length_east_se,
    v.facade_length_south_mean,
    v.facade_length_south_se,
    v.facade_length_west_mean,
    v.facade_length_west_se,
    v.facade_length_unit,
    v.exterior_wall_name,
    v.exterior_wall_construction_type,
    v.exterior_wall_u_value_typical_min,
    v.exterior_wall_u_value_typical_max,
    v.exterior_wall_u_value,
    v.exterior_wall_u_value_unit,
    v.exterior_wall_inner_radiation,
    v.exterior_wall_inner_radiation_unit,
    v.exterior_wall_outer_radiation,
    v.exterior_wall_outer_radiation_unit,
    v.exterior_wall_inner_convection,
    v.exterior_wall_inner_convection_unit,
    v.exterior_wall_outer_convection,
    v.exterior_wall_outer_convection_unit,
    v.exterior_wall_layer0_position,
    v.exterior_wall_layer0_material_id,
    v.exterior_wall_layer0_material_name,
    v.exterior_wall_layer0_thickness,
    v.exterior_wall_layer0_thickness_unit,
    v.exterior_wall_layer0_solar_absorption_rate,
    v.exterior_wall_layer0_thermal_capacity,
    v.exterior_wall_layer0_thermal_capacity_unit,
    v.exterior_wall_layer0_thermal_conductivity,
    v.exterior_wall_layer0_thermal_conductivity_unit,
    v.exterior_wall_layer0_service_life,
    v.exterior_wall_layer0_service_life_unit,
    v.exterior_wall_layer0_density,
    v.exterior_wall_layer0_density_unit,
    v.exterior_wall_layer1_position,
    v.exterior_wall_layer1_material_id,
    v.exterior_wall_layer1_material_name,
    v.exterior_wall_layer1_thickness,
    v.exterior_wall_layer1_thickness_unit,
    v.exterior_wall_layer1_solar_absorption_rate,
    v.exterior_wall_layer1_thermal_capacity,
    v.exterior_wall_layer1_thermal_capacity_unit,
    v.exterior_wall_layer1_thermal_conductivity,
    v.exterior_wall_layer1_thermal_conductivity_unit,
    v.exterior_wall_layer1_service_life,
    v.exterior_wall_layer1_service_life_unit,
    v.exterior_wall_layer1_density,
    v.exterior_wall_layer1_density_unit,
    v.exterior_wall_layer2_position,
    v.exterior_wall_layer2_material_id,
    v.exterior_wall_layer2_material_name,
    v.exterior_wall_layer2_thickness,
    v.exterior_wall_layer2_thickness_unit,
    v.exterior_wall_layer2_solar_absorption_rate,
    v.exterior_wall_layer2_thermal_capacity,
    v.exterior_wall_layer2_thermal_capacity_unit,
    v.exterior_wall_layer2_thermal_conductivity,
    v.exterior_wall_layer2_thermal_conductivity_unit,
    v.exterior_wall_layer2_service_life,
    v.exterior_wall_layer2_service_life_unit,
    v.exterior_wall_layer2_density,
    v.exterior_wall_layer2_density_unit,
    v.exterior_wall_layer3_position,
    v.exterior_wall_layer3_material_id,
    v.exterior_wall_layer3_material_name,
    v.exterior_wall_layer3_thickness,
    v.exterior_wall_layer3_thickness_unit,
    v.exterior_wall_layer3_solar_absorption_rate,
    v.exterior_wall_layer3_thermal_capacity,
    v.exterior_wall_layer3_thermal_capacity_unit,
    v.exterior_wall_layer3_thermal_conductivity,
    v.exterior_wall_layer3_thermal_conductivity_unit,
    v.exterior_wall_layer3_service_life,
    v.exterior_wall_layer3_service_life_unit,
    v.exterior_wall_layer3_density,
    v.exterior_wall_layer3_density_unit,
    v.exterior_wall_layer4_position,
    v.exterior_wall_layer4_material_id,
    v.exterior_wall_layer4_material_name,
    v.exterior_wall_layer4_thickness,
    v.exterior_wall_layer4_thickness_unit,
    v.exterior_wall_layer4_solar_absorption_rate,
    v.exterior_wall_layer4_thermal_capacity,
    v.exterior_wall_layer4_thermal_capacity_unit,
    v.exterior_wall_layer4_thermal_conductivity,
    v.exterior_wall_layer4_thermal_conductivity_unit,
    v.exterior_wall_layer4_service_life,
    v.exterior_wall_layer4_service_life_unit,
    v.exterior_wall_layer4_density,
    v.exterior_wall_layer4_density_unit,
    v.exterior_wall_layer5_position,
    v.exterior_wall_layer5_material_id,
    v.exterior_wall_layer5_material_name,
    v.exterior_wall_layer5_thickness,
    v.exterior_wall_layer5_thickness_unit,
    v.exterior_wall_layer5_solar_absorption_rate,
    v.exterior_wall_layer5_thermal_capacity,
    v.exterior_wall_layer5_thermal_capacity_unit,
    v.exterior_wall_layer5_thermal_conductivity,
    v.exterior_wall_layer5_thermal_conductivity_unit,
    v.exterior_wall_layer5_service_life,
    v.exterior_wall_layer5_service_life_unit,
    v.exterior_wall_layer5_density,
    v.exterior_wall_layer5_density_unit,
    v.exterior_wall_layer0_epd1_oekobaudat_name,
    v.exterior_wall_layer0_epd1_oekobaudat_uuid,
    v.exterior_wall_layer0_epd2_oekobaudat_name,
    v.exterior_wall_layer0_epd2_oekobaudat_uuid,
    v.exterior_wall_layer1_epd1_oekobaudat_name,
    v.exterior_wall_layer1_epd1_oekobaudat_uuid,
    v.exterior_wall_layer1_epd2_oekobaudat_name,
    v.exterior_wall_layer1_epd2_oekobaudat_uuid,
    v.exterior_wall_layer2_epd1_oekobaudat_name,
    v.exterior_wall_layer2_epd1_oekobaudat_uuid,
    v.exterior_wall_layer2_epd2_oekobaudat_name,
    v.exterior_wall_layer2_epd2_oekobaudat_uuid,
    v.exterior_wall_layer3_epd1_oekobaudat_name,
    v.exterior_wall_layer3_epd1_oekobaudat_uuid,
    v.exterior_wall_layer3_epd2_oekobaudat_name,
    v.exterior_wall_layer3_epd2_oekobaudat_uuid,
    v.exterior_wall_layer4_epd1_oekobaudat_name,
    v.exterior_wall_layer4_epd1_oekobaudat_uuid,
    v.exterior_wall_layer4_epd2_oekobaudat_name,
    v.exterior_wall_layer4_epd2_oekobaudat_uuid,
    v.exterior_wall_layer5_epd1_oekobaudat_name,
    v.exterior_wall_layer5_epd1_oekobaudat_uuid,
    v.exterior_wall_layer5_epd2_oekobaudat_name,
    v.exterior_wall_layer5_epd2_oekobaudat_uuid,
    v.interior_wall_name,
    v.interior_wall_u_value_typical_min,
    v.interior_wall_u_value_typical_max,
    v.interior_wall_u_value,
    v.interior_wall_u_value_unit,
    v.interior_wall_inner_radiation,
    v.interior_wall_inner_radiation_unit,
    v.interior_wall_inner_convection,
    v.interior_wall_inner_convection_unit,
    v.interior_wall_layer0_position,
    v.interior_wall_layer0_material_id,
    v.interior_wall_layer0_material_name,
    v.interior_wall_layer0_thickness,
    v.interior_wall_layer0_thickness_unit,
    v.interior_wall_layer0_solar_absorption_rate,
    v.interior_wall_layer0_thermal_capacity,
    v.interior_wall_layer0_thermal_capacity_unit,
    v.interior_wall_layer0_thermal_conductivity,
    v.interior_wall_layer0_thermal_conductivity_unit,
    v.interior_wall_layer0_service_life,
    v.interior_wall_layer0_service_life_unit,
    v.interior_wall_layer0_density,
    v.interior_wall_layer0_density_unit,
    v.interior_wall_layer1_position,
    v.interior_wall_layer1_material_id,
    v.interior_wall_layer1_material_name,
    v.interior_wall_layer1_thickness,
    v.interior_wall_layer1_thickness_unit,
    v.interior_wall_layer1_solar_absorption_rate,
    v.interior_wall_layer1_thermal_capacity,
    v.interior_wall_layer1_thermal_capacity_unit,
    v.interior_wall_layer1_thermal_conductivity,
    v.interior_wall_layer1_thermal_conductivity_unit,
    v.interior_wall_layer1_service_life,
    v.interior_wall_layer1_service_life_unit,
    v.interior_wall_layer1_density,
    v.interior_wall_layer1_density_unit,
    v.interior_wall_layer2_position,
    v.interior_wall_layer2_material_id,
    v.interior_wall_layer2_material_name,
    v.interior_wall_layer2_thickness,
    v.interior_wall_layer2_thickness_unit,
    v.interior_wall_layer2_solar_absorption_rate,
    v.interior_wall_layer2_thermal_capacity,
    v.interior_wall_layer2_thermal_capacity_unit,
    v.interior_wall_layer2_thermal_conductivity,
    v.interior_wall_layer2_thermal_conductivity_unit,
    v.interior_wall_layer2_service_life,
    v.interior_wall_layer2_service_life_unit,
    v.interior_wall_layer2_density,
    v.interior_wall_layer2_density_unit,
    v.interior_wall_layer0_epd1_oekobaudat_name,
    v.interior_wall_layer0_epd1_oekobaudat_uuid,
    v.interior_wall_layer0_epd2_oekobaudat_name,
    v.interior_wall_layer0_epd2_oekobaudat_uuid,
    v.interior_wall_layer1_epd1_oekobaudat_name,
    v.interior_wall_layer1_epd1_oekobaudat_uuid,
    v.interior_wall_layer1_epd2_oekobaudat_name,
    v.interior_wall_layer1_epd2_oekobaudat_uuid,
    v.interior_wall_layer2_epd1_oekobaudat_name,
    v.interior_wall_layer2_epd1_oekobaudat_uuid,
    v.interior_wall_layer2_epd2_oekobaudat_name,
    v.interior_wall_layer2_epd2_oekobaudat_uuid,
    v.roof_name,
    v.roof_construction_type,
    v.roof_pitch_type,
    v.roof_u_value_typical_min,
    v.roof_u_value_typical_max,
    v.roof_u_value,
    v.roof_u_value_unit,
    v.roof_inner_radiation,
    v.roof_inner_radiation_unit,
    v.roof_outer_radiation,
    v.roof_outer_radiation_unit,
    v.roof_inner_convection,
    v.roof_inner_convection_unit,
    v.roof_outer_convection,
    v.roof_outer_convection_unit,
    v.roof_layer0_position,
    v.roof_layer0_material_id,
    v.roof_layer0_material_name,
    v.roof_layer0_thickness,
    v.roof_layer0_thickness_unit,
    v.roof_layer0_solar_absorption_rate,
    v.roof_layer0_thermal_capacity,
    v.roof_layer0_thermal_capacity_unit,
    v.roof_layer0_thermal_conductivity,
    v.roof_layer0_thermal_conductivity_unit,
    v.roof_layer0_service_life,
    v.roof_layer0_service_life_unit,
    v.roof_layer0_density,
    v.roof_layer0_density_unit,
    v.roof_layer1_position,
    v.roof_layer1_material_id,
    v.roof_layer1_material_name,
    v.roof_layer1_thickness,
    v.roof_layer1_thickness_unit,
    v.roof_layer1_solar_absorption_rate,
    v.roof_layer1_thermal_capacity,
    v.roof_layer1_thermal_capacity_unit,
    v.roof_layer1_thermal_conductivity,
    v.roof_layer1_thermal_conductivity_unit,
    v.roof_layer1_service_life,
    v.roof_layer1_service_life_unit,
    v.roof_layer1_density,
    v.roof_layer1_density_unit,
    v.roof_layer2_position,
    v.roof_layer2_material_id,
    v.roof_layer2_material_name,
    v.roof_layer2_thickness,
    v.roof_layer2_thickness_unit,
    v.roof_layer2_solar_absorption_rate,
    v.roof_layer2_thermal_capacity,
    v.roof_layer2_thermal_capacity_unit,
    v.roof_layer2_thermal_conductivity,
    v.roof_layer2_thermal_conductivity_unit,
    v.roof_layer2_service_life,
    v.roof_layer2_service_life_unit,
    v.roof_layer2_density,
    v.roof_layer2_density_unit,
    v.roof_layer3_position,
    v.roof_layer3_material_id,
    v.roof_layer3_material_name,
    v.roof_layer3_thickness,
    v.roof_layer3_thickness_unit,
    v.roof_layer3_solar_absorption_rate,
    v.roof_layer3_thermal_capacity,
    v.roof_layer3_thermal_capacity_unit,
    v.roof_layer3_thermal_conductivity,
    v.roof_layer3_thermal_conductivity_unit,
    v.roof_layer3_service_life,
    v.roof_layer3_service_life_unit,
    v.roof_layer3_density,
    v.roof_layer3_density_unit,
    v.roof_layer4_position,
    v.roof_layer4_material_id,
    v.roof_layer4_material_name,
    v.roof_layer4_thickness,
    v.roof_layer4_thickness_unit,
    v.roof_layer4_solar_absorption_rate,
    v.roof_layer4_thermal_capacity,
    v.roof_layer4_thermal_capacity_unit,
    v.roof_layer4_thermal_conductivity,
    v.roof_layer4_thermal_conductivity_unit,
    v.roof_layer4_service_life,
    v.roof_layer4_service_life_unit,
    v.roof_layer4_density,
    v.roof_layer4_density_unit,
    v.roof_layer5_position,
    v.roof_layer5_material_id,
    v.roof_layer5_material_name,
    v.roof_layer5_thickness,
    v.roof_layer5_thickness_unit,
    v.roof_layer5_solar_absorption_rate,
    v.roof_layer5_thermal_capacity,
    v.roof_layer5_thermal_capacity_unit,
    v.roof_layer5_thermal_conductivity,
    v.roof_layer5_thermal_conductivity_unit,
    v.roof_layer5_service_life,
    v.roof_layer5_service_life_unit,
    v.roof_layer5_density,
    v.roof_layer5_density_unit,
    v.roof_layer0_epd1_oekobaudat_name,
    v.roof_layer0_epd1_oekobaudat_uuid,
    v.roof_layer0_epd2_oekobaudat_name,
    v.roof_layer0_epd2_oekobaudat_uuid,
    v.roof_layer1_epd1_oekobaudat_name,
    v.roof_layer1_epd1_oekobaudat_uuid,
    v.roof_layer1_epd2_oekobaudat_name,
    v.roof_layer1_epd2_oekobaudat_uuid,
    v.roof_layer2_epd1_oekobaudat_name,
    v.roof_layer2_epd1_oekobaudat_uuid,
    v.roof_layer2_epd2_oekobaudat_name,
    v.roof_layer2_epd2_oekobaudat_uuid,
    v.roof_layer3_epd1_oekobaudat_name,
    v.roof_layer3_epd1_oekobaudat_uuid,
    v.roof_layer3_epd2_oekobaudat_name,
    v.roof_layer3_epd2_oekobaudat_uuid,
    v.roof_layer4_epd1_oekobaudat_name,
    v.roof_layer4_epd1_oekobaudat_uuid,
    v.roof_layer4_epd2_oekobaudat_name,
    v.roof_layer4_epd2_oekobaudat_uuid,
    v.roof_layer5_epd1_oekobaudat_name,
    v.roof_layer5_epd1_oekobaudat_uuid,
    v.roof_layer5_epd2_oekobaudat_name,
    v.roof_layer5_epd2_oekobaudat_uuid,
    v.foundation_name,
    v.foundation_construction_type,
    v.foundation_u_value_typical_min,
    v.foundation_u_value_typical_max,
    v.foundation_u_value,
    v.foundation_u_value_unit,
    v.foundation_inner_radiation,
    v.foundation_inner_radiation_unit,
    v.foundation_inner_convection,
    v.foundation_inner_convection_unit,
    v.foundation_layer0_position,
    v.foundation_layer0_material_id,
    v.foundation_layer0_material_name,
    v.foundation_layer0_thickness,
    v.foundation_layer0_thickness_unit,
    v.foundation_layer0_solar_absorption_rate,
    v.foundation_layer0_thermal_capacity,
    v.foundation_layer0_thermal_capacity_unit,
    v.foundation_layer0_thermal_conductivity,
    v.foundation_layer0_thermal_conductivity_unit,
    v.foundation_layer0_service_life,
    v.foundation_layer0_service_life_unit,
    v.foundation_layer0_density,
    v.foundation_layer0_density_unit,
    v.foundation_layer1_position,
    v.foundation_layer1_material_id,
    v.foundation_layer1_material_name,
    v.foundation_layer1_thickness,
    v.foundation_layer1_thickness_unit,
    v.foundation_layer1_solar_absorption_rate,
    v.foundation_layer1_thermal_capacity,
    v.foundation_layer1_thermal_capacity_unit,
    v.foundation_layer1_thermal_conductivity,
    v.foundation_layer1_thermal_conductivity_unit,
    v.foundation_layer1_service_life,
    v.foundation_layer1_service_life_unit,
    v.foundation_layer1_density,
    v.foundation_layer1_density_unit,
    v.foundation_layer2_position,
    v.foundation_layer2_material_id,
    v.foundation_layer2_material_name,
    v.foundation_layer2_thickness,
    v.foundation_layer2_thickness_unit,
    v.foundation_layer2_solar_absorption_rate,
    v.foundation_layer2_thermal_capacity,
    v.foundation_layer2_thermal_capacity_unit,
    v.foundation_layer2_thermal_conductivity,
    v.foundation_layer2_thermal_conductivity_unit,
    v.foundation_layer2_service_life,
    v.foundation_layer2_service_life_unit,
    v.foundation_layer2_density,
    v.foundation_layer2_density_unit,
    v.foundation_layer3_position,
    v.foundation_layer3_material_id,
    v.foundation_layer3_material_name,
    v.foundation_layer3_thickness,
    v.foundation_layer3_thickness_unit,
    v.foundation_layer3_solar_absorption_rate,
    v.foundation_layer3_thermal_capacity,
    v.foundation_layer3_thermal_capacity_unit,
    v.foundation_layer3_thermal_conductivity,
    v.foundation_layer3_thermal_conductivity_unit,
    v.foundation_layer3_service_life,
    v.foundation_layer3_service_life_unit,
    v.foundation_layer3_density,
    v.foundation_layer3_density_unit,
    v.foundation_layer4_position,
    v.foundation_layer4_material_id,
    v.foundation_layer4_material_name,
    v.foundation_layer4_thickness,
    v.foundation_layer4_thickness_unit,
    v.foundation_layer4_solar_absorption_rate,
    v.foundation_layer4_thermal_capacity,
    v.foundation_layer4_thermal_capacity_unit,
    v.foundation_layer4_thermal_conductivity,
    v.foundation_layer4_thermal_conductivity_unit,
    v.foundation_layer4_service_life,
    v.foundation_layer4_service_life_unit,
    v.foundation_layer4_density,
    v.foundation_layer4_density_unit,
    v.foundation_layer5_position,
    v.foundation_layer5_material_id,
    v.foundation_layer5_material_name,
    v.foundation_layer5_thickness,
    v.foundation_layer5_thickness_unit,
    v.foundation_layer5_solar_absorption_rate,
    v.foundation_layer5_thermal_capacity,
    v.foundation_layer5_thermal_capacity_unit,
    v.foundation_layer5_thermal_conductivity,
    v.foundation_layer5_thermal_conductivity_unit,
    v.foundation_layer5_service_life,
    v.foundation_layer5_service_life_unit,
    v.foundation_layer5_density,
    v.foundation_layer5_density_unit,
    v.foundation_layer0_epd1_oekobaudat_name,
    v.foundation_layer0_epd1_oekobaudat_uuid,
    v.foundation_layer0_epd2_oekobaudat_name,
    v.foundation_layer0_epd2_oekobaudat_uuid,
    v.foundation_layer1_epd1_oekobaudat_name,
    v.foundation_layer1_epd1_oekobaudat_uuid,
    v.foundation_layer1_epd2_oekobaudat_name,
    v.foundation_layer1_epd2_oekobaudat_uuid,
    v.foundation_layer2_epd1_oekobaudat_name,
    v.foundation_layer2_epd1_oekobaudat_uuid,
    v.foundation_layer2_epd2_oekobaudat_name,
    v.foundation_layer2_epd2_oekobaudat_uuid,
    v.foundation_layer3_epd1_oekobaudat_name,
    v.foundation_layer3_epd1_oekobaudat_uuid,
    v.foundation_layer3_epd2_oekobaudat_name,
    v.foundation_layer3_epd2_oekobaudat_uuid,
    v.foundation_layer4_epd1_oekobaudat_name,
    v.foundation_layer4_epd1_oekobaudat_uuid,
    v.foundation_layer4_epd2_oekobaudat_name,
    v.foundation_layer4_epd2_oekobaudat_uuid,
    v.foundation_layer5_epd1_oekobaudat_name,
    v.foundation_layer5_epd1_oekobaudat_uuid,
    v.foundation_layer5_epd2_oekobaudat_name,
    v.foundation_layer5_epd2_oekobaudat_uuid,
    v.floor_name,
    v.floor_u_value_typical_min,
    v.floor_u_value_typical_max,
    v.floor_u_value,
    v.floor_u_value_unit,
    v.floor_inner_radiation,
    v.floor_inner_radiation_unit,
    v.floor_inner_convection,
    v.floor_inner_convection_unit,
    v.floor_layer0_position,
    v.floor_layer0_material_id,
    v.floor_layer0_material_name,
    v.floor_layer0_thickness,
    v.floor_layer0_thickness_unit,
    v.floor_layer0_solar_absorption_rate,
    v.floor_layer0_thermal_capacity,
    v.floor_layer0_thermal_capacity_unit,
    v.floor_layer0_thermal_conductivity,
    v.floor_layer0_thermal_conductivity_unit,
    v.floor_layer0_service_life,
    v.floor_layer0_service_life_unit,
    v.floor_layer0_density,
    v.floor_layer0_density_unit,
    v.floor_layer1_position,
    v.floor_layer1_material_id,
    v.floor_layer1_material_name,
    v.floor_layer1_thickness,
    v.floor_layer1_thickness_unit,
    v.floor_layer1_solar_absorption_rate,
    v.floor_layer1_thermal_capacity,
    v.floor_layer1_thermal_capacity_unit,
    v.floor_layer1_thermal_conductivity,
    v.floor_layer1_thermal_conductivity_unit,
    v.floor_layer1_service_life,
    v.floor_layer1_service_life_unit,
    v.floor_layer1_density,
    v.floor_layer1_density_unit,
    v.floor_layer2_position,
    v.floor_layer2_material_id,
    v.floor_layer2_material_name,
    v.floor_layer2_thickness,
    v.floor_layer2_thickness_unit,
    v.floor_layer2_solar_absorption_rate,
    v.floor_layer2_thermal_capacity,
    v.floor_layer2_thermal_capacity_unit,
    v.floor_layer2_thermal_conductivity,
    v.floor_layer2_thermal_conductivity_unit,
    v.floor_layer2_service_life,
    v.floor_layer2_service_life_unit,
    v.floor_layer2_density,
    v.floor_layer2_density_unit,
    v.floor_layer0_epd1_oekobaudat_name,
    v.floor_layer0_epd1_oekobaudat_uuid,
    v.floor_layer0_epd2_oekobaudat_name,
    v.floor_layer0_epd2_oekobaudat_uuid,
    v.floor_layer1_epd1_oekobaudat_name,
    v.floor_layer1_epd1_oekobaudat_uuid,
    v.floor_layer1_epd2_oekobaudat_name,
    v.floor_layer1_epd2_oekobaudat_uuid,
    v.floor_layer2_epd1_oekobaudat_name,
    v.floor_layer2_epd1_oekobaudat_uuid,
    v.floor_layer2_epd2_oekobaudat_name,
    v.floor_layer2_epd2_oekobaudat_uuid,
    v.window_name,
    v.window_inner_radiation,
    v.window_inner_radiation_unit,
    v.window_outer_radiation,
    v.window_outer_radiation_unit,
    v.window_inner_convection,
    v.window_inner_convection_unit,
    v.window_outer_convection,
    v.window_outer_convection_unit,
    v.glazing,
    v.frame_per_window,
    v.frame_per_window_unit,
    v.window_frame_area_share,
    v.g_value,
    v.a_conv,
    v.shading_type_name,
    v.window_frame_type_name,
    v.window_layer0_position,
    v.window_layer0_material_id,
    v.window_layer0_material_name,
    v.window_layer0_thickness,
    v.window_layer0_thickness_unit,
    v.window_layer0_solar_absorption_rate,
    v.window_layer0_thermal_capacity,
    v.window_layer0_thermal_capacity_unit,
    v.window_layer0_thermal_conductivity,
    v.window_layer0_thermal_conductivity_unit,
    v.window_layer0_service_life,
    v.window_layer0_service_life_unit,
    v.window_layer1_position,
    v.window_layer1_material_id,
    v.window_layer1_material_name,
    v.window_layer1_thickness,
    v.window_layer1_thickness_unit,
    v.window_layer1_solar_absorption_rate,
    v.window_layer1_thermal_capacity,
    v.window_layer1_thermal_capacity_unit,
    v.window_layer1_thermal_conductivity,
    v.window_layer1_thermal_conductivity_unit,
    v.window_layer1_service_life,
    v.window_layer1_service_life_unit,
    v.window_layer2_position,
    v.window_layer2_material_id,
    v.window_layer2_material_name,
    v.window_layer2_thickness,
    v.window_layer2_thickness_unit,
    v.window_layer2_solar_absorption_rate,
    v.window_layer2_thermal_capacity,
    v.window_layer2_thermal_capacity_unit,
    v.window_layer2_thermal_conductivity,
    v.window_layer2_thermal_conductivity_unit,
    v.window_layer2_service_life,
    v.window_layer2_service_life_unit,
    v.window_layer0_epd1_oekobaudat_name,
    v.window_layer0_epd1_oekobaudat_uuid,
    v.window_layer0_epd2_oekobaudat_name,
    v.window_layer0_epd2_oekobaudat_uuid,
    v.window_layer1_epd1_oekobaudat_name,
    v.window_layer1_epd1_oekobaudat_uuid,
    v.window_layer1_epd2_oekobaudat_name,
    v.window_layer1_epd2_oekobaudat_uuid,
    v.window_layer2_epd1_oekobaudat_name,
    v.window_layer2_epd1_oekobaudat_uuid,
    v.window_layer2_epd2_oekobaudat_name,
    v.window_layer2_epd2_oekobaudat_uuid,
    v.energy_system_name,
    v.converter_0_id,
    v.converter_0_energy_converter_name,
    v.converter_1_id,
    v.converter_1_energy_converter_name,
    v.converter_0_nominal_power_min,
    v.converter_0_nominal_power_max,
    v.converter_0_nominal_power_unit,
    v.converter_1_nominal_power_min,
    v.converter_1_nominal_power_max,
    v.converter_1_nominal_power_unit,
    v.converter_0_area,
    v.converter_0_area_unit,
    v.converter_1_area,
    v.converter_1_area_unit,
    v.converter_0_supply_function_name,
    v.converter_1_supply_function_name,
    v.converter_0_energy_source_name,
    v.converter_1_energy_source_name,
    v.converter_0_service_life,
    v.converter_0_service_life_unit,
    v.converter_1_service_life,
    v.converter_1_service_life_unit,
    v.converter_0_epd_1_id,
    v.converter_0_epd_1_name,
    v.converter_0_epd_1_database_uuid,
    v.converter_0_epd_2_id,
    v.converter_0_epd_2_name,
    v.converter_0_epd_2_database_uuid,
    v.converter_0_energy_source_epd_id,
    v.converter_0_energy_source_epd_name,
    v.converter_0_energy_source_epd_database_uuid,
    v.converter_1_epd_1_id,
    v.converter_1_epd_1_name,
    v.converter_1_epd_1_database_uuid,
    v.converter_1_epd_2_id,
    v.converter_1_epd_2_name,
    v.converter_1_epd_2_database_uuid,
    v.converter_1_energy_source_epd_id,
    v.converter_1_energy_source_epd_name,
    v.converter_1_energy_source_epd_database_uuid,
    v.bmp_building_archetype_id,
    v.heat_useful_total_mean_value,
    v.heat_useful_total_median_value,
    v.heat_useful_total_std_dev,
    v.heat_useful_total_min_value,
    v.heat_useful_total_max_value,
    v.heat_useful_total_p05_value,
    v.heat_useful_total_p25_value,
    v.heat_useful_total_p75_value,
    v.heat_useful_total_p95_value,
    v.heat_useful_total_se_mean,
    v.heat_useful_total_cv,
    v.heat_useful_per_m2_mean_value,
    v.heat_useful_per_m2_median_value,
    v.heat_useful_per_m2_std_dev,
    v.heat_useful_per_m2_min_value,
    v.heat_useful_per_m2_max_value,
    v.heat_useful_per_m2_p05_value,
    v.heat_useful_per_m2_p25_value,
    v.heat_useful_per_m2_p75_value,
    v.heat_useful_per_m2_p95_value,
    v.heat_useful_per_m2_se_mean,
    v.heat_useful_per_m2_cv,
    v.gwp_a1_a3_mean_value,
    v.gwp_a1_a3_median_value,
    v.gwp_a1_a3_std_dev,
    v.gwp_a1_a3_min_value,
    v.gwp_a1_a3_max_value,
    v.gwp_a1_a3_p05_value,
    v.gwp_a1_a3_p25_value,
    v.gwp_a1_a3_p75_value,
    v.gwp_a1_a3_p95_value,
    v.gwp_a1_a3_se_mean,
    v.gwp_a1_a3_cv,
    v.gwp_a4_mean_value,
    v.gwp_a4_median_value,
    v.gwp_a4_std_dev,
    v.gwp_a4_min_value,
    v.gwp_a4_max_value,
    v.gwp_a4_p05_value,
    v.gwp_a4_p25_value,
    v.gwp_a4_p75_value,
    v.gwp_a4_p95_value,
    v.gwp_a4_se_mean,
    v.gwp_a4_cv,
    v.gwp_a5_mean_value,
    v.gwp_a5_median_value,
    v.gwp_a5_std_dev,
    v.gwp_a5_min_value,
    v.gwp_a5_max_value,
    v.gwp_a5_p05_value,
    v.gwp_a5_p25_value,
    v.gwp_a5_p75_value,
    v.gwp_a5_p95_value,
    v.gwp_a5_se_mean,
    v.gwp_a5_cv,
    v.gwp_b1_mean_value,
    v.gwp_b1_median_value,
    v.gwp_b1_std_dev,
    v.gwp_b1_min_value,
    v.gwp_b1_max_value,
    v.gwp_b1_p05_value,
    v.gwp_b1_p25_value,
    v.gwp_b1_p75_value,
    v.gwp_b1_p95_value,
    v.gwp_b1_se_mean,
    v.gwp_b1_cv,
    v.gwp_b2_mean_value,
    v.gwp_b2_median_value,
    v.gwp_b2_std_dev,
    v.gwp_b2_min_value,
    v.gwp_b2_max_value,
    v.gwp_b2_p05_value,
    v.gwp_b2_p25_value,
    v.gwp_b2_p75_value,
    v.gwp_b2_p95_value,
    v.gwp_b2_se_mean,
    v.gwp_b2_cv,
    v.gwp_b3_mean_value,
    v.gwp_b3_median_value,
    v.gwp_b3_std_dev,
    v.gwp_b3_min_value,
    v.gwp_b3_max_value,
    v.gwp_b3_p05_value,
    v.gwp_b3_p25_value,
    v.gwp_b3_p75_value,
    v.gwp_b3_p95_value,
    v.gwp_b3_se_mean,
    v.gwp_b3_cv,
    v.gwp_b4_mean_value,
    v.gwp_b4_median_value,
    v.gwp_b4_std_dev,
    v.gwp_b4_min_value,
    v.gwp_b4_max_value,
    v.gwp_b4_p05_value,
    v.gwp_b4_p25_value,
    v.gwp_b4_p75_value,
    v.gwp_b4_p95_value,
    v.gwp_b4_se_mean,
    v.gwp_b4_cv,
    v.gwp_b5_mean_value,
    v.gwp_b5_median_value,
    v.gwp_b5_std_dev,
    v.gwp_b5_min_value,
    v.gwp_b5_max_value,
    v.gwp_b5_p05_value,
    v.gwp_b5_p25_value,
    v.gwp_b5_p75_value,
    v.gwp_b5_p95_value,
    v.gwp_b5_se_mean,
    v.gwp_b5_cv,
    v.gwp_b6_mean_value,
    v.gwp_b6_median_value,
    v.gwp_b6_std_dev,
    v.gwp_b6_min_value,
    v.gwp_b6_max_value,
    v.gwp_b6_p05_value,
    v.gwp_b6_p25_value,
    v.gwp_b6_p75_value,
    v.gwp_b6_p95_value,
    v.gwp_b6_se_mean,
    v.gwp_b6_cv,
    v.gwp_b7_mean_value,
    v.gwp_b7_median_value,
    v.gwp_b7_std_dev,
    v.gwp_b7_min_value,
    v.gwp_b7_max_value,
    v.gwp_b7_p05_value,
    v.gwp_b7_p25_value,
    v.gwp_b7_p75_value,
    v.gwp_b7_p95_value,
    v.gwp_b7_se_mean,
    v.gwp_b7_cv,
    v.gwp_c1_mean_value,
    v.gwp_c1_median_value,
    v.gwp_c1_std_dev,
    v.gwp_c1_min_value,
    v.gwp_c1_max_value,
    v.gwp_c1_p05_value,
    v.gwp_c1_p25_value,
    v.gwp_c1_p75_value,
    v.gwp_c1_p95_value,
    v.gwp_c1_se_mean,
    v.gwp_c1_cv,
    v.gwp_c2_mean_value,
    v.gwp_c2_median_value,
    v.gwp_c2_std_dev,
    v.gwp_c2_min_value,
    v.gwp_c2_max_value,
    v.gwp_c2_p05_value,
    v.gwp_c2_p25_value,
    v.gwp_c2_p75_value,
    v.gwp_c2_p95_value,
    v.gwp_c2_se_mean,
    v.gwp_c2_cv,
    v.gwp_c3_mean_value,
    v.gwp_c3_median_value,
    v.gwp_c3_std_dev,
    v.gwp_c3_min_value,
    v.gwp_c3_max_value,
    v.gwp_c3_p05_value,
    v.gwp_c3_p25_value,
    v.gwp_c3_p75_value,
    v.gwp_c3_p95_value,
    v.gwp_c3_se_mean,
    v.gwp_c3_cv,
    v.gwp_c4_mean_value,
    v.gwp_c4_median_value,
    v.gwp_c4_std_dev,
    v.gwp_c4_min_value,
    v.gwp_c4_max_value,
    v.gwp_c4_p05_value,
    v.gwp_c4_p25_value,
    v.gwp_c4_p75_value,
    v.gwp_c4_p95_value,
    v.gwp_c4_se_mean,
    v.gwp_c4_cv,
    v.gwp_d_mean_value,
    v.gwp_d_median_value,
    v.gwp_d_std_dev,
    v.gwp_d_min_value,
    v.gwp_d_max_value,
    v.gwp_d_p05_value,
    v.gwp_d_p25_value,
    v.gwp_d_p75_value,
    v.gwp_d_p95_value,
    v.gwp_d_se_mean,
    v.gwp_d_cv,
    v.gwp_lifecycle_mean_value,
    v.gwp_lifecycle_median_value,
    v.gwp_lifecycle_std_dev,
    v.gwp_lifecycle_min_value,
    v.gwp_lifecycle_max_value,
    v.gwp_lifecycle_p05_value,
    v.gwp_lifecycle_p25_value,
    v.gwp_lifecycle_p75_value,
    v.gwp_lifecycle_p95_value,
    v.gwp_lifecycle_se_mean,
    v.gwp_lifecycle_cv,
    v.gwp_lifecycle_no_d_mean_value,
    v.gwp_lifecycle_no_d_median_value,
    v.gwp_lifecycle_no_d_std_dev,
    v.gwp_lifecycle_no_d_min_value,
    v.gwp_lifecycle_no_d_max_value,
    v.gwp_lifecycle_no_d_p05_value,
    v.gwp_lifecycle_no_d_p25_value,
    v.gwp_lifecycle_no_d_p75_value,
    v.gwp_lifecycle_no_d_p95_value,
    v.gwp_lifecycle_no_d_se_mean,
    v.gwp_lifecycle_no_d_cv,
    v.gwp_a1_a3_per_m2_mean_value,
    v.gwp_a1_a3_per_m2_median_value,
    v.gwp_a1_a3_per_m2_std_dev,
    v.gwp_a1_a3_per_m2_min_value,
    v.gwp_a1_a3_per_m2_max_value,
    v.gwp_a1_a3_per_m2_p05_value,
    v.gwp_a1_a3_per_m2_p25_value,
    v.gwp_a1_a3_per_m2_p75_value,
    v.gwp_a1_a3_per_m2_p95_value,
    v.gwp_a1_a3_per_m2_se_mean,
    v.gwp_a1_a3_per_m2_cv,
    v.gwp_a4_per_m2_mean_value,
    v.gwp_a4_per_m2_median_value,
    v.gwp_a4_per_m2_std_dev,
    v.gwp_a4_per_m2_min_value,
    v.gwp_a4_per_m2_max_value,
    v.gwp_a4_per_m2_p05_value,
    v.gwp_a4_per_m2_p25_value,
    v.gwp_a4_per_m2_p75_value,
    v.gwp_a4_per_m2_p95_value,
    v.gwp_a4_per_m2_se_mean,
    v.gwp_a4_per_m2_cv,
    v.gwp_a5_per_m2_mean_value,
    v.gwp_a5_per_m2_median_value,
    v.gwp_a5_per_m2_std_dev,
    v.gwp_a5_per_m2_min_value,
    v.gwp_a5_per_m2_max_value,
    v.gwp_a5_per_m2_p05_value,
    v.gwp_a5_per_m2_p25_value,
    v.gwp_a5_per_m2_p75_value,
    v.gwp_a5_per_m2_p95_value,
    v.gwp_a5_per_m2_se_mean,
    v.gwp_a5_per_m2_cv,
    v.gwp_b1_per_m2_mean_value,
    v.gwp_b1_per_m2_median_value,
    v.gwp_b1_per_m2_std_dev,
    v.gwp_b1_per_m2_min_value,
    v.gwp_b1_per_m2_max_value,
    v.gwp_b1_per_m2_p05_value,
    v.gwp_b1_per_m2_p25_value,
    v.gwp_b1_per_m2_p75_value,
    v.gwp_b1_per_m2_p95_value,
    v.gwp_b1_per_m2_se_mean,
    v.gwp_b1_per_m2_cv,
    v.gwp_b2_per_m2_mean_value,
    v.gwp_b2_per_m2_median_value,
    v.gwp_b2_per_m2_std_dev,
    v.gwp_b2_per_m2_min_value,
    v.gwp_b2_per_m2_max_value,
    v.gwp_b2_per_m2_p05_value,
    v.gwp_b2_per_m2_p25_value,
    v.gwp_b2_per_m2_p75_value,
    v.gwp_b2_per_m2_p95_value,
    v.gwp_b2_per_m2_se_mean,
    v.gwp_b2_per_m2_cv,
    v.gwp_b3_per_m2_mean_value,
    v.gwp_b3_per_m2_median_value,
    v.gwp_b3_per_m2_std_dev,
    v.gwp_b3_per_m2_min_value,
    v.gwp_b3_per_m2_max_value,
    v.gwp_b3_per_m2_p05_value,
    v.gwp_b3_per_m2_p25_value,
    v.gwp_b3_per_m2_p75_value,
    v.gwp_b3_per_m2_p95_value,
    v.gwp_b3_per_m2_se_mean,
    v.gwp_b3_per_m2_cv,
    v.gwp_b4_per_m2_mean_value,
    v.gwp_b4_per_m2_median_value,
    v.gwp_b4_per_m2_std_dev,
    v.gwp_b4_per_m2_min_value,
    v.gwp_b4_per_m2_max_value,
    v.gwp_b4_per_m2_p05_value,
    v.gwp_b4_per_m2_p25_value,
    v.gwp_b4_per_m2_p75_value,
    v.gwp_b4_per_m2_p95_value,
    v.gwp_b4_per_m2_se_mean,
    v.gwp_b4_per_m2_cv,
    v.gwp_b5_per_m2_mean_value,
    v.gwp_b5_per_m2_median_value,
    v.gwp_b5_per_m2_std_dev,
    v.gwp_b5_per_m2_min_value,
    v.gwp_b5_per_m2_max_value,
    v.gwp_b5_per_m2_p05_value,
    v.gwp_b5_per_m2_p25_value,
    v.gwp_b5_per_m2_p75_value,
    v.gwp_b5_per_m2_p95_value,
    v.gwp_b5_per_m2_se_mean,
    v.gwp_b5_per_m2_cv,
    v.gwp_b6_per_m2_mean_value,
    v.gwp_b6_per_m2_median_value,
    v.gwp_b6_per_m2_std_dev,
    v.gwp_b6_per_m2_min_value,
    v.gwp_b6_per_m2_max_value,
    v.gwp_b6_per_m2_p05_value,
    v.gwp_b6_per_m2_p25_value,
    v.gwp_b6_per_m2_p75_value,
    v.gwp_b6_per_m2_p95_value,
    v.gwp_b6_per_m2_se_mean,
    v.gwp_b6_per_m2_cv,
    v.gwp_b7_per_m2_mean_value,
    v.gwp_b7_per_m2_median_value,
    v.gwp_b7_per_m2_std_dev,
    v.gwp_b7_per_m2_min_value,
    v.gwp_b7_per_m2_max_value,
    v.gwp_b7_per_m2_p05_value,
    v.gwp_b7_per_m2_p25_value,
    v.gwp_b7_per_m2_p75_value,
    v.gwp_b7_per_m2_p95_value,
    v.gwp_b7_per_m2_se_mean,
    v.gwp_b7_per_m2_cv,
    v.gwp_c1_per_m2_mean_value,
    v.gwp_c1_per_m2_median_value,
    v.gwp_c1_per_m2_std_dev,
    v.gwp_c1_per_m2_min_value,
    v.gwp_c1_per_m2_max_value,
    v.gwp_c1_per_m2_p05_value,
    v.gwp_c1_per_m2_p25_value,
    v.gwp_c1_per_m2_p75_value,
    v.gwp_c1_per_m2_p95_value,
    v.gwp_c1_per_m2_se_mean,
    v.gwp_c1_per_m2_cv,
    v.gwp_c2_per_m2_mean_value,
    v.gwp_c2_per_m2_median_value,
    v.gwp_c2_per_m2_std_dev,
    v.gwp_c2_per_m2_min_value,
    v.gwp_c2_per_m2_max_value,
    v.gwp_c2_per_m2_p05_value,
    v.gwp_c2_per_m2_p25_value,
    v.gwp_c2_per_m2_p75_value,
    v.gwp_c2_per_m2_p95_value,
    v.gwp_c2_per_m2_se_mean,
    v.gwp_c2_per_m2_cv,
    v.gwp_c3_per_m2_mean_value,
    v.gwp_c3_per_m2_median_value,
    v.gwp_c3_per_m2_std_dev,
    v.gwp_c3_per_m2_min_value,
    v.gwp_c3_per_m2_max_value,
    v.gwp_c3_per_m2_p05_value,
    v.gwp_c3_per_m2_p25_value,
    v.gwp_c3_per_m2_p75_value,
    v.gwp_c3_per_m2_p95_value,
    v.gwp_c3_per_m2_se_mean,
    v.gwp_c3_per_m2_cv,
    v.gwp_c4_per_m2_mean_value,
    v.gwp_c4_per_m2_median_value,
    v.gwp_c4_per_m2_std_dev,
    v.gwp_c4_per_m2_min_value,
    v.gwp_c4_per_m2_max_value,
    v.gwp_c4_per_m2_p05_value,
    v.gwp_c4_per_m2_p25_value,
    v.gwp_c4_per_m2_p75_value,
    v.gwp_c4_per_m2_p95_value,
    v.gwp_c4_per_m2_se_mean,
    v.gwp_c4_per_m2_cv,
    v.gwp_d_per_m2_mean_value,
    v.gwp_d_per_m2_median_value,
    v.gwp_d_per_m2_std_dev,
    v.gwp_d_per_m2_min_value,
    v.gwp_d_per_m2_max_value,
    v.gwp_d_per_m2_p05_value,
    v.gwp_d_per_m2_p25_value,
    v.gwp_d_per_m2_p75_value,
    v.gwp_d_per_m2_p95_value,
    v.gwp_d_per_m2_se_mean,
    v.gwp_d_per_m2_cv,
    v.gwp_lifecycle_per_m2_mean_value,
    v.gwp_lifecycle_per_m2_median_value,
    v.gwp_lifecycle_per_m2_std_dev,
    v.gwp_lifecycle_per_m2_min_value,
    v.gwp_lifecycle_per_m2_max_value,
    v.gwp_lifecycle_per_m2_p05_value,
    v.gwp_lifecycle_per_m2_p25_value,
    v.gwp_lifecycle_per_m2_p75_value,
    v.gwp_lifecycle_per_m2_p95_value,
    v.gwp_lifecycle_per_m2_se_mean,
    v.gwp_lifecycle_per_m2_cv,
    v.gwp_lifecycle_no_d_per_m2_mean_value,
    v.gwp_lifecycle_no_d_per_m2_median_value,
    v.gwp_lifecycle_no_d_per_m2_std_dev,
    v.gwp_lifecycle_no_d_per_m2_min_value,
    v.gwp_lifecycle_no_d_per_m2_max_value,
    v.gwp_lifecycle_no_d_per_m2_p05_value,
    v.gwp_lifecycle_no_d_per_m2_p25_value,
    v.gwp_lifecycle_no_d_per_m2_p75_value,
    v.gwp_lifecycle_no_d_per_m2_p95_value,
    v.gwp_lifecycle_no_d_per_m2_se_mean,
    v.gwp_lifecycle_no_d_per_m2_cv,
    v.emp_building_archetype_id,
    v.gwp_lifecycle_exterior_wall_mean_value,
    v.gwp_lifecycle_exterior_wall_median_value,
    v.gwp_lifecycle_exterior_wall_std_dev,
    v.gwp_lifecycle_exterior_wall_min_value,
    v.gwp_lifecycle_exterior_wall_max_value,
    v.gwp_lifecycle_exterior_wall_p05_value,
    v.gwp_lifecycle_exterior_wall_p25_value,
    v.gwp_lifecycle_exterior_wall_p75_value,
    v.gwp_lifecycle_exterior_wall_p95_value,
    v.gwp_lifecycle_exterior_wall_se_mean,
    v.gwp_lifecycle_exterior_wall_cv,
    v.gwp_lifecycle_roof_mean_value,
    v.gwp_lifecycle_roof_median_value,
    v.gwp_lifecycle_roof_std_dev,
    v.gwp_lifecycle_roof_min_value,
    v.gwp_lifecycle_roof_max_value,
    v.gwp_lifecycle_roof_p05_value,
    v.gwp_lifecycle_roof_p25_value,
    v.gwp_lifecycle_roof_p75_value,
    v.gwp_lifecycle_roof_p95_value,
    v.gwp_lifecycle_roof_se_mean,
    v.gwp_lifecycle_roof_cv,
    v.gwp_lifecycle_foundation_mean_value,
    v.gwp_lifecycle_foundation_median_value,
    v.gwp_lifecycle_foundation_std_dev,
    v.gwp_lifecycle_foundation_min_value,
    v.gwp_lifecycle_foundation_max_value,
    v.gwp_lifecycle_foundation_p05_value,
    v.gwp_lifecycle_foundation_p25_value,
    v.gwp_lifecycle_foundation_p75_value,
    v.gwp_lifecycle_foundation_p95_value,
    v.gwp_lifecycle_foundation_se_mean,
    v.gwp_lifecycle_foundation_cv,
    v.gwp_lifecycle_floor_mean_value,
    v.gwp_lifecycle_floor_median_value,
    v.gwp_lifecycle_floor_std_dev,
    v.gwp_lifecycle_floor_min_value,
    v.gwp_lifecycle_floor_max_value,
    v.gwp_lifecycle_floor_p05_value,
    v.gwp_lifecycle_floor_p25_value,
    v.gwp_lifecycle_floor_p75_value,
    v.gwp_lifecycle_floor_p95_value,
    v.gwp_lifecycle_floor_se_mean,
    v.gwp_lifecycle_floor_cv,
    v.gwp_lifecycle_window_mean_value,
    v.gwp_lifecycle_window_median_value,
    v.gwp_lifecycle_window_std_dev,
    v.gwp_lifecycle_window_min_value,
    v.gwp_lifecycle_window_max_value,
    v.gwp_lifecycle_window_p05_value,
    v.gwp_lifecycle_window_p25_value,
    v.gwp_lifecycle_window_p75_value,
    v.gwp_lifecycle_window_p95_value,
    v.gwp_lifecycle_window_se_mean,
    v.gwp_lifecycle_window_cv,
    v.gwp_lifecycle_interior_wall_mean_value,
    v.gwp_lifecycle_interior_wall_median_value,
    v.gwp_lifecycle_interior_wall_std_dev,
    v.gwp_lifecycle_interior_wall_min_value,
    v.gwp_lifecycle_interior_wall_max_value,
    v.gwp_lifecycle_interior_wall_p05_value,
    v.gwp_lifecycle_interior_wall_p25_value,
    v.gwp_lifecycle_interior_wall_p75_value,
    v.gwp_lifecycle_interior_wall_p95_value,
    v.gwp_lifecycle_interior_wall_se_mean,
    v.gwp_lifecycle_interior_wall_cv,
    v.gwp_lifecycle_no_d_exterior_wall_mean_value,
    v.gwp_lifecycle_no_d_exterior_wall_median_value,
    v.gwp_lifecycle_no_d_exterior_wall_std_dev,
    v.gwp_lifecycle_no_d_exterior_wall_min_value,
    v.gwp_lifecycle_no_d_exterior_wall_max_value,
    v.gwp_lifecycle_no_d_exterior_wall_p05_value,
    v.gwp_lifecycle_no_d_exterior_wall_p25_value,
    v.gwp_lifecycle_no_d_exterior_wall_p75_value,
    v.gwp_lifecycle_no_d_exterior_wall_p95_value,
    v.gwp_lifecycle_no_d_exterior_wall_se_mean,
    v.gwp_lifecycle_no_d_exterior_wall_cv,
    v.gwp_lifecycle_no_d_roof_mean_value,
    v.gwp_lifecycle_no_d_roof_median_value,
    v.gwp_lifecycle_no_d_roof_std_dev,
    v.gwp_lifecycle_no_d_roof_min_value,
    v.gwp_lifecycle_no_d_roof_max_value,
    v.gwp_lifecycle_no_d_roof_p05_value,
    v.gwp_lifecycle_no_d_roof_p25_value,
    v.gwp_lifecycle_no_d_roof_p75_value,
    v.gwp_lifecycle_no_d_roof_p95_value,
    v.gwp_lifecycle_no_d_roof_se_mean,
    v.gwp_lifecycle_no_d_roof_cv,
    v.gwp_lifecycle_no_d_foundation_mean_value,
    v.gwp_lifecycle_no_d_foundation_median_value,
    v.gwp_lifecycle_no_d_foundation_std_dev,
    v.gwp_lifecycle_no_d_foundation_min_value,
    v.gwp_lifecycle_no_d_foundation_max_value,
    v.gwp_lifecycle_no_d_foundation_p05_value,
    v.gwp_lifecycle_no_d_foundation_p25_value,
    v.gwp_lifecycle_no_d_foundation_p75_value,
    v.gwp_lifecycle_no_d_foundation_p95_value,
    v.gwp_lifecycle_no_d_foundation_se_mean,
    v.gwp_lifecycle_no_d_foundation_cv,
    v.gwp_lifecycle_no_d_floor_mean_value,
    v.gwp_lifecycle_no_d_floor_median_value,
    v.gwp_lifecycle_no_d_floor_std_dev,
    v.gwp_lifecycle_no_d_floor_min_value,
    v.gwp_lifecycle_no_d_floor_max_value,
    v.gwp_lifecycle_no_d_floor_p05_value,
    v.gwp_lifecycle_no_d_floor_p25_value,
    v.gwp_lifecycle_no_d_floor_p75_value,
    v.gwp_lifecycle_no_d_floor_p95_value,
    v.gwp_lifecycle_no_d_floor_se_mean,
    v.gwp_lifecycle_no_d_floor_cv,
    v.gwp_lifecycle_no_d_window_mean_value,
    v.gwp_lifecycle_no_d_window_median_value,
    v.gwp_lifecycle_no_d_window_std_dev,
    v.gwp_lifecycle_no_d_window_min_value,
    v.gwp_lifecycle_no_d_window_max_value,
    v.gwp_lifecycle_no_d_window_p05_value,
    v.gwp_lifecycle_no_d_window_p25_value,
    v.gwp_lifecycle_no_d_window_p75_value,
    v.gwp_lifecycle_no_d_window_p95_value,
    v.gwp_lifecycle_no_d_window_se_mean,
    v.gwp_lifecycle_no_d_window_cv,
    v.gwp_lifecycle_no_d_interior_wall_mean_value,
    v.gwp_lifecycle_no_d_interior_wall_median_value,
    v.gwp_lifecycle_no_d_interior_wall_std_dev,
    v.gwp_lifecycle_no_d_interior_wall_min_value,
    v.gwp_lifecycle_no_d_interior_wall_max_value,
    v.gwp_lifecycle_no_d_interior_wall_p05_value,
    v.gwp_lifecycle_no_d_interior_wall_p25_value,
    v.gwp_lifecycle_no_d_interior_wall_p75_value,
    v.gwp_lifecycle_no_d_interior_wall_p95_value,
    v.gwp_lifecycle_no_d_interior_wall_se_mean,
    v.gwp_lifecycle_no_d_interior_wall_cv
   FROM ((hub4lca_post_simulation.vw_post_simulation_base v
     JOIN hub4lca_post_simulation.building_archetypes bat_post ON ((bat_post.building_archetype_id = v.building_archetype_id)))
     JOIN hub4lca_post_simulation.building_types bt_post ON ((bt_post.building_type_id = bat_post.building_type_id)))
  WHERE ((bt_post.building_type_name)::text = 'ab'::text);
 9   DROP VIEW hub4lca_post_simulation.vw_post_simulation_ab;
       hub4lca_post_simulation       v       max_schildt    false    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    239    239    229    229    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    343    6            Y           1259    37623    vw_post_simulation_mfh    VIEW       CREATE VIEW hub4lca_post_simulation.vw_post_simulation_mfh AS
 SELECT v.building_archetype_id,
    v.building_archetype_name,
    v.share_of_building_type,
    v.share_of_building_type_in_region,
    v.share_of_building_type_in_region_mun,
    v.exterior_wall_building_element_id,
    v.interior_wall_building_element_id,
    v.roof_building_element_id,
    v.foundation_building_element_id,
    v.floor_building_element_id,
    v.window_building_element_id,
    v.energy_system_id,
    v.building_type_name,
    v.region_name,
    v.municipality_size_name,
    v.municipality_growth_name,
    v.age_class_name,
    v.building_adjacency_name,
    v.facade_to_net_leased_area_ratio_mean,
    v.facade_to_net_leased_area_ratio_se_min,
    v.facade_to_net_leased_area_ratio_se_max,
    v.roof_to_net_leased_area_ratio_mean,
    v.roof_to_net_leased_area_ratio_se_min,
    v.roof_to_net_leased_area_ratio_se_max,
    v.foundation_to_net_leased_area_ratio_mean,
    v.foundation_to_net_leased_area_ratio_se_min,
    v.foundation_to_net_leased_area_ratio_se_max,
    v.window_to_net_leased_area_ratio_mean,
    v.window_to_net_leased_area_ratio_se_min,
    v.window_to_net_leased_area_ratio_se_max,
    v.building_height_mean,
    v.building_height_se,
    v.height_unit,
    v.aspect_ratio_mean,
    v.aspect_ratio_se_min,
    v.aspect_ratio_se_max,
    v.storeys_below_ground_mean,
    v.storeys_below_ground_se,
    v.storeys_above_ground_mean,
    v.storeys_above_ground_se,
    v.storeys_above_ground_se_min,
    v.storeys_above_ground_se_max,
    v.storey_height_mean,
    v.storey_height_se_min,
    v.storey_height_se_max,
    v.window_share,
    v.net_leased_area_mean,
    v.net_leased_area_se,
    v.net_leased_area_se_min,
    v.net_leased_area_se_max,
    v.net_leased_area_unit,
    v.facade_area_north_mean,
    v.facade_area_north_se,
    v.facade_area_east_mean,
    v.facade_area_east_se,
    v.facade_area_south_mean,
    v.facade_area_south_se,
    v.facade_area_west_mean,
    v.facade_area_west_se,
    v.facade_area_unit,
    v.facade_length_north_mean,
    v.facade_length_north_se,
    v.facade_length_east_mean,
    v.facade_length_east_se,
    v.facade_length_south_mean,
    v.facade_length_south_se,
    v.facade_length_west_mean,
    v.facade_length_west_se,
    v.facade_length_unit,
    v.exterior_wall_name,
    v.exterior_wall_construction_type,
    v.exterior_wall_u_value_typical_min,
    v.exterior_wall_u_value_typical_max,
    v.exterior_wall_u_value,
    v.exterior_wall_u_value_unit,
    v.exterior_wall_inner_radiation,
    v.exterior_wall_inner_radiation_unit,
    v.exterior_wall_outer_radiation,
    v.exterior_wall_outer_radiation_unit,
    v.exterior_wall_inner_convection,
    v.exterior_wall_inner_convection_unit,
    v.exterior_wall_outer_convection,
    v.exterior_wall_outer_convection_unit,
    v.exterior_wall_layer0_position,
    v.exterior_wall_layer0_material_id,
    v.exterior_wall_layer0_material_name,
    v.exterior_wall_layer0_thickness,
    v.exterior_wall_layer0_thickness_unit,
    v.exterior_wall_layer0_solar_absorption_rate,
    v.exterior_wall_layer0_thermal_capacity,
    v.exterior_wall_layer0_thermal_capacity_unit,
    v.exterior_wall_layer0_thermal_conductivity,
    v.exterior_wall_layer0_thermal_conductivity_unit,
    v.exterior_wall_layer0_service_life,
    v.exterior_wall_layer0_service_life_unit,
    v.exterior_wall_layer0_density,
    v.exterior_wall_layer0_density_unit,
    v.exterior_wall_layer1_position,
    v.exterior_wall_layer1_material_id,
    v.exterior_wall_layer1_material_name,
    v.exterior_wall_layer1_thickness,
    v.exterior_wall_layer1_thickness_unit,
    v.exterior_wall_layer1_solar_absorption_rate,
    v.exterior_wall_layer1_thermal_capacity,
    v.exterior_wall_layer1_thermal_capacity_unit,
    v.exterior_wall_layer1_thermal_conductivity,
    v.exterior_wall_layer1_thermal_conductivity_unit,
    v.exterior_wall_layer1_service_life,
    v.exterior_wall_layer1_service_life_unit,
    v.exterior_wall_layer1_density,
    v.exterior_wall_layer1_density_unit,
    v.exterior_wall_layer2_position,
    v.exterior_wall_layer2_material_id,
    v.exterior_wall_layer2_material_name,
    v.exterior_wall_layer2_thickness,
    v.exterior_wall_layer2_thickness_unit,
    v.exterior_wall_layer2_solar_absorption_rate,
    v.exterior_wall_layer2_thermal_capacity,
    v.exterior_wall_layer2_thermal_capacity_unit,
    v.exterior_wall_layer2_thermal_conductivity,
    v.exterior_wall_layer2_thermal_conductivity_unit,
    v.exterior_wall_layer2_service_life,
    v.exterior_wall_layer2_service_life_unit,
    v.exterior_wall_layer2_density,
    v.exterior_wall_layer2_density_unit,
    v.exterior_wall_layer3_position,
    v.exterior_wall_layer3_material_id,
    v.exterior_wall_layer3_material_name,
    v.exterior_wall_layer3_thickness,
    v.exterior_wall_layer3_thickness_unit,
    v.exterior_wall_layer3_solar_absorption_rate,
    v.exterior_wall_layer3_thermal_capacity,
    v.exterior_wall_layer3_thermal_capacity_unit,
    v.exterior_wall_layer3_thermal_conductivity,
    v.exterior_wall_layer3_thermal_conductivity_unit,
    v.exterior_wall_layer3_service_life,
    v.exterior_wall_layer3_service_life_unit,
    v.exterior_wall_layer3_density,
    v.exterior_wall_layer3_density_unit,
    v.exterior_wall_layer4_position,
    v.exterior_wall_layer4_material_id,
    v.exterior_wall_layer4_material_name,
    v.exterior_wall_layer4_thickness,
    v.exterior_wall_layer4_thickness_unit,
    v.exterior_wall_layer4_solar_absorption_rate,
    v.exterior_wall_layer4_thermal_capacity,
    v.exterior_wall_layer4_thermal_capacity_unit,
    v.exterior_wall_layer4_thermal_conductivity,
    v.exterior_wall_layer4_thermal_conductivity_unit,
    v.exterior_wall_layer4_service_life,
    v.exterior_wall_layer4_service_life_unit,
    v.exterior_wall_layer4_density,
    v.exterior_wall_layer4_density_unit,
    v.exterior_wall_layer5_position,
    v.exterior_wall_layer5_material_id,
    v.exterior_wall_layer5_material_name,
    v.exterior_wall_layer5_thickness,
    v.exterior_wall_layer5_thickness_unit,
    v.exterior_wall_layer5_solar_absorption_rate,
    v.exterior_wall_layer5_thermal_capacity,
    v.exterior_wall_layer5_thermal_capacity_unit,
    v.exterior_wall_layer5_thermal_conductivity,
    v.exterior_wall_layer5_thermal_conductivity_unit,
    v.exterior_wall_layer5_service_life,
    v.exterior_wall_layer5_service_life_unit,
    v.exterior_wall_layer5_density,
    v.exterior_wall_layer5_density_unit,
    v.exterior_wall_layer0_epd1_oekobaudat_name,
    v.exterior_wall_layer0_epd1_oekobaudat_uuid,
    v.exterior_wall_layer0_epd2_oekobaudat_name,
    v.exterior_wall_layer0_epd2_oekobaudat_uuid,
    v.exterior_wall_layer1_epd1_oekobaudat_name,
    v.exterior_wall_layer1_epd1_oekobaudat_uuid,
    v.exterior_wall_layer1_epd2_oekobaudat_name,
    v.exterior_wall_layer1_epd2_oekobaudat_uuid,
    v.exterior_wall_layer2_epd1_oekobaudat_name,
    v.exterior_wall_layer2_epd1_oekobaudat_uuid,
    v.exterior_wall_layer2_epd2_oekobaudat_name,
    v.exterior_wall_layer2_epd2_oekobaudat_uuid,
    v.exterior_wall_layer3_epd1_oekobaudat_name,
    v.exterior_wall_layer3_epd1_oekobaudat_uuid,
    v.exterior_wall_layer3_epd2_oekobaudat_name,
    v.exterior_wall_layer3_epd2_oekobaudat_uuid,
    v.exterior_wall_layer4_epd1_oekobaudat_name,
    v.exterior_wall_layer4_epd1_oekobaudat_uuid,
    v.exterior_wall_layer4_epd2_oekobaudat_name,
    v.exterior_wall_layer4_epd2_oekobaudat_uuid,
    v.exterior_wall_layer5_epd1_oekobaudat_name,
    v.exterior_wall_layer5_epd1_oekobaudat_uuid,
    v.exterior_wall_layer5_epd2_oekobaudat_name,
    v.exterior_wall_layer5_epd2_oekobaudat_uuid,
    v.interior_wall_name,
    v.interior_wall_u_value_typical_min,
    v.interior_wall_u_value_typical_max,
    v.interior_wall_u_value,
    v.interior_wall_u_value_unit,
    v.interior_wall_inner_radiation,
    v.interior_wall_inner_radiation_unit,
    v.interior_wall_inner_convection,
    v.interior_wall_inner_convection_unit,
    v.interior_wall_layer0_position,
    v.interior_wall_layer0_material_id,
    v.interior_wall_layer0_material_name,
    v.interior_wall_layer0_thickness,
    v.interior_wall_layer0_thickness_unit,
    v.interior_wall_layer0_solar_absorption_rate,
    v.interior_wall_layer0_thermal_capacity,
    v.interior_wall_layer0_thermal_capacity_unit,
    v.interior_wall_layer0_thermal_conductivity,
    v.interior_wall_layer0_thermal_conductivity_unit,
    v.interior_wall_layer0_service_life,
    v.interior_wall_layer0_service_life_unit,
    v.interior_wall_layer0_density,
    v.interior_wall_layer0_density_unit,
    v.interior_wall_layer1_position,
    v.interior_wall_layer1_material_id,
    v.interior_wall_layer1_material_name,
    v.interior_wall_layer1_thickness,
    v.interior_wall_layer1_thickness_unit,
    v.interior_wall_layer1_solar_absorption_rate,
    v.interior_wall_layer1_thermal_capacity,
    v.interior_wall_layer1_thermal_capacity_unit,
    v.interior_wall_layer1_thermal_conductivity,
    v.interior_wall_layer1_thermal_conductivity_unit,
    v.interior_wall_layer1_service_life,
    v.interior_wall_layer1_service_life_unit,
    v.interior_wall_layer1_density,
    v.interior_wall_layer1_density_unit,
    v.interior_wall_layer2_position,
    v.interior_wall_layer2_material_id,
    v.interior_wall_layer2_material_name,
    v.interior_wall_layer2_thickness,
    v.interior_wall_layer2_thickness_unit,
    v.interior_wall_layer2_solar_absorption_rate,
    v.interior_wall_layer2_thermal_capacity,
    v.interior_wall_layer2_thermal_capacity_unit,
    v.interior_wall_layer2_thermal_conductivity,
    v.interior_wall_layer2_thermal_conductivity_unit,
    v.interior_wall_layer2_service_life,
    v.interior_wall_layer2_service_life_unit,
    v.interior_wall_layer2_density,
    v.interior_wall_layer2_density_unit,
    v.interior_wall_layer0_epd1_oekobaudat_name,
    v.interior_wall_layer0_epd1_oekobaudat_uuid,
    v.interior_wall_layer0_epd2_oekobaudat_name,
    v.interior_wall_layer0_epd2_oekobaudat_uuid,
    v.interior_wall_layer1_epd1_oekobaudat_name,
    v.interior_wall_layer1_epd1_oekobaudat_uuid,
    v.interior_wall_layer1_epd2_oekobaudat_name,
    v.interior_wall_layer1_epd2_oekobaudat_uuid,
    v.interior_wall_layer2_epd1_oekobaudat_name,
    v.interior_wall_layer2_epd1_oekobaudat_uuid,
    v.interior_wall_layer2_epd2_oekobaudat_name,
    v.interior_wall_layer2_epd2_oekobaudat_uuid,
    v.roof_name,
    v.roof_construction_type,
    v.roof_pitch_type,
    v.roof_u_value_typical_min,
    v.roof_u_value_typical_max,
    v.roof_u_value,
    v.roof_u_value_unit,
    v.roof_inner_radiation,
    v.roof_inner_radiation_unit,
    v.roof_outer_radiation,
    v.roof_outer_radiation_unit,
    v.roof_inner_convection,
    v.roof_inner_convection_unit,
    v.roof_outer_convection,
    v.roof_outer_convection_unit,
    v.roof_layer0_position,
    v.roof_layer0_material_id,
    v.roof_layer0_material_name,
    v.roof_layer0_thickness,
    v.roof_layer0_thickness_unit,
    v.roof_layer0_solar_absorption_rate,
    v.roof_layer0_thermal_capacity,
    v.roof_layer0_thermal_capacity_unit,
    v.roof_layer0_thermal_conductivity,
    v.roof_layer0_thermal_conductivity_unit,
    v.roof_layer0_service_life,
    v.roof_layer0_service_life_unit,
    v.roof_layer0_density,
    v.roof_layer0_density_unit,
    v.roof_layer1_position,
    v.roof_layer1_material_id,
    v.roof_layer1_material_name,
    v.roof_layer1_thickness,
    v.roof_layer1_thickness_unit,
    v.roof_layer1_solar_absorption_rate,
    v.roof_layer1_thermal_capacity,
    v.roof_layer1_thermal_capacity_unit,
    v.roof_layer1_thermal_conductivity,
    v.roof_layer1_thermal_conductivity_unit,
    v.roof_layer1_service_life,
    v.roof_layer1_service_life_unit,
    v.roof_layer1_density,
    v.roof_layer1_density_unit,
    v.roof_layer2_position,
    v.roof_layer2_material_id,
    v.roof_layer2_material_name,
    v.roof_layer2_thickness,
    v.roof_layer2_thickness_unit,
    v.roof_layer2_solar_absorption_rate,
    v.roof_layer2_thermal_capacity,
    v.roof_layer2_thermal_capacity_unit,
    v.roof_layer2_thermal_conductivity,
    v.roof_layer2_thermal_conductivity_unit,
    v.roof_layer2_service_life,
    v.roof_layer2_service_life_unit,
    v.roof_layer2_density,
    v.roof_layer2_density_unit,
    v.roof_layer3_position,
    v.roof_layer3_material_id,
    v.roof_layer3_material_name,
    v.roof_layer3_thickness,
    v.roof_layer3_thickness_unit,
    v.roof_layer3_solar_absorption_rate,
    v.roof_layer3_thermal_capacity,
    v.roof_layer3_thermal_capacity_unit,
    v.roof_layer3_thermal_conductivity,
    v.roof_layer3_thermal_conductivity_unit,
    v.roof_layer3_service_life,
    v.roof_layer3_service_life_unit,
    v.roof_layer3_density,
    v.roof_layer3_density_unit,
    v.roof_layer4_position,
    v.roof_layer4_material_id,
    v.roof_layer4_material_name,
    v.roof_layer4_thickness,
    v.roof_layer4_thickness_unit,
    v.roof_layer4_solar_absorption_rate,
    v.roof_layer4_thermal_capacity,
    v.roof_layer4_thermal_capacity_unit,
    v.roof_layer4_thermal_conductivity,
    v.roof_layer4_thermal_conductivity_unit,
    v.roof_layer4_service_life,
    v.roof_layer4_service_life_unit,
    v.roof_layer4_density,
    v.roof_layer4_density_unit,
    v.roof_layer5_position,
    v.roof_layer5_material_id,
    v.roof_layer5_material_name,
    v.roof_layer5_thickness,
    v.roof_layer5_thickness_unit,
    v.roof_layer5_solar_absorption_rate,
    v.roof_layer5_thermal_capacity,
    v.roof_layer5_thermal_capacity_unit,
    v.roof_layer5_thermal_conductivity,
    v.roof_layer5_thermal_conductivity_unit,
    v.roof_layer5_service_life,
    v.roof_layer5_service_life_unit,
    v.roof_layer5_density,
    v.roof_layer5_density_unit,
    v.roof_layer0_epd1_oekobaudat_name,
    v.roof_layer0_epd1_oekobaudat_uuid,
    v.roof_layer0_epd2_oekobaudat_name,
    v.roof_layer0_epd2_oekobaudat_uuid,
    v.roof_layer1_epd1_oekobaudat_name,
    v.roof_layer1_epd1_oekobaudat_uuid,
    v.roof_layer1_epd2_oekobaudat_name,
    v.roof_layer1_epd2_oekobaudat_uuid,
    v.roof_layer2_epd1_oekobaudat_name,
    v.roof_layer2_epd1_oekobaudat_uuid,
    v.roof_layer2_epd2_oekobaudat_name,
    v.roof_layer2_epd2_oekobaudat_uuid,
    v.roof_layer3_epd1_oekobaudat_name,
    v.roof_layer3_epd1_oekobaudat_uuid,
    v.roof_layer3_epd2_oekobaudat_name,
    v.roof_layer3_epd2_oekobaudat_uuid,
    v.roof_layer4_epd1_oekobaudat_name,
    v.roof_layer4_epd1_oekobaudat_uuid,
    v.roof_layer4_epd2_oekobaudat_name,
    v.roof_layer4_epd2_oekobaudat_uuid,
    v.roof_layer5_epd1_oekobaudat_name,
    v.roof_layer5_epd1_oekobaudat_uuid,
    v.roof_layer5_epd2_oekobaudat_name,
    v.roof_layer5_epd2_oekobaudat_uuid,
    v.foundation_name,
    v.foundation_construction_type,
    v.foundation_u_value_typical_min,
    v.foundation_u_value_typical_max,
    v.foundation_u_value,
    v.foundation_u_value_unit,
    v.foundation_inner_radiation,
    v.foundation_inner_radiation_unit,
    v.foundation_inner_convection,
    v.foundation_inner_convection_unit,
    v.foundation_layer0_position,
    v.foundation_layer0_material_id,
    v.foundation_layer0_material_name,
    v.foundation_layer0_thickness,
    v.foundation_layer0_thickness_unit,
    v.foundation_layer0_solar_absorption_rate,
    v.foundation_layer0_thermal_capacity,
    v.foundation_layer0_thermal_capacity_unit,
    v.foundation_layer0_thermal_conductivity,
    v.foundation_layer0_thermal_conductivity_unit,
    v.foundation_layer0_service_life,
    v.foundation_layer0_service_life_unit,
    v.foundation_layer0_density,
    v.foundation_layer0_density_unit,
    v.foundation_layer1_position,
    v.foundation_layer1_material_id,
    v.foundation_layer1_material_name,
    v.foundation_layer1_thickness,
    v.foundation_layer1_thickness_unit,
    v.foundation_layer1_solar_absorption_rate,
    v.foundation_layer1_thermal_capacity,
    v.foundation_layer1_thermal_capacity_unit,
    v.foundation_layer1_thermal_conductivity,
    v.foundation_layer1_thermal_conductivity_unit,
    v.foundation_layer1_service_life,
    v.foundation_layer1_service_life_unit,
    v.foundation_layer1_density,
    v.foundation_layer1_density_unit,
    v.foundation_layer2_position,
    v.foundation_layer2_material_id,
    v.foundation_layer2_material_name,
    v.foundation_layer2_thickness,
    v.foundation_layer2_thickness_unit,
    v.foundation_layer2_solar_absorption_rate,
    v.foundation_layer2_thermal_capacity,
    v.foundation_layer2_thermal_capacity_unit,
    v.foundation_layer2_thermal_conductivity,
    v.foundation_layer2_thermal_conductivity_unit,
    v.foundation_layer2_service_life,
    v.foundation_layer2_service_life_unit,
    v.foundation_layer2_density,
    v.foundation_layer2_density_unit,
    v.foundation_layer3_position,
    v.foundation_layer3_material_id,
    v.foundation_layer3_material_name,
    v.foundation_layer3_thickness,
    v.foundation_layer3_thickness_unit,
    v.foundation_layer3_solar_absorption_rate,
    v.foundation_layer3_thermal_capacity,
    v.foundation_layer3_thermal_capacity_unit,
    v.foundation_layer3_thermal_conductivity,
    v.foundation_layer3_thermal_conductivity_unit,
    v.foundation_layer3_service_life,
    v.foundation_layer3_service_life_unit,
    v.foundation_layer3_density,
    v.foundation_layer3_density_unit,
    v.foundation_layer4_position,
    v.foundation_layer4_material_id,
    v.foundation_layer4_material_name,
    v.foundation_layer4_thickness,
    v.foundation_layer4_thickness_unit,
    v.foundation_layer4_solar_absorption_rate,
    v.foundation_layer4_thermal_capacity,
    v.foundation_layer4_thermal_capacity_unit,
    v.foundation_layer4_thermal_conductivity,
    v.foundation_layer4_thermal_conductivity_unit,
    v.foundation_layer4_service_life,
    v.foundation_layer4_service_life_unit,
    v.foundation_layer4_density,
    v.foundation_layer4_density_unit,
    v.foundation_layer5_position,
    v.foundation_layer5_material_id,
    v.foundation_layer5_material_name,
    v.foundation_layer5_thickness,
    v.foundation_layer5_thickness_unit,
    v.foundation_layer5_solar_absorption_rate,
    v.foundation_layer5_thermal_capacity,
    v.foundation_layer5_thermal_capacity_unit,
    v.foundation_layer5_thermal_conductivity,
    v.foundation_layer5_thermal_conductivity_unit,
    v.foundation_layer5_service_life,
    v.foundation_layer5_service_life_unit,
    v.foundation_layer5_density,
    v.foundation_layer5_density_unit,
    v.foundation_layer0_epd1_oekobaudat_name,
    v.foundation_layer0_epd1_oekobaudat_uuid,
    v.foundation_layer0_epd2_oekobaudat_name,
    v.foundation_layer0_epd2_oekobaudat_uuid,
    v.foundation_layer1_epd1_oekobaudat_name,
    v.foundation_layer1_epd1_oekobaudat_uuid,
    v.foundation_layer1_epd2_oekobaudat_name,
    v.foundation_layer1_epd2_oekobaudat_uuid,
    v.foundation_layer2_epd1_oekobaudat_name,
    v.foundation_layer2_epd1_oekobaudat_uuid,
    v.foundation_layer2_epd2_oekobaudat_name,
    v.foundation_layer2_epd2_oekobaudat_uuid,
    v.foundation_layer3_epd1_oekobaudat_name,
    v.foundation_layer3_epd1_oekobaudat_uuid,
    v.foundation_layer3_epd2_oekobaudat_name,
    v.foundation_layer3_epd2_oekobaudat_uuid,
    v.foundation_layer4_epd1_oekobaudat_name,
    v.foundation_layer4_epd1_oekobaudat_uuid,
    v.foundation_layer4_epd2_oekobaudat_name,
    v.foundation_layer4_epd2_oekobaudat_uuid,
    v.foundation_layer5_epd1_oekobaudat_name,
    v.foundation_layer5_epd1_oekobaudat_uuid,
    v.foundation_layer5_epd2_oekobaudat_name,
    v.foundation_layer5_epd2_oekobaudat_uuid,
    v.floor_name,
    v.floor_u_value_typical_min,
    v.floor_u_value_typical_max,
    v.floor_u_value,
    v.floor_u_value_unit,
    v.floor_inner_radiation,
    v.floor_inner_radiation_unit,
    v.floor_inner_convection,
    v.floor_inner_convection_unit,
    v.floor_layer0_position,
    v.floor_layer0_material_id,
    v.floor_layer0_material_name,
    v.floor_layer0_thickness,
    v.floor_layer0_thickness_unit,
    v.floor_layer0_solar_absorption_rate,
    v.floor_layer0_thermal_capacity,
    v.floor_layer0_thermal_capacity_unit,
    v.floor_layer0_thermal_conductivity,
    v.floor_layer0_thermal_conductivity_unit,
    v.floor_layer0_service_life,
    v.floor_layer0_service_life_unit,
    v.floor_layer0_density,
    v.floor_layer0_density_unit,
    v.floor_layer1_position,
    v.floor_layer1_material_id,
    v.floor_layer1_material_name,
    v.floor_layer1_thickness,
    v.floor_layer1_thickness_unit,
    v.floor_layer1_solar_absorption_rate,
    v.floor_layer1_thermal_capacity,
    v.floor_layer1_thermal_capacity_unit,
    v.floor_layer1_thermal_conductivity,
    v.floor_layer1_thermal_conductivity_unit,
    v.floor_layer1_service_life,
    v.floor_layer1_service_life_unit,
    v.floor_layer1_density,
    v.floor_layer1_density_unit,
    v.floor_layer2_position,
    v.floor_layer2_material_id,
    v.floor_layer2_material_name,
    v.floor_layer2_thickness,
    v.floor_layer2_thickness_unit,
    v.floor_layer2_solar_absorption_rate,
    v.floor_layer2_thermal_capacity,
    v.floor_layer2_thermal_capacity_unit,
    v.floor_layer2_thermal_conductivity,
    v.floor_layer2_thermal_conductivity_unit,
    v.floor_layer2_service_life,
    v.floor_layer2_service_life_unit,
    v.floor_layer2_density,
    v.floor_layer2_density_unit,
    v.floor_layer0_epd1_oekobaudat_name,
    v.floor_layer0_epd1_oekobaudat_uuid,
    v.floor_layer0_epd2_oekobaudat_name,
    v.floor_layer0_epd2_oekobaudat_uuid,
    v.floor_layer1_epd1_oekobaudat_name,
    v.floor_layer1_epd1_oekobaudat_uuid,
    v.floor_layer1_epd2_oekobaudat_name,
    v.floor_layer1_epd2_oekobaudat_uuid,
    v.floor_layer2_epd1_oekobaudat_name,
    v.floor_layer2_epd1_oekobaudat_uuid,
    v.floor_layer2_epd2_oekobaudat_name,
    v.floor_layer2_epd2_oekobaudat_uuid,
    v.window_name,
    v.window_inner_radiation,
    v.window_inner_radiation_unit,
    v.window_outer_radiation,
    v.window_outer_radiation_unit,
    v.window_inner_convection,
    v.window_inner_convection_unit,
    v.window_outer_convection,
    v.window_outer_convection_unit,
    v.glazing,
    v.frame_per_window,
    v.frame_per_window_unit,
    v.window_frame_area_share,
    v.g_value,
    v.a_conv,
    v.shading_type_name,
    v.window_frame_type_name,
    v.window_layer0_position,
    v.window_layer0_material_id,
    v.window_layer0_material_name,
    v.window_layer0_thickness,
    v.window_layer0_thickness_unit,
    v.window_layer0_solar_absorption_rate,
    v.window_layer0_thermal_capacity,
    v.window_layer0_thermal_capacity_unit,
    v.window_layer0_thermal_conductivity,
    v.window_layer0_thermal_conductivity_unit,
    v.window_layer0_service_life,
    v.window_layer0_service_life_unit,
    v.window_layer1_position,
    v.window_layer1_material_id,
    v.window_layer1_material_name,
    v.window_layer1_thickness,
    v.window_layer1_thickness_unit,
    v.window_layer1_solar_absorption_rate,
    v.window_layer1_thermal_capacity,
    v.window_layer1_thermal_capacity_unit,
    v.window_layer1_thermal_conductivity,
    v.window_layer1_thermal_conductivity_unit,
    v.window_layer1_service_life,
    v.window_layer1_service_life_unit,
    v.window_layer2_position,
    v.window_layer2_material_id,
    v.window_layer2_material_name,
    v.window_layer2_thickness,
    v.window_layer2_thickness_unit,
    v.window_layer2_solar_absorption_rate,
    v.window_layer2_thermal_capacity,
    v.window_layer2_thermal_capacity_unit,
    v.window_layer2_thermal_conductivity,
    v.window_layer2_thermal_conductivity_unit,
    v.window_layer2_service_life,
    v.window_layer2_service_life_unit,
    v.window_layer0_epd1_oekobaudat_name,
    v.window_layer0_epd1_oekobaudat_uuid,
    v.window_layer0_epd2_oekobaudat_name,
    v.window_layer0_epd2_oekobaudat_uuid,
    v.window_layer1_epd1_oekobaudat_name,
    v.window_layer1_epd1_oekobaudat_uuid,
    v.window_layer1_epd2_oekobaudat_name,
    v.window_layer1_epd2_oekobaudat_uuid,
    v.window_layer2_epd1_oekobaudat_name,
    v.window_layer2_epd1_oekobaudat_uuid,
    v.window_layer2_epd2_oekobaudat_name,
    v.window_layer2_epd2_oekobaudat_uuid,
    v.energy_system_name,
    v.converter_0_id,
    v.converter_0_energy_converter_name,
    v.converter_1_id,
    v.converter_1_energy_converter_name,
    v.converter_0_nominal_power_min,
    v.converter_0_nominal_power_max,
    v.converter_0_nominal_power_unit,
    v.converter_1_nominal_power_min,
    v.converter_1_nominal_power_max,
    v.converter_1_nominal_power_unit,
    v.converter_0_area,
    v.converter_0_area_unit,
    v.converter_1_area,
    v.converter_1_area_unit,
    v.converter_0_supply_function_name,
    v.converter_1_supply_function_name,
    v.converter_0_energy_source_name,
    v.converter_1_energy_source_name,
    v.converter_0_service_life,
    v.converter_0_service_life_unit,
    v.converter_1_service_life,
    v.converter_1_service_life_unit,
    v.converter_0_epd_1_id,
    v.converter_0_epd_1_name,
    v.converter_0_epd_1_database_uuid,
    v.converter_0_epd_2_id,
    v.converter_0_epd_2_name,
    v.converter_0_epd_2_database_uuid,
    v.converter_0_energy_source_epd_id,
    v.converter_0_energy_source_epd_name,
    v.converter_0_energy_source_epd_database_uuid,
    v.converter_1_epd_1_id,
    v.converter_1_epd_1_name,
    v.converter_1_epd_1_database_uuid,
    v.converter_1_epd_2_id,
    v.converter_1_epd_2_name,
    v.converter_1_epd_2_database_uuid,
    v.converter_1_energy_source_epd_id,
    v.converter_1_energy_source_epd_name,
    v.converter_1_energy_source_epd_database_uuid,
    v.bmp_building_archetype_id,
    v.heat_useful_total_mean_value,
    v.heat_useful_total_median_value,
    v.heat_useful_total_std_dev,
    v.heat_useful_total_min_value,
    v.heat_useful_total_max_value,
    v.heat_useful_total_p05_value,
    v.heat_useful_total_p25_value,
    v.heat_useful_total_p75_value,
    v.heat_useful_total_p95_value,
    v.heat_useful_total_se_mean,
    v.heat_useful_total_cv,
    v.heat_useful_per_m2_mean_value,
    v.heat_useful_per_m2_median_value,
    v.heat_useful_per_m2_std_dev,
    v.heat_useful_per_m2_min_value,
    v.heat_useful_per_m2_max_value,
    v.heat_useful_per_m2_p05_value,
    v.heat_useful_per_m2_p25_value,
    v.heat_useful_per_m2_p75_value,
    v.heat_useful_per_m2_p95_value,
    v.heat_useful_per_m2_se_mean,
    v.heat_useful_per_m2_cv,
    v.gwp_a1_a3_mean_value,
    v.gwp_a1_a3_median_value,
    v.gwp_a1_a3_std_dev,
    v.gwp_a1_a3_min_value,
    v.gwp_a1_a3_max_value,
    v.gwp_a1_a3_p05_value,
    v.gwp_a1_a3_p25_value,
    v.gwp_a1_a3_p75_value,
    v.gwp_a1_a3_p95_value,
    v.gwp_a1_a3_se_mean,
    v.gwp_a1_a3_cv,
    v.gwp_a4_mean_value,
    v.gwp_a4_median_value,
    v.gwp_a4_std_dev,
    v.gwp_a4_min_value,
    v.gwp_a4_max_value,
    v.gwp_a4_p05_value,
    v.gwp_a4_p25_value,
    v.gwp_a4_p75_value,
    v.gwp_a4_p95_value,
    v.gwp_a4_se_mean,
    v.gwp_a4_cv,
    v.gwp_a5_mean_value,
    v.gwp_a5_median_value,
    v.gwp_a5_std_dev,
    v.gwp_a5_min_value,
    v.gwp_a5_max_value,
    v.gwp_a5_p05_value,
    v.gwp_a5_p25_value,
    v.gwp_a5_p75_value,
    v.gwp_a5_p95_value,
    v.gwp_a5_se_mean,
    v.gwp_a5_cv,
    v.gwp_b1_mean_value,
    v.gwp_b1_median_value,
    v.gwp_b1_std_dev,
    v.gwp_b1_min_value,
    v.gwp_b1_max_value,
    v.gwp_b1_p05_value,
    v.gwp_b1_p25_value,
    v.gwp_b1_p75_value,
    v.gwp_b1_p95_value,
    v.gwp_b1_se_mean,
    v.gwp_b1_cv,
    v.gwp_b2_mean_value,
    v.gwp_b2_median_value,
    v.gwp_b2_std_dev,
    v.gwp_b2_min_value,
    v.gwp_b2_max_value,
    v.gwp_b2_p05_value,
    v.gwp_b2_p25_value,
    v.gwp_b2_p75_value,
    v.gwp_b2_p95_value,
    v.gwp_b2_se_mean,
    v.gwp_b2_cv,
    v.gwp_b3_mean_value,
    v.gwp_b3_median_value,
    v.gwp_b3_std_dev,
    v.gwp_b3_min_value,
    v.gwp_b3_max_value,
    v.gwp_b3_p05_value,
    v.gwp_b3_p25_value,
    v.gwp_b3_p75_value,
    v.gwp_b3_p95_value,
    v.gwp_b3_se_mean,
    v.gwp_b3_cv,
    v.gwp_b4_mean_value,
    v.gwp_b4_median_value,
    v.gwp_b4_std_dev,
    v.gwp_b4_min_value,
    v.gwp_b4_max_value,
    v.gwp_b4_p05_value,
    v.gwp_b4_p25_value,
    v.gwp_b4_p75_value,
    v.gwp_b4_p95_value,
    v.gwp_b4_se_mean,
    v.gwp_b4_cv,
    v.gwp_b5_mean_value,
    v.gwp_b5_median_value,
    v.gwp_b5_std_dev,
    v.gwp_b5_min_value,
    v.gwp_b5_max_value,
    v.gwp_b5_p05_value,
    v.gwp_b5_p25_value,
    v.gwp_b5_p75_value,
    v.gwp_b5_p95_value,
    v.gwp_b5_se_mean,
    v.gwp_b5_cv,
    v.gwp_b6_mean_value,
    v.gwp_b6_median_value,
    v.gwp_b6_std_dev,
    v.gwp_b6_min_value,
    v.gwp_b6_max_value,
    v.gwp_b6_p05_value,
    v.gwp_b6_p25_value,
    v.gwp_b6_p75_value,
    v.gwp_b6_p95_value,
    v.gwp_b6_se_mean,
    v.gwp_b6_cv,
    v.gwp_b7_mean_value,
    v.gwp_b7_median_value,
    v.gwp_b7_std_dev,
    v.gwp_b7_min_value,
    v.gwp_b7_max_value,
    v.gwp_b7_p05_value,
    v.gwp_b7_p25_value,
    v.gwp_b7_p75_value,
    v.gwp_b7_p95_value,
    v.gwp_b7_se_mean,
    v.gwp_b7_cv,
    v.gwp_c1_mean_value,
    v.gwp_c1_median_value,
    v.gwp_c1_std_dev,
    v.gwp_c1_min_value,
    v.gwp_c1_max_value,
    v.gwp_c1_p05_value,
    v.gwp_c1_p25_value,
    v.gwp_c1_p75_value,
    v.gwp_c1_p95_value,
    v.gwp_c1_se_mean,
    v.gwp_c1_cv,
    v.gwp_c2_mean_value,
    v.gwp_c2_median_value,
    v.gwp_c2_std_dev,
    v.gwp_c2_min_value,
    v.gwp_c2_max_value,
    v.gwp_c2_p05_value,
    v.gwp_c2_p25_value,
    v.gwp_c2_p75_value,
    v.gwp_c2_p95_value,
    v.gwp_c2_se_mean,
    v.gwp_c2_cv,
    v.gwp_c3_mean_value,
    v.gwp_c3_median_value,
    v.gwp_c3_std_dev,
    v.gwp_c3_min_value,
    v.gwp_c3_max_value,
    v.gwp_c3_p05_value,
    v.gwp_c3_p25_value,
    v.gwp_c3_p75_value,
    v.gwp_c3_p95_value,
    v.gwp_c3_se_mean,
    v.gwp_c3_cv,
    v.gwp_c4_mean_value,
    v.gwp_c4_median_value,
    v.gwp_c4_std_dev,
    v.gwp_c4_min_value,
    v.gwp_c4_max_value,
    v.gwp_c4_p05_value,
    v.gwp_c4_p25_value,
    v.gwp_c4_p75_value,
    v.gwp_c4_p95_value,
    v.gwp_c4_se_mean,
    v.gwp_c4_cv,
    v.gwp_d_mean_value,
    v.gwp_d_median_value,
    v.gwp_d_std_dev,
    v.gwp_d_min_value,
    v.gwp_d_max_value,
    v.gwp_d_p05_value,
    v.gwp_d_p25_value,
    v.gwp_d_p75_value,
    v.gwp_d_p95_value,
    v.gwp_d_se_mean,
    v.gwp_d_cv,
    v.gwp_lifecycle_mean_value,
    v.gwp_lifecycle_median_value,
    v.gwp_lifecycle_std_dev,
    v.gwp_lifecycle_min_value,
    v.gwp_lifecycle_max_value,
    v.gwp_lifecycle_p05_value,
    v.gwp_lifecycle_p25_value,
    v.gwp_lifecycle_p75_value,
    v.gwp_lifecycle_p95_value,
    v.gwp_lifecycle_se_mean,
    v.gwp_lifecycle_cv,
    v.gwp_lifecycle_no_d_mean_value,
    v.gwp_lifecycle_no_d_median_value,
    v.gwp_lifecycle_no_d_std_dev,
    v.gwp_lifecycle_no_d_min_value,
    v.gwp_lifecycle_no_d_max_value,
    v.gwp_lifecycle_no_d_p05_value,
    v.gwp_lifecycle_no_d_p25_value,
    v.gwp_lifecycle_no_d_p75_value,
    v.gwp_lifecycle_no_d_p95_value,
    v.gwp_lifecycle_no_d_se_mean,
    v.gwp_lifecycle_no_d_cv,
    v.gwp_a1_a3_per_m2_mean_value,
    v.gwp_a1_a3_per_m2_median_value,
    v.gwp_a1_a3_per_m2_std_dev,
    v.gwp_a1_a3_per_m2_min_value,
    v.gwp_a1_a3_per_m2_max_value,
    v.gwp_a1_a3_per_m2_p05_value,
    v.gwp_a1_a3_per_m2_p25_value,
    v.gwp_a1_a3_per_m2_p75_value,
    v.gwp_a1_a3_per_m2_p95_value,
    v.gwp_a1_a3_per_m2_se_mean,
    v.gwp_a1_a3_per_m2_cv,
    v.gwp_a4_per_m2_mean_value,
    v.gwp_a4_per_m2_median_value,
    v.gwp_a4_per_m2_std_dev,
    v.gwp_a4_per_m2_min_value,
    v.gwp_a4_per_m2_max_value,
    v.gwp_a4_per_m2_p05_value,
    v.gwp_a4_per_m2_p25_value,
    v.gwp_a4_per_m2_p75_value,
    v.gwp_a4_per_m2_p95_value,
    v.gwp_a4_per_m2_se_mean,
    v.gwp_a4_per_m2_cv,
    v.gwp_a5_per_m2_mean_value,
    v.gwp_a5_per_m2_median_value,
    v.gwp_a5_per_m2_std_dev,
    v.gwp_a5_per_m2_min_value,
    v.gwp_a5_per_m2_max_value,
    v.gwp_a5_per_m2_p05_va